/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.tilegroups.layers;

import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.ruleset.unique.LocalUniqueCache;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001b\u0010\u0012\u001a\u00020\u0013*\u00020\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u001bH\u0014J\u001c\u0010\u001f\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\b\u0002\u0010\u001c\u001a\u00020\u001dH$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006 "}, d2={"Lcom/unciv/ui/components/tilegroups/layers/TileLayer;", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "tileGroup", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "size", "", "<init>", "(Lcom/unciv/ui/components/tilegroups/TileGroup;F)V", "getTileGroup", "()Lcom/unciv/ui/components/tilegroups/TileGroup;", "tile", "Lcom/unciv/logic/map/tile/Tile;", "getTile", "()Lcom/unciv/logic/map/tile/Tile;", "strings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "getStrings", "()Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "setHexagonSize", "Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "scale", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Image;Ljava/lang/Float;)Lcom/badlogic/gdx/scenes/scene2d/ui/Image;", "isViewable", "", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "update", "", "localUniqueCache", "Lcom/unciv/models/ruleset/unique/LocalUniqueCache;", "determineVisibility", "doUpdate", "core"})
public abstract class TileLayer
extends Group {
    @NotNull
    private final TileGroup tileGroup;
    @NotNull
    private final Tile tile;
    @NotNull
    private final TileSetStrings strings;

    public TileLayer(@NotNull TileGroup tileGroup, float size) {
        Intrinsics.checkNotNullParameter(tileGroup, "tileGroup");
        this.tileGroup = tileGroup;
        this.setTouchable(Touchable.disabled);
        this.setTransform(false);
        this.setSize(size, size);
        this.tile = this.tileGroup.getTile();
        this.strings = this.tileGroup.getTileSetStrings();
    }

    @NotNull
    public final TileGroup getTileGroup() {
        return this.tileGroup;
    }

    @NotNull
    public final Tile getTile() {
        return this.tile;
    }

    @NotNull
    public final TileSetStrings getStrings() {
        return this.strings;
    }

    @NotNull
    public final Image setHexagonSize(@NotNull Image $this$setHexagonSize, @Nullable Float scale) {
        Intrinsics.checkNotNullParameter($this$setHexagonSize, "<this>");
        $this$setHexagonSize.setSize(this.tileGroup.getHexagonImageWidth(), $this$setHexagonSize.getHeight() * this.tileGroup.getHexagonImageWidth() / $this$setHexagonSize.getWidth());
        $this$setHexagonSize.setOrigin(((Number)this.tileGroup.getHexagonImageOrigin().getFirst()).floatValue(), ((Number)this.tileGroup.getHexagonImageOrigin().getSecond()).floatValue());
        $this$setHexagonSize.setX(((Number)this.tileGroup.getHexagonImagePosition().getFirst()).floatValue());
        $this$setHexagonSize.setY(((Number)this.tileGroup.getHexagonImagePosition().getSecond()).floatValue());
        Float f = scale;
        $this$setHexagonSize.setScale(f != null ? f.floatValue() : TileSetCache.INSTANCE.getCurrent().getConfig().getTileScale());
        return $this$setHexagonSize;
    }

    public static /* synthetic */ Image setHexagonSize$default(TileLayer tileLayer, Image image, Float f, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: setHexagonSize");
        }
        if ((n & 1) != 0) {
            f = null;
        }
        return tileLayer.setHexagonSize(image, f);
    }

    public final boolean isViewable(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return this.tileGroup.isViewable(viewingCiv);
    }

    public final void update(@Nullable Civilization viewingCiv, @NotNull LocalUniqueCache localUniqueCache) {
        Intrinsics.checkNotNullParameter(localUniqueCache, "localUniqueCache");
        this.doUpdate(viewingCiv, localUniqueCache);
        this.determineVisibility();
    }

    public static /* synthetic */ void update$default(TileLayer tileLayer, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        tileLayer.update(civilization, localUniqueCache);
    }

    protected void determineVisibility() {
        this.setVisible(this.hasChildren());
    }

    protected abstract void doUpdate(@Nullable Civilization var1, @NotNull LocalUniqueCache var2);

    public static /* synthetic */ void doUpdate$default(TileLayer tileLayer, Civilization civilization, LocalUniqueCache localUniqueCache, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doUpdate");
        }
        if ((n & 2) != 0) {
            localUniqueCache = new LocalUniqueCache(false);
        }
        tileLayer.doUpdate(civilization, localUniqueCache);
    }
}

