/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.components.widgets;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextField;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyCharAndCode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB\u0011\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J(\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0014J\u000e\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u0000\u00a8\u0006\u001b"}, d2={"Lcom/unciv/ui/components/widgets/TextFieldWithFixes;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField;", "text", "", "style", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextField$TextFieldStyle;", "<init>", "(Ljava/lang/String;Lcom/badlogic/gdx/scenes/scene2d/ui/TextField$TextFieldStyle;)V", "skin", "Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;", "(Ljava/lang/String;Lcom/badlogic/gdx/scenes/scene2d/ui/Skin;)V", "textField", "(Lcom/unciv/ui/components/widgets/TextFieldWithFixes;)V", "next", "", "up", "", "layout", "drawText", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "font", "Lcom/badlogic/gdx/graphics/g2d/BitmapFont;", "x", "", "y", "copyTextAndSelection", "core"})
public class TextFieldWithFixes
extends TextField {
    private TextFieldWithFixes(String text2, TextField.TextFieldStyle style) {
        super(text2, style);
    }

    public TextFieldWithFixes(@NotNull String text2, @NotNull Skin skin) {
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(skin, "skin");
        TextField.TextFieldStyle textFieldStyle = skin.get(TextField.TextFieldStyle.class);
        Intrinsics.checkNotNullExpressionValue(textFieldStyle, "get(...)");
        this(text2, textFieldStyle);
    }

    public TextFieldWithFixes(@NotNull TextFieldWithFixes textField) {
        Intrinsics.checkNotNullParameter(textField, "textField");
        String string = textField.text;
        Intrinsics.checkNotNullExpressionValue(string, "text");
        TextField.TextFieldStyle textFieldStyle = textField.getStyle();
        Intrinsics.checkNotNullExpressionValue(textFieldStyle, "getStyle(...)");
        this(string, textFieldStyle);
        this.setTextFieldFilter(textField.getTextFieldFilter());
        this.setMessageText(textField.getMessageText());
        this.hasSelection = textField.hasSelection;
        this.cursor = textField.cursor;
        this.selectionStart = textField.selectionStart;
        this.setAlignment(textField.getAlignment());
        this.setPasswordMode(textField.isPasswordMode());
        this.setOnscreenKeyboard(textField.getOnscreenKeyboard());
    }

    @Override
    public void next(boolean up) {
        if (ActivationExtensionsKt.getKeyShortcuts(this).contains(KeyCharAndCode.Companion.getTAB())) {
            return;
        }
        super.next(up);
    }

    @Override
    public void layout() {
        boolean oldEnable = this.getStyle().font.getData().markupEnabled;
        this.getStyle().font.getData().markupEnabled = false;
        super.layout();
        this.getStyle().font.getData().markupEnabled = oldEnable;
    }

    @Override
    protected void drawText(@NotNull Batch batch, @NotNull BitmapFont font, float x, float y) {
        Intrinsics.checkNotNullParameter(batch, "batch");
        Intrinsics.checkNotNullParameter(font, "font");
        boolean oldEnable = font.getData().markupEnabled;
        font.getData().markupEnabled = false;
        super.drawText(batch, font, x, y);
        font.getData().markupEnabled = oldEnable;
    }

    public final void copyTextAndSelection(@NotNull TextFieldWithFixes textField) {
        Intrinsics.checkNotNullParameter(textField, "textField");
        this.text = textField.text;
        this.hasSelection = textField.hasSelection;
        this.cursor = textField.cursor;
        this.selectionStart = textField.selectionStart;
    }
}

