/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.images;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.images.IconTextButtonKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/unciv/ui/images/IconTextButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Button;", "text", "", "icon", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "fontSize", "", "fontColor", "Lcom/badlogic/gdx/graphics/Color;", "<init>", "(Ljava/lang/String;Lcom/badlogic/gdx/scenes/scene2d/Actor;ILcom/badlogic/gdx/graphics/Color;)V", "getIcon", "()Lcom/badlogic/gdx/scenes/scene2d/Actor;", "getFontColor", "()Lcom/badlogic/gdx/graphics/Color;", "label", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "getLabel", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "iconCell", "Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "getIconCell", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Cell;", "labelCell", "getLabelCell", "core"})
public class IconTextButton
extends Button {
    @Nullable
    private final Actor icon;
    @NotNull
    private final Color fontColor;
    @NotNull
    private final Label label;
    @NotNull
    private final Cell<Actor> iconCell;
    @NotNull
    private final Cell<Label> labelCell;

    public IconTextButton(@NotNull String text2, @Nullable Actor icon, int fontSize, @NotNull Color fontColor) {
        Cell<Object> cell;
        Intrinsics.checkNotNullParameter(text2, "text");
        Intrinsics.checkNotNullParameter(fontColor, "fontColor");
        super(BaseScreen.Companion.getSkin());
        this.icon = icon;
        this.fontColor = fontColor;
        this.label = Scene2dExtensionsKt.toLabel$default(text2, this.fontColor, fontSize, 0, true, 4, null);
        if (this.icon != null) {
            float size = fontSize;
            this.icon.setSize(size, size);
            this.icon.setOrigin(1);
            Cell<Actor> cell2 = this.add(this.icon).size(size).padRight(size / 3.0f);
            Intrinsics.checkNotNull(cell2);
            cell = cell2;
        } else {
            Cell cell3 = this.add().padRight((float)fontSize / 2.0f);
            Intrinsics.checkNotNull(cell3);
            cell = cell3;
        }
        this.iconCell = cell;
        Cell<Actor> cell4 = this.add((Actor)this.label);
        Intrinsics.checkNotNullExpressionValue(cell4, "add(...)");
        this.labelCell = cell4;
        this.pad(10.0f);
        IconTextButtonKt.padTopDescent(this.labelCell);
    }

    public /* synthetic */ IconTextButton(String string, Actor actor, int n, Color color, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            actor = null;
        }
        if ((n2 & 4) != 0) {
            n = 18;
        }
        if ((n2 & 8) != 0) {
            Color color2 = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue(color2, "WHITE");
            color = color2;
        }
        this(string, actor, n, color);
    }

    @Nullable
    public final Actor getIcon() {
        return this.icon;
    }

    @NotNull
    public final Color getFontColor() {
        return this.fontColor;
    }

    @NotNull
    public final Label getLabel() {
        return this.label;
    }

    @NotNull
    public final Cell<Actor> getIconCell() {
        return this.iconCell;
    }

    @NotNull
    public final Cell<Label> getLabelCell() {
        return this.labelCell;
    }
}

