/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.objectdescriptions;

import com.unciv.logic.city.City;
import com.unciv.models.Counter;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.stats.Stats;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.ui.objectdescriptions.DescriptionHelpersKt;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u0016\b\u0002\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bJ\u001e\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0014j\b\u0012\u0004\u0012\u00020\u0005`\u0015J6\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u00052\u0016\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0014j\b\u0012\u0004\u0012\u00020\u0005`\u0015J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 J*\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019*\u00020\u00072\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bH\u0002J*\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019*\u00020\u00072\u0016\b\u0002\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bH\u0002\u00a8\u0006$"}, d2={"Lcom/unciv/ui/objectdescriptions/BuildingDescriptions;", "", "<init>", "()V", "getShortDescription", "", "building", "Lcom/unciv/models/ruleset/Building;", "multiline", "", "uniqueInclusionFilter", "Lkotlin/Function1;", "Lcom/unciv/models/ruleset/unique/Unique;", "getDescription", "city", "Lcom/unciv/logic/city/City;", "showAdditionalInfo", "additionalDescription", "", "lines", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "missingCityText", "filter", "getDifferences", "Lkotlin/sequences/Sequence;", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "originalBuilding", "replacementBuilding", "getCivilopediaTextLines", "", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getUniquesStrings", "filterUniques", "getUniquesStringsWithoutDisablers", "core"})
@SourceDebugExtension(value={"SMAP\nBuildingDescriptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuildingDescriptions.kt\ncom/unciv/ui/objectdescriptions/BuildingDescriptions\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1#2:306\n777#3:307\n873#3,2:308\n1915#3,2:310\n1807#3,3:312\n*S KotlinDebug\n*F\n+ 1 BuildingDescriptions.kt\ncom/unciv/ui/objectdescriptions/BuildingDescriptions\n*L\n108#1:307\n108#1:308,2\n248#1:310,2\n261#1:312,3\n*E\n"})
public final class BuildingDescriptions {
    @NotNull
    public static final BuildingDescriptions INSTANCE = new BuildingDescriptions();

    private BuildingDescriptions() {
    }

    @NotNull
    public final String getShortDescription(@NotNull Building building, boolean multiline, @Nullable Function1<? super Unique, Boolean> uniqueInclusionFilter) {
        Intrinsics.checkNotNullParameter(building, "building");
        Building $this$getShortDescription_u24lambda_u240 = building;
        boolean bl = false;
        List infoList = new ArrayList();
        String string = $this$getShortDescription_u24lambda_u240.clone().toString();
        String it = string;
        boolean bl2 = false;
        if (((CharSequence)it).length() > 0) {
            ((Collection)infoList).add(it);
        }
        for (Stats.StatValuePair statValuePair : Building.getStatPercentageBonuses$default($this$getShortDescription_u24lambda_u240, null, null, 2, null)) {
            Stat key = statValuePair.component1();
            float value = statValuePair.component2();
            ((Collection)infoList).add("" + '+' + (int)value + "% " + TranslationsKt.tr$default(key.name(), false, false, 3, null));
        }
        if ($this$getShortDescription_u24lambda_u240.getRequiredNearbyImprovedResources() != null) {
            Collection collection = infoList;
            StringBuilder stringBuilder = new StringBuilder().append("Requires improved [");
            List<String> list2 = $this$getShortDescription_u24lambda_u240.getRequiredNearbyImprovedResources();
            Intrinsics.checkNotNull(list2);
            collection.add(stringBuilder.append(CollectionsKt.joinToString$default(list2, "/", null, null, 0, null, BuildingDescriptions::getShortDescription$lambda$0$1, 30, null)).append("] near city").toString());
        }
        if (!((Collection)$this$getShortDescription_u24lambda_u240.getUniques()).isEmpty()) {
            if (((CharSequence)$this$getShortDescription_u24lambda_u240.getReplacementTextForUniques()).length() > 0) {
                ((Collection)infoList).add($this$getShortDescription_u24lambda_u240.getReplacementTextForUniques());
            } else {
                CollectionsKt.addAll((Collection)infoList, INSTANCE.getUniquesStringsWithoutDisablers($this$getShortDescription_u24lambda_u240, uniqueInclusionFilter));
            }
        }
        if (!($this$getShortDescription_u24lambda_u240.getCityStrength() == 0.0)) {
            ((Collection)infoList).add("{City strength} +" + $this$getShortDescription_u24lambda_u240.getCityStrength());
        }
        if ($this$getShortDescription_u24lambda_u240.getCityHealth() != 0) {
            ((Collection)infoList).add("{City health} +" + $this$getShortDescription_u24lambda_u240.getCityHealth());
        }
        String separator = multiline ? "\n" : "; ";
        return CollectionsKt.joinToString$default(infoList, separator, null, null, 0, null, BuildingDescriptions::getShortDescription$lambda$0$2, 30, null);
    }

    public static /* synthetic */ String getShortDescription$default(BuildingDescriptions buildingDescriptions, Building building, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        return buildingDescriptions.getShortDescription(building, bl, function1);
    }

    @NotNull
    public final String getDescription(@NotNull Building building, @NotNull City city, boolean showAdditionalInfo) {
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(city, "city");
        Building $this$getDescription_u24lambda_u240 = building;
        boolean bl = false;
        Stats stats = Building.getStats$default($this$getDescription_u24lambda_u240, city, null, 2, null);
        ArrayList<String> translatedLines = new ArrayList<String>();
        boolean isFree = city.getCiv().getCivConstructions().hasFreeBuilding(city, $this$getDescription_u24lambda_u240);
        if ($this$getDescription_u24lambda_u240.getUniqueTo() != null) {
            ((Collection)translatedLines).add($this$getDescription_u24lambda_u240.getReplaces() == null ? TranslationsKt.tr$default("Unique to [" + $this$getDescription_u24lambda_u240.getUniqueTo() + ']', false, false, 3, null) : TranslationsKt.tr$default("Unique to [" + $this$getDescription_u24lambda_u240.getUniqueTo() + "], replaces [" + $this$getDescription_u24lambda_u240.getReplaces() + ']', false, false, 3, null));
        }
        if ($this$getDescription_u24lambda_u240.isWonder()) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("Wonder", false, false, 3, null));
        }
        if ($this$getDescription_u24lambda_u240.isNationalWonder()) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("National Wonder", false, false, 3, null));
        }
        if (!isFree) {
            int amount;
            String resourceName;
            for (Map.Entry object : ((Map)$this$getDescription_u24lambda_u240.getResourceRequirementsPerTurn(city.getState())).entrySet()) {
                TileResource resource;
                int available;
                resourceName = (String)object.getKey();
                amount = ((Number)object.getValue()).intValue();
                int n = available = showAdditionalInfo ? city.getAvailableResourceAmount(resourceName) : -1;
                if (city.getRuleset().getTileResources().get(resourceName) == null) continue;
                ((Collection)translatedLines).add(TranslationsKt.tr$default(FormattingExtensionsKt.getConsumesAmountString(resourceName, amount, resource.isStockpiled(), available), false, false, 3, null));
            }
            for (Map.Entry entry : ((Map)$this$getDescription_u24lambda_u240.getStockpiledResourceRequirements(city.getState())).entrySet()) {
                resourceName = (String)entry.getKey();
                amount = ((Number)entry.getValue()).intValue();
                if (city.getRuleset().getTileResources().get(resourceName) == null) continue;
                int available = showAdditionalInfo ? city.getAvailableResourceAmount(resourceName) : -1;
                ((Collection)translatedLines).add(TranslationsKt.tr$default(FormattingExtensionsKt.getCostsAmountString(resourceName, amount, available), false, false, 3, null));
            }
        }
        if (!((Collection)$this$getDescription_u24lambda_u240.getUniques()).isEmpty()) {
            if (((CharSequence)$this$getDescription_u24lambda_u240.getReplacementTextForUniques()).length() > 0) {
                ((Collection)translatedLines).add(TranslationsKt.tr$default($this$getDescription_u24lambda_u240.getReplacementTextForUniques(), false, false, 3, null));
            } else {
                CollectionsKt.addAll((Collection)translatedLines, SequencesKt.map(INSTANCE.getUniquesStringsWithoutDisablers($this$getDescription_u24lambda_u240, BuildingDescriptions::getDescription$lambda$0$0), BuildingDescriptions::getDescription$lambda$0$1));
            }
        }
        if (!stats.isEmpty()) {
            ((Collection)translatedLines).add(stats.toString());
        }
        for (Stats.StatValuePair statValuePair : Building.getStatPercentageBonuses$default($this$getDescription_u24lambda_u240, city, null, 2, null)) {
            Stat stat = statValuePair.component1();
            float value = statValuePair.component2();
            if (value == 0.0f) continue;
            ((Collection)translatedLines).add(TranslationsKt.tr$default(FormattingExtensionsKt.toStringSigned((int)value) + "% {" + stat.name() + '}', false, false, 3, null));
        }
        for (Map.Entry entry : ((Map)$this$getDescription_u24lambda_u240.getGreatPersonPoints()).entrySet()) {
            String greatPersonName = (String)entry.getKey();
            int value = ((Number)entry.getValue()).intValue();
            ((Collection)translatedLines).add("" + '+' + value + ' ' + TranslationsKt.tr$default('[' + greatPersonName + "] points", false, false, 3, null));
        }
        for (Map.Entry entry : ((Map)$this$getDescription_u24lambda_u240.newSpecialists()).entrySet()) {
            String specialistName = (String)entry.getKey();
            int amount = ((Number)entry.getValue()).intValue();
            ((Collection)translatedLines).add("" + '+' + amount + ' ' + TranslationsKt.tr$default('[' + specialistName + "] slots", false, false, 3, null));
        }
        if ($this$getDescription_u24lambda_u240.getRequiredNearbyImprovedResources() != null) {
            Collection collection = translatedLines;
            StringBuilder stringBuilder = new StringBuilder().append("Requires improved [");
            List<String> list2 = $this$getDescription_u24lambda_u240.getRequiredNearbyImprovedResources();
            Intrinsics.checkNotNull(list2);
            collection.add(TranslationsKt.tr$default(stringBuilder.append(CollectionsKt.joinToString$default(list2, "/", null, null, 0, null, BuildingDescriptions::getDescription$lambda$0$2, 30, null)).append("] near city").toString(), false, false, 3, null));
        }
        if (!($this$getDescription_u24lambda_u240.getCityStrength() == 0.0)) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("{City strength} +" + $this$getDescription_u24lambda_u240.getCityStrength(), false, false, 3, null));
        }
        if ($this$getDescription_u24lambda_u240.getCityHealth() != 0) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("{City health} +" + $this$getDescription_u24lambda_u240.getCityHealth(), false, false, 3, null));
        }
        if ($this$getDescription_u24lambda_u240.getMaintenance() != 0 && !isFree) {
            ((Collection)translatedLines).add(TranslationsKt.tr$default("{Maintenance cost}: " + $this$getDescription_u24lambda_u240.getMaintenance() + " {Gold}", false, false, 3, null));
        }
        if (showAdditionalInfo) {
            INSTANCE.additionalDescription(building, city, translatedLines);
        }
        return ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default(translatedLines, "\n", null, null, 0, null, null, 62, null))).toString();
    }

    public final void additionalDescription(@NotNull Building building, @NotNull City city, @NotNull ArrayList<String> lines2) {
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        for (Unique unique : building.getUniqueObjects()) {
            if (unique.getType() != UniqueType.OnlyAvailable && unique.getType() != UniqueType.CanOnlyBeBuiltWhen) continue;
            for (Unique conditional : unique.getModifiers(UniqueType.ConditionalBuildingBuiltAll)) {
                this.missingCityText(conditional.getParams().get(0), city, conditional.getParams().get(1), lines2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void missingCityText(@NotNull String building, @NotNull City city, @NotNull String filter2, @NotNull ArrayList<String> lines2) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(city, "city");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(lines2, "lines");
        Iterable $this$filter$iv = city.getCiv().getCities();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            City it = (City)element$iv$iv;
            boolean bl = false;
            if (!(City.matchesFilter$default(it, filter2, null, false, 6, null) && !it.getCityConstructions().containsBuildingOrEquivalent(building))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingCities = (List)destination$iv$iv;
        if (!((Collection)missingCities).isEmpty()) {
            ((Collection)lines2).add('\n' + TranslationsKt.tr$default("" + '[' + city.getCiv().getEquivalentBuilding(building) + "] required:", false, false, 3, null) + ' ' + CollectionsKt.joinToString$default(missingCities, ", ", null, null, 0, null, BuildingDescriptions::missingCityText$lambda$1, 30, null));
        }
    }

    @NotNull
    public final Sequence<FormattedLine> getDifferences(@NotNull Building originalBuilding, @NotNull Building replacementBuilding) {
        Intrinsics.checkNotNullParameter(originalBuilding, "originalBuilding");
        Intrinsics.checkNotNullParameter(replacementBuilding, "replacementBuilding");
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object>(replacementBuilding, originalBuilding, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Building $replacementBuilding;
            final /* synthetic */ Building $originalBuilding;
            {
                this.$replacementBuilding = $replacementBuilding;
                this.$originalBuilding = $originalBuilding;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var14_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        var3_4 = Stat.getEntries().iterator();
lbl7:
                        // 4 sources

                        while (var3_4.hasNext()) {
                            stat = (Stat)var3_4.next();
                            if (this.$replacementBuilding.get(stat) == this.$originalBuilding.get(stat)) continue;
                            this.L$0 = $this$sequence;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable(stat);
                            this.label = 1;
                            v0 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default(stat.name(), false, false, 3, null) + ' ' + TranslationsKt.tr$default("" + '[' + (int)this.$replacementBuilding.get(stat) + "] vs [" + (int)this.$originalBuilding.get(stat) + ']', false, false, 3, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v0 != var14_3) continue;
                            return var14_3;
                        }
                        break;
                    }
                    case 1: {
                        stat = (Stat)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                originalStatBonus = Building.getStatPercentageBonuses$default(this.$originalBuilding, null, null, 2, null);
                replacementStatBonus = Building.getStatPercentageBonuses$default(this.$replacementBuilding, null, null, 2, null);
                var5_6 = Stat.getEntries().iterator();
lbl27:
                // 4 sources

                while (var5_6.hasNext()) {
                    stat = (Stat)var5_6.next();
                    if (replacementStatBonus.get(stat) == originalStatBonus.get(stat)) continue;
                    this.L$0 = $this$sequence;
                    this.L$1 = originalStatBonus;
                    this.L$2 = replacementStatBonus;
                    this.L$3 = var5_6;
                    this.L$4 = SpillingKt.nullOutSpilledVariable(stat);
                    this.label = 2;
                    v1 = $this$sequence.yield(new FormattedLine("" + '[' + (int)replacementStatBonus.get(stat) + "]% [" + stat.name() + "] vs [" + (int)originalStatBonus.get(stat) + "]% [" + stat.name() + ']', null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v1 != var14_3) continue;
                    return var14_3;
                }
                {
                    break;
                    case 2: {
                        stat = (Stat)this.L$4;
                        var5_6 = (Iterator<E>)this.L$3;
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        ** GOTO lbl27
                    }
                }
                if (this.$replacementBuilding.getMaintenance() != this.$originalBuilding.getMaintenance()) {
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(originalStatBonus);
                    this.L$2 = SpillingKt.nullOutSpilledVariable(replacementStatBonus);
                    this.L$3 = null;
                    this.L$4 = null;
                    this.label = 3;
                    v2 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{Maintenance} ", false, false, 3, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getMaintenance() + "] vs [" + this.$originalBuilding.getMaintenance() + ']', false, false, 3, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v2 == var14_3) {
                        return var14_3;
                    }
                }
                ** GOTO lbl64
                {
                    case 3: {
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
lbl64:
                        // 2 sources

                        if (this.$replacementBuilding.getCost() != this.$originalBuilding.getCost()) {
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable(originalStatBonus);
                            this.L$2 = SpillingKt.nullOutSpilledVariable(replacementStatBonus);
                            this.L$3 = null;
                            this.L$4 = null;
                            this.label = 4;
                            v3 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{Cost} ", false, false, 3, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getCost() + "] vs [" + this.$originalBuilding.getCost() + ']', false, false, 3, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v3 == var14_3) {
                                return var14_3;
                            }
                        }
                        ** GOTO lbl80
                    }
                    case 4: {
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl80:
                        // 2 sources

                        if (!(this.$replacementBuilding.getCityStrength() == this.$originalBuilding.getCityStrength())) {
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable(originalStatBonus);
                            this.L$2 = SpillingKt.nullOutSpilledVariable(replacementStatBonus);
                            this.L$3 = null;
                            this.L$4 = null;
                            this.label = 5;
                            v4 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{City strength} ", false, false, 3, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getCityStrength() + "] vs [" + this.$originalBuilding.getCityStrength() + ']', false, false, 3, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v4 == var14_3) {
                                return var14_3;
                            }
                        }
                        ** GOTO lbl96
                    }
                    case 5: {
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v4 = $result;
lbl96:
                        // 2 sources

                        if (this.$replacementBuilding.getCityHealth() != this.$originalBuilding.getCityHealth()) {
                            this.L$0 = $this$sequence;
                            this.L$1 = SpillingKt.nullOutSpilledVariable(originalStatBonus);
                            this.L$2 = SpillingKt.nullOutSpilledVariable(replacementStatBonus);
                            this.L$3 = null;
                            this.L$4 = null;
                            this.label = 6;
                            v5 = $this$sequence.yield(new FormattedLine(TranslationsKt.tr$default("{City health} ", false, false, 3, null) + TranslationsKt.tr$default("" + '[' + this.$replacementBuilding.getCityHealth() + "] vs [" + this.$originalBuilding.getCityHealth() + ']', false, false, 3, null), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                            if (v5 == var14_3) {
                                return var14_3;
                            }
                        }
                        ** GOTO lbl112
                    }
                    case 6: {
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v5 = $result;
lbl112:
                        // 2 sources

                        if (!(((CharSequence)this.$replacementBuilding.getReplacementTextForUniques()).length() > 0)) break;
                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable(originalStatBonus);
                        this.L$2 = SpillingKt.nullOutSpilledVariable(replacementStatBonus);
                        this.L$3 = null;
                        this.L$4 = null;
                        this.label = 7;
                        v6 = $this$sequence.yield(new FormattedLine(this.$replacementBuilding.getReplacementTextForUniques(), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                        if (v6 == var14_3) {
                            return var14_3;
                        }
                        break;
                    }
                    case 7: {
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v6 = $result;
                        break;
                    }
                }
                newAbilityPredicate = (Function1<Unique, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(com.unciv.models.ruleset.Building com.unciv.models.ruleset.unique.Unique ), (Lcom/unciv/models/ruleset/unique/Unique;)Ljava/lang/Boolean;)((Building)this.$originalBuilding);
                $this$filterNot$iv = this.$replacementBuilding.getUniqueObjects();
                $i$f$filterNot = false;
                var9_10 = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    if (newAbilityPredicate.invoke((Unique)element$iv$iv).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var6_7 = ((List)destination$iv$iv).iterator();
lbl141:
                // 3 sources

                while (var6_7.hasNext()) {
                    unique = (Unique)var6_7.next();
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(originalStatBonus);
                    this.L$2 = SpillingKt.nullOutSpilledVariable(replacementStatBonus);
                    this.L$3 = SpillingKt.nullOutSpilledVariable(newAbilityPredicate);
                    this.L$4 = var6_7;
                    this.L$5 = SpillingKt.nullOutSpilledVariable(unique);
                    this.label = 8;
                    v7 = $this$sequence.yield(new FormattedLine(unique.getDisplayText(), null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v7 != var14_3) continue;
                    return var14_3;
                }
                {
                    break;
                    case 8: {
                        unique = (Unique)this.L$5;
                        var6_7 = (Iterator<E>)this.L$4;
                        newAbilityPredicate = (Function1<Unique, Boolean>)this.L$3;
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v7 = $result;
                        ** GOTO lbl141
                    }
                }
                lostAbilityPredicate = (Function1<Unique, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$1(com.unciv.models.ruleset.Building com.unciv.models.ruleset.unique.Unique ), (Lcom/unciv/models/ruleset/unique/Unique;)Ljava/lang/Boolean;)((Building)this.$replacementBuilding);
                $this$filterNot$iv = this.$originalBuilding.getUniqueObjects();
                $i$f$filterNot = false;
                $this$filterNotTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    if (lostAbilityPredicate.invoke((Unique)element$iv$iv).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                var6_7 = ((List)destination$iv$iv).iterator();
lbl175:
                // 3 sources

                while (var6_7.hasNext()) {
                    unique = (Unique)var6_7.next();
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(originalStatBonus);
                    this.L$2 = SpillingKt.nullOutSpilledVariable(replacementStatBonus);
                    this.L$3 = SpillingKt.nullOutSpilledVariable(lostAbilityPredicate);
                    this.L$4 = var6_7;
                    this.L$5 = SpillingKt.nullOutSpilledVariable(unique);
                    this.label = 9;
                    v8 = $this$sequence.yield(new FormattedLine("Lost ability (vs [" + this.$originalBuilding.getName() + "]): [" + TranslationsKt.tr$default(unique.getText(), false, false, 3, null) + ']', null, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16254, null), this);
                    if (v8 != var14_3) continue;
                    return var14_3;
                }
                {
                    break;
                    case 9: {
                        unique = (Unique)this.L$5;
                        var6_7 = (Iterator)this.L$4;
                        lostAbilityPredicate = (Function1<Unique, Boolean>)this.L$3;
                        replacementStatBonus = (Stats)this.L$2;
                        originalStatBonus = (Stats)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v8 = $result;
                        ** GOTO lbl175
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super FormattedLine>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super FormattedLine> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final boolean invokeSuspend$lambda$0(Building $originalBuilding, Unique it) {
                return $originalBuilding.getUniques().contains(it.getText()) || it.isHiddenToUsers();
            }

            private static final boolean invokeSuspend$lambda$1(Building $replacementBuilding, Unique it) {
                return $replacementBuilding.getUniques().contains(it.getText()) || it.isHiddenToUsers();
            }
        });
    }

    @NotNull
    public final List<FormattedLine> getCivilopediaTextLines(@NotNull Building building, @NotNull Ruleset ruleset) {
        Iterable<Stats.StatValuePair> stats;
        Object object;
        Intrinsics.checkNotNullParameter(building, "building");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        Building $this$getCivilopediaTextLines_u24lambda_u240 = building;
        boolean bl = false;
        ArrayList textList = new ArrayList();
        if ($this$getCivilopediaTextLines_u24lambda_u240.isAnyWonder()) {
            Collection collection = textList;
            object = $this$getCivilopediaTextLines_u24lambda_u240.isWonder() ? "Wonder" : "National Wonder";
            collection.add(new FormattedLine((String)object, null, null, null, 0.0f, 0, 3, 0, 0.0f, "#CA4", false, false, false, false, 15806, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getUniqueTo() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Unique to [" + $this$getCivilopediaTextLines_u24lambda_u240.getUniqueTo() + ']', "Nation/" + $this$getCivilopediaTextLines_u24lambda_u240.getUniqueTo(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
            if ($this$getCivilopediaTextLines_u24lambda_u240.getReplaces() != null) {
                Building replacesBuilding = (Building)((Map)ruleset.getBuildings()).get($this$getCivilopediaTextLines_u24lambda_u240.getReplaces());
                object = textList;
                String string = "Replaces [" + $this$getCivilopediaTextLines_u24lambda_u240.getReplaces() + ']';
                Object object2 = replacesBuilding;
                if (object2 == null || (object2 = ((Building)object2).makeLink()) == null) {
                    object2 = "";
                }
                object.add(new FormattedLine(string, (String)object2, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getCost() > 0) {
            object = new String[]{"" + $this$getCivilopediaTextLines_u24lambda_u240.getCost() + '\u2699'};
            stats = CollectionsKt.mutableListOf(object);
            if ($this$getCivilopediaTextLines_u24lambda_u240.canBePurchasedWithStat(null, Stat.Gold)) {
                ((Collection)stats).add("" + $this$getCivilopediaTextLines_u24lambda_u240.getCivilopediaGoldCost() + '\u00a4');
            }
            ((Collection)textList).add(new FormattedLine(CollectionsKt.joinToString$default(stats, "/", "{Cost}: ", null, 0, null, null, 60, null), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getRequiredTech() != null) {
            ((Collection)textList).add(new FormattedLine("Required tech: [" + $this$getCivilopediaTextLines_u24lambda_u240.getRequiredTech() + ']', "Technology/" + $this$getCivilopediaTextLines_u24lambda_u240.getRequiredTech(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getRequiredBuilding() != null) {
            Building building2 = (Building)((Map)ruleset.getBuildings()).get($this$getCivilopediaTextLines_u24lambda_u240.getRequiredBuilding());
            String linkType = (building2 != null ? building2.isWonder() : false) ? "Wonder" : "Building";
            ((Collection)textList).add(new FormattedLine("Requires [" + $this$getCivilopediaTextLines_u24lambda_u240.getRequiredBuilding() + "] to be built in the city", linkType + '/' + $this$getCivilopediaTextLines_u24lambda_u240.getRequiredBuilding(), null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getRequiredResource() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            TileResource resource = (TileResource)((Map)ruleset.getTileResources()).get($this$getCivilopediaTextLines_u24lambda_u240.getRequiredResource());
            Collection collection = textList;
            String string = $this$getCivilopediaTextLines_u24lambda_u240.getRequiredResource();
            Intrinsics.checkNotNull(string);
            TileResource tileResource = resource;
            Intrinsics.checkNotNull(tileResource);
            collection.add(new FormattedLine(FormattingExtensionsKt.getConsumesAmountString$default(string, 1, tileResource.isStockpiled(), 0, 4, null), "Resources/" + $this$getCivilopediaTextLines_u24lambda_u240.getRequiredResource(), null, null, 0.0f, 0, 0, 0, 0.0f, "#F42", false, false, false, false, 15868, null));
        }
        stats = $this$getCivilopediaTextLines_u24lambda_u240.cloneStats();
        Stats percentStats = Building.getStatPercentageBonuses$default($this$getCivilopediaTextLines_u24lambda_u240, null, null, 2, null);
        Counter<String> specialists = $this$getCivilopediaTextLines_u24lambda_u240.newSpecialists();
        if (!((Collection)$this$getCivilopediaTextLines_u24lambda_u240.getUniques()).isEmpty() || !((Stats)stats).isEmpty() || !percentStats.isEmpty() || !((Map)$this$getCivilopediaTextLines_u24lambda_u240.getGreatPersonPoints()).isEmpty() || !((Map)specialists).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        }
        if (((CharSequence)$this$getCivilopediaTextLines_u24lambda_u240.getReplacementTextForUniques()).length() > 0) {
            ((Collection)textList).add(new FormattedLine($this$getCivilopediaTextLines_u24lambda_u240.getReplacementTextForUniques(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        } else {
            DescriptionHelpersKt.uniquesToCivilopediaTextLines$default($this$getCivilopediaTextLines_u24lambda_u240, textList, null, true, null, 10, null);
        }
        if (!((Stats)stats).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(((Stats)stats).toString(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if (!percentStats.isEmpty()) {
            for (Stats.StatValuePair object3 : percentStats) {
                Stat key = object3.component1();
                float value = object3.component2();
                if (value == 0.0f) continue;
                ((Collection)textList).add(new FormattedLine(BuildingDescriptions.getCivilopediaTextLines$lambda$0$formatSignedInt(value) + "% {" + key + '}', null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            }
        }
        for (Map.Entry iterator2 : ((Map)$this$getCivilopediaTextLines_u24lambda_u240.getGreatPersonPoints()).entrySet()) {
            String greatPersonName = (String)iterator2.getKey();
            int value = ((Number)iterator2.getValue()).intValue();
            ((Collection)textList).add(new FormattedLine("" + '+' + value + ' ' + TranslationsKt.tr$default('[' + greatPersonName + "] points", false, false, 3, null), "Unit/" + greatPersonName, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16380, null));
        }
        if (!((Map)specialists).isEmpty()) {
            for (Map.Entry entry : ((Map)specialists).entrySet()) {
                String specialistName = (String)entry.getKey();
                int amount = ((Number)entry.getValue()).intValue();
                ((Collection)textList).add(new FormattedLine("" + '+' + amount + ' ' + TranslationsKt.tr$default('[' + (String)specialistName + "] slots", false, false, 3, null), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            }
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getRequiredNearbyImprovedResources() != null) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("Requires at least one of the following resources improved near the city:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            List<String> list2 = $this$getCivilopediaTextLines_u24lambda_u240.getRequiredNearbyImprovedResources();
            Intrinsics.checkNotNull(list2);
            Iterable $this$forEach$iv = list2;
            boolean bl2 = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl22 = false;
                Collection collection = textList;
                String string = "Resource/" + it;
                collection.add(new FormattedLine(it, string, null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
            }
        }
        if (!($this$getCivilopediaTextLines_u24lambda_u240.getCityStrength() == 0.0) || $this$getCivilopediaTextLines_u24lambda_u240.getCityHealth() != 0 || $this$getCivilopediaTextLines_u24lambda_u240.getMaintenance() != 0) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
        }
        if (!($this$getCivilopediaTextLines_u24lambda_u240.getCityStrength() == 0.0)) {
            ((Collection)textList).add(new FormattedLine("{City strength} +" + $this$getCivilopediaTextLines_u24lambda_u240.getCityStrength(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getCityHealth() != 0) {
            ((Collection)textList).add(new FormattedLine("{City health} +" + $this$getCivilopediaTextLines_u24lambda_u240.getCityHealth(), null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        if ($this$getCivilopediaTextLines_u24lambda_u240.getMaintenance() != 0) {
            ((Collection)textList).add(new FormattedLine("{Maintenance cost}: " + $this$getCivilopediaTextLines_u24lambda_u240.getMaintenance() + " {Gold}", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
        }
        ArrayList seeAlso = new ArrayList();
        Iterator<Building> iterator2 = ruleset.getBuildings().values().iterator();
        while (iterator2.hasNext()) {
            Building seeAlsoBuilding;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!Intrinsics.areEqual(seeAlsoBuilding.getReplaces(), $this$getCivilopediaTextLines_u24lambda_u240.getName())) {
                boolean bl3;
                block34: {
                    Iterable $this$any$iv = seeAlsoBuilding.getUniqueObjects();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl4;
                            block33: {
                                Unique unique = (Unique)element$iv;
                                boolean bl5 = false;
                                Iterable $this$any$iv2 = unique.getParams();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl4 = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        String it = (String)element$iv2;
                                        boolean bl6 = false;
                                        if (!Intrinsics.areEqual(it, $this$getCivilopediaTextLines_u24lambda_u240.getName())) continue;
                                        bl4 = true;
                                        break block33;
                                    }
                                    bl4 = false;
                                }
                            }
                            if (!bl4) continue;
                            bl3 = true;
                            break block34;
                        }
                        bl3 = false;
                    }
                }
                if (!bl3) continue;
            }
            ((Collection)seeAlso).add(new FormattedLine(seeAlsoBuilding.getName(), seeAlsoBuilding.makeLink(), null, null, 0.0f, 0, 0, 1, 0.0f, null, false, false, false, false, 16252, null));
        }
        CollectionsKt.addAll((Collection)seeAlso, Belief.Companion.getCivilopediaTextMatching($this$getCivilopediaTextLines_u24lambda_u240.getName(), ruleset, false));
        if (!((Collection)seeAlso).isEmpty()) {
            ((Collection)textList).add(new FormattedLine(null, null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16383, null));
            ((Collection)textList).add(new FormattedLine("{See also}:", null, null, null, 0.0f, 0, 0, 0, 0.0f, null, false, false, false, false, 16382, null));
            CollectionsKt.addAll((Collection)textList, seeAlso);
        }
        return textList;
    }

    private final Sequence<String> getUniquesStrings(Building $this$getUniquesStrings, Function1<? super Unique, Boolean> filterUniques) {
        return SequencesKt.sequence((Function2)new Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object>($this$getUniquesStrings, filterUniques, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Building $this_getUniquesStrings;
            final /* synthetic */ Function1<Unique, Boolean> $filterUniques;
            {
                this.$this_getUniquesStrings = $receiver;
                this.$filterUniques = $filterUniques;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (SequenceScope)this.L$0;
                var10_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        tileBonusHashmap = new HashMap();
                        var4_5 = this.$this_getUniquesStrings.getUniqueObjects().iterator();
lbl8:
                        // 5 sources

                        while (var4_5.hasNext()) {
                            unique = (Unique)var4_5.next();
                            if (this.$filterUniques != null && !this.$filterUniques.invoke(unique).booleanValue()) continue;
                            if (unique.getType() == UniqueType.StatsFromTiles && Intrinsics.areEqual(unique.getParams().get(2), "in this city")) {
                                stats = unique.getParams().get(0);
                                if (!tileBonusHashmap.containsKey(stats)) {
                                    ((Map)tileBonusHashmap).put(stats, new ArrayList<E>());
                                }
                                v0 = tileBonusHashmap.get(stats);
                                Intrinsics.checkNotNull(v0);
                                Boxing.boxBoolean(((ArrayList)v0).add(unique.getParams().get(1)));
                                continue;
                            }
                            this.L$0 = $this$sequence;
                            this.L$1 = tileBonusHashmap;
                            this.L$2 = var4_5;
                            this.L$3 = SpillingKt.nullOutSpilledVariable(unique);
                            this.label = 1;
                            v1 = $this$sequence.yield(unique.getDisplayText(), this);
                            if (v1 != var10_3) continue;
                            return var10_3;
                        }
                        break;
                    }
                    case 1: {
                        unique = (Unique)this.L$3;
                        var4_5 = (Iterator<Map.Entry<K, V>>)this.L$2;
                        tileBonusHashmap = (HashMap)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v1 = $result;
                        ** GOTO lbl8
                    }
                }
                var4_5 = ((Map)tileBonusHashmap).entrySet().iterator();
lbl38:
                // 3 sources

                while (var4_5.hasNext()) {
                    var5_6 = var4_5.next();
                    key = (String)var5_6.getKey();
                    value = (ArrayList)var5_6.getValue();
                    var8_9 = new String[2];
                    var8_9[0] = key;
                    var9_10 = value.size() == 1 ? (String)value.get(0) : CollectionsKt.joinToString$default(value, null, null, null, 0, null, (Function1<String, CharSequence>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(java.lang.String ), (Ljava/lang/String;)Ljava/lang/CharSequence;)(), 31, null);
                    Intrinsics.checkNotNull(var9_10);
                    var8_9[1] = var9_10;
                    this.L$0 = $this$sequence;
                    this.L$1 = SpillingKt.nullOutSpilledVariable(tileBonusHashmap);
                    this.L$2 = var4_5;
                    this.L$3 = SpillingKt.nullOutSpilledVariable(key);
                    this.L$4 = SpillingKt.nullOutSpilledVariable(value);
                    this.label = 2;
                    v2 = $this$sequence.yield(TranslationsKt.fillPlaceholders("[stats] from [tileFilter] tiles in this city", var8_9), this);
                    if (v2 != var10_3) continue;
                    return var10_3;
                }
                {
                    break;
                    case 2: {
                        value = (ArrayList)this.L$4;
                        key = (String)this.L$3;
                        var4_5 = (Iterator<Map.Entry<K, V>>)this.L$2;
                        tileBonusHashmap = (HashMap)this.L$1;
                        ResultKt.throwOnFailure($result);
                        v2 = $result;
                        ** GOTO lbl38
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<SequenceScope<? super String>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(SequenceScope<? super String> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final CharSequence invokeSuspend$lambda$0(String it) {
                return TranslationsKt.tr$default(it, false, false, 3, null);
            }
        });
    }

    static /* synthetic */ Sequence getUniquesStrings$default(BuildingDescriptions buildingDescriptions, Building building, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return buildingDescriptions.getUniquesStrings(building, function1);
    }

    private final Sequence<String> getUniquesStringsWithoutDisablers(Building $this$getUniquesStringsWithoutDisablers, Function1<? super Unique, Boolean> filterUniques) {
        return this.getUniquesStrings($this$getUniquesStringsWithoutDisablers, arg_0 -> BuildingDescriptions.getUniquesStringsWithoutDisablers$lambda$0(filterUniques, arg_0));
    }

    static /* synthetic */ Sequence getUniquesStringsWithoutDisablers$default(BuildingDescriptions buildingDescriptions, Building building, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return buildingDescriptions.getUniquesStringsWithoutDisablers(building, function1);
    }

    private static final CharSequence getShortDescription$lambda$0$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    private static final CharSequence getShortDescription$lambda$0$2(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    private static final boolean getDescription$lambda$0$0(Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getType() != UniqueType.ConsumesResources && it.getType() != UniqueType.CostsResources;
    }

    private static final String getDescription$lambda$0$1(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    private static final CharSequence getDescription$lambda$0$2(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it, false, false, 3, null);
    }

    private static final CharSequence missingCityText$lambda$1(City it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TranslationsKt.tr$default(it.getName(), true, false, 2, null);
    }

    private static final String getCivilopediaTextLines$lambda$0$formatSignedInt(float $this$getCivilopediaTextLines_u24lambda_u240_u24formatSignedInt) {
        return ($this$getCivilopediaTextLines_u24lambda_u240_u24formatSignedInt > 0.0f ? "+" : "") + TranslationsKt.tr((int)$this$getCivilopediaTextLines_u24lambda_u240_u24formatSignedInt);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getUniquesStringsWithoutDisablers$lambda$0(Function1 $filterUniques, Unique it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it.isHiddenToUsers()) return false;
        Function1 function1 = $filterUniques;
        if (function1 == null) return true;
        boolean bl = (Boolean)function1.invoke(it);
        if (!bl) return false;
        return true;
    }
}

