/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.utils.Array;
import com.unciv.logic.multiplayer.Multiplayer;
import com.unciv.models.UncivSound;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.FormattingExtensionsKt;
import com.unciv.utils.CollectionExtensionsKt;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0002\b\u0006\b`\u0018\u00002\u00020\u0001:\u0005\n\u000b\f\r\u000eJ\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00020\b\"\u00020\tH\u0016\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers;", "", "createRefreshOptions", "", "Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$DurationItem;", "unit", "Ljava/time/temporal/ChronoUnit;", "options", "", "", "SelectItem", "UncivSoundLabeled", "UncivSoundProxy", "DurationItem", "RefreshSelectOptions", "core"})
@SourceDebugExtension(value={"SMAP\nMultiplayerSelectBoxHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiplayerSelectBoxHelpers.kt\ncom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,84:1\n11745#2:85\n12096#2,3:86\n*S KotlinDebug\n*F\n+ 1 MultiplayerSelectBoxHelpers.kt\ncom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers\n*L\n45#1:85\n45#1:86,3\n*E\n"})
public interface MultiplayerSelectBoxHelpers {
    /*
     * WARNING - void declaration
     */
    @NotNull
    default public List<DurationItem> createRefreshOptions(@NotNull ChronoUnit unit, long ... options2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(unit, "unit");
        Intrinsics.checkNotNullParameter(options2, "options");
        long[] $this$map$iv = options2;
        boolean $i$f$map = false;
        long[] lArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var12_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Duration duration = Duration.of((long)it, unit);
            Intrinsics.checkNotNullExpressionValue(duration, "of(...)");
            collection.add(new DurationItem(duration));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static List<DurationItem> createRefreshOptions(@NotNull MultiplayerSelectBoxHelpers $this, @NotNull ChronoUnit unit, long ... options2) {
            Intrinsics.checkNotNullParameter(unit, "unit");
            Intrinsics.checkNotNullParameter(options2, "options");
            return $this.createRefreshOptions(unit, options2);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\t\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$DurationItem;", "Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$SelectItem;", "Ljava/time/Duration;", "label", "", "value", "<init>", "(Ljava/lang/String;Ljava/time/Duration;)V", "duration", "(Ljava/time/Duration;)V", "core"})
    public static final class DurationItem
    extends SelectItem<Duration> {
        public DurationItem(@NotNull String label, @NotNull Duration value) {
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(value, "value");
            super(label, value);
        }

        public DurationItem(@NotNull Duration duration) {
            Intrinsics.checkNotNullParameter(duration, "duration");
            this(FormattingExtensionsKt.format(duration), duration);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\f2\b\b\u0002\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001e"}, d2={"Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$RefreshSelectOptions;", "", "property", "Lkotlin/reflect/KMutableProperty0;", "Ljava/time/Duration;", "extraCustomServerOptions", "", "Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$DurationItem;", "dropboxOptions", "<init>", "(Lkotlin/reflect/KMutableProperty0;Ljava/lang/Iterable;Ljava/lang/Iterable;)V", "customServerItems", "Lcom/badlogic/gdx/utils/Array;", "dropboxItems", "selectBox", "Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "getSelectBox", "()Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "setSelectBox", "(Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;)V", "value", "getValue", "()Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$DurationItem;", "setValue", "(Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$DurationItem;)V", "getItems", "isCustomServer", "", "update", "", "core"})
    public static final class RefreshSelectOptions {
        @NotNull
        private final KMutableProperty0<Duration> property;
        @NotNull
        private final Array<DurationItem> customServerItems;
        @NotNull
        private final Array<DurationItem> dropboxItems;
        public SelectBox<DurationItem> selectBox;

        public RefreshSelectOptions(@NotNull KMutableProperty0<Duration> property2, @NotNull Iterable<DurationItem> extraCustomServerOptions, @NotNull Iterable<DurationItem> dropboxOptions) {
            Intrinsics.checkNotNullParameter(property2, "property");
            Intrinsics.checkNotNullParameter(extraCustomServerOptions, "extraCustomServerOptions");
            Intrinsics.checkNotNullParameter(dropboxOptions, "dropboxOptions");
            this.property = property2;
            this.customServerItems = CollectionExtensionsKt.toGdxArray((Iterable)CollectionsKt.plus(extraCustomServerOptions, dropboxOptions));
            this.dropboxItems = CollectionExtensionsKt.toGdxArray(dropboxOptions);
        }

        @NotNull
        public final SelectBox<DurationItem> getSelectBox() {
            SelectBox<DurationItem> selectBox = this.selectBox;
            if (selectBox != null) {
                return selectBox;
            }
            Intrinsics.throwUninitializedPropertyAccessException("selectBox");
            return null;
        }

        public final void setSelectBox(@NotNull SelectBox<DurationItem> selectBox) {
            Intrinsics.checkNotNullParameter(selectBox, "<set-?>");
            this.selectBox = selectBox;
        }

        @NotNull
        public final DurationItem getValue() {
            return new DurationItem((Duration)this.property.get());
        }

        public final void setValue(@NotNull DurationItem value) {
            Intrinsics.checkNotNullParameter(value, "value");
            this.property.set((Duration)value.getValue());
        }

        @NotNull
        public final Array<DurationItem> getItems(boolean isCustomServer) {
            return isCustomServer ? this.customServerItems : this.dropboxItems;
        }

        public static /* synthetic */ Array getItems$default(RefreshSelectOptions refreshSelectOptions, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = Multiplayer.Companion.usesCustomServer();
            }
            return refreshSelectOptions.getItems(bl);
        }

        public final void update(boolean isCustomServer) {
            Array<DurationItem> newItems = this.getItems(isCustomServer);
            if (this.getSelectBox().getItems().size == newItems.size) {
                return;
            }
            DurationItem prev = this.getSelectBox().getSelected();
            this.getSelectBox().setItems(newItems);
            this.getSelectBox().setSelected(prev);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\r\u001a\u00020\u0004H\u0096\u0080\u0004J\u0014\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0096\u0082\u0004J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0080\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$SelectItem;", "T", "", "label", "", "value", "<init>", "(Ljava/lang/String;Ljava/lang/Object;)V", "getLabel", "()Ljava/lang/String;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "toString", "equals", "", "other", "hashCode", "", "core"})
    public static abstract class SelectItem<T> {
        @NotNull
        private final String label;
        private final T value;

        public SelectItem(@NotNull String label, T value) {
            Intrinsics.checkNotNullParameter(label, "label");
            this.label = label;
            this.value = value;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final T getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return TranslationsKt.tr$default(this.label, false, false, 3, null);
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof SelectItem && Intrinsics.areEqual(this.value, ((SelectItem)other).value);
        }

        public int hashCode() {
            T t = this.value;
            return t != null ? t.hashCode() : 0;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010&\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t\u00a2\u0006\u0004\b\u0006\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$UncivSoundLabeled;", "Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$SelectItem;", "Lcom/unciv/models/UncivSound;", "label", "", "value", "<init>", "(Ljava/lang/String;Lcom/unciv/models/UncivSound;)V", "entry", "", "(Ljava/util/Map$Entry;)V", "core"})
    public static final class UncivSoundLabeled
    extends SelectItem<UncivSound> {
        public UncivSoundLabeled(@NotNull String label, @NotNull UncivSound value) {
            Intrinsics.checkNotNullParameter(label, "label");
            Intrinsics.checkNotNullParameter(value, "value");
            super(label, value);
        }

        public UncivSoundLabeled(@NotNull Map.Entry<String, String> entry) {
            Intrinsics.checkNotNullParameter(entry, "entry");
            this(entry.getValue(), new UncivSound(entry.getKey()));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$UncivSoundProxy;", "", "property", "Lkotlin/reflect/KMutableProperty0;", "Lcom/unciv/models/UncivSound;", "<init>", "(Lkotlin/reflect/KMutableProperty0;)V", "value", "Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$UncivSoundLabeled;", "getValue", "()Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$UncivSoundLabeled;", "setValue", "(Lcom/unciv/ui/popups/options/MultiplayerSelectBoxHelpers$UncivSoundLabeled;)V", "core"})
    public static final class UncivSoundProxy {
        @NotNull
        private final KMutableProperty0<UncivSound> property;

        public UncivSoundProxy(@NotNull KMutableProperty0<UncivSound> property2) {
            Intrinsics.checkNotNullParameter(property2, "property");
            this.property = property2;
        }

        @NotNull
        public final UncivSoundLabeled getValue() {
            return new UncivSoundLabeled("", (UncivSound)this.property.get());
        }

        public final void setValue(@NotNull UncivSoundLabeled value) {
            Intrinsics.checkNotNullParameter(value, "value");
            this.property.set((UncivSound)value.getValue());
        }
    }
}

