/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.cityscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.city.City;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Building;
import com.unciv.models.ruleset.IConstruction;
import com.unciv.models.ruleset.INonPerpetualConstruction;
import com.unciv.models.ruleset.PerpetualConstruction;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.Stat;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.KeyboardBinding;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.popups.PopupKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.cityscreen.CityScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001e\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\f\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0013\u001a\u00020\tH\u0002J\u001a\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\tH\u0002J$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0002J&\u0010\u001a\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\t2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory;", "", "cityScreen", "Lcom/unciv/ui/screens/cityscreen/CityScreen;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/CityScreen;)V", "getCityScreen", "()Lcom/unciv/ui/screens/cityscreen/CityScreen;", "preferredBuyStat", "Lcom/unciv/models/stats/Stat;", "hasBuyButtons", "", "construction", "Lcom/unciv/models/ruleset/IConstruction;", "getBuyButtons", "", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "getBuyButton", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "stat", "buyButtonOnClick", "", "askToBuyConstruction", "tile", "Lcom/unciv/logic/map/tile/Tile;", "isConstructionPurchaseShown", "purchaseConstruction", "ConfirmBuyPopup", "core"})
@SourceDebugExtension(value={"SMAP\nBuyButtonFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BuyButtonFactory.kt\ncom/unciv/ui/screens/cityscreen/BuyButtonFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1642#2,10:197\n1915#2:207\n1916#2:209\n1652#2:210\n1#3:208\n*S KotlinDebug\n*F\n+ 1 BuyButtonFactory.kt\ncom/unciv/ui/screens/cityscreen/BuyButtonFactory\n*L\n41#1:197,10\n41#1:207\n41#1:209\n41#1:210\n41#1:208\n*E\n"})
public final class BuyButtonFactory {
    @NotNull
    private final CityScreen cityScreen;
    @NotNull
    private Stat preferredBuyStat;

    public BuyButtonFactory(@NotNull CityScreen cityScreen) {
        Intrinsics.checkNotNullParameter(cityScreen, "cityScreen");
        this.cityScreen = cityScreen;
        this.preferredBuyStat = Stat.Gold;
    }

    @NotNull
    public final CityScreen getCityScreen() {
        return this.cityScreen;
    }

    public final boolean hasBuyButtons(@Nullable IConstruction construction) {
        return !((Collection)this.getBuyButtons(construction)).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<TextButton> getBuyButtons(@Nullable IConstruction construction) {
        boolean selection;
        boolean bl = selection = this.cityScreen.getSelectedConstruction() != null || this.cityScreen.getSelectedQueueEntry() >= 0;
        if (selection && construction != null && !(construction instanceof PerpetualConstruction)) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = Stat.Companion.getStatsUsableToBuy();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                TextButton it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl2 = false;
                Stat it = (Stat)element$iv$iv;
                boolean bl3 = false;
                if (this.getBuyButton((INonPerpetualConstruction)construction, it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private final TextButton getBuyButton(INonPerpetualConstruction construction, Stat stat) {
        if (!Stat.Companion.getStatsUsableToBuy().contains(stat) || construction == null) {
            return null;
        }
        City city = this.cityScreen.getCity$core();
        TextButton button = Scene2dExtensionsKt.toTextButton$default("", null, false, 3, null);
        if (!this.isConstructionPurchaseShown(construction, stat)) {
            if (stat != Stat.Gold || construction.canBePurchasedWithAnyStat(city)) {
                return null;
            }
            button.setText(TranslationsKt.tr$default("Buy", false, false, 3, null));
            Scene2dExtensionsKt.disable(button);
        } else {
            Integer n = construction.getStatBuyCost(city, stat);
            Intrinsics.checkNotNull(n);
            int constructionBuyCost = n;
            button.setText(TranslationsKt.tr$default("Buy", false, false, 3, null) + ' ' + TranslationsKt.tr(constructionBuyCost) + stat.getCharacter());
            ActivationExtensionsKt.onActivation$default(button, null, KeyboardBinding.BuyConstruction, () -> BuyButtonFactory.getBuyButton$lambda$0(button, this, construction, stat), 1, null);
            Scene2dExtensionsKt.setEnabled(button, this.cityScreen.getCanChangeState() && city.getCityConstructions().isConstructionPurchaseAllowed(construction, stat, constructionBuyCost));
            this.preferredBuyStat = stat;
            if (city.getCityConstructions().isConstructionPurchaseBlockedByUnit(construction)) {
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, button, "Move unit out of city first", 26.0f, false, 0, 0, false, null, 120, null);
            }
        }
        button.getLabelCell().pad(5.0f);
        return button;
    }

    static /* synthetic */ TextButton getBuyButton$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, int n, Object object) {
        if ((n & 2) != 0) {
            stat = Stat.Gold;
        }
        return buyButtonFactory.getBuyButton(iNonPerpetualConstruction, stat);
    }

    private final void buyButtonOnClick(INonPerpetualConstruction construction, Stat stat) {
        if (!(construction instanceof Building) || !((Building)construction).hasCreateOneImprovementUnique()) {
            BuyButtonFactory.askToBuyConstruction$default(this, construction, stat, null, 4, null);
            return;
        }
        if (this.cityScreen.getSelectedQueueEntry() < 0) {
            this.cityScreen.startPickTileForCreatesOneImprovement((Building)construction, stat, true);
            return;
        }
        TileImprovement tileImprovement = ((Building)construction).getImprovementToCreate(this.cityScreen.getCity$core().getRuleset(), this.cityScreen.getCity$core().getCiv());
        Intrinsics.checkNotNull(tileImprovement);
        TileImprovement improvement = tileImprovement;
        Tile tileForImprovement = this.cityScreen.getCity$core().getCityConstructions().getTileForImprovement(improvement.getName());
        this.askToBuyConstruction(construction, stat, tileForImprovement);
    }

    static /* synthetic */ void buyButtonOnClick$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, int n, Object object) {
        if ((n & 2) != 0) {
            stat = buyButtonFactory.preferredBuyStat;
        }
        buyButtonFactory.buyButtonOnClick(iNonPerpetualConstruction, stat);
    }

    public final void askToBuyConstruction(@NotNull INonPerpetualConstruction construction, @NotNull Stat stat, @Nullable Tile tile) {
        Intrinsics.checkNotNullParameter(construction, "construction");
        Intrinsics.checkNotNullParameter(stat, "stat");
        if (!this.isConstructionPurchaseShown(construction, stat)) {
            return;
        }
        City city = this.cityScreen.getCity$core();
        Integer n = construction.getStatBuyCost(city, stat);
        Intrinsics.checkNotNull(n);
        int constructionStatBuyCost = n;
        if (!city.getCityConstructions().isConstructionPurchaseAllowed(construction, stat, constructionStatBuyCost)) {
            return;
        }
        PopupKt.closeAllPopups(this.cityScreen);
        new ConfirmBuyPopup(construction, stat, constructionStatBuyCost, tile);
    }

    public static /* synthetic */ void askToBuyConstruction$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, Tile tile, int n, Object object) {
        if ((n & 2) != 0) {
            stat = buyButtonFactory.preferredBuyStat;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        buyButtonFactory.askToBuyConstruction(iNonPerpetualConstruction, stat, tile);
    }

    private final boolean isConstructionPurchaseShown(INonPerpetualConstruction construction, Stat stat) {
        City city = this.cityScreen.getCity$core();
        return construction.canBePurchasedWithStat(city, stat);
    }

    private final void purchaseConstruction(INonPerpetualConstruction construction, Stat stat, Tile tile) {
        block6: {
            IConstruction newConstruction;
            City city;
            block5: {
                SoundPlayer.INSTANCE.play(stat.getPurchaseSound());
                city = this.cityScreen.getCity$core();
                if (!city.getCityConstructions().purchaseConstruction(construction, this.cityScreen.getSelectedQueueEntry(), false, stat, tile)) {
                    Popup popup2;
                    Popup $this$purchaseConstruction_u24lambda_u240 = popup2 = new Popup(this.cityScreen, null, 0.0f, 6, null);
                    boolean bl = false;
                    $this$purchaseConstruction_u24lambda_u240.add((CharSequence)TranslationsKt.tr$default("No space available to place [" + construction.getName() + "] near [" + city.getName() + ']', false, false, 3, null)).row();
                    Popup.addCloseButton$default($this$purchaseConstruction_u24lambda_u240, null, null, null, null, 15, null);
                    Popup.open$default($this$purchaseConstruction_u24lambda_u240, false, 1, null);
                    return;
                }
                if (this.cityScreen.getSelectedQueueEntry() >= 0) break block5;
                IConstruction iConstruction = this.cityScreen.getSelectedConstruction();
                if (iConstruction != null ? iConstruction.isBuildable(city.getCityConstructions()) : false) break block6;
            }
            this.cityScreen.setSelectedQueueEntry(-1);
            this.cityScreen.clearSelection();
            city.getCityConstructions().chooseNextConstruction();
            if (((CharSequence)city.getCityConstructions().currentConstructionName()).length() > 0 && (newConstruction = city.getCityConstructions().getCurrentConstruction()) instanceof INonPerpetualConstruction) {
                this.cityScreen.selectConstruction(newConstruction);
            }
        }
        City.reassignPopulation$default(this.cityScreen.getCity$core(), false, 1, null);
        this.cityScreen.update$core();
    }

    static /* synthetic */ void purchaseConstruction$default(BuyButtonFactory buyButtonFactory, INonPerpetualConstruction iNonPerpetualConstruction, Stat stat, Tile tile, int n, Object object) {
        if ((n & 2) != 0) {
            stat = Stat.Gold;
        }
        if ((n & 4) != 0) {
            tile = null;
        }
        buyButtonFactory.purchaseConstruction(iNonPerpetualConstruction, stat, tile);
    }

    private static final Unit getBuyButton$lambda$0(TextButton $button, BuyButtonFactory this$0, INonPerpetualConstruction $construction, Stat $stat) {
        Scene2dExtensionsKt.disable($button);
        this$0.buyButtonOnClick($construction, $stat);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory$ConfirmBuyPopup;", "Lcom/unciv/ui/popups/Popup;", "construction", "Lcom/unciv/models/ruleset/INonPerpetualConstruction;", "stat", "Lcom/unciv/models/stats/Stat;", "constructionStatBuyCost", "", "tile", "Lcom/unciv/logic/map/tile/Tile;", "<init>", "(Lcom/unciv/ui/screens/cityscreen/BuyButtonFactory;Lcom/unciv/models/ruleset/INonPerpetualConstruction;Lcom/unciv/models/stats/Stat;ILcom/unciv/logic/map/tile/Tile;)V", "core"})
    private final class ConfirmBuyPopup
    extends Popup {
        public ConfirmBuyPopup(@NotNull INonPerpetualConstruction construction, Stat stat, @Nullable int constructionStatBuyCost, Tile tile) {
            Intrinsics.checkNotNullParameter(construction, "construction");
            Intrinsics.checkNotNullParameter(stat, "stat");
            super(BuyButtonFactory.this.getCityScreen().getStage(), null, 0.0f, 6, null);
            City city = BuyButtonFactory.this.getCityScreen().getCity$core();
            int balance = city.getStatReserve(stat);
            Religion majorityReligion = city.getReligion().getMajorityReligion();
            Religion yourReligion = city.getCiv().getReligionManager().getReligion();
            boolean isBuyingWithFaithForForeignReligion = IHasUniques.hasUnique$default(construction, UniqueType.ReligiousUnit, null, 2, null) && !IHasUniques.hasUnique$default(construction, UniqueType.TakeReligionOverBirthCity, null, 2, null) && !Intrinsics.areEqual(majorityReligion, yourReligion);
            Popup.addGoodSizedLabel$default(this, "Currently you have [" + balance + "] [" + stat.name() + "].", 0, false, null, 14, null).padBottom(10.0f).row();
            if (isBuyingWithFaithForForeignReligion) {
                Popup.addGoodSizedLabel$default(this, "You are buying a religious unit in a city that doesn't follow the religion you founded ([" + ConfirmBuyPopup._init_$getName(yourReligion) + "]). This means that the unit is tied to that foreign religion ([" + ConfirmBuyPopup._init_$getName(majorityReligion) + "]) and will be less useful.", 0, false, null, 14, null).row();
                Cell $this$_init__u24lambda_u240 = Popup.addGoodSizedLabel$default(this, "Are you really sure you want to purchase this unit?", 24, false, null, 12, null);
                boolean bl = false;
                ((Label)$this$_init__u24lambda_u240.getActor()).setColor(Color.FIREBRICK);
                $this$_init__u24lambda_u240.padBottom(10.0f);
                $this$_init__u24lambda_u240.row();
            }
            Popup.addGoodSizedLabel$default(this, "Would you like to purchase [" + construction.getName() + "] for [" + constructionStatBuyCost + "] [" + stat.getCharacter() + "]?", 0, false, null, 14, null).row();
            this.addCloseButton("Cancel", KeyboardBinding.Cancel, () -> ConfirmBuyPopup._init_$lambda$1(BuyButtonFactory.this));
            TextButton.TextButtonStyle confirmStyle = BaseScreen.Companion.getSkin().get("positive", TextButton.TextButtonStyle.class);
            this.addOKButton("Purchase", KeyboardBinding.Confirm, confirmStyle, () -> ConfirmBuyPopup._init_$lambda$2(BuyButtonFactory.this, construction, stat, tile));
            this.equalizeLastTwoButtonWidths();
            this.open(true);
        }

        private static final String _init_$getName(Religion $this$_init__u24getName) {
            Object object = $this$_init__u24getName;
            if (object == null || (object = ((Religion)object).getReligionDisplayName()) == null) {
                object = "???";
            }
            return object;
        }

        private static final Unit _init_$lambda$1(BuyButtonFactory this$0) {
            this$0.getCityScreen().update$core();
            return Unit.INSTANCE;
        }

        private static final Unit _init_$lambda$2(BuyButtonFactory this$0, INonPerpetualConstruction $construction, Stat $stat, Tile $tile) {
            this$0.purchaseConstruction($construction, $stat, $tile);
            return Unit.INSTANCE;
        }
    }
}

