/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.AlertType;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.PopupAlert;
import com.unciv.logic.civilization.diplomacy.Demand;
import com.unciv.logic.civilization.diplomacy.DiplomacyFlags;
import com.unciv.logic.civilization.diplomacy.DiplomacyManager;
import com.unciv.logic.civilization.diplomacy.DiplomaticModifiers;
import com.unciv.logic.civilization.diplomacy.RelationshipLevel;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.LeaderIntroTable;
import com.unciv.ui.screens.diplomacyscreen.TradeTable;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/MajorCivDiplomacyTable;", "", "diplomacyScreen", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "<init>", "(Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "getViewingCiv", "()Lcom/unciv/logic/civilization/Civilization;", "getMajorCivDiplomacyTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "otherCiv", "getNegotiatePeaceMajorCivButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "otherCivDiplomacyManager", "Lcom/unciv/logic/civilization/diplomacy/DiplomacyManager;", "getDenounceButton", "diplomacyManager", "getDeclareFriendshipButton", "getTradeButton", "getPromisesTable", "getDiplomacyModifiersTable", "getDemandsTable", "core"})
@SourceDebugExtension(value={"SMAP\nMajorCivDiplomacyTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MajorCivDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/MajorCivDiplomacyTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,245:1\n1807#2,3:246\n1807#2,3:249\n*S KotlinDebug\n*F\n+ 1 MajorCivDiplomacyTable.kt\ncom/unciv/ui/screens/diplomacyscreen/MajorCivDiplomacyTable\n*L\n162#1:246,3\n229#1:249,3\n*E\n"})
public final class MajorCivDiplomacyTable {
    @NotNull
    private final DiplomacyScreen diplomacyScreen;
    @NotNull
    private final Civilization viewingCiv;

    public MajorCivDiplomacyTable(@NotNull DiplomacyScreen diplomacyScreen) {
        Intrinsics.checkNotNullParameter(diplomacyScreen, "diplomacyScreen");
        this.diplomacyScreen = diplomacyScreen;
        this.viewingCiv = this.diplomacyScreen.getViewingCiv$core();
    }

    @NotNull
    public final Civilization getViewingCiv() {
        return this.viewingCiv;
    }

    @NotNull
    public final Table getMajorCivDiplomacyTable(@NotNull Civilization otherCiv) {
        Intrinsics.checkNotNullParameter(otherCiv, "otherCiv");
        DiplomacyManager diplomacyManager = otherCiv.getDiplomacyManager(this.viewingCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager otherCivDiplomacyManager = diplomacyManager;
        Table diplomacyTable = new Table();
        diplomacyTable.defaults().pad(10.0f);
        String helloText = null;
        String helloVoice = null;
        if (otherCivDiplomacyManager.isRelationshipLevelLE(RelationshipLevel.Enemy)) {
            helloText = otherCiv.getNation().getHateHello();
            helloVoice = otherCiv.getCivName() + ".hateHello";
        } else {
            helloText = otherCiv.getNation().getNeutralHello();
            helloVoice = otherCiv.getCivName() + ".neutralHello";
        }
        LeaderIntroTable leaderIntroTable = new LeaderIntroTable(otherCiv, helloText);
        diplomacyTable.add((Actor)leaderIntroTable).row();
        Scene2dExtensionsKt.addSeparator$default(diplomacyTable, null, 0, 0.0f, 7, null);
        boolean diplomaticRelationshipsCanChange = !IHasUniques.hasUnique$default(this.viewingCiv.getGameInfo().getRuleset().getModOptions(), UniqueType.DiplomaticRelationshipsCannotChange, null, 2, null);
        DiplomacyManager diplomacyManager2 = this.viewingCiv.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager2);
        DiplomacyManager diplomacyManager3 = diplomacyManager2;
        if (!this.viewingCiv.isAtWarWith(otherCiv)) {
            diplomacyTable.add((Actor)this.getTradeButton(otherCiv)).row();
            if (!diplomacyManager3.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
                diplomacyTable.add((Actor)this.getDeclareFriendshipButton(otherCiv)).row();
            }
            if (!diplomacyManager3.hasFlag(DiplomacyFlags.Denunciation) && !diplomacyManager3.hasFlag(DiplomacyFlags.DeclarationOfFriendship)) {
                diplomacyTable.add((Actor)this.getDenounceButton(otherCiv, diplomacyManager3)).row();
            }
            if (diplomaticRelationshipsCanChange) {
                diplomacyTable.add((Actor)this.diplomacyScreen.getDeclareWarButton$core(diplomacyManager3, otherCiv)).row();
            }
        } else if (diplomaticRelationshipsCanChange) {
            TextButton negotiatePeaceButton = this.getNegotiatePeaceMajorCivButton(otherCiv, otherCivDiplomacyManager);
            diplomacyTable.add((Actor)negotiatePeaceButton).row();
        }
        TextButton demandsButton = Scene2dExtensionsKt.toTextButton$default("Demands", null, false, 3, null);
        ActivationExtensionsKt.onClick(demandsButton, () -> MajorCivDiplomacyTable.getMajorCivDiplomacyTable$lambda$0(this, otherCiv));
        diplomacyTable.add((Actor)demandsButton).row();
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(demandsButton);
        }
        if (Civilization.getCapital$default(otherCiv, false, 1, null) != null) {
            City city = Civilization.getCapital$default(otherCiv, false, 1, null);
            Intrinsics.checkNotNull(city);
            if (this.viewingCiv.hasExplored(city.getCenterTile())) {
                diplomacyTable.add((Actor)this.diplomacyScreen.getGoToOnMapButton$core(otherCiv)).row();
            }
        }
        if (otherCiv.isHuman()) {
            diplomacyTable.add((Actor)this.diplomacyScreen.getHumanRelationshipTable$core(otherCivDiplomacyManager)).row();
        } else {
            diplomacyTable.add((Actor)this.diplomacyScreen.getRelationshipTable$core(otherCivDiplomacyManager)).row();
            diplomacyTable.add((Actor)this.getDiplomacyModifiersTable(otherCivDiplomacyManager)).row();
        }
        Table promisesTable = this.getPromisesTable(diplomacyManager3, otherCivDiplomacyManager);
        if (promisesTable != null) {
            diplomacyTable.add((Actor)promisesTable).row();
        }
        UncivGame.Companion.getCurrent().getMusicController().playVoice(helloVoice);
        return diplomacyTable;
    }

    private final TextButton getNegotiatePeaceMajorCivButton(Civilization otherCiv, DiplomacyManager otherCivDiplomacyManager) {
        TextButton negotiatePeaceButton = Scene2dExtensionsKt.toTextButton$default("Negotiate Peace", null, false, 3, null);
        ActivationExtensionsKt.onClick(negotiatePeaceButton, () -> MajorCivDiplomacyTable.getNegotiatePeaceMajorCivButton$lambda$0(this, otherCiv));
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(negotiatePeaceButton);
        }
        if (otherCivDiplomacyManager.hasFlag(DiplomacyFlags.DeclaredWar)) {
            Scene2dExtensionsKt.disable(negotiatePeaceButton);
            int turnsLeft = otherCivDiplomacyManager.getFlag(DiplomacyFlags.DeclaredWar);
            negotiatePeaceButton.setText(negotiatePeaceButton.getText() + '\n' + TranslationsKt.tr(turnsLeft) + '\u23f3');
        }
        return negotiatePeaceButton;
    }

    private final TextButton getDenounceButton(Civilization otherCiv, DiplomacyManager diplomacyManager) {
        TextButton denounceButton = Scene2dExtensionsKt.toTextButton$default("Denounce ([30] turns)", null, false, 3, null);
        ActivationExtensionsKt.onClick(denounceButton, () -> MajorCivDiplomacyTable.getDenounceButton$lambda$0(this, otherCiv, diplomacyManager));
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(denounceButton);
        }
        return denounceButton;
    }

    private final TextButton getDeclareFriendshipButton(Civilization otherCiv) {
        TextButton declareFriendshipButton;
        block9: {
            block8: {
                boolean bl;
                block7: {
                    declareFriendshipButton = Scene2dExtensionsKt.toTextButton$default("Offer Declaration of Friendship ([30] turns)", null, false, 3, null);
                    ActivationExtensionsKt.onClick(declareFriendshipButton, () -> MajorCivDiplomacyTable.getDeclareFriendshipButton$lambda$0(otherCiv, this, declareFriendshipButton));
                    if (this.diplomacyScreen.isNotPlayersTurn$core()) break block8;
                    Iterable $this$any$iv = otherCiv.getPopupAlerts();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PopupAlert it = (PopupAlert)element$iv;
                            boolean bl2 = false;
                            if (!(it.getType() == AlertType.DeclarationOfFriendship && Intrinsics.areEqual(it.getValue(), this.viewingCiv.getCivID()))) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block9;
            }
            Scene2dExtensionsKt.disable(declareFriendshipButton);
        }
        return declareFriendshipButton;
    }

    private final TextButton getTradeButton(Civilization otherCiv) {
        TextButton tradeButton = Scene2dExtensionsKt.toTextButton$default("Trade", null, false, 3, null);
        ActivationExtensionsKt.onClick(tradeButton, () -> MajorCivDiplomacyTable.getTradeButton$lambda$0(this, otherCiv));
        if (this.diplomacyScreen.isNotPlayersTurn$core()) {
            Scene2dExtensionsKt.disable(tradeButton);
        }
        return tradeButton;
    }

    private final Table getPromisesTable(DiplomacyManager diplomacyManager, DiplomacyManager otherCivDiplomacyManager) {
        Table promisesTable = new Table();
        for (Demand demand : Demand.getEntries()) {
            String text2;
            String[] stringArray;
            int turnsLeft;
            if (otherCivDiplomacyManager.hasFlag(demand.getAgreedToDemand())) {
                turnsLeft = otherCivDiplomacyManager.getFlag(demand.getAgreedToDemand());
                stringArray = new String[]{String.valueOf(turnsLeft)};
                text2 = TranslationsKt.fillPlaceholders(demand.getWePromisedText(), stringArray);
                Color color = Color.LIGHT_GRAY;
                Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
                promisesTable.add((Actor)Scene2dExtensionsKt.toLabel$default(text2, color, 0, 0, false, 14, null)).row();
            }
            if (!diplomacyManager.hasFlag(demand.getAgreedToDemand())) continue;
            turnsLeft = diplomacyManager.getFlag(demand.getAgreedToDemand());
            stringArray = new String[]{String.valueOf(turnsLeft)};
            text2 = TranslationsKt.fillPlaceholders(demand.getTheyPromisedText(), stringArray);
            Color color = Color.LIGHT_GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
            promisesTable.add((Actor)Scene2dExtensionsKt.toLabel$default(text2, color, 0, 0, false, 14, null)).row();
        }
        return promisesTable.getCells().isEmpty() ? null : promisesTable;
    }

    private final Table getDiplomacyModifiersTable(DiplomacyManager otherCivDiplomacyManager) {
        Table diplomacyModifiersTable = new Table();
        for (Map.Entry modifier : ((Map)otherCivDiplomacyManager.getDiplomaticModifiers()).entrySet()) {
            DiplomaticModifiers diplomaticModifier;
            if (Intrinsics.areEqual(modifier.getKey(), "AttackedProtectedMinor") && otherCivDiplomacyManager.hasModifier(DiplomaticModifiers.DestroyedProtectedMinor) || DiplomaticModifiers.Companion.safeValueOf((String)modifier.getKey()) == null) continue;
            String text2 = TranslationsKt.tr$default(diplomaticModifier.getText(), false, false, 3, null) + ' ';
            if (((Number)modifier.getValue()).floatValue() > 0.0f) {
                text2 = text2 + '+';
            }
            text2 = text2 + MathKt.roundToInt(((Number)modifier.getValue()).floatValue());
            Color color = ((Number)modifier.getValue()).floatValue() < 0.0f ? Color.RED : Color.GREEN;
            Intrinsics.checkNotNull(color);
            diplomacyModifiersTable.add((Actor)Scene2dExtensionsKt.toLabel$default(text2, color, 0, 0, false, 14, null)).row();
        }
        return diplomacyModifiersTable;
    }

    private final Table getDemandsTable(Civilization viewingCiv, Civilization otherCiv) {
        Table demandsTable = new Table();
        demandsTable.defaults().pad(10.0f);
        DiplomacyManager diplomacyManager = viewingCiv.getDiplomacyManager(otherCiv);
        Intrinsics.checkNotNull(diplomacyManager);
        DiplomacyManager diplomacyManager2 = diplomacyManager;
        for (Demand demand : Demand.getEntries()) {
            boolean bl;
            TextButton button;
            block6: {
                button = Scene2dExtensionsKt.toTextButton$default(demand.getDemandText(), null, false, 3, null);
                Iterable $this$any$iv = otherCiv.getPopupAlerts();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PopupAlert it = (PopupAlert)element$iv;
                        boolean bl2 = false;
                        if (!(it.getType() == demand.getDemandAlert() && Intrinsics.areEqual(it.getValue(), viewingCiv.getCivID()))) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl || diplomacyManager2.hasFlag(demand.getAgreedToDemand())) {
                Scene2dExtensionsKt.disable(button);
            } else {
                ActivationExtensionsKt.onClick(button, () -> MajorCivDiplomacyTable.getDemandsTable$lambda$1(otherCiv, demand, viewingCiv, button));
            }
            demandsTable.add((Actor)button).row();
        }
        demandsTable.add(ActivationExtensionsKt.onClick(Scene2dExtensionsKt.toTextButton$default("Close", null, false, 3, null), () -> MajorCivDiplomacyTable.getDemandsTable$lambda$2(this, otherCiv)));
        return demandsTable;
    }

    private static final Unit getMajorCivDiplomacyTable$lambda$0(MajorCivDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.getRightSideTable$core().clear();
        this$0.diplomacyScreen.getRightSideTable$core().add((Actor)this$0.getDemandsTable(this$0.viewingCiv, $otherCiv));
        return Unit.INSTANCE;
    }

    private static final Unit getNegotiatePeaceMajorCivButton$lambda$0(MajorCivDiplomacyTable this$0, Civilization $otherCiv) {
        TradeTable tradeTable = this$0.diplomacyScreen.setTrade$core($otherCiv);
        TradeOffer peaceTreaty = new TradeOffer("Peace Treaty", TradeOfferType.Treaty, 0, this$0.viewingCiv.getGameInfo().getSpeed(), 4, null);
        tradeTable.getTradeLogic$core().getCurrentTrade().getTheirOffers().add(peaceTreaty);
        tradeTable.getTradeLogic$core().getCurrentTrade().getOurOffers().add(peaceTreaty);
        tradeTable.getOfferColumnsTable$core().update();
        tradeTable.enableOfferButton(true);
        return Unit.INSTANCE;
    }

    private static final Unit getDenounceButton$lambda$0$0(DiplomacyManager $diplomacyManager, MajorCivDiplomacyTable this$0, Civilization $otherCiv) {
        $diplomacyManager.denounce();
        this$0.diplomacyScreen.updateLeftSideTable$core($otherCiv);
        this$0.diplomacyScreen.setRightSideFlavorText$core($otherCiv, ((CharSequence)$otherCiv.getNation().getDenounced()).length() > 0 ? $otherCiv.getNation().getDenounced() : "We will remember this.", "Very well.");
        MusicController music = UncivGame.Companion.getCurrent().getMusicController();
        music.playVoice($otherCiv.getNation().getName() + ".denounced");
        return Unit.INSTANCE;
    }

    private static final Unit getDenounceButton$lambda$0(MajorCivDiplomacyTable this$0, Civilization $otherCiv, DiplomacyManager $diplomacyManager) {
        Popup.open$default(new ConfirmPopup(this$0.diplomacyScreen, "Denounce [" + $otherCiv.getCivName() + "]?", "Denounce ([30] turns)", false, null, () -> MajorCivDiplomacyTable.getDenounceButton$lambda$0$0($diplomacyManager, this$0, $otherCiv), 24, null), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit getDeclareFriendshipButton$lambda$0(Civilization $otherCiv, MajorCivDiplomacyTable this$0, TextButton $declareFriendshipButton) {
        $otherCiv.getPopupAlerts().add(new PopupAlert(AlertType.DeclarationOfFriendship, this$0.viewingCiv.getCivID()));
        Scene2dExtensionsKt.disable($declareFriendshipButton);
        return Unit.INSTANCE;
    }

    private static final Unit getTradeButton$lambda$0(MajorCivDiplomacyTable this$0, Civilization $otherCiv) {
        TradeTable tradeTable;
        TradeTable $this$getTradeButton_u24lambda_u240_u240 = tradeTable = this$0.diplomacyScreen.setTrade$core($otherCiv);
        boolean bl = false;
        $this$getTradeButton_u24lambda_u240_u240.getOfferColumnsTable$core().update();
        return Unit.INSTANCE;
    }

    private static final Unit getDemandsTable$lambda$1(Civilization $otherCiv, Demand $demand, Civilization $viewingCiv, TextButton $button) {
        $otherCiv.getPopupAlerts().add(new PopupAlert($demand.getDemandAlert(), $viewingCiv.getCivID()));
        Scene2dExtensionsKt.disable($button);
        return Unit.INSTANCE;
    }

    private static final Unit getDemandsTable$lambda$2(MajorCivDiplomacyTable this$0, Civilization $otherCiv) {
        this$0.diplomacyScreen.updateRightSide$core($otherCiv);
        return Unit.INSTANCE;
    }
}

