/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.diplomacyscreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.trade.TradeLogic;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.diplomacyscreen.DiplomacyScreen;
import com.unciv.ui.screens.diplomacyscreen.OfferColumnsTable;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/unciv/ui/screens/diplomacyscreen/TradeTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "civ", "Lcom/unciv/logic/civilization/Civilization;", "otherCivilization", "diplomacyScreen", "Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/diplomacyscreen/DiplomacyScreen;)V", "tradeLogic", "Lcom/unciv/logic/trade/TradeLogic;", "getTradeLogic$core", "()Lcom/unciv/logic/trade/TradeLogic;", "offerColumnsTable", "Lcom/unciv/ui/screens/diplomacyscreen/OfferColumnsTable;", "getOfferColumnsTable$core", "()Lcom/unciv/ui/screens/diplomacyscreen/OfferColumnsTable;", "offerColumnsTableWrapper", "offerTradeText", "", "getOfferTradeText", "()Ljava/lang/String;", "offerButton", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "isTradeOffered", "", "retractOffer", "", "onChange", "enableOfferButton", "isEnabled", "core"})
@SourceDebugExtension(value={"SMAP\nTradeTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TradeTable.kt\ncom/unciv/ui/screens/diplomacyscreen/TradeTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n1#2:101\n296#3,2:102\n1807#3,3:104\n1807#3,3:107\n296#3,2:110\n296#3,2:112\n231#3,2:114\n231#3,2:116\n*S KotlinDebug\n*F\n+ 1 TradeTable.kt\ncom/unciv/ui/screens/diplomacyscreen/TradeTable\n*L\n42#1:102,2\n28#1:104,3\n59#1:107,3\n61#1:110,2\n62#1:112,2\n67#1:114,2\n72#1:116,2\n*E\n"})
public final class TradeTable
extends Table {
    @NotNull
    private final Civilization civ;
    @NotNull
    private final Civilization otherCivilization;
    @NotNull
    private final TradeLogic tradeLogic;
    @NotNull
    private final OfferColumnsTable offerColumnsTable;
    @NotNull
    private final Table offerColumnsTableWrapper;
    @NotNull
    private final String offerTradeText;
    @NotNull
    private final TextButton offerButton;

    public TradeTable(@NotNull Civilization civ, @NotNull Civilization otherCivilization, @NotNull DiplomacyScreen diplomacyScreen) {
        Object v0;
        Table lowerTable;
        block4: {
            Table table2;
            Intrinsics.checkNotNullParameter(civ, "civ");
            Intrinsics.checkNotNullParameter(otherCivilization, "otherCivilization");
            Intrinsics.checkNotNullParameter(diplomacyScreen, "diplomacyScreen");
            super(BaseScreen.Companion.getSkin());
            this.civ = civ;
            this.otherCivilization = otherCivilization;
            this.tradeLogic = new TradeLogic(this.civ, this.otherCivilization);
            this.offerColumnsTable = new OfferColumnsTable(this.tradeLogic, diplomacyScreen, this.civ, this.otherCivilization, () -> TradeTable.offerColumnsTable$lambda$0(this));
            this.offerColumnsTableWrapper = new Table();
            this.offerTradeText = "{Offer trade}\n({They'll decide on their turn})";
            this.offerButton = Scene2dExtensionsKt.toTextButton$default(this.offerTradeText, null, false, 3, null);
            this.offerColumnsTableWrapper.add((Actor)this.offerColumnsTable);
            this.add((Actor)this.offerColumnsTableWrapper).row();
            Table $this$_init__u24lambda_u240 = table2 = new Table();
            boolean bl = false;
            $this$_init__u24lambda_u240.defaults().pad(10.0f);
            lowerTable = table2;
            Iterable $this$firstOrNull$iv = this.otherCivilization.getTradeRequests();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TradeRequest it = (TradeRequest)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual(it.getRequestingCiv(), this.civ.getCivID())) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        TradeRequest existingOffer = v0;
        if (existingOffer != null) {
            this.tradeLogic.getCurrentTrade().set(existingOffer.getTrade().reverse());
            this.offerColumnsTable.update();
        }
        if (this.isTradeOffered()) {
            this.offerButton.setText(TranslationsKt.tr$default("Retract offer", false, false, 3, null));
        } else {
            TextButton textButton;
            TextButton $this$_init__u24lambda_u242 = textButton = this.offerButton;
            boolean bl = false;
            Scene2dExtensionsKt.setEnabled($this$_init__u24lambda_u242, false);
            textButton.setText(TranslationsKt.tr$default(this.offerTradeText, false, false, 3, null));
        }
        ActivationExtensionsKt.onClick(this.offerButton, () -> TradeTable._init_$lambda$3(this));
        lowerTable.add((Actor)this.offerButton);
        lowerTable.pack();
        lowerTable.setY(10.0f);
        this.add((Actor)lowerTable);
        this.pack();
    }

    @NotNull
    public final TradeLogic getTradeLogic$core() {
        return this.tradeLogic;
    }

    @NotNull
    public final OfferColumnsTable getOfferColumnsTable$core() {
        return this.offerColumnsTable;
    }

    @NotNull
    public final String getOfferTradeText() {
        return this.offerTradeText;
    }

    private final boolean isTradeOffered() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.otherCivilization.getTradeRequests();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TradeRequest it = (TradeRequest)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getRequestingCiv(), this.civ.getCivID())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final void retractOffer() {
        CollectionsKt.removeAll((List)this.otherCivilization.getTradeRequests(), arg_0 -> TradeTable.retractOffer$lambda$0(this, arg_0));
        this.civ.getCache().updateCivResources();
        this.offerButton.setText(TranslationsKt.tr$default(this.offerTradeText, false, false, 3, null));
    }

    private final void onChange() {
        this.offerColumnsTable.update();
        this.retractOffer();
        Scene2dExtensionsKt.setEnabled(this.offerButton, this.tradeLogic.getCurrentTrade().getTheirOffers().size() != 0 || this.tradeLogic.getCurrentTrade().getOurOffers().size() != 0);
    }

    public final void enableOfferButton(boolean isEnabled) {
        Scene2dExtensionsKt.setEnabled(this.offerButton, isEnabled);
    }

    private static final Unit offerColumnsTable$lambda$0(TradeTable this$0) {
        this$0.onChange();
        return Unit.INSTANCE;
    }

    private static final boolean retractOffer$lambda$0(TradeTable this$0, TradeRequest it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Intrinsics.areEqual(it.getRequestingCiv(), this$0.civ.getCivID());
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$3(TradeTable this$0) {
        boolean bl;
        block11: {
            if (this$0.isTradeOffered()) {
                this$0.retractOffer();
                return Unit.INSTANCE;
            }
            Iterable $this$any$iv = this$0.tradeLogic.getCurrentTrade().getOurOffers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TradeOffer it = (TradeOffer)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getName(), "Research Agreement")) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            OfferColumnsTable offerColumnsTable;
            Object v3;
            int currentPlayerOfferedGold;
            int researchCost;
            block13: {
                Object v1;
                block12: {
                    researchCost = this$0.civ.getDiplomacyFunctions().getResearchAgreementCost(this$0.otherCivilization);
                    Iterable $this$firstOrNull$iv = this$0.tradeLogic.getCurrentTrade().getOurOffers();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        TradeOffer it = (TradeOffer)element$iv;
                        boolean bl3 = false;
                        if (!(it.getType() == TradeOfferType.Gold)) continue;
                        v1 = element$iv;
                        break block12;
                    }
                    v1 = null;
                }
                TradeOffer tradeOffer = v1;
                currentPlayerOfferedGold = tradeOffer != null ? tradeOffer.getAmount() : 0;
                Iterable $this$firstOrNull$iv = this$0.tradeLogic.getCurrentTrade().getTheirOffers();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TradeOffer it = (TradeOffer)element$iv;
                    boolean bl4 = false;
                    if (!(it.getType() == TradeOfferType.Gold)) continue;
                    v3 = element$iv;
                    break block13;
                }
                v3 = null;
            }
            TradeOffer tradeOffer = v3;
            int otherCivOfferedGold = tradeOffer != null ? tradeOffer.getAmount() : 0;
            int newCurrentPlayerGold = this$0.civ.getGold() + otherCivOfferedGold - researchCost;
            int newOtherCivGold = this$0.otherCivilization.getGold() + currentPlayerOfferedGold - researchCost;
            if (newCurrentPlayerGold < 0) {
                Object element$iv2;
                block14: {
                    void $this$first$iv;
                    Iterable $i$f$firstOrNull = this$0.tradeLogic.getTheirAvailableOffers();
                    offerColumnsTable = this$0.offerColumnsTable;
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        TradeOffer it = (TradeOffer)element$iv2;
                        boolean bl5 = false;
                        if (!(it.getType() == TradeOfferType.Gold)) continue;
                        break block14;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                offerColumnsTable.addOffer(TradeOffer.copy$default((TradeOffer)element$iv2, null, null, -newCurrentPlayerGold, 0, 11, null), this$0.tradeLogic.getCurrentTrade().getTheirOffers(), this$0.tradeLogic.getCurrentTrade().getOurOffers());
            }
            if (newOtherCivGold < 0) {
                Object element$iv3;
                block15: {
                    Iterable $this$first$iv = this$0.tradeLogic.getOurAvailableOffers();
                    offerColumnsTable = this$0.offerColumnsTable;
                    boolean $i$f$first = false;
                    for (Object element$iv3 : $this$first$iv) {
                        TradeOffer it = (TradeOffer)element$iv3;
                        boolean bl6 = false;
                        if (!(it.getType() == TradeOfferType.Gold)) continue;
                        break block15;
                    }
                    throw new NoSuchElementException("Collection contains no element matching the predicate.");
                }
                offerColumnsTable.addOffer(TradeOffer.copy$default((TradeOffer)element$iv3, null, null, -newOtherCivGold, 0, 11, null), this$0.tradeLogic.getCurrentTrade().getOurOffers(), this$0.tradeLogic.getCurrentTrade().getTheirOffers());
            }
        }
        this$0.otherCivilization.getTradeRequests().add(new TradeRequest(this$0.civ.getCivID(), this$0.tradeLogic.getCurrentTrade().reverse()));
        this$0.civ.getCache().updateCivResources();
        this$0.offerButton.setText(TranslationsKt.tr$default("Retract offer", false, false, 3, null));
        return Unit.INSTANCE;
    }
}

