/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.multiplayerscreens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.UncivGame;
import com.unciv.logic.IdChecker;
import com.unciv.logic.multiplayer.FriendList;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivTextField;
import com.unciv.ui.popups.ToastPopup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.multiplayerscreens.ViewFriendsListScreen;
import com.unciv.ui.screens.pickerscreens.PickerScreen;
import com.unciv.utils.StringExtensionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/unciv/ui/screens/multiplayerscreens/AddFriendScreen;", "Lcom/unciv/ui/screens/pickerscreens/PickerScreen;", "<init>", "()V", "core"})
public final class AddFriendScreen
extends PickerScreen {
    public AddFriendScreen() {
        super(false, 1, null);
        UncivTextField friendNameTextField = new UncivTextField("Please input a name for your friend!", null, null, 6, null);
        TextButton pastePlayerIDButton = Scene2dExtensionsKt.toTextButton$default("Paste player ID from clipboard", null, false, 3, null);
        UncivTextField playerIDTextField = new UncivTextField("Please input a player ID for your friend!", null, null, 6, null);
        FriendList friendlist = new FriendList();
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Friend name")).row();
        this.getTopTable().add((Actor)friendNameTextField).pad(10.0f).padBottom(30.0f).width(this.getStage().getWidth() / (float)2).row();
        ActivationExtensionsKt.onClick(pastePlayerIDButton, () -> AddFriendScreen._init_$lambda$0(playerIDTextField));
        this.getTopTable().add((Actor)Scene2dExtensionsKt.toLabel("Player ID")).row();
        Table gameIDTable = new Table();
        gameIDTable.add((Actor)playerIDTextField).pad(10.0f).width((float)2 * this.getStage().getWidth() / (float)3 - pastePlayerIDButton.getWidth());
        gameIDTable.add((Actor)pastePlayerIDButton);
        this.getTopTable().add((Actor)gameIDTable).padBottom(30.0f).row();
        this.getCloseButton().setText(TranslationsKt.tr$default("Back", false, false, 3, null));
        ActivationExtensionsKt.onClick(this.getCloseButton(), AddFriendScreen::_init_$lambda$1);
        this.getRightSideButton().setText(TranslationsKt.tr$default("Add friend", false, false, 3, null));
        Scene2dExtensionsKt.enable(this.getRightSideButton());
        ActivationExtensionsKt.onClick(this.getRightSideButton(), () -> AddFriendScreen._init_$lambda$2(playerIDTextField, this, friendlist, friendNameTextField));
    }

    private static final Unit _init_$lambda$0(UncivTextField $playerIDTextField) {
        $playerIDTextField.setText(Gdx.app.getClipboard().getContents());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1() {
        UncivGame.popScreen$default(UncivGame.Companion.getCurrent(), false, 1, null);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(UncivTextField $playerIDTextField, AddFriendScreen this$0, FriendList $friendlist, UncivTextField $friendNameTextField) {
        String string = $playerIDTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string, "getText(...)");
        String string2 = IdChecker.INSTANCE.checkAndReturnPlayerUuid(string);
        if (!(string2 != null ? StringExtensionsKt.isUUID(string2) : false)) {
            new ToastPopup("Player ID is incorrect", this$0, 0L, 4, null);
            return Unit.INSTANCE;
        }
        String string3 = $friendNameTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
        String string4 = $playerIDTextField.getText();
        Intrinsics.checkNotNullExpressionValue(string4, "getText(...)");
        switch (WhenMappings.$EnumSwitchMapping$0[$friendlist.add(string3, string4).ordinal()]) {
            case 1: {
                Object object = new ToastPopup("Friend name is already in your friends list!", this$0, 0L, 4, null);
                break;
            }
            case 2: {
                Object object = new ToastPopup("Player ID is already in your friends list!", this$0, 0L, 4, null);
                break;
            }
            case 3: {
                Object object = new ToastPopup("You have to write a name for your friend!", this$0, 0L, 4, null);
                break;
            }
            case 4: {
                Object object = new ToastPopup("You have to write an ID for your friend!", this$0, 0L, 4, null);
                break;
            }
            case 5: {
                Object object = new ToastPopup("You cannot add your own player ID in your friend list!", this$0, 0L, 4, null);
                break;
            }
            default: {
                BaseScreen newScreen = UncivGame.popScreen$default(UncivGame.Companion.getCurrent(), false, 1, null);
                if (newScreen instanceof ViewFriendsListScreen) {
                    ((ViewFriendsListScreen)newScreen).refreshFriendsList();
                }
                Object object = Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FriendList.ErrorType.values().length];
            try {
                nArray[FriendList.ErrorType.NAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FriendList.ErrorType.ID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FriendList.ErrorType.NONAME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FriendList.ErrorType.NOID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FriendList.ErrorType.YOURSELF.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

