/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.newgamescreen;

import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.CheckBox;
import com.badlogic.gdx.scenes.scene2d.ui.SelectBox;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import com.unciv.UncivGame;
import com.unciv.logic.civilization.PlayerType;
import com.unciv.models.metadata.BaseRuleset;
import com.unciv.models.metadata.GameParameters;
import com.unciv.models.metadata.Player;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetCache;
import com.unciv.models.ruleset.Speed;
import com.unciv.models.ruleset.Victory;
import com.unciv.models.ruleset.nation.Nation;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.validation.RulesetErrorList;
import com.unciv.models.skins.SkinStrings;
import com.unciv.ui.audio.MusicController;
import com.unciv.ui.audio.MusicMood;
import com.unciv.ui.audio.MusicTrackChooserFlags;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.components.widgets.TranslatedSelectBox;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.Popup;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.multiplayerscreens.MultiplayerHelpers;
import com.unciv.ui.screens.newgamescreen.GameOptionsTable;
import com.unciv.ui.screens.newgamescreen.IPreviousScreen;
import com.unciv.ui.screens.newgamescreen.ModCheckboxTable;
import com.unciv.ui.screens.newgamescreen.NewGameModCheckHelpersKt;
import com.unciv.ui.screens.newgamescreen.RandomNationPickerPopup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KMutableProperty1;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001:\u0001`BJ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010$\u001a\u00020\fJI\u0010%\u001a\u00020!*\u00020\u00012\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u00052\b\b\u0002\u0010(\u001a\u00020\u00052!\u0010)\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(*\u0012\u0004\u0012\u00020\f0\u0007H\u0002J\f\u0010+\u001a\u00020!*\u00020\u0001H\u0002J\f\u0010,\u001a\u00020!*\u00020\u0001H\u0002J\f\u0010-\u001a\u00020!*\u00020\u0001H\u0002J\f\u0010.\u001a\u00020!*\u00020\u0001H\u0002J\f\u0010/\u001a\u00020!*\u00020\u0001H\u0002J\f\u00100\u001a\u00020!*\u00020\u0001H\u0002J\f\u00101\u001a\u00020!*\u00020\u0001H\u0002J\f\u00102\u001a\u00020!*\u00020\u0001H\u0002J\f\u00103\u001a\u00020\f*\u00020\u0001H\u0002J\f\u00104\u001a\u00020!*\u00020\u0001H\u0002J\f\u00105\u001a\u00020\f*\u00020\u0001H\u0002J\b\u00106\u001a\u00020\u001bH\u0002J\b\u00107\u001a\u00020\u001bH\u0002J\f\u00108\u001a\u00020!*\u00020\u0001H\u0002J\f\u00109\u001a\u00020!*\u00020\u0001H\u0002J\f\u0010:\u001a\u00020!*\u00020\u0001H\u0002JZ\u0010;\u001a\u00020\f*\u00020\u00012\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010>\u001a\u00020\b2\u0006\u0010?\u001a\u00020\b2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001b0A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u001b0A2\u0010\b\u0002\u0010C\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000eH\u0002J\f\u0010D\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010E\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010F\u001a\u00020\f*\u00020\u0001H\u0002J\u000e\u0010G\u001a\u0004\u0018\u00010H*\u00020\u0001H\u0002JO\u0010I\u001a\u00020#*\u00020\u00012\u0006\u0010&\u001a\u00020\b2\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\b0K2\u0006\u0010'\u001a\u00020\b2#\u0010)\u001a\u001f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(*\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0002J\f\u0010L\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010M\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010N\u001a\u00020\f*\u00020\u0001H\u0002J\f\u0010O\u001a\u00020\f*\u00020\u0001H\u0002J@\u0010P\u001a\u00020\f*\u00020\u00012\u0006\u0010Q\u001a\u00020\b2\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001b0S2\u0006\u0010T\u001a\u00020\u001b2\u0006\u0010U\u001a\u00020\u001b2\u0006\u0010V\u001a\u00020\u001bH\u0002J\b\u0010W\u001a\u00020\fH\u0002J\u000e\u0010X\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010Y\u001a\u00020\fJ\b\u0010Z\u001a\u00020\fH\u0002J\u0012\u0010[\u001a\u00020\u001d2\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\\\u001a\u00020\f2\u0006\u0010]\u001a\u00020\bH\u0002J\u000e\u0010^\u001a\u00020\f2\u0006\u0010_\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/unciv/ui/screens/newgamescreen/GameOptionsTable;", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "previousScreen", "Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;", "isPortrait", "", "updatePlayerPickerTable", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "desiredCiv", "", "updatePlayerPickerRandomLabel", "Lkotlin/Function0;", "<init>", "(Lcom/unciv/ui/screens/newgamescreen/IPreviousScreen;ZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "locked", "getLocked$core", "()Z", "setLocked$core", "(Z)V", "baseRulesetHash", "", "modCheckboxes", "Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable;", "getModCheckboxes$core", "()Lcom/unciv/ui/screens/newgamescreen/ModCheckboxTable;", "randomNationsPoolCheckbox", "Lcom/badlogic/gdx/scenes/scene2d/ui/CheckBox;", "baseRulesetSelectBox", "Lcom/unciv/ui/components/widgets/TranslatedSelectBox;", "update", "addCheckbox", "text", "initialState", "lockable", "onChange", "newValue", "addNoCityRazingCheckbox", "addNoBarbariansCheckbox", "addRagingBarbariansCheckbox", "addOneCityChallengeCheckbox", "addNuclearWeaponsCheckbox", "addIsOnlineMultiplayerCheckbox", "addAnyoneCanSpectateCheckbox", "addEnableEspionageCheckbox", "addRandomNationsPoolCheckbox", "addShowVictoryStatsCheckbox", "addNationsSelectTextButton", "numberOfMajorCivs", "numberOfCityStates", "addNoStartBiasCheckbox", "addRandomPlayersCheckbox", "addRandomCityStatesCheckbox", "addLinkedMinMaxSliders", "minValue", "maxValue", "minText", "maxText", "minField", "Lkotlin/reflect/KMutableProperty0;", "maxField", "onChangeCallback", "addMinMaxPlayersSliders", "addMinMaxCityStatesSliders", "addCityStatesSlider", "addMaxTurnsSlider", "Lcom/unciv/ui/components/widgets/UncivSlider;", "addSelectBox", "values", "", "addDifficultySelectBox", "addBaseRulesetSelectBox", "addGameSpeedSelectBox", "addEraSelectBox", "addDurationSelectBox", "title", "param", "Lkotlin/reflect/KMutableProperty1;", "defaultDayValue", "defaultHourValue", "defaultMinuteValue", "addVictoryTypeCheckboxes", "updateRuleset", "resetRuleset", "reloadRuleset", "getModCheckboxes", "onChooseMod", "mod", "changeGameParameters", "newGameParameters", "DurationSelector", "core"})
@SourceDebugExtension(value={"SMAP\nGameOptionsTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameOptionsTable.kt\ncom/unciv/ui/screens/newgamescreen/GameOptionsTable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,704:1\n1#2:705\n1834#3,4:706\n1834#3,4:710\n2792#3,3:714\n1586#3:717\n1661#3,3:718\n777#3:721\n873#3,2:722\n*S KotlinDebug\n*F\n+ 1 GameOptionsTable.kt\ncom/unciv/ui/screens/newgamescreen/GameOptionsTable\n*L\n233#1:706,4\n237#1:710,4\n353#1:714,3\n418#1:717\n418#1:718,3\n556#1:721\n556#1:722,2\n*E\n"})
public final class GameOptionsTable
extends Table {
    @NotNull
    private final IPreviousScreen previousScreen;
    private final boolean isPortrait;
    @NotNull
    private final Function1<String, Unit> updatePlayerPickerTable;
    @NotNull
    private final Function0<Unit> updatePlayerPickerRandomLabel;
    @NotNull
    private GameParameters gameParameters;
    @NotNull
    private Ruleset ruleset;
    private boolean locked;
    private int baseRulesetHash;
    @NotNull
    private final ModCheckboxTable modCheckboxes;
    @Nullable
    private CheckBox randomNationsPoolCheckbox;
    @Nullable
    private TranslatedSelectBox baseRulesetSelectBox;

    public GameOptionsTable(@NotNull IPreviousScreen previousScreen, boolean isPortrait, @NotNull Function1<? super String, Unit> updatePlayerPickerTable, @NotNull Function0<Unit> updatePlayerPickerRandomLabel) {
        Intrinsics.checkNotNullParameter(previousScreen, "previousScreen");
        Intrinsics.checkNotNullParameter(updatePlayerPickerTable, "updatePlayerPickerTable");
        Intrinsics.checkNotNullParameter(updatePlayerPickerRandomLabel, "updatePlayerPickerRandomLabel");
        super(BaseScreen.Companion.getSkin());
        this.previousScreen = previousScreen;
        this.isPortrait = isPortrait;
        this.updatePlayerPickerTable = updatePlayerPickerTable;
        this.updatePlayerPickerRandomLabel = updatePlayerPickerRandomLabel;
        this.gameParameters = this.previousScreen.getGameSetupInfo().getGameParameters();
        this.ruleset = this.previousScreen.getRuleset();
        this.baseRulesetHash = this.gameParameters.getBaseRuleset().hashCode();
        this.modCheckboxes = this.getModCheckboxes(this.isPortrait);
        this.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "NewGameScreen/GameOptionsTable", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getClearColor(), 2, null));
        this.top();
        this.defaults().pad(5.0f);
        this.update();
    }

    public /* synthetic */ GameOptionsTable(IPreviousScreen iPreviousScreen, boolean bl, Function1 function1, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(iPreviousScreen, bl, function1, function0);
    }

    public final boolean getLocked$core() {
        return this.locked;
    }

    public final void setLocked$core(boolean bl) {
        this.locked = bl;
    }

    @NotNull
    public final ModCheckboxTable getModCheckboxes$core() {
        return this.modCheckboxes;
    }

    /*
     * WARNING - void declaration
     */
    public final void update() {
        void $this$update_u24lambda_u240_u240;
        Table table2;
        Table $this$update_u24lambda_u240;
        Table table3;
        this.clear();
        this.modCheckboxes.updateSelection();
        int newBaseRulesetHash = this.gameParameters.getBaseRuleset().hashCode();
        if (newBaseRulesetHash != this.baseRulesetHash) {
            this.baseRulesetHash = newBaseRulesetHash;
            this.modCheckboxes.setBaseRuleset(this.gameParameters.getBaseRuleset());
        }
        Table table4 = table3 = new Table();
        GameOptionsTable gameOptionsTable = this;
        boolean bl = false;
        $this$update_u24lambda_u240.defaults().pad(5.0f);
        this.addBaseRulesetSelectBox($this$update_u24lambda_u240);
        this.addDifficultySelectBox($this$update_u24lambda_u240);
        this.addGameSpeedSelectBox($this$update_u24lambda_u240);
        this.addEraSelectBox($this$update_u24lambda_u240);
        Table table5 = table2 = new Table();
        void var7_10 = $this$update_u24lambda_u240;
        boolean bl2 = false;
        UncivSlider turnSlider = this.addMaxTurnsSlider((Table)$this$update_u24lambda_u240_u240);
        if (turnSlider != null) {
            $this$update_u24lambda_u240_u240.add((Actor)turnSlider).padTop(10.0f).row();
        }
        if (this.gameParameters.getRandomNumberOfPlayers()) {
            this.addMinMaxPlayersSliders((Table)$this$update_u24lambda_u240_u240);
        }
        if (this.gameParameters.getRandomNumberOfCityStates()) {
            this.addMinMaxCityStatesSliders((Table)$this$update_u24lambda_u240_u240);
        } else {
            this.addCityStatesSlider((Table)$this$update_u24lambda_u240_u240);
        }
        var7_10.add((Actor)table2).colspan(2).fillX().row();
        gameOptionsTable.add((Actor)table3).row();
        this.addVictoryTypeCheckboxes();
        Table $this$update_u24lambda_u241 = $this$update_u24lambda_u240 = new Table();
        boolean bl3 = false;
        $this$update_u24lambda_u241.defaults().left().pad(2.5f);
        Table checkboxTable = $this$update_u24lambda_u240;
        Table selectBoxTable = new Table();
        this.addIsOnlineMultiplayerCheckbox(checkboxTable);
        if (this.gameParameters.isOnlineMultiplayer()) {
            this.addAnyoneCanSpectateCheckbox(checkboxTable);
            this.addDurationSelectBox(selectBoxTable, "Time until skip turn:", update.2.INSTANCE, 1, 0, 0);
            this.addDurationSelectBox(selectBoxTable, "Total time to play:", update.3.INSTANCE, 3, 0, 0);
            this.addDurationSelectBox(selectBoxTable, "Time recovered per turn:", update.4.INSTANCE, 3, 0, 0);
        }
        this.add((Actor)checkboxTable).center().row();
        this.add((Actor)selectBoxTable).center().row();
        ExpanderTab expander = new ExpanderTab("Advanced Settings", 0, null, this.gameParameters.getEnableRandomNationsPool(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, "GameOptionsTable.Advanced", null, null, arg_0 -> GameOptionsTable.update$lambda$2(this, arg_0), 3574, null);
        this.add((Actor)expander).pad(10.0f).row();
        if (!this.isPortrait) {
            this.add((Actor)this.modCheckboxes).padTop(0.0f).row();
        }
        this.pack();
    }

    private final CheckBox addCheckbox(Table $this$addCheckbox, String text2, boolean initialState, boolean lockable, Function1<? super Boolean, Unit> onChange) {
        CheckBox checkbox = Scene2dExtensionsKt.toCheckBox(text2, initialState, arg_0 -> GameOptionsTable.addCheckbox$lambda$0(onChange, arg_0));
        checkbox.setDisabled(lockable && this.locked);
        checkbox.align(8);
        $this$addCheckbox.add((Actor)checkbox).colspan(2).row();
        return checkbox;
    }

    static /* synthetic */ CheckBox addCheckbox$default(GameOptionsTable gameOptionsTable, Table table2, String string, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        return gameOptionsTable.addCheckbox(table2, string, bl, bl2, function1);
    }

    private final CheckBox addNoCityRazingCheckbox(Table $this$addNoCityRazingCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addNoCityRazingCheckbox, "No City Razing", this.gameParameters.getNoCityRazing(), false, arg_0 -> GameOptionsTable.addNoCityRazingCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addNoBarbariansCheckbox(Table $this$addNoBarbariansCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addNoBarbariansCheckbox, "No Barbarians", this.gameParameters.getNoBarbarians(), false, arg_0 -> GameOptionsTable.addNoBarbariansCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addRagingBarbariansCheckbox(Table $this$addRagingBarbariansCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addRagingBarbariansCheckbox, "Raging Barbarians", this.gameParameters.getRagingBarbarians(), false, arg_0 -> GameOptionsTable.addRagingBarbariansCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addOneCityChallengeCheckbox(Table $this$addOneCityChallengeCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addOneCityChallengeCheckbox, "One City Challenge", this.gameParameters.getOneCityChallenge(), false, arg_0 -> GameOptionsTable.addOneCityChallengeCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addNuclearWeaponsCheckbox(Table $this$addNuclearWeaponsCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addNuclearWeaponsCheckbox, "Enable Nuclear Weapons", this.gameParameters.getNuclearWeaponsEnabled(), false, arg_0 -> GameOptionsTable.addNuclearWeaponsCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addIsOnlineMultiplayerCheckbox(Table $this$addIsOnlineMultiplayerCheckbox) {
        return this.addCheckbox($this$addIsOnlineMultiplayerCheckbox, "Online Multiplayer", this.gameParameters.isOnlineMultiplayer(), false, arg_0 -> GameOptionsTable.addIsOnlineMultiplayerCheckbox$lambda$0(this, arg_0));
    }

    private final CheckBox addAnyoneCanSpectateCheckbox(Table $this$addAnyoneCanSpectateCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addAnyoneCanSpectateCheckbox, "Allow anyone to spectate", this.gameParameters.getAnyoneCanSpectate(), false, arg_0 -> GameOptionsTable.addAnyoneCanSpectateCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addEnableEspionageCheckbox(Table $this$addEnableEspionageCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addEnableEspionageCheckbox, "Enable Espionage", this.gameParameters.getEspionageEnabled(), false, arg_0 -> GameOptionsTable.addEnableEspionageCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final void addRandomNationsPoolCheckbox(Table $this$addRandomNationsPoolCheckbox) {
        this.randomNationsPoolCheckbox = GameOptionsTable.addCheckbox$default(this, $this$addRandomNationsPoolCheckbox, "Set available nations for random pool", this.gameParameters.getEnableRandomNationsPool(), false, arg_0 -> GameOptionsTable.addRandomNationsPoolCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addShowVictoryStatsCheckbox(Table $this$addShowVictoryStatsCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addShowVictoryStatsCheckbox, "Show victory stats", this.gameParameters.getShowVictoryStats(), false, arg_0 -> GameOptionsTable.addShowVictoryStatsCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final void addNationsSelectTextButton(Table $this$addNationsSelectTextButton) {
        TextButton button = Scene2dExtensionsKt.toTextButton$default("Select nations", null, false, 3, null);
        ActivationExtensionsKt.onClick(button, () -> GameOptionsTable.addNationsSelectTextButton$lambda$0(this));
        $this$addNationsSelectTextButton.add((Actor)button);
    }

    /*
     * WARNING - void declaration
     */
    private final int numberOfMajorCivs() {
        int n;
        Collection<Nation> collection = this.ruleset.getNations().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$count$iv = collection;
        boolean $i$f$count = false;
        if (((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            void var3_3;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Nation it = (Nation)element$iv;
                boolean bl = false;
                if (!it.isMajorCiv() || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = var3_3;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    private final int numberOfCityStates() {
        block4: {
            block3: {
                v0 = this.ruleset.getNations().values();
                Intrinsics.checkNotNullExpressionValue(v0, "<get-values>(...)");
                $this$count$iv = v0;
                $i$f$count = false;
                if (!((Collection)$this$count$iv).isEmpty()) break block3;
                v1 = 0;
                break block4;
            }
            count$iv = 0;
            for (T element$iv : $this$count$iv) {
                it = (Nation)element$iv;
                $i$a$-count-GameOptionsTable$numberOfCityStates$1 = false;
                if (!it.isCityState()) ** GOTO lbl-1000
                Intrinsics.checkNotNull(it);
                if (!IHasUniques.hasUnique$default(it, UniqueType.WillNotBeChosenForNewGames, null, 2, null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2 || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            v1 = var3_3;
        }
        return v1;
    }

    private final CheckBox addNoStartBiasCheckbox(Table $this$addNoStartBiasCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addNoStartBiasCheckbox, "Disable starting bias", this.gameParameters.getNoStartBias(), false, arg_0 -> GameOptionsTable.addNoStartBiasCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addRandomPlayersCheckbox(Table $this$addRandomPlayersCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addRandomPlayersCheckbox, "Random number of Civilizations", this.gameParameters.getRandomNumberOfPlayers(), false, arg_0 -> GameOptionsTable.addRandomPlayersCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final CheckBox addRandomCityStatesCheckbox(Table $this$addRandomCityStatesCheckbox) {
        return GameOptionsTable.addCheckbox$default(this, $this$addRandomCityStatesCheckbox, "Random number of City-States", this.gameParameters.getRandomNumberOfCityStates(), false, arg_0 -> GameOptionsTable.addRandomCityStatesCheckbox$lambda$0(this, arg_0), 4, null);
    }

    private final void addLinkedMinMaxSliders(Table $this$addLinkedMinMaxSliders, int minValue, int maxValue, String minText, String maxText, KMutableProperty0<Integer> minField, KMutableProperty0<Integer> maxField, Function0<Unit> onChangeCallback) {
        UncivSlider uncivSlider;
        UncivSlider uncivSlider2;
        if (maxValue < minValue) {
            return;
        }
        Ref.ObjectRef maxSlider = new Ref.ObjectRef();
        UncivSlider minSlider = new UncivSlider(minValue, maxValue, 1.0f, false, false, ((Number)minField.get()).intValue(), null, null, null, arg_0 -> GameOptionsTable.addLinkedMinMaxSliders$lambda$0(minField, maxSlider, maxField, onChangeCallback, arg_0), 472, null);
        minSlider.setDisabled(this.locked);
        maxSlider.element = new UncivSlider(minValue, maxValue, 1.0f, false, false, ((Number)maxField.get()).intValue(), null, null, null, arg_0 -> GameOptionsTable.addLinkedMinMaxSliders$lambda$1(maxField, minSlider, minField, onChangeCallback, arg_0), 472, null);
        if (maxSlider.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("maxSlider");
            uncivSlider2 = null;
        } else {
            uncivSlider2 = (UncivSlider)maxSlider.element;
        }
        uncivSlider2.setDisabled(this.locked);
        $this$addLinkedMinMaxSliders.add((Actor)Scene2dExtensionsKt.toLabel(minText)).left().expandX();
        $this$addLinkedMinMaxSliders.add((Actor)minSlider).padTop(10.0f).row();
        $this$addLinkedMinMaxSliders.add((Actor)Scene2dExtensionsKt.toLabel(maxText)).left().expandX();
        if (maxSlider.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException("maxSlider");
            uncivSlider = null;
        } else {
            uncivSlider = (UncivSlider)maxSlider.element;
        }
        $this$addLinkedMinMaxSliders.add((Actor)uncivSlider).padTop(10.0f).row();
    }

    static /* synthetic */ void addLinkedMinMaxSliders$default(GameOptionsTable gameOptionsTable, Table table2, int n, int n2, String string, String string2, KMutableProperty0 kMutableProperty0, KMutableProperty0 kMutableProperty02, Function0 function0, int n3, Object object) {
        if ((n3 & 0x40) != 0) {
            function0 = null;
        }
        gameOptionsTable.addLinkedMinMaxSliders(table2, n, n2, string, string2, kMutableProperty0, kMutableProperty02, function0);
    }

    private final void addMinMaxPlayersSliders(Table $this$addMinMaxPlayersSliders) {
        this.addLinkedMinMaxSliders($this$addMinMaxPlayersSliders, 2, this.numberOfMajorCivs(), "{Min number of Civilizations}:", "{Max number of Civilizations}:", new MutablePropertyReference0Impl(this.gameParameters){

            public Object get() {
                return ((GameParameters)this.receiver).getMinNumberOfPlayers();
            }

            public void set(Object value) {
                ((GameParameters)this.receiver).setMinNumberOfPlayers(((Number)value).intValue());
            }
        }, new MutablePropertyReference0Impl(this.gameParameters){

            public Object get() {
                return ((GameParameters)this.receiver).getMaxNumberOfPlayers();
            }

            public void set(Object value) {
                ((GameParameters)this.receiver).setMaxNumberOfPlayers(((Number)value).intValue());
            }
        }, this.updatePlayerPickerRandomLabel);
    }

    private final void addMinMaxCityStatesSliders(Table $this$addMinMaxCityStatesSliders) {
        GameOptionsTable.addLinkedMinMaxSliders$default(this, $this$addMinMaxCityStatesSliders, 0, this.numberOfCityStates(), "{Min number of City-States}:", "{Max number of City-States}:", new MutablePropertyReference0Impl(this.gameParameters){

            public Object get() {
                return ((GameParameters)this.receiver).getMinNumberOfCityStates();
            }

            public void set(Object value) {
                ((GameParameters)this.receiver).setMinNumberOfCityStates(((Number)value).intValue());
            }
        }, new MutablePropertyReference0Impl(this.gameParameters){

            public Object get() {
                return ((GameParameters)this.receiver).getMaxNumberOfCityStates();
            }

            public void set(Object value) {
                ((GameParameters)this.receiver).setMaxNumberOfCityStates(((Number)value).intValue());
            }
        }, null, 64, null);
    }

    private final void addCityStatesSlider(Table $this$addCityStatesSlider) {
        int cityStatesAvailable = this.numberOfCityStates();
        if (cityStatesAvailable == 0) {
            return;
        }
        $this$addCityStatesSlider.add((Actor)Scene2dExtensionsKt.toLabel("{City-States}:")).left().expandX();
        UncivSlider slider2 = new UncivSlider(0.0f, cityStatesAvailable, 1.0f, false, false, this.gameParameters.getNumberOfCityStates(), null, null, null, arg_0 -> GameOptionsTable.addCityStatesSlider$lambda$0(this, arg_0), 472, null);
        slider2.setDisabled(this.locked);
        $this$addCityStatesSlider.add((Actor)slider2).padTop(10.0f).row();
    }

    private final UncivSlider addMaxTurnsSlider(Table $this$addMaxTurnsSlider) {
        boolean bl;
        block4: {
            Iterable $this$none$iv = this.gameParameters.getVictoryTypes();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Victory victory = this.ruleset.getVictories().get(it);
                    boolean bl3 = victory != null ? victory.enablesMaxTurns() : false;
                    if (!bl3) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return null;
        }
        $this$addMaxTurnsSlider.add((Actor)Scene2dExtensionsKt.toLabel("{Max Turns}:")).left().expandX();
        UncivSlider slider2 = new UncivSlider(100.0f, 1500.0f, 5.0f, false, false, this.gameParameters.getMaxTurns(), null, null, null, arg_0 -> GameOptionsTable.addMaxTurnsSlider$lambda$1(this, arg_0), 472, null);
        slider2.setDisabled(this.locked);
        Object object = new float[19];
        object[0] = 100.0f;
        object[1] = 150.0f;
        object[2] = 200.0f;
        object[3] = 250.0f;
        object[4] = 300.0f;
        object[5] = 350.0f;
        object[6] = 400.0f;
        object[7] = 450.0f;
        object[8] = 500.0f;
        object[9] = 550.0f;
        object[10] = 600.0f;
        object[11] = 650.0f;
        object[12] = 700.0f;
        object[13] = 750.0f;
        object[14] = 800.0f;
        object[15] = 900.0f;
        object[16] = 1000.0f;
        object[17] = 1250.0f;
        object[18] = 1500.0f;
        Object snapValues = object;
        slider2.setSnapToValues(125.0f, Arrays.copyOf((float[])snapValues, ((Object)snapValues).length));
        return slider2;
    }

    private final TranslatedSelectBox addSelectBox(Table $this$addSelectBox, String text2, Collection<String> values2, String initialState, Function1<? super String, String> onChange) {
        $this$addSelectBox.add((Actor)Scene2dExtensionsKt.toLabel$default(text2, null, 0, 0, true, 7, null)).left();
        TranslatedSelectBox selectBox = new TranslatedSelectBox(values2, initialState);
        selectBox.setDisabled(this.locked);
        ActivationExtensionsKt.onChange(selectBox, arg_0 -> GameOptionsTable.addSelectBox$lambda$0(onChange, selectBox, arg_0));
        onChange.invoke(((TranslatedSelectBox.TranslatedString)selectBox.getSelected()).getValue());
        $this$addSelectBox.add((Actor)selectBox).fillX().row();
        return selectBox;
    }

    private final void addDifficultySelectBox(Table $this$addDifficultySelectBox) {
        Set<String> set = this.ruleset.getDifficulties().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        this.addSelectBox($this$addDifficultySelectBox, "{Difficulty}:", (Collection<String>)set, this.gameParameters.getDifficulty(), arg_0 -> GameOptionsTable.addDifficultySelectBox$lambda$0(this, arg_0));
    }

    private final void addBaseRulesetSelectBox(Table $this$addBaseRulesetSelectBox) {
        List<String> sortedBaseRulesets = RulesetCache.INSTANCE.getSortedBaseRulesets();
        if (sortedBaseRulesets.size() < 2) {
            return;
        }
        this.baseRulesetSelectBox = this.addSelectBox($this$addBaseRulesetSelectBox, "{Base Ruleset}:", (Collection<String>)sortedBaseRulesets, this.gameParameters.getBaseRuleset(), (Function1<? super String, String>)new Function1<String, String>(this){
            final /* synthetic */ GameOptionsTable this$0;
            {
                this.this$0 = $receiver;
                super(1, Intrinsics.Kotlin.class, "onBaseRulesetSelected", "addBaseRulesetSelectBox$onBaseRulesetSelected(Lcom/unciv/ui/screens/newgamescreen/GameOptionsTable;Ljava/lang/String;)Ljava/lang/String;", 0);
            }

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return GameOptionsTable.access$addBaseRulesetSelectBox$onBaseRulesetSelected(this.this$0, p0);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void addGameSpeedSelectBox(Table $this$addGameSpeedSelectBox) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<Speed> collection2 = this.ruleset.getSpeeds().values();
        Intrinsics.checkNotNullExpressionValue(collection2, "<get-values>(...)");
        Iterable iterable = collection2;
        String string = "{Game Speed}:";
        Table table2 = $this$addGameSpeedSelectBox;
        GameOptionsTable gameOptionsTable = this;
        boolean $i$f$map = false;
        void var4_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Speed speed = (Speed)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        collection = (List)destination$iv$iv;
        gameOptionsTable.addSelectBox(table2, string, collection, this.gameParameters.getSpeed(), arg_0 -> GameOptionsTable.addGameSpeedSelectBox$lambda$1(this, arg_0));
    }

    private final void addEraSelectBox(Table $this$addEraSelectBox) {
        if (this.ruleset.getEras().isEmpty()) {
            return;
        }
        if (IHasUniques.hasUnique$default(this.ruleset.getModOptions(), UniqueType.CanOnlyStartFromStartingEra, null, 2, null)) {
            Set<String> set = this.ruleset.getEras().keySet();
            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
            this.gameParameters.setStartingEra((String)CollectionsKt.first((Iterable)set));
            return;
        }
        Set<String> set = this.ruleset.getEras().keySet();
        Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
        Set<String> eras = set;
        this.addSelectBox($this$addEraSelectBox, "{Starting Era}:", (Collection<String>)eras, this.gameParameters.getStartingEra(), arg_0 -> GameOptionsTable.addEraSelectBox$lambda$0(this, arg_0));
    }

    private final void addDurationSelectBox(Table $this$addDurationSelectBox, String title, KMutableProperty1<GameParameters, Integer> param, int defaultDayValue, int defaultHourValue, int defaultMinuteValue) {
        $this$addDurationSelectBox.add((Actor)Scene2dExtensionsKt.toLabel$default(title, null, 0, 0, true, 7, null)).right();
        DurationSelector selector = new DurationSelector(this.gameParameters, param, defaultDayValue, defaultHourValue, defaultMinuteValue, null, null, null, 224, null);
        $this$addDurationSelectBox.add((Actor)selector.getDayBox());
        $this$addDurationSelectBox.add((Actor)selector.getHourBox());
        $this$addDurationSelectBox.add((Actor)selector.getMinuteBox()).row();
    }

    private final void addVictoryTypeCheckboxes() {
        this.add((Actor)Scene2dExtensionsKt.toLabel("{Victory Conditions}:")).colspan(2).row();
        Object object = new Table();
        Table $this$addVictoryTypeCheckboxes_u24lambda_u240 = object;
        boolean bl = false;
        $this$addVictoryTypeCheckboxes_u24lambda_u240.defaults().pad(5.0f);
        Table victoryConditionsTable = object;
        object = ((Iterable)this.ruleset.getVictories().values()).iterator();
        int n = 0;
        while (object.hasNext()) {
            int i = n++;
            Object e = object.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            Victory victoryType = (Victory)e;
            CheckBox victoryCheckbox = Scene2dExtensionsKt.toCheckBox(victoryType.getName(), this.gameParameters.getVictoryTypes().contains(victoryType.getName()), arg_0 -> GameOptionsTable.addVictoryTypeCheckboxes$lambda$1(this, victoryType, arg_0));
            victoryCheckbox.setName(victoryType.getName());
            victoryCheckbox.setDisabled(this.locked);
            victoryConditionsTable.add((Actor)victoryCheckbox).left();
            if ((i + 1) % 2 != 0) continue;
            victoryConditionsTable.row();
        }
        this.add((Actor)victoryConditionsTable).colspan(2).row();
    }

    public final void updateRuleset(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.ruleset = ruleset;
        this.gameParameters.setAcceptedModCheckErrors("");
        this.modCheckboxes.updateSelection();
        this.modCheckboxes.setBaseRuleset(this.gameParameters.getBaseRuleset());
    }

    public final void resetRuleset() {
        String rulesetName = BaseRuleset.Civ_V_GnK.getFullName();
        this.gameParameters.setBaseRuleset(rulesetName);
        this.modCheckboxes.setBaseRuleset(rulesetName);
        this.modCheckboxes.disableAllCheckboxes();
        TranslatedSelectBox translatedSelectBox = this.baseRulesetSelectBox;
        if (translatedSelectBox != null) {
            translatedSelectBox.setSelected(rulesetName);
        }
        this.reloadRuleset();
    }

    private final void reloadRuleset() {
        this.ruleset.clear();
        Ruleset newRuleset = RulesetCache.INSTANCE.getComplexRuleset(this.gameParameters);
        this.ruleset.add(newRuleset);
        ((Collection)this.ruleset.getMods()).add(this.gameParameters.getBaseRuleset());
        CollectionsKt.addAll((Collection)this.ruleset.getMods(), (Iterable)this.gameParameters.getMods());
        this.ruleset.setModOptions(newRuleset.getModOptions());
        this.gameParameters.setAcceptedModCheckErrors("");
        ImageGetter.setNewRuleset$default(ImageGetter.INSTANCE, this.ruleset, false, 2, null);
        UncivGame.Companion.getCurrent().getMusicController().setModList((HashSet<String>)this.gameParameters.getModsAndBaseRuleset());
    }

    private final ModCheckboxTable getModCheckboxes(boolean isPortrait) {
        LinkedHashSet<String> linkedHashSet = this.gameParameters.getMods();
        String string = this.gameParameters.getBaseRuleset();
        IPreviousScreen iPreviousScreen = this.previousScreen;
        Intrinsics.checkNotNull(iPreviousScreen, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.BaseScreen");
        return new ModCheckboxTable(linkedHashSet, string, (BaseScreen)((Object)iPreviousScreen), isPortrait, arg_0 -> GameOptionsTable.getModCheckboxes$lambda$0(this, arg_0));
    }

    static /* synthetic */ ModCheckboxTable getModCheckboxes$default(GameOptionsTable gameOptionsTable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return gameOptionsTable.getModCheckboxes(bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void onChooseMod(String mod) {
        LinkedHashSet<String> activeMods = this.gameParameters.getModsAndBaseRuleset();
        UncivGame.Companion.getCurrent().getTranslations().setTranslationActiveMods(activeMods);
        this.reloadRuleset();
        this.update();
        String desiredCiv = "";
        if (this.gameParameters.getMods().contains(mod)) {
            MusicController music;
            List modNations;
            List list2;
            Object object = (Ruleset)RulesetCache.INSTANCE.get((Object)mod);
            if (object != null && (object = ((Ruleset)object).getNations()) != null && (object = ((LinkedHashMap)object).values()) != null) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = (Iterable)object;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Nation it = (Nation)element$iv$iv;
                    boolean bl = false;
                    if (!it.isMajorCiv()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = modNations = null;
            }
            if (modNations != null && CollectionsKt.any(modNations)) {
                desiredCiv = ((Nation)CollectionsKt.random(modNations, Random.Default)).getName();
            }
            if (!(music = UncivGame.Companion.getCurrent().getMusicController()).chooseTrack(mod, "Theme", MusicTrackChooserFlags.Companion.getSetSelectNation()) && ((CharSequence)desiredCiv).length() > 0) {
                music.chooseTrack(desiredCiv, MusicMood.INSTANCE.getThemeOrPeace(), MusicTrackChooserFlags.Companion.getSetSelectNation());
            }
        }
        this.updatePlayerPickerTable.invoke(desiredCiv);
    }

    public final void changeGameParameters(@NotNull GameParameters newGameParameters) {
        Intrinsics.checkNotNullParameter(newGameParameters, "newGameParameters");
        this.gameParameters = newGameParameters;
        this.modCheckboxes.changeGameParameters(newGameParameters);
    }

    private static final Unit update$lambda$2(GameOptionsTable this$0, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        Cell cell = it.defaults();
        Intrinsics.checkNotNullExpressionValue(cell, "defaults(...)");
        Scene2dExtensionsKt.pad(cell, 5.0f, 0.0f);
        this$0.addNoCityRazingCheckbox(it);
        this$0.addNoBarbariansCheckbox(it);
        this$0.addRagingBarbariansCheckbox(it);
        this$0.addOneCityChallengeCheckbox(it);
        this$0.addNuclearWeaponsCheckbox(it);
        this$0.addEnableEspionageCheckbox(it);
        this$0.addNoStartBiasCheckbox(it);
        this$0.addRandomPlayersCheckbox(it);
        this$0.addRandomCityStatesCheckbox(it);
        this$0.addRandomNationsPoolCheckbox(it);
        if (this$0.gameParameters.getEnableRandomNationsPool()) {
            this$0.addNationsSelectTextButton(it);
        }
        this$0.addShowVictoryStatsCheckbox(it);
        return Unit.INSTANCE;
    }

    private static final Unit addCheckbox$lambda$0(Function1 $onChange, boolean it) {
        $onChange.invoke(it);
        return Unit.INSTANCE;
    }

    private static final Unit addNoCityRazingCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setNoCityRazing(it);
        return Unit.INSTANCE;
    }

    private static final Unit addNoBarbariansCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setNoBarbarians(it);
        return Unit.INSTANCE;
    }

    private static final Unit addRagingBarbariansCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setRagingBarbarians(it);
        return Unit.INSTANCE;
    }

    private static final Unit addOneCityChallengeCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setOneCityChallenge(it);
        return Unit.INSTANCE;
    }

    private static final Unit addNuclearWeaponsCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setNuclearWeaponsEnabled(it);
        return Unit.INSTANCE;
    }

    private static final Unit addIsOnlineMultiplayerCheckbox$lambda$0(GameOptionsTable this$0, boolean shouldUseMultiplayer) {
        this$0.gameParameters.setOnlineMultiplayer(shouldUseMultiplayer);
        this$0.updatePlayerPickerTable.invoke("");
        if (shouldUseMultiplayer) {
            IPreviousScreen iPreviousScreen = this$0.previousScreen;
            Intrinsics.checkNotNull(iPreviousScreen, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.BaseScreen");
            MultiplayerHelpers.INSTANCE.showDropboxWarning((BaseScreen)((Object)iPreviousScreen));
        }
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit addAnyoneCanSpectateCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setAnyoneCanSpectate(it);
        return Unit.INSTANCE;
    }

    private static final Unit addEnableEspionageCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setEspionageEnabled(it);
        return Unit.INSTANCE;
    }

    private static final Unit addRandomNationsPoolCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setEnableRandomNationsPool(it);
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit addShowVictoryStatsCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setShowVictoryStats(it);
        return Unit.INSTANCE;
    }

    private static final Unit addNationsSelectTextButton$lambda$0$0(GameOptionsTable this$0) {
        block1: {
            if (!this$0.gameParameters.getRandomNationsPool().isEmpty()) break block1;
            this$0.gameParameters.setEnableRandomNationsPool(false);
            CheckBox checkBox = this$0.randomNationsPoolCheckbox;
            if (checkBox != null) {
                checkBox.setChecked(false);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit addNationsSelectTextButton$lambda$0(GameOptionsTable this$0) {
        RandomNationPickerPopup popup2 = new RandomNationPickerPopup(this$0.previousScreen, this$0.gameParameters, () -> GameOptionsTable.addNationsSelectTextButton$lambda$0$0(this$0));
        Popup.open$default(popup2, false, 1, null);
        popup2.update();
        return Unit.INSTANCE;
    }

    private static final Unit addNoStartBiasCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        this$0.gameParameters.setNoStartBias(it);
        return Unit.INSTANCE;
    }

    private static final boolean addRandomPlayersCheckbox$lambda$0$0(Player it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getPlayerType() == PlayerType.AI && Intrinsics.areEqual(it.getChosenCiv(), "Random");
    }

    private static final Unit addRandomPlayersCheckbox$lambda$0(GameOptionsTable this$0, boolean newRandomNumberOfPlayers) {
        this$0.gameParameters.setRandomNumberOfPlayers(newRandomNumberOfPlayers);
        if (newRandomNumberOfPlayers) {
            this$0.gameParameters.setPlayers((ArrayList)SequencesKt.toCollection(SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)this$0.gameParameters.getPlayers()), GameOptionsTable::addRandomPlayersCheckbox$lambda$0$0), (Collection)new ArrayList(this$0.gameParameters.getPlayers().size())));
            this$0.updatePlayerPickerTable.invoke("");
        } else {
            int additionalRandom = this$0.gameParameters.getMinNumberOfPlayers() - this$0.gameParameters.getPlayers().size();
            if (additionalRandom > 0) {
                int n = 0;
                while (n < additionalRandom) {
                    int it = n++;
                    boolean bl = false;
                    this$0.gameParameters.getPlayers().add(new Player("Random", null, null, 6, null));
                }
                this$0.updatePlayerPickerTable.invoke("");
            }
        }
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit addRandomCityStatesCheckbox$lambda$0(GameOptionsTable this$0, boolean it) {
        GameParameters $this$addRandomCityStatesCheckbox_u24lambda_u240_u240 = this$0.gameParameters;
        boolean bl = false;
        $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.setRandomNumberOfCityStates(it);
        if (it) {
            if ($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getNumberOfCityStates() > $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getMaxNumberOfCityStates()) {
                $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.setMaxNumberOfCityStates($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getNumberOfCityStates());
            }
            if ($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getNumberOfCityStates() < $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getMinNumberOfCityStates()) {
                $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.setMinNumberOfCityStates($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getNumberOfCityStates());
            }
        } else {
            if ($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getNumberOfCityStates() > $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getMaxNumberOfCityStates()) {
                $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.setNumberOfCityStates($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getMaxNumberOfCityStates());
            }
            if ($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getNumberOfCityStates() < $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getMinNumberOfCityStates()) {
                $this$addRandomCityStatesCheckbox_u24lambda_u240_u240.setNumberOfCityStates($this$addRandomCityStatesCheckbox_u24lambda_u240_u240.getMinNumberOfCityStates());
            }
        }
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit addLinkedMinMaxSliders$lambda$0(KMutableProperty0 $minField, Ref.ObjectRef $maxSlider, KMutableProperty0 $maxField, Function0 $onChangeCallback, float it) {
        block5: {
            UncivSlider uncivSlider;
            int newMin = (int)it;
            $minField.set(newMin);
            if ($maxSlider.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException("maxSlider");
                uncivSlider = null;
            } else {
                uncivSlider = (UncivSlider)$maxSlider.element;
            }
            if (newMin > (int)uncivSlider.getValue()) {
                UncivSlider uncivSlider2;
                if ($maxSlider.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("maxSlider");
                    uncivSlider2 = null;
                } else {
                    uncivSlider2 = (UncivSlider)$maxSlider.element;
                }
                uncivSlider2.setValue(it);
                $maxField.set(newMin);
            }
            Function0 function0 = $onChangeCallback;
            if (function0 == null) break block5;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit addLinkedMinMaxSliders$lambda$1(KMutableProperty0 $maxField, UncivSlider $minSlider, KMutableProperty0 $minField, Function0 $onChangeCallback, float it) {
        block1: {
            int newMax = (int)it;
            $maxField.set(newMax);
            if (newMax < (int)$minSlider.getValue()) {
                $minSlider.setValue(it);
                $minField.set(newMax);
            }
            Function0 function0 = $onChangeCallback;
            if (function0 == null) break block1;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit addCityStatesSlider$lambda$0(GameOptionsTable this$0, float it) {
        this$0.gameParameters.setNumberOfCityStates((int)it);
        return Unit.INSTANCE;
    }

    private static final Unit addMaxTurnsSlider$lambda$1(GameOptionsTable this$0, float it) {
        this$0.gameParameters.setMaxTurns((int)it);
        return Unit.INSTANCE;
    }

    private static final Unit addSelectBox$lambda$0(Function1 $onChange, TranslatedSelectBox $selectBox, ChangeListener.ChangeEvent it) {
        String changedValue = (String)$onChange.invoke(((TranslatedSelectBox.TranslatedString)$selectBox.getSelected()).getValue());
        if (changedValue != null) {
            $selectBox.setSelected(changedValue);
        }
        return Unit.INSTANCE;
    }

    private static final String addDifficultySelectBox$lambda$0(GameOptionsTable this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.gameParameters.setDifficulty(it);
        return null;
    }

    private static final String addBaseRulesetSelectBox$onBaseRulesetSelected(GameOptionsTable this$0, String newBaseRuleset) {
        String previousSelection = this$0.gameParameters.getBaseRuleset();
        if (Intrinsics.areEqual(newBaseRuleset, previousSelection)) {
            return null;
        }
        Object object = RulesetCache.INSTANCE.get((Object)newBaseRuleset);
        Intrinsics.checkNotNull(object);
        RulesetErrorList baseRulesetErrors = Ruleset.getErrorList$default((Ruleset)object, false, 1, null);
        if (baseRulesetErrors.isError()) {
            IPreviousScreen iPreviousScreen = this$0.previousScreen;
            Intrinsics.checkNotNull(iPreviousScreen, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.BaseScreen");
            NewGameModCheckHelpersKt.showWarnOrErrorToast(baseRulesetErrors, (BaseScreen)((Object)iPreviousScreen));
            return previousSelection;
        }
        this$0.gameParameters.setBaseRuleset(newBaseRuleset);
        this$0.modCheckboxes.setBaseRuleset(newBaseRuleset);
        this$0.onChooseMod(newBaseRuleset);
        RulesetErrorList modLinkErrors = Ruleset.getErrorList$default(this$0.ruleset, false, 1, null);
        if (modLinkErrors.isError()) {
            this$0.modCheckboxes.disableAllCheckboxes();
            this$0.reloadRuleset();
        }
        IPreviousScreen iPreviousScreen = this$0.previousScreen;
        Intrinsics.checkNotNull(iPreviousScreen, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.BaseScreen");
        NewGameModCheckHelpersKt.showWarnOrErrorToast(modLinkErrors, (BaseScreen)((Object)iPreviousScreen));
        return null;
    }

    private static final String addGameSpeedSelectBox$lambda$1(GameOptionsTable this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.gameParameters.setSpeed(it);
        return null;
    }

    private static final String addEraSelectBox$lambda$0(GameOptionsTable this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.gameParameters.setStartingEra(it);
        return null;
    }

    private static final Unit addVictoryTypeCheckboxes$lambda$1(GameOptionsTable this$0, Victory $victoryType, boolean it) {
        boolean bl = it ? this$0.gameParameters.getVictoryTypes().add($victoryType.getName()) : this$0.gameParameters.getVictoryTypes().remove($victoryType.getName());
        if ($victoryType.enablesMaxTurns()) {
            this$0.update();
        }
        return Unit.INSTANCE;
    }

    private static final Unit getModCheckboxes$lambda$0(GameOptionsTable this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.onChooseMod(it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ String access$addBaseRulesetSelectBox$onBaseRulesetSelected(GameOptionsTable this$0, String newBaseRuleset) {
        return GameOptionsTable.addBaseRulesetSelectBox$onBaseRulesetSelected(this$0, newBaseRuleset);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001fJ/\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0013\u00a2\u0006\u0002\u0010%R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u001d\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006&"}, d2={"Lcom/unciv/ui/screens/newgamescreen/GameOptionsTable$DurationSelector;", "", "gameParameters", "Lcom/unciv/models/metadata/GameParameters;", "param", "Lkotlin/reflect/KMutableProperty1;", "", "defaultDayValue", "defaultHourValue", "defaultMinuteValue", "dayValues", "", "hourValues", "minuteValues", "<init>", "(Lcom/unciv/models/metadata/GameParameters;Lkotlin/reflect/KMutableProperty1;III[Ljava/lang/Integer;[Ljava/lang/Integer;[Ljava/lang/Integer;)V", "[Ljava/lang/Integer;", "dayBox", "Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "", "getDayBox", "()Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "hourBox", "getHourBox", "minuteBox", "getMinuteBox", "boxes", "", "getBoxes", "()Ljava/util/List;", "preventNullTime", "", "updateGameParameter", "createTimeCell", "intValues", "initialValue", "suffix", "([Ljava/lang/Integer;ILjava/lang/String;)Lcom/badlogic/gdx/scenes/scene2d/ui/SelectBox;", "core"})
    private static final class DurationSelector {
        @NotNull
        private final GameParameters gameParameters;
        @NotNull
        private final KMutableProperty1<GameParameters, Integer> param;
        private final int defaultDayValue;
        private final int defaultHourValue;
        private final int defaultMinuteValue;
        @NotNull
        private final Integer[] dayValues;
        @NotNull
        private final Integer[] hourValues;
        @NotNull
        private final Integer[] minuteValues;
        @NotNull
        private final SelectBox<String> dayBox;
        @NotNull
        private final SelectBox<String> hourBox;
        @NotNull
        private final SelectBox<String> minuteBox;
        @NotNull
        private final List<SelectBox<String>> boxes;

        public DurationSelector(@NotNull GameParameters gameParameters, @NotNull KMutableProperty1<GameParameters, Integer> param, int defaultDayValue, int defaultHourValue, int defaultMinuteValue, @NotNull Integer[] dayValues, @NotNull Integer[] hourValues, @NotNull Integer[] minuteValues) {
            Intrinsics.checkNotNullParameter(gameParameters, "gameParameters");
            Intrinsics.checkNotNullParameter(param, "param");
            Intrinsics.checkNotNullParameter(dayValues, "dayValues");
            Intrinsics.checkNotNullParameter(hourValues, "hourValues");
            Intrinsics.checkNotNullParameter(minuteValues, "minuteValues");
            this.gameParameters = gameParameters;
            this.param = param;
            this.defaultDayValue = defaultDayValue;
            this.defaultHourValue = defaultHourValue;
            this.defaultMinuteValue = defaultMinuteValue;
            this.dayValues = dayValues;
            this.hourValues = hourValues;
            this.minuteValues = minuteValues;
            this.dayBox = this.createTimeCell(this.dayValues, this.defaultDayValue, "d");
            this.hourBox = this.createTimeCell(this.hourValues, this.defaultHourValue, "h");
            this.minuteBox = this.createTimeCell(this.minuteValues, this.defaultMinuteValue, "m");
            SelectBox[] selectBoxArray = new SelectBox[]{this.dayBox, this.hourBox, this.minuteBox};
            this.boxes = CollectionsKt.listOf(selectBoxArray);
            for (SelectBox selectBox : this.boxes) {
                ActivationExtensionsKt.onChange(selectBox, arg_0 -> DurationSelector._init_$lambda$0(this, arg_0));
            }
        }

        public /* synthetic */ DurationSelector(GameParameters gameParameters, KMutableProperty1 kMutableProperty1, int n, int n2, int n3, Integer[] integerArray, Integer[] integerArray2, Integer[] integerArray3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
            Integer[] integerArray4;
            if ((n4 & 0x20) != 0) {
                integerArray4 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
                integerArray = integerArray4;
            }
            if ((n4 & 0x40) != 0) {
                integerArray4 = new Integer[]{0, 1, 2, 3, 4, 5, 6, 8, 10, 12, 16, 20};
                integerArray2 = integerArray4;
            }
            if ((n4 & 0x80) != 0) {
                integerArray4 = new Integer[]{0, 3, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50};
                integerArray3 = integerArray4;
            }
            this(gameParameters, kMutableProperty1, n, n2, n3, integerArray, integerArray2, integerArray3);
        }

        @NotNull
        public final SelectBox<String> getDayBox() {
            return this.dayBox;
        }

        @NotNull
        public final SelectBox<String> getHourBox() {
            return this.hourBox;
        }

        @NotNull
        public final SelectBox<String> getMinuteBox() {
            return this.minuteBox;
        }

        @NotNull
        public final List<SelectBox<String>> getBoxes() {
            return this.boxes;
        }

        public final void preventNullTime() {
            if (Intrinsics.areEqual(this.dayBox.getSelected(), "0d") && Intrinsics.areEqual(this.hourBox.getSelected(), "0h") && Intrinsics.areEqual(this.minuteBox.getSelected(), "0m")) {
                this.minuteBox.setSelected("3m");
            }
        }

        public final void updateGameParameter() {
            int value = this.dayValues[this.dayBox.getSelectedIndex()] * 24 * 60 + this.hourValues[this.hourBox.getSelectedIndex()] * 60 + this.minuteValues[this.minuteBox.getSelectedIndex()];
            this.param.set(this.gameParameters, value);
        }

        @NotNull
        public final SelectBox<String> createTimeCell(@NotNull Integer[] intValues, int initialValue, @NotNull String suffix) {
            Intrinsics.checkNotNullParameter(intValues, "intValues");
            Intrinsics.checkNotNullParameter(suffix, "suffix");
            SelectBox<String> timeBox = new SelectBox<String>(BaseScreen.Companion.getSkin());
            int n = 0;
            int n2 = intValues.length;
            String[] stringArray = new String[n2];
            while (n < n2) {
                int n3 = n++;
                stringArray[n3] = intValues[n3] + suffix;
            }
            String[] stringValues = stringArray;
            timeBox.setItems(Arrays.copyOf(stringValues, stringValues.length));
            timeBox.setSelected(initialValue + suffix);
            return timeBox;
        }

        private static final Unit _init_$lambda$0(DurationSelector this$0, ChangeListener.ChangeEvent it) {
            this$0.preventNullTime();
            this$0.updateGameParameter();
            return Unit.INSTANCE;
        }
    }
}

