/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Button;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.ScrollPane;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Array;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.managers.ReligionManager;
import com.unciv.models.Religion;
import com.unciv.models.ruleset.Belief;
import com.unciv.models.ruleset.unit.BaseUnit;
import com.unciv.models.skins.SkinStrings;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.ExpanderTab;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.images.Portrait;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.civilopediascreen.MarkupRenderer;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u000fH\u0016J\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000fH\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u00020\u00182\b\u0010 \u001a\u0004\u0018\u00010\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab$ReligionTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab$ReligionTabPersistableData;", "civStatsTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "religionButtons", "religionButtonLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "statsTable", "beliefsTable", "headerTable", "getFixedContent", "addCivSpecificStats", "", "loadReligionButtons", "select", "", "selection", "", "(Ljava/lang/String;)Ljava/lang/Float;", "loadReligion", "religionName", "religion", "Lcom/unciv/models/Religion;", "createBeliefDescription", "belief", "Lcom/unciv/models/ruleset/Belief;", "ReligionTabPersistableData", "core"})
@SourceDebugExtension(value={"SMAP\nReligionOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReligionOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ReligionOverviewTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,204:1\n1642#2,10:205\n1915#2:215\n1916#2:217\n1652#2:218\n1#3:216\n184#4,2:219\n*S KotlinDebug\n*F\n+ 1 ReligionOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ReligionOverviewTab\n*L\n105#1:205,10\n105#1:215\n105#1:217\n105#1:218\n105#1:216\n161#1:219,2\n*E\n"})
public final class ReligionOverviewTab
extends EmpireOverviewTab {
    @NotNull
    private final ReligionTabPersistableData persistableData;
    @NotNull
    private final Table civStatsTable;
    @NotNull
    private final Table religionButtons;
    @NotNull
    private final Label religionButtonLabel;
    @NotNull
    private final Table statsTable;
    @NotNull
    private final Table beliefsTable;
    @NotNull
    private final Table headerTable;

    public ReligionOverviewTab(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        Table table2;
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        ReligionTabPersistableData religionTabPersistableData = persistedData instanceof ReligionTabPersistableData ? (ReligionTabPersistableData)persistedData : null;
        if (religionTabPersistableData == null) {
            religionTabPersistableData = new ReligionTabPersistableData(null, 1, null);
        }
        this.persistableData = religionTabPersistableData;
        this.civStatsTable = new Table();
        this.religionButtons = new Table();
        this.religionButtonLabel = Scene2dExtensionsKt.toLabel("Click an icon to see the stats of this religion");
        this.statsTable = new Table();
        this.beliefsTable = new Table();
        this.headerTable = new Table();
        this.civStatsTable.defaults().left().pad(5.0f);
        this.addCivSpecificStats(this.civStatsTable);
        Table $this$_init__u24lambda_u240 = table2 = this.headerTable;
        boolean bl = false;
        $this$_init__u24lambda_u240.defaults().pad(5.0f);
        $this$_init__u24lambda_u240.align(2);
        $this$_init__u24lambda_u240.add((Actor)this.civStatsTable).row();
        $this$_init__u24lambda_u240.add((Actor)this.religionButtons).row();
        $this$_init__u24lambda_u240.add((Actor)this.religionButtonLabel);
        Scene2dExtensionsKt.addSeparator$default($this$_init__u24lambda_u240, null, 0, 0.0f, 7, null);
        this.defaults().pad(5.0f);
        this.align(2);
        this.loadReligionButtons();
        this.statsTable.defaults().left().pad(5.0f);
        this.beliefsTable.defaults().padBottom(20.0f);
        this.loadReligion(this.getPersistableData().getSelectedReligion());
        this.add((Actor)this.statsTable).row();
        this.add((Actor)this.beliefsTable).pad(20.0f);
    }

    public /* synthetic */ ReligionOverviewTab(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public ReligionTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.headerTable;
    }

    private final void addCivSpecificStats(Table $this$addCivSpecificStats) {
        float minWidth = Math.max(this.religionButtonLabel.getPrefWidth(), this.getOverviewScreen().getStage().getWidth() / (float)3);
        ReligionManager manager = this.getViewingPlayer().getReligionManager();
        String headerText = this.getViewingPlayer().shouldHideCivCount() ? "Religions to be founded: [?]" : "Religions to be founded: [" + manager.remainingFoundableReligions() + ']';
        ExpanderTab religionCountExpander = new ExpanderTab(headerText, 18, null, false, 0.0f, 0.0f, 5.0f, minWidth, 0.0f, null, null, () -> ReligionOverviewTab.addCivSpecificStats$lambda$0(this), arg_0 -> ReligionOverviewTab.addCivSpecificStats$lambda$1(manager, arg_0), 1828, null);
        $this$addCivSpecificStats.add((Actor)religionCountExpander).colspan(2).growX().row();
        if (manager.canGenerateProphet(true)) {
            String[] stringArray = new String[1];
            BaseUnit baseUnit = manager.getGreatProphetEquivalent();
            Intrinsics.checkNotNull(baseUnit);
            stringArray[0] = baseUnit.getName();
            $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel(TranslationsKt.fillPlaceholders("Minimal Faith required for\nthe next [great prophet equivalent]:", stringArray)));
            $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel(manager.faithForNextGreatProphet() + 1)).right().row();
        }
        $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel("Religious status:")).left();
        $this$addCivSpecificStats.add((Actor)Scene2dExtensionsKt.toLabel(manager.getReligionState().toString())).right().row();
    }

    /*
     * WARNING - void declaration
     */
    private final void loadReligionButtons() {
        void $this$mapNotNullTo$iv$iv;
        this.religionButtons.clear();
        Iterable $this$mapNotNull$iv = this.getGameInfo().getCivilizations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Religion it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Civilization it = (Civilization)element$iv$iv;
            boolean bl2 = false;
            if (it.getReligionManager().getReligion() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List existingReligions = (List)destination$iv$iv;
        for (Religion religion : existingReligions) {
            Portrait image = religion.isPantheon() ? (this.getViewingPlayer().knows(religion.getFoundingCiv()) || Intrinsics.areEqual(this.getViewingPlayer(), religion.getFoundingCiv()) ? ImageGetter.INSTANCE.getNationPortrait(religion.getFoundingCiv().getNation(), 60.0f) : ImageGetter.INSTANCE.getRandomNationPortrait(60.0f)) : ImageGetter.INSTANCE.getReligionPortrait(religion.getIconName(), 60.0f);
            Button button = new Button((Actor)image, BaseScreen.Companion.getSkin());
            ActivationExtensionsKt.onClick(button, () -> ReligionOverviewTab.loadReligionButtons$lambda$1(this, religion));
            if (Intrinsics.areEqual(this.getPersistableData().getSelectedReligion(), religion.getName())) {
                Scene2dExtensionsKt.disable(button);
            }
            this.religionButtons.add((Actor)button).pad(5.0f);
        }
    }

    @Override
    @Nullable
    public Float select(@NotNull String selection) {
        Intrinsics.checkNotNullParameter(selection, "selection");
        this.getPersistableData().setSelectedReligion(selection);
        this.loadReligionButtons();
        this.loadReligion(selection);
        return null;
    }

    private final void loadReligion(String religionName) {
        if (religionName == null) {
            return;
        }
        Religion religion = this.getGameInfo().getReligions().get(religionName);
        if (religion == null) {
            return;
        }
        Religion religion2 = religion;
        this.loadReligion(religion2);
    }

    private final void loadReligion(Religion religion) {
        block6: {
            Object object;
            this.statsTable.clear();
            this.beliefsTable.clear();
            this.religionButtonLabel.setText(TranslationsKt.tr$default(religion.getReligionDisplayName(), false, false, 3, null));
            Scene2dExtensionsKt.setFontSize(this.religionButtonLabel, 24);
            this.religionButtonLabel.setColor(Color.CORAL);
            Iterator<Belief> iterator2 = religion.getAllBeliefsOrdered().iterator();
            while (iterator2.hasNext()) {
                Belief belief;
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                this.beliefsTable.add((Actor)this.createBeliefDescription(belief)).row();
            }
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(religion.isPantheon() ? "Pantheon Name:" : "Religion Name:"));
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(religion.getReligionDisplayName())).right().row();
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Founding Civ:"));
            String foundingCivName = this.getViewingPlayer().knows(religion.getFoundingCiv()) || Intrinsics.areEqual(this.getViewingPlayer(), religion.getFoundingCiv()) ? religion.getFoundingCivName() : "???";
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(foundingCivName)).right().row();
            if (religion.isMajorReligion()) {
                City city;
                block5: {
                    Sequence<City> $this$firstOrNull$iv = this.getGameInfo().getCities();
                    boolean $i$f$firstOrNull = false;
                    object = $this$firstOrNull$iv.iterator();
                    while (object.hasNext()) {
                        City element$iv;
                        City it = element$iv = object.next();
                        boolean bl = false;
                        if (!it.isHolyCityOf(religion.getName())) continue;
                        city = element$iv;
                        break block5;
                    }
                    city = null;
                }
                City holyCity = city;
                if (holyCity != null) {
                    this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Holy City:"));
                    String cityName = this.getViewingPlayer().hasExplored(holyCity.getCenterTile()) ? holyCity.getName() : "???";
                    this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel$default(cityName, null, 0, 0, true, 7, null)).right().row();
                }
            }
            ReligionManager manager = religion.getFoundingCiv().getReligionManager();
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Cities following this religion:"));
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(manager.numberOfCitiesFollowingThisReligion())).right().row();
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel("Followers of this religion:"));
            this.statsTable.add((Actor)Scene2dExtensionsKt.toLabel(manager.numberOfFollowersFollowingThisReligion("in all cities"))).right().row();
            float minWidth = Math.max(this.statsTable.getMinWidth(), this.beliefsTable.getMinWidth()) + (float)5;
            this.statsTable.setWidth(minWidth);
            Iterator iterator3 = this.beliefsTable.getCells().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator3, "iterator(...)");
            Iterator iterator4 = iterator3;
            while (((Array.ArrayIterator)iterator4).hasNext()) {
                Cell cell = (Cell)((Array.ArrayIterator)iterator4).next();
                cell.minWidth(minWidth);
            }
            object = this.getParent();
            ScrollPane scrollPane = object instanceof ScrollPane ? (ScrollPane)object : null;
            if (scrollPane == null) break block6;
            Object $this$loadReligion_u24lambda_u241 = object = scrollPane;
            boolean bl = false;
            ((ScrollPane)$this$loadReligion_u24lambda_u241).layout();
            ((ScrollPane)$this$loadReligion_u24lambda_u241).setScrollX(((ScrollPane)$this$loadReligion_u24lambda_u241).getMaxX() / (float)2);
            ((ScrollPane)$this$loadReligion_u24lambda_u241).updateVisualScroll();
        }
    }

    private final Table createBeliefDescription(Belief belief) {
        Table table2;
        Table $this$createBeliefDescription_u24lambda_u241 = table2 = MarkupRenderer.render$default(MarkupRenderer.INSTANCE, belief.getCivilopediaTextLines(true), 0.0f, 0.0f, null, arg_0 -> ReligionOverviewTab.createBeliefDescription$lambda$0(this, arg_0), 14, null);
        boolean bl = false;
        $this$createBeliefDescription_u24lambda_u241.setBackground(SkinStrings.getUiBackground$default(BaseScreen.Companion.getSkinStrings(), "OverviewScreen/ReligionOverviewTab/BeliefDescription", null, BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor(), 2, null));
        return table2;
    }

    private static final Unit addCivSpecificStats$lambda$0(ReligionOverviewTab this$0) {
        this$0.getOverviewScreen().resizePage(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit addCivSpecificStats$lambda$1(ReligionManager $manager, Table it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.defaults().padTop(10.0f);
        Iterator<Pair<String, Integer>> iterator2 = $manager.remainingFoundableReligionsBreakdown().iterator();
        while (iterator2.hasNext()) {
            Pair<String, Integer> pair = iterator2.next();
            String text2 = pair.component1();
            int num = ((Number)pair.component2()).intValue();
            it.add((Actor)Scene2dExtensionsKt.toLabel(text2));
            it.add((Actor)Scene2dExtensionsKt.toLabel$default(TranslationsKt.tr(num), null, 0, 16, false, 11, null)).right().row();
        }
        return Unit.INSTANCE;
    }

    private static final Unit loadReligionButtons$lambda$1(ReligionOverviewTab this$0, Religion $religion) {
        this$0.getPersistableData().setSelectedReligion($religion.getName());
        this$0.loadReligionButtons();
        this$0.loadReligion($religion);
        return Unit.INSTANCE;
    }

    private static final Unit createBeliefDescription$lambda$0(ReligionOverviewTab this$0, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        this$0.getOverviewScreen().openCivilopedia(it);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ReligionOverviewTab$ReligionTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "selectedReligion", "", "<init>", "(Ljava/lang/String;)V", "getSelectedReligion", "()Ljava/lang/String;", "setSelectedReligion", "core"})
    public static final class ReligionTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        @Nullable
        private String selectedReligion;

        public ReligionTabPersistableData(@Nullable String selectedReligion) {
            this.selectedReligion = selectedReligion;
        }

        public /* synthetic */ ReligionTabPersistableData(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            this(string);
        }

        @Nullable
        public final String getSelectedReligion() {
            return this.selectedReligion;
        }

        public final void setSelectedReligion(@Nullable String string) {
            this.selectedReligion = string;
        }

        public ReligionTabPersistableData() {
            this(null, 1, null);
        }
    }
}

