/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.overviewscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Cell;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.unciv.UncivGame;
import com.unciv.logic.GameInfo;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.trade.TradeOffer;
import com.unciv.logic.trade.TradeOfferType;
import com.unciv.logic.trade.TradeRequest;
import com.unciv.models.ruleset.tile.ResourceSupplyList;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.TileResource;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.UncivTooltip;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewScreen;
import com.unciv.ui.screens.overviewscreen.EmpireOverviewTab;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\u00020\u0001:\u0003345B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u00152\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001eH\u0002J\u0014\u0010%\u001a\u00020\"*\u00020\u00152\u0006\u0010#\u001a\u00020\u001cH\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u001eH\u0002J\f\u0010!\u001a\u00020\"*\u00020\u001cH\u0002J\b\u0010+\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020-H\u0002J\b\u0010/\u001a\u00020-H\u0002J\f\u00100\u001a\u00020\u0011*\u000201H\u0002J\b\u00102\u001a\u00020\u0015H\u0002R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab;", "viewingPlayer", "Lcom/unciv/logic/civilization/Civilization;", "overviewScreen", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;", "persistedData", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewScreen;Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;)V", "persistableData", "Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ResourcesTabPersistableData;", "getPersistableData", "()Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ResourcesTabPersistableData;", "getTurnImage", "Lcom/unciv/ui/images/IconCircleGroup;", "vertical", "", "turnImageH", "turnImageV", "resourceDrilldown", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList;", "extraDrilldown", "allResources", "Lkotlin/sequences/Sequence;", "Lcom/unciv/models/ruleset/tile/ResourceSupplyList$ResourceSupply;", "resources", "", "Lcom/unciv/models/ruleset/tile/TileResource;", "origins", "", "extraOrigins", "Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin;", "getLabel", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "resource", "origin", "getTotalLabel", "getResourceImage", "Lcom/badlogic/gdx/scenes/scene2d/Group;", "name", "fixedContent", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "getFixedContent", "update", "", "updateHorizontal", "updateVertical", "countAsUnimproved", "Lcom/unciv/logic/map/tile/Tile;", "getExtraDrilldown", "ResourcesTabPersistableData", "Companion", "ExtraInfoOrigin", "core"})
@SourceDebugExtension(value={"SMAP\nResourcesOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,314:1\n777#2:315\n873#2,2:316\n1807#2,3:319\n1512#2:322\n1538#2,3:323\n1541#2,3:333\n777#2:336\n873#2,2:337\n777#2:339\n873#2,2:340\n1#3:318\n383#4,7:326\n*S KotlinDebug\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab\n*L\n99#1:315\n99#1:316,2\n203#1:319,3\n215#1:322\n215#1:323,3\n215#1:333,3\n294#1:336\n294#1:337,2\n295#1:339\n295#1:340,2\n215#1:326,7\n*E\n"})
public final class ResourcesOverviewTab
extends EmpireOverviewTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourcesTabPersistableData persistableData;
    @NotNull
    private final IconCircleGroup turnImageH;
    @NotNull
    private final IconCircleGroup turnImageV;
    @NotNull
    private final ResourceSupplyList resourceDrilldown;
    @NotNull
    private final ResourceSupplyList extraDrilldown;
    @NotNull
    private final Sequence<ResourceSupplyList.ResourceSupply> allResources;
    @NotNull
    private final List<TileResource> resources;
    @NotNull
    private final List<String> origins;
    @NotNull
    private final List<ExtraInfoOrigin> extraOrigins;
    @NotNull
    private final Table fixedContent;
    private static final float iconSize = 50.0f;
    private static final float defaultPad = 10.0f;
    private static final float tooltipSize = 24.0f;

    public ResourcesOverviewTab(@NotNull Civilization viewingPlayer, @NotNull EmpireOverviewScreen overviewScreen, @Nullable EmpireOverviewTab.EmpireOverviewTabPersistableData persistedData) {
        Intrinsics.checkNotNullParameter(viewingPlayer, "viewingPlayer");
        Intrinsics.checkNotNullParameter(overviewScreen, "overviewScreen");
        super(viewingPlayer, overviewScreen, null, 4, null);
        ResourcesTabPersistableData resourcesTabPersistableData = persistedData instanceof ResourcesTabPersistableData ? (ResourcesTabPersistableData)persistedData : null;
        if (resourcesTabPersistableData == null) {
            resourcesTabPersistableData = new ResourcesTabPersistableData(false, 1, null);
        }
        this.persistableData = resourcesTabPersistableData;
        this.turnImageH = this.getTurnImage(false);
        this.turnImageV = this.getTurnImage(true);
        this.resourceDrilldown = viewingPlayer.getDetailedCivResources();
        this.extraDrilldown = this.getExtraDrilldown();
        this.allResources = SequencesKt.plus(CollectionsKt.asSequence(this.resourceDrilldown), this.extraDrilldown);
        Comparator comparator = new Comparator(){

            public final int compare(T a, T b) {
                TileResource it = (TileResource)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getResourceType());
                it = (TileResource)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getResourceType()));
            }
        };
        Comparator comparator2 = UncivGame.Companion.getCurrent().getSettings().getCollatorFromLocale();
        this.resources = SequencesKt.toList(SequencesKt.sortedWith(SequencesKt.distinct(SequencesKt.filter(SequencesKt.map(this.allResources, ResourcesOverviewTab::resources$lambda$0), arg_0 -> ResourcesOverviewTab.resources$lambda$1(viewingPlayer, arg_0))), new Comparator(comparator, comparator2){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    TileResource tileResource = (TileResource)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    TileResource it = (TileResource)b;
                    String string = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    bl = false;
                    String string2 = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }));
        this.origins = SequencesKt.toList(SequencesKt.distinct(SequencesKt.map(CollectionsKt.asSequence(this.resourceDrilldown), ResourcesOverviewTab::origins$lambda$0)));
        this.extraOrigins = SequencesKt.toList(SequencesKt.distinct(SequencesKt.mapNotNull(CollectionsKt.asSequence(this.extraDrilldown), ResourcesOverviewTab::extraOrigins$lambda$0)));
        this.fixedContent = new Table();
        this.defaults().pad(10.0f);
        this.top();
        this.fixedContent.defaults().pad(10.0f);
        ActivationExtensionsKt.onClick(this.turnImageH, () -> ResourcesOverviewTab._init_$lambda$0(this));
        ActivationExtensionsKt.onClick(this.turnImageV, () -> ResourcesOverviewTab._init_$lambda$1(this));
        this.update();
    }

    public /* synthetic */ ResourcesOverviewTab(Civilization civilization, EmpireOverviewScreen empireOverviewScreen, EmpireOverviewTab.EmpireOverviewTabPersistableData empireOverviewTabPersistableData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            empireOverviewTabPersistableData = null;
        }
        this(civilization, empireOverviewScreen, empireOverviewTabPersistableData);
    }

    @Override
    @NotNull
    public ResourcesTabPersistableData getPersistableData() {
        return this.persistableData;
    }

    private final IconCircleGroup getTurnImage(boolean vertical) {
        Image image;
        Image $this$getTurnImage_u24lambda_u240 = image = ImageGetter.getImage$default(ImageGetter.INSTANCE, "OtherIcons/Turn right", null, 2, null);
        boolean bl = false;
        $this$getTurnImage_u24lambda_u240.setColor(BaseScreen.Companion.getSkinStrings().getSkinConfig().getBaseColor());
        if (vertical) {
            $this$getTurnImage_u24lambda_u240.rotateBy(90.0f);
        }
        Actor actor = image;
        Color color = Color.LIGHT_GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "LIGHT_GRAY");
        return Scene2dExtensionsKt.surroundWithCircle$default(actor, 50.0f, false, color, null, 10, null);
    }

    private final Label getLabel(ResourceSupplyList $this$getLabel, TileResource resource, String origin2) {
        Label label;
        ResourceSupplyList.ResourceSupply resourceSupply = $this$getLabel.get(resource, origin2);
        if (resourceSupply == null) {
            return null;
        }
        int amount = resourceSupply.getAmount();
        Label label2 = label = resource.isStockpiled() && amount > 0 ? Scene2dExtensionsKt.toLabel("" + '+' + amount) : Scene2dExtensionsKt.toLabel(amount);
        if (Intrinsics.areEqual(origin2, "Unimproved")) {
            ActivationExtensionsKt.onClick(label, () -> ResourcesOverviewTab.getLabel$lambda$0(this, resource));
        }
        return label;
    }

    /*
     * WARNING - void declaration
     */
    private final Label getTotalLabel(ResourceSupplyList $this$getTotalLabel, TileResource resource) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = $this$getTotalLabel;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ResourceSupplyList.ResourceSupply it = (ResourceSupplyList.ResourceSupply)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual(it.getResource(), resource)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it;
            ResourceSupplyList.ResourceSupply $i$f$filterTo2 = (ResourceSupplyList.ResourceSupply)e;
            int n2 = n;
            boolean bl = false;
            int n3 = it.getAmount();
            n = n2 + n3;
        }
        int total = n;
        return resource.isStockpiled() && total > 0 ? Scene2dExtensionsKt.toLabel("" + '+' + total) : Scene2dExtensionsKt.toLabel(total);
    }

    private final Group getResourceImage(String name) {
        Group group;
        Group $this$getResourceImage_u24lambda_u240 = group = ImageGetter.getResourcePortrait$default(ImageGetter.INSTANCE, name, 50.0f, 0, 4, null);
        boolean bl = false;
        ActivationExtensionsKt.onClick($this$getResourceImage_u24lambda_u240, () -> ResourcesOverviewTab.getResourceImage$lambda$0$0(this, name));
        return group;
    }

    private final Label getLabel(TileResource $this$getLabel) {
        Label label;
        Label $this$getLabel_u24lambda_u241 = label = Scene2dExtensionsKt.toLabel$default($this$getLabel.getName(), null, 0, 0, true, 7, null);
        boolean bl = false;
        ActivationExtensionsKt.onClick($this$getLabel_u24lambda_u241, () -> ResourcesOverviewTab.getLabel$lambda$1$0(this, $this$getLabel));
        return label;
    }

    @Override
    @NotNull
    public Table getFixedContent() {
        return this.fixedContent;
    }

    private final void update() {
        this.clear();
        this.fixedContent.clear();
        if (this.getPersistableData().getVertical()) {
            this.updateVertical();
        } else {
            this.updateHorizontal();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateHorizontal() {
        boolean bl;
        block12: {
            Object resource;
            ResourcesOverviewTab resourcesOverviewTab;
            Iterator<TileResource> iterator2;
            this.add((Actor)this.turnImageH);
            Iterator<Object> iterator3 = this.resources.iterator();
            while (iterator3.hasNext()) {
                void $this$updateHorizontal_u24lambda_u240;
                TileResource tileResource;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                iterator2 = this.getResourceImage(tileResource.getName());
                Group group = iterator2;
                resourcesOverviewTab = this;
                boolean bl2 = false;
                UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)$this$updateHorizontal_u24lambda_u240, tileResource.getName(), 0.0f, false, 0, 10, true, null, 78, null);
                resourcesOverviewTab.add((Actor)((Object)iterator2));
            }
            Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
            for (String string : this.origins) {
                this.add((Actor)Scene2dExtensionsKt.toLabel(StringsKt.removeSuffix(string, (CharSequence)"+"))).left();
                for (Object e : this.resources) {
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    resource = (TileResource)e;
                    this.add((Actor)this.getLabel(this.resourceDrilldown, (TileResource)resource, string));
                }
                this.row();
            }
            Table table2 = this;
            Color color = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color, "GRAY");
            Scene2dExtensionsKt.pad(Scene2dExtensionsKt.addSeparator$default(table2, color, 0, 0.0f, 6, null), 0.0f, 10.0f);
            this.add((Actor)Scene2dExtensionsKt.toLabel("Total")).left();
            for (Object object : this.resources) {
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                TileResource tileResource = (TileResource)object;
                this.add((Actor)this.getTotalLabel(this.resourceDrilldown, tileResource));
            }
            if (CollectionsKt.any((Iterable)this.extraOrigins)) {
                Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
                for (ExtraInfoOrigin extraInfoOrigin : this.extraOrigins) {
                    void $this$updateHorizontal_u24lambda_u241;
                    iterator2 = Scene2dExtensionsKt.toLabel(extraInfoOrigin.getHorizontalCaption());
                    resource = iterator2;
                    resourcesOverviewTab = this;
                    boolean bl3 = false;
                    UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)$this$updateHorizontal_u24lambda_u241, extraInfoOrigin.getTooltip(), 24.0f, false, 0, 8, false, null, 108, null);
                    resourcesOverviewTab.add((Actor)((Object)iterator2)).left();
                    iterator2 = this.resources.iterator();
                    while (iterator2.hasNext()) {
                        Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                        this.add((Actor)this.getLabel(this.extraDrilldown, (TileResource)resource, extraInfoOrigin.name()));
                    }
                    this.row();
                }
            }
            Iterable $this$any$iv = this.resources;
            boolean bl2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TileResource it = (TileResource)element$iv;
                    boolean bl4 = false;
                    if (!it.isStockpiled()) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            Scene2dExtensionsKt.addSeparator$default(this, null, 0, 0.0f, 7, null);
            this.add((Actor)Scene2dExtensionsKt.toLabel("Stockpiled resources")).left();
            for (Object object : this.resources) {
                Intrinsics.checkNotNullExpressionValue(object, "next(...)");
                TileResource tileResource = (TileResource)object;
                Cell<Actor> cell = !tileResource.isStockpiled() ? this.add() : this.add((Actor)Scene2dExtensionsKt.toLabel(this.getViewingPlayer().getResourceAmount(tileResource)));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateVertical() {
        Object object;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = this.origins;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Iterator<ExtraInfoOrigin> destination$iv$iv = new LinkedHashMap();
        boolean bl = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            void $this$getOrPut$iv$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            String key$iv$iv = StringsKt.removeSuffix(it, (CharSequence)"+");
            Map map2 = destination$iv$iv;
            String key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedOrigins = destination$iv$iv;
        Table[] tableArray = this.fixedContent;
        Table $this$updateVertical_u24lambda_u241 = tableArray;
        boolean bl3 = false;
        $this$updateVertical_u24lambda_u241.add((Actor)this.turnImageV).size(50.0f);
        $this$updateVertical_u24lambda_u241.add();
        Color color = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$updateVertical_u24lambda_u241, color, 0.0f, 2, null).pad(0.0f);
        for (Map.Entry entry : groupedOrigins.entrySet()) {
            $this$updateVertical_u24lambda_u241.add((Actor)Scene2dExtensionsKt.toLabel((String)entry.getKey()));
        }
        $this$updateVertical_u24lambda_u241.add((Actor)Scene2dExtensionsKt.toLabel("Total"));
        Color color2 = Color.GRAY;
        Intrinsics.checkNotNullExpressionValue(color2, "GRAY");
        Scene2dExtensionsKt.addSeparatorVertical$default($this$updateVertical_u24lambda_u241, color2, 0.0f, 2, null).pad(0.0f);
        for (ExtraInfoOrigin extraInfoOrigin : this.extraOrigins) {
            void $this$updateVertical_u24lambda_u241_u240;
            Object element$iv$iv;
            object = Scene2dExtensionsKt.toLabel(extraInfoOrigin.getVerticalCaption());
            element$iv$iv = object;
            Table table2 = $this$updateVertical_u24lambda_u241;
            boolean bl4 = false;
            UncivTooltip.Companion.addTooltip$default(UncivTooltip.Companion, (Actor)$this$updateVertical_u24lambda_u241_u240, extraInfoOrigin.getTooltip(), 24.0f, false, 4, 18, false, null, 100, null);
            table2.add((Actor)object);
        }
        Scene2dExtensionsKt.pad(Scene2dExtensionsKt.addSeparator$default($this$updateVertical_u24lambda_u241, null, 0, 0.0f, 7, null), 0.0f, 10.0f);
        for (Object e : this.resources) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            TileResource resource = (TileResource)e;
            this.add((Actor)this.getResourceImage(resource.getName()));
            this.add((Actor)this.getLabel(resource));
            Table table2 = this;
            Color color3 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color3, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table2, color3, 0.0f, 2, null).pad(0.0f);
            for (Map.Entry groupedOrigin : groupedOrigins.entrySet()) {
                Cell<Actor> cell;
                if (((List)groupedOrigin.getValue()).size() == 1) {
                    cell = this.add((Actor)this.getLabel(this.resourceDrilldown, resource, (String)groupedOrigin.getKey()));
                    continue;
                }
                Table table4 = new Table();
                object = table4;
                ResourcesOverviewTab resourcesOverviewTab = this;
                boolean bl4 = false;
                for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)groupedOrigin.getValue())) {
                    void $this$updateVertical_u24lambda_u242;
                    $this$updateVertical_u24lambda_u242.add((Actor)this.getLabel(this.resourceDrilldown, resource, (String)indexedValue.getValue())).padLeft(indexedValue.getIndex() == 0 ? 0.0f : 10.0f);
                }
                cell = resourcesOverviewTab.add((Actor)table4);
            }
            this.add((Actor)this.getTotalLabel(this.resourceDrilldown, resource));
            Table table3 = this;
            Color color4 = Color.GRAY;
            Intrinsics.checkNotNullExpressionValue(color4, "GRAY");
            Scene2dExtensionsKt.addSeparatorVertical$default(table3, color4, 0.0f, 2, null).pad(0.0f);
            for (ExtraInfoOrigin origin5 : this.extraOrigins) {
                this.add((Actor)this.getLabel(this.extraDrilldown, resource, origin5.name()));
            }
            this.row();
        }
        if (this.getRows() == 0) {
            return;
        }
        tableArray = new Table[]{this.fixedContent, this};
        Scene2dExtensionsKt.equalizeColumns(tableArray);
        this.getOverviewScreen().resizePage(this);
    }

    private final boolean countAsUnimproved(Tile $this$countAsUnimproved) {
        TileResource resource = $this$countAsUnimproved.getTileResource();
        return this.getViewingPlayer().canSeeResource(resource) && resource.getResourceType() != ResourceType.Bonus && !$this$countAsUnimproved.providesResources(this.getViewingPlayer());
    }

    /*
     * WARNING - void declaration
     */
    private final ResourceSupplyList getExtraDrilldown() {
        ResourceSupplyList newResourceSupplyList = new ResourceSupplyList(true);
        for (City city : this.getViewingPlayer().getCities()) {
            if (((CharSequence)city.getDemandedResource()).length() > 0) {
                TileResource wltkResource;
                Intrinsics.checkNotNull(this.getGameInfo().getRuleset().getTileResources().get(city.getDemandedResource()));
                if (city.isWeLoveTheKingDayActive()) {
                    ResourceSupplyList.add$default(newResourceSupplyList, wltkResource, "CelebratingWLKT", 0, 4, null);
                } else {
                    ResourceSupplyList.add$default(newResourceSupplyList, wltkResource, "DemandingWLTK", 0, 4, null);
                }
            }
            ResourcesOverviewTab.getExtraDrilldown$addUnimproved(city, this, newResourceSupplyList);
        }
        Iterator<Object> iterator2 = this.getViewingPlayer().getKnownCivs().iterator();
        while (iterator2.hasNext()) {
            void $this$filterTo$iv$iv;
            Civilization otherCiv = (Civilization)iterator2.next();
            Iterable $this$filter$iv = otherCiv.getTradeRequests();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo22 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                TradeRequest it = (TradeRequest)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getRequestingCiv(), this.getViewingPlayer().getCivID())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (TradeRequest trade : (List)destination$iv$iv) {
                void $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2 = trade.getTrade().getTheirOffers();
                boolean $i$f$filter2 = false;
                Iterable $i$f$filterTo22 = $this$filter$iv2;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo3 = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                    TradeOffer it = (TradeOffer)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getType() == TradeOfferType.Strategic_Resource || it.getType() == TradeOfferType.Luxury_Resource)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                for (Object e : (List)destination$iv$iv2) {
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    TradeOffer offer = (TradeOffer)e;
                    TileResource tileResource = this.getGameInfo().getRuleset().getTileResources().get(offer.getName());
                    Intrinsics.checkNotNull(tileResource);
                    newResourceSupplyList.add(tileResource, "TradeOffer", offer.getAmount());
                }
            }
            if (!otherCiv.isCityState() || !Intrinsics.areEqual(otherCiv.getAllyCiv(), this.getViewingPlayer())) continue;
            for (City city : otherCiv.getCities()) {
                ResourcesOverviewTab.getExtraDrilldown$addUnimproved(city, this, newResourceSupplyList);
            }
        }
        for (Object object : this.getViewingPlayer().getGameInfo().getRuleset().getTileResources().values()) {
            Intrinsics.checkNotNullExpressionValue(object, "next(...)");
            TileResource resource = (TileResource)object;
            if (resource.getResourceType() != ResourceType.Strategic || !this.getViewingPlayer().canSeeResource(resource)) continue;
            newResourceSupplyList.add(resource, "No source", 0);
        }
        return newResourceSupplyList;
    }

    private static final TileResource resources$lambda$0(ResourceSupplyList.ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResource();
    }

    private static final boolean resources$lambda$1(Civilization $viewingPlayer, TileResource it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getResourceType() != ResourceType.Bonus && !it.hasUnique(UniqueType.NotShownOnWorldScreen, $viewingPlayer.getState()) && !it.isCityWide();
    }

    private static final String origins$lambda$0(ResourceSupplyList.ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOrigin();
    }

    private static final ExtraInfoOrigin extraOrigins$lambda$0(ResourceSupplyList.ResourceSupply it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ExtraInfoOrigin.Companion.safeValueOf(it.getOrigin());
    }

    private static final boolean getLabel$isAlliedAndUnimproved(ResourcesOverviewTab this$0, Tile tile) {
        Civilization civilization = tile.getOwner();
        if (civilization == null) {
            return false;
        }
        Civilization owner = civilization;
        if (!(Intrinsics.areEqual(owner, this$0.getViewingPlayer()) || owner.isCityState() && Intrinsics.areEqual(owner.getAllyCiv(), this$0.getViewingPlayer()))) {
            return false;
        }
        return this$0.countAsUnimproved(tile);
    }

    private static final Unit getLabel$lambda$0(ResourcesOverviewTab this$0, TileResource $resource) {
        this$0.getOverviewScreen().showOneTimeNotification$core(GameInfo.getExploredResourcesNotification$default(this$0.getGameInfo(), this$0.getViewingPlayer(), $resource, 0, (Function1)new Function1<Tile, Boolean>(this$0){
            final /* synthetic */ ResourcesOverviewTab this$0;
            {
                this.this$0 = $receiver;
                super(1, Intrinsics.Kotlin.class, "isAlliedAndUnimproved", "getLabel$isAlliedAndUnimproved(Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab;Lcom/unciv/logic/map/tile/Tile;)Z", 0);
            }

            public final Boolean invoke(Tile p0) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ResourcesOverviewTab.access$getLabel$isAlliedAndUnimproved(this.this$0, p0);
            }
        }, 4, null));
        return Unit.INSTANCE;
    }

    private static final Unit getResourceImage$lambda$0$0(ResourcesOverviewTab this$0, String $name) {
        this$0.getOverviewScreen().showOneTimeNotification$core(GameInfo.getExploredResourcesNotification$default(this$0.getGameInfo(), this$0.getViewingPlayer(), $name, 0, null, 12, null));
        return Unit.INSTANCE;
    }

    private static final Unit getLabel$lambda$1$0(ResourcesOverviewTab this$0, TileResource $this_getLabel) {
        this$0.getOverviewScreen().openCivilopedia($this_getLabel.makeLink());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(ResourcesOverviewTab this$0) {
        this$0.getPersistableData().setVertical(true);
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ResourcesOverviewTab this$0) {
        this$0.getPersistableData().setVertical(false);
        this$0.update();
        return Unit.INSTANCE;
    }

    private static final void getExtraDrilldown$addUnimproved(City $this$getExtraDrilldown_u24addUnimproved, ResourcesOverviewTab this$0, ResourceSupplyList newResourceSupplyList) {
        Iterator<Tile> iterator2 = $this$getExtraDrilldown_u24addUnimproved.getTiles().iterator();
        while (iterator2.hasNext()) {
            Tile tile = iterator2.next();
            if (!this$0.countAsUnimproved(tile)) continue;
            TileResource tileResource = tile.getTileResource();
            Intrinsics.checkNotNull(tileResource);
            ResourceSupplyList.add$default(newResourceSupplyList, tileResource, "Unimproved", 0, 4, null);
        }
    }

    public static final /* synthetic */ boolean access$getLabel$isAlliedAndUnimproved(ResourcesOverviewTab this$0, Tile tile) {
        return ResourcesOverviewTab.getLabel$isAlliedAndUnimproved(this$0, tile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$Companion;", "", "<init>", "()V", "iconSize", "", "defaultPad", "tooltipSize", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\b\u0082\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin;", "", "horizontalCaption", "", "verticalCaption", "tooltip", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getHorizontalCaption", "()Ljava/lang/String;", "getVerticalCaption", "getTooltip", "Unimproved", "CelebratingWLKT", "DemandingWLTK", "TradeOffer", "Companion", "core"})
    private static final class ExtraInfoOrigin
    extends Enum<ExtraInfoOrigin> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String horizontalCaption;
        @NotNull
        private final String verticalCaption;
        @NotNull
        private final String tooltip;
        public static final /* enum */ ExtraInfoOrigin Unimproved;
        public static final /* enum */ ExtraInfoOrigin CelebratingWLKT;
        public static final /* enum */ ExtraInfoOrigin DemandingWLTK;
        public static final /* enum */ ExtraInfoOrigin TradeOffer;
        private static final /* synthetic */ ExtraInfoOrigin[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ExtraInfoOrigin(String horizontalCaption, String verticalCaption, String tooltip) {
            this.horizontalCaption = horizontalCaption;
            this.verticalCaption = verticalCaption;
            this.tooltip = tooltip;
        }

        @NotNull
        public final String getHorizontalCaption() {
            return this.horizontalCaption;
        }

        @NotNull
        public final String getVerticalCaption() {
            return this.verticalCaption;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        public static ExtraInfoOrigin[] values() {
            return (ExtraInfoOrigin[])$VALUES.clone();
        }

        public static ExtraInfoOrigin valueOf(String value) {
            return Enum.valueOf(ExtraInfoOrigin.class, value);
        }

        @NotNull
        public static EnumEntries<ExtraInfoOrigin> getEntries() {
            return $ENTRIES;
        }

        static {
            Unimproved = new ExtraInfoOrigin("Unimproved", "Unimproved", "Number of tiles with this resource\nin your territory, without an\nappropriate improvement to use it");
            CelebratingWLKT = new ExtraInfoOrigin("We Love The King Day", "WLTK+", "Number of your cities celebrating\n'We Love The King Day' thanks\nto access to this resource");
            DemandingWLTK = new ExtraInfoOrigin("WLTK demand", "WLTK-", "Number of your cities\ndemanding this resource for\n'We Love The King Day'");
            TradeOffer = new ExtraInfoOrigin("Trade offer", "Trade offer", "Resources we're offering in trades");
            $VALUES = extraInfoOriginArray = new ExtraInfoOrigin[]{ExtraInfoOrigin.Unimproved, ExtraInfoOrigin.CelebratingWLKT, ExtraInfoOrigin.DemandingWLTK, ExtraInfoOrigin.TradeOffer};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin$Companion;", "", "<init>", "()V", "safeValueOf", "Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nResourcesOverviewTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,314:1\n296#2,2:315\n*S KotlinDebug\n*F\n+ 1 ResourcesOverviewTab.kt\ncom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ExtraInfoOrigin$Companion\n*L\n130#1:315,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ExtraInfoOrigin safeValueOf(@NotNull String name) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Iterable $this$firstOrNull$iv = ExtraInfoOrigin.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ExtraInfoOrigin it = (ExtraInfoOrigin)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0003H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\n"}, d2={"Lcom/unciv/ui/screens/overviewscreen/ResourcesOverviewTab$ResourcesTabPersistableData;", "Lcom/unciv/ui/screens/overviewscreen/EmpireOverviewTab$EmpireOverviewTabPersistableData;", "vertical", "", "<init>", "(Z)V", "getVertical", "()Z", "setVertical", "isEmpty", "core"})
    public static final class ResourcesTabPersistableData
    extends EmpireOverviewTab.EmpireOverviewTabPersistableData {
        private boolean vertical;

        public ResourcesTabPersistableData(boolean vertical) {
            this.vertical = vertical;
        }

        public /* synthetic */ ResourcesTabPersistableData(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean getVertical() {
            return this.vertical;
        }

        public final void setVertical(boolean bl) {
            this.vertical = bl;
        }

        @Override
        public boolean isEmpty() {
            return !this.vertical;
        }

        public ResourcesTabPersistableData() {
            this(false, 1, null);
        }
    }
}

