/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.pickerscreens;

import com.unciv.GUI;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.UnitPromotions;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.ruleset.unit.Promotion;
import com.unciv.models.translations.TranslationsKt;
import java.text.Collator;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\u0011\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00190\u0018J\u0011\u0010\u001a\u001a\r\u0012\t\u0012\u00070\u0013\u00a2\u0006\u0002\b\u00190\u0018J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\nJ\u0012\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\nJ\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0#2\u0006\u0010\u001f\u001a\u00020\nJ\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011j\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013`\u0014X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/unciv/ui/screens/pickerscreens/PromotionTree;", "", "unit", "Lcom/unciv/logic/map/mapunit/MapUnit;", "<init>", "(Lcom/unciv/logic/map/mapunit/MapUnit;)V", "getUnit", "()Lcom/unciv/logic/map/mapunit/MapUnit;", "possiblePromotions", "Ljava/util/LinkedHashSet;", "Lcom/unciv/models/ruleset/unit/Promotion;", "Lkotlin/collections/LinkedHashSet;", "getPossiblePromotions", "()Ljava/util/LinkedHashSet;", "setPossiblePromotions", "(Ljava/util/LinkedHashSet;)V", "nodes", "Ljava/util/LinkedHashMap;", "", "Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "Lkotlin/collections/LinkedHashMap;", "update", "", "allNodes", "Lkotlin/sequences/Sequence;", "Lkotlin/jvm/internal/EnhancedNullability;", "allRoots", "detectLoop", "", "node", "getNode", "promotion", "getReachableNode", "canBuyUpTo", "getPathTo", "", "getMaxRows", "", "getMaxColumns", "PromotionNode", "core"})
@SourceDebugExtension(value={"SMAP\nPromotionTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromotionTree.kt\ncom/unciv/ui/screens/pickerscreens/PromotionTree\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1276#2,2:205\n1#3:207\n*S KotlinDebug\n*F\n+ 1 PromotionTree.kt\ncom/unciv/ui/screens/pickerscreens/PromotionTree\n*L\n115#1:205,2\n*E\n"})
public final class PromotionTree {
    @NotNull
    private final MapUnit unit;
    public LinkedHashSet<Promotion> possiblePromotions;
    private LinkedHashMap<String, PromotionNode> nodes;

    public PromotionTree(@NotNull MapUnit unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        this.unit = unit;
        this.update();
    }

    @NotNull
    public final MapUnit getUnit() {
        return this.unit;
    }

    @NotNull
    public final LinkedHashSet<Promotion> getPossiblePromotions() {
        LinkedHashSet<Promotion> linkedHashSet = this.possiblePromotions;
        if (linkedHashSet != null) {
            return linkedHashSet;
        }
        Intrinsics.throwUninitializedPropertyAccessException("possiblePromotions");
        return null;
    }

    public final void setPossiblePromotions(@NotNull LinkedHashSet<Promotion> linkedHashSet) {
        Intrinsics.checkNotNullParameter(linkedHashSet, "<set-?>");
        this.possiblePromotions = linkedHashSet;
    }

    public final void update() {
        PromotionNode node;
        Object node2;
        Collator collator = GUI.INSTANCE.getSettings().getCollatorFromLocale();
        Collection<Promotion> collection = this.unit.getCiv().getGameInfo().getRuleset().getUnitPromotions().values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Collection<Promotion> rulesetPromotions = collection;
        String unitType = this.unit.getBaseUnit().getUnitType();
        HashSet<String> adoptedPromotions = this.unit.getPromotions().getPromotions();
        Object object = new Comparator(){

            public final int compare(T a, T b) {
                Promotion it = (Promotion)a;
                boolean bl = false;
                Comparable comparable = it.getRow() < 0 ? (Comparable)Integer.valueOf(Integer.MAX_VALUE) : (it.getRow() == 0 ? (Comparable)Integer.valueOf(Integer.MIN_VALUE + it.getColumn()) : (Comparable)Integer.valueOf(it.getColumn()));
                it = (Promotion)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getRow() < 0 ? (Comparable)Integer.valueOf(Integer.MAX_VALUE) : (it.getRow() == 0 ? (Comparable)Integer.valueOf(Integer.MIN_VALUE + it.getColumn()) : (Comparable)Integer.valueOf(it.getColumn())));
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Promotion it = (Promotion)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getRow());
                    it = (Promotion)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues(comparable2, it.getRow());
                }
                return n;
            }
        };
        this.setPossiblePromotions((LinkedHashSet)SequencesKt.toCollection(SequencesKt.sortedWith(SequencesKt.filter(CollectionsKt.asSequence((Iterable)rulesetPromotions), arg_0 -> PromotionTree.update$lambda$0(unitType, adoptedPromotions, arg_0)), new Comparator((Comparator)object, collator){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ Comparator $comparator;
            {
                this.$this_thenBy = $receiver;
                this.$comparator = $comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Promotion promotion = (Promotion)a;
                    Comparator comparator = this.$comparator;
                    boolean bl = false;
                    Promotion it = (Promotion)b;
                    String string = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    bl = false;
                    String string2 = TranslationsKt.tr$default(it.getName(), true, false, 2, null);
                    n = comparator.compare(string, string2);
                }
                return n;
            }
        }), (Collection)new LinkedHashSet()));
        this.nodes = (LinkedHashMap)MapsKt.toMap(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.getPossiblePromotions()), arg_0 -> PromotionTree.update$lambda$4(adoptedPromotions, arg_0)), (Map)new LinkedHashMap(this.getPossiblePromotions().size()));
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        for (Object e : linkedHashMap.values()) {
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            node2 = (PromotionNode)e;
            if (this.detectLoop((PromotionNode)node2)) continue;
            for (String iterator2 : ((PromotionNode)node2).getPromotion().getPrerequisites()) {
                PromotionNode parent;
                LinkedHashMap<String, PromotionNode> linkedHashMap2 = this.nodes;
                if (linkedHashMap2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("nodes");
                    linkedHashMap2 = null;
                }
                if (linkedHashMap2.get(iterator2) == null) continue;
                ((Collection)((PromotionNode)node2).getParents()).add(parent);
                ((Collection)parent.getChildren()).add(node2);
                if (((PromotionNode)node2).getLevel() <= 0 || !Intrinsics.areEqual(((PromotionNode)node2).getBaseName(), parent.getBaseName())) continue;
                int n = parent.getLevels();
                parent.setLevels(n + 1);
            }
        }
        GameContext state = this.unit.getCache().getState();
        LinkedHashMap<String, PromotionNode> linkedHashMap3 = this.nodes;
        if (linkedHashMap3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap3 = null;
        }
        for (Object e : linkedHashMap3.values()) {
            boolean bl;
            block17: {
                Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                node = (PromotionNode)e;
                if (!((Collection)node.getPromotion().getPrerequisites()).isEmpty() && node.getParents().isEmpty()) {
                    node.setUnreachable(true);
                }
                Sequence<Unique> sequence = node.getPromotion().getMatchingUniques(UniqueType.OnlyAvailable, GameContext.Companion.getIgnoreConditionals());
                boolean $i$f$any = false;
                Iterator<Unique> iterator2 = sequence.iterator();
                while (iterator2.hasNext()) {
                    Unique element$iv;
                    Unique it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(!it.conditionalsApply(state))) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
            if (bl) {
                node.setUnreachable(true);
            }
            if (!node.getPromotion().hasUnique(UniqueType.Unavailable, state)) continue;
            node.setUnreachable(true);
        }
        node2 = this.allRoots().iterator();
        while (node2.hasNext()) {
            Intrinsics.checkNotNullExpressionValue(node2.next(), "next(...)");
            node.setDepth(0);
            node.setDistanceToAdopted(node.isAdopted() ? 0 : (node.getUnreachable() ? Integer.MAX_VALUE : 1));
        }
        for (int depth = 0; depth < 100; ++depth) {
            boolean complete = true;
            LinkedHashMap<String, PromotionNode> linkedHashMap4 = this.nodes;
            if (linkedHashMap4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("nodes");
                linkedHashMap4 = null;
            }
            Iterator<PromotionNode> iterator3 = linkedHashMap4.values().iterator();
            while (iterator3.hasNext()) {
                Iterator iterator4;
                PromotionNode node3;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                if (node3.getDepth() == Integer.MIN_VALUE) {
                    complete = false;
                    continue;
                }
                if (node3.getDepth() != depth) continue;
                Intrinsics.checkNotNullExpressionValue(node3.getChildren().iterator(), "iterator(...)");
                while (iterator4.hasNext()) {
                    PromotionNode promotionNode;
                    Object e = iterator4.next();
                    Intrinsics.checkNotNullExpressionValue(e, "next(...)");
                    PromotionNode child = (PromotionNode)e;
                    int distance = child.isAdopted() ? 0 : (node3.getDistanceToAdopted() == Integer.MAX_VALUE ? Integer.MAX_VALUE : (child.getUnreachable() ? Integer.MAX_VALUE : node3.getDistanceToAdopted() + 1));
                    if (child.getDepth() != Integer.MIN_VALUE) {
                        if (child.getDistanceToAdopted() < distance) continue;
                        if (child.getDistanceToAdopted() == distance) {
                            child.setPathIsAmbiguous(true);
                            child.setPreferredParent(null);
                            continue;
                        }
                    }
                    child.setDepth(depth + 1);
                    child.setDistanceToAdopted(distance);
                    child.setPathIsAmbiguous(node3.getPathIsAmbiguous());
                    PromotionNode promotionNode2 = promotionNode = node3;
                    PromotionNode promotionNode3 = child;
                    boolean bl = false;
                    boolean bl2 = node3.getPathIsAmbiguous();
                    promotionNode3.setPreferredParent(!bl2 ? promotionNode : null);
                }
            }
            if (complete) break;
        }
    }

    @NotNull
    public final Sequence<PromotionNode> allNodes() {
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        Collection<PromotionNode> collection = linkedHashMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        return CollectionsKt.asSequence((Iterable)collection);
    }

    @NotNull
    public final Sequence<PromotionNode> allRoots() {
        return SequencesKt.filter(this.allNodes(), PromotionTree::allRoots$lambda$0);
    }

    private final boolean detectLoop(PromotionNode node) {
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        HashSet<PromotionNode> loopCheck = new HashSet<PromotionNode>(linkedHashMap.size());
        return PromotionTree.detectLoop$detectRecursive(node, 0, loopCheck);
    }

    @Nullable
    public final PromotionNode getNode(@NotNull Promotion promotion) {
        Intrinsics.checkNotNullParameter(promotion, "promotion");
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        return linkedHashMap.get(promotion.getName());
    }

    private final PromotionNode getReachableNode(Promotion promotion) {
        PromotionNode promotionNode;
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        PromotionNode promotionNode2 = linkedHashMap.get(promotion.getName());
        if (promotionNode2 != null) {
            PromotionNode promotionNode3;
            PromotionNode it = promotionNode3 = promotionNode2;
            boolean bl = false;
            promotionNode = !(it.getDistanceToAdopted() == Integer.MAX_VALUE) ? promotionNode3 : null;
        } else {
            promotionNode = null;
        }
        return promotionNode;
    }

    public final boolean canBuyUpTo(@NotNull Promotion promotion) {
        Intrinsics.checkNotNullParameter(promotion, "promotion");
        UnitPromotions $this$canBuyUpTo_u24lambda_u240 = this.unit.getPromotions();
        boolean bl = false;
        PromotionNode promotionNode = this.getReachableNode(promotion);
        if (promotionNode == null) {
            return false;
        }
        PromotionNode node = promotionNode;
        if (node.isAdopted()) {
            return false;
        }
        return $this$canBuyUpTo_u24lambda_u240.getXP() >= $this$canBuyUpTo_u24lambda_u240.xpForNextNPromotions(node.getDistanceToAdopted());
    }

    @NotNull
    public final List<Promotion> getPathTo(@NotNull Promotion promotion) {
        Intrinsics.checkNotNullParameter(promotion, "promotion");
        PromotionNode promotionNode = this.getReachableNode(promotion);
        if (promotionNode == null) {
            return CollectionsKt.emptyList();
        }
        PromotionNode node = promotionNode;
        Promotion[] promotionArray = new Promotion[]{node.getPromotion()};
        List<Promotion> result2 = CollectionsKt.mutableListOf(promotionArray);
        while (node.getPreferredParent() != null && !node.isAdopted()) {
            result2.add(node.getPromotion());
        }
        return CollectionsKt.asReversedMutable(result2);
    }

    public final int getMaxRows() {
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        return linkedHashMap.size();
    }

    public final int getMaxColumns() {
        Comparable comparable;
        LinkedHashMap<String, PromotionNode> linkedHashMap = this.nodes;
        if (linkedHashMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("nodes");
            linkedHashMap = null;
        }
        Collection<PromotionNode> collection = linkedHashMap.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterator iterator2 = ((Iterable)collection).iterator();
        if (!iterator2.hasNext()) {
            comparable = null;
        } else {
            PromotionNode it = (PromotionNode)iterator2.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(RangesKt.coerceAtLeast(it.getPromotion().getRow(), it.getDepth() + 1));
            while (iterator2.hasNext()) {
                PromotionNode it2 = (PromotionNode)iterator2.next();
                $i$a$-maxOfOrNull-PromotionTree$getMaxColumns$1 = false;
                Comparable comparable3 = Integer.valueOf(RangesKt.coerceAtLeast(it2.getPromotion().getRow(), it2.getDepth() + 1));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    private static final boolean update$lambda$0(String $unitType, HashSet $adoptedPromotions, Promotion it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getUnitTypes().contains($unitType) || $adoptedPromotions.contains(it.getName());
    }

    private static final Pair update$lambda$4(HashSet $adoptedPromotions, Promotion it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return TuplesKt.to(it.getName(), new PromotionNode(it, $adoptedPromotions.contains(it.getName())));
    }

    private static final boolean allRoots$lambda$0(PromotionNode it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isRoot();
    }

    private static final boolean detectLoop$detectRecursive(PromotionNode node, int level, HashSet<PromotionNode> loopCheck) {
        if (level > 99) {
            return true;
        }
        if (loopCheck.contains(node)) {
            return true;
        }
        loopCheck.add(node);
        Iterator<PromotionNode> iterator2 = node.getParents().iterator();
        while (iterator2.hasNext()) {
            PromotionNode parent;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            if (!PromotionTree.detectLoop$detectRecursive(parent, level + 1, loopCheck)) continue;
            return true;
        }
        return false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u00103\u001a\u00020*H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR!\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u00000\u001ej\b\u0012\u0004\u0012\u00020\u0000`\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\n\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\n\"\u0004\b(\u0010%R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010-\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u000eR\u001a\u0010/\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u000e\"\u0004\b1\u0010\u0010R\u0011\u00102\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\n\u00a8\u00064"}, d2={"Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "", "promotion", "Lcom/unciv/models/ruleset/unit/Promotion;", "isAdopted", "", "<init>", "(Lcom/unciv/models/ruleset/unit/Promotion;Z)V", "getPromotion", "()Lcom/unciv/models/ruleset/unit/Promotion;", "()Z", "depth", "", "getDepth", "()I", "setDepth", "(I)V", "distanceToAdopted", "getDistanceToAdopted", "setDistanceToAdopted", "parents", "", "getParents", "()Ljava/util/Set;", "preferredParent", "getPreferredParent", "()Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;", "setPreferredParent", "(Lcom/unciv/ui/screens/pickerscreens/PromotionTree$PromotionNode;)V", "children", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getChildren", "()Ljava/util/LinkedHashSet;", "pathIsAmbiguous", "getPathIsAmbiguous", "setPathIsAmbiguous", "(Z)V", "unreachable", "getUnreachable", "setUnreachable", "baseName", "", "getBaseName", "()Ljava/lang/String;", "level", "getLevel", "levels", "getLevels", "setLevels", "isRoot", "toString", "core"})
    public static final class PromotionNode {
        @NotNull
        private final Promotion promotion;
        private final boolean isAdopted;
        private int depth;
        private int distanceToAdopted;
        @NotNull
        private final Set<PromotionNode> parents;
        @Nullable
        private PromotionNode preferredParent;
        @NotNull
        private final LinkedHashSet<PromotionNode> children;
        private boolean pathIsAmbiguous;
        private boolean unreachable;
        @NotNull
        private final String baseName;
        private final int level;
        private int levels;

        public PromotionNode(@NotNull Promotion promotion, boolean isAdopted) {
            Intrinsics.checkNotNullParameter(promotion, "promotion");
            this.promotion = promotion;
            this.isAdopted = isAdopted;
            this.depth = Integer.MIN_VALUE;
            this.distanceToAdopted = Integer.MAX_VALUE;
            this.parents = new LinkedHashSet();
            this.children = new LinkedHashSet();
            this.levels = 1;
            Promotion.Companion.PromotionBaseNameAndLevel splitName = Promotion.Companion.getBaseNameAndLevel(this.promotion.getName());
            this.level = splitName.getLevel();
            this.baseName = splitName.getBasePromotionName();
        }

        @NotNull
        public final Promotion getPromotion() {
            return this.promotion;
        }

        public final boolean isAdopted() {
            return this.isAdopted;
        }

        public final int getDepth() {
            return this.depth;
        }

        public final void setDepth(int n) {
            this.depth = n;
        }

        public final int getDistanceToAdopted() {
            return this.distanceToAdopted;
        }

        public final void setDistanceToAdopted(int n) {
            this.distanceToAdopted = n;
        }

        @NotNull
        public final Set<PromotionNode> getParents() {
            return this.parents;
        }

        @Nullable
        public final PromotionNode getPreferredParent() {
            return this.preferredParent;
        }

        public final void setPreferredParent(@Nullable PromotionNode promotionNode) {
            this.preferredParent = promotionNode;
        }

        @NotNull
        public final LinkedHashSet<PromotionNode> getChildren() {
            return this.children;
        }

        public final boolean getPathIsAmbiguous() {
            return this.pathIsAmbiguous;
        }

        public final void setPathIsAmbiguous(boolean bl) {
            this.pathIsAmbiguous = bl;
        }

        public final boolean getUnreachable() {
            return this.unreachable;
        }

        public final void setUnreachable(boolean bl) {
            this.unreachable = bl;
        }

        @NotNull
        public final String getBaseName() {
            return this.baseName;
        }

        public final int getLevel() {
            return this.level;
        }

        public final int getLevels() {
            return this.levels;
        }

        public final void setLevels(int n) {
            this.levels = n;
        }

        public final boolean isRoot() {
            return this.parents.isEmpty();
        }

        @NotNull
        public String toString() {
            return this.promotion.getName();
        }
    }
}

