/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.savescreens;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.logic.files.UncivFiles;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.AutoScrollPane;
import com.unciv.ui.components.widgets.LoadingImage;
import com.unciv.ui.screens.basescreen.BaseScreen;
import com.unciv.ui.screens.savescreens.VerticalFileListScrollPane;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001:\u0001,B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0014\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010J\u001a\u0010\u0016\u001a\u00020\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ,\u0010\u001c\u001a\u00020\u00122\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00110\u001d2\u0016\b\u0002\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\rH\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\nH\u0002J\u0018\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\nH\u0002J\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#*\u00020\u00032\u0006\u0010!\u001a\u00020\nH\u0002J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0002J\u0010\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020\u0012H\u0002J\u0010\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\rH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/unciv/ui/screens/savescreens/VerticalFileListScrollPane;", "Lcom/unciv/ui/components/widgets/AutoScrollPane;", "existingSavesTable", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "<init>", "(Lcom/badlogic/gdx/scenes/scene2d/ui/Table;)V", "getExistingSavesTable", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "buttonIndex", "Ljava/util/ArrayList;", "Lcom/unciv/ui/screens/savescreens/VerticalFileListScrollPane$FileHandleButton;", "Lkotlin/collections/ArrayList;", "selectedIndex", "", "selectedButton", "onChangeListener", "Lkotlin/Function1;", "Lcom/badlogic/gdx/files/FileHandle;", "", "onDoubleClickListener", "onChange", "action", "onDoubleClick", "updateSaveGames", "files", "Lcom/unciv/logic/files/UncivFiles;", "showAutosaves", "", "update", "Lkotlin/sequences/Sequence;", "beforeRowCallback", "selectExistingSave", "index", "button", "getVerticalSpan", "Lkotlin/ranges/ClosedFloatingPointRange;", "", "getButtonAt", "y", "scrollTo", "onArrowKey", "direction", "onPageKey", "onHomeEndKey", "FileHandleButton", "core"})
@SourceDebugExtension(value={"SMAP\nVerticalFileListScrollPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerticalFileListScrollPane.kt\ncom/unciv/ui/screens/savescreens/VerticalFileListScrollPane\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,201:1\n628#2:202\n*S KotlinDebug\n*F\n+ 1 VerticalFileListScrollPane.kt\ncom/unciv/ui/screens/savescreens/VerticalFileListScrollPane\n*L\n62#1:202\n*E\n"})
public class VerticalFileListScrollPane
extends AutoScrollPane {
    @NotNull
    private final Table existingSavesTable;
    @NotNull
    private final ArrayList<FileHandleButton> buttonIndex;
    private int selectedIndex;
    @Nullable
    private FileHandleButton selectedButton;
    @Nullable
    private Function1<? super FileHandle, Unit> onChangeListener;
    @Nullable
    private Function1<? super FileHandle, Unit> onDoubleClickListener;

    public VerticalFileListScrollPane(@NotNull Table existingSavesTable) {
        Intrinsics.checkNotNullParameter(existingSavesTable, "existingSavesTable");
        super((Actor)existingSavesTable, null, 2, null);
        this.existingSavesTable = existingSavesTable;
        this.buttonIndex = new ArrayList();
        this.selectedIndex = -1;
        ActivationExtensionsKt.getKeyShortcuts(this).add(19, () -> VerticalFileListScrollPane._init_$lambda$0(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(20, () -> VerticalFileListScrollPane._init_$lambda$1(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(92, () -> VerticalFileListScrollPane._init_$lambda$2(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(93, () -> VerticalFileListScrollPane._init_$lambda$3(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(3, () -> VerticalFileListScrollPane._init_$lambda$4(this));
        ActivationExtensionsKt.getKeyShortcuts(this).add(123, () -> VerticalFileListScrollPane._init_$lambda$5(this));
    }

    public /* synthetic */ VerticalFileListScrollPane(Table table2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            table2 = new Table();
        }
        this(table2);
    }

    @NotNull
    protected final Table getExistingSavesTable() {
        return this.existingSavesTable;
    }

    public final void onChange(@NotNull Function1<? super FileHandle, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        this.onChangeListener = action2;
    }

    public final void onDoubleClick(@NotNull Function1<? super FileHandle, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, "action");
        this.onDoubleClickListener = action2;
    }

    public final void updateSaveGames(@NotNull UncivFiles files, boolean showAutosaves) {
        Intrinsics.checkNotNullParameter(files, "files");
        Sequence<FileHandle> $this$sortedByDescending$iv = files.getSaves(showAutosaves);
        boolean $i$f$sortedByDescending = false;
        VerticalFileListScrollPane.update$default(this, SequencesKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                FileHandle it = (FileHandle)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.lastModified());
                it = (FileHandle)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.lastModified());
            }
        }), null, 2, null);
    }

    public final void update(@NotNull Sequence<? extends FileHandle> files, @Nullable Function1<? super FileHandle, Unit> beforeRowCallback) {
        Intrinsics.checkNotNullParameter(files, "files");
        this.existingSavesTable.clear();
        this.selectedIndex = -1;
        this.selectedButton = null;
        LoadingImage loadingImage = new LoadingImage(62.0f, new LoadingImage.Style(null, null, null, 0, null, null, null, 0.8f, 0.0f, 0.0f, 0.0f, 1919, null));
        this.existingSavesTable.add((Actor)loadingImage);
        loadingImage.show();
        Concurrency.run$default(Concurrency.INSTANCE, "GetSaves", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(files, loadingImage, this, beforeRowCallback, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Sequence<FileHandle> $files;
            final /* synthetic */ LoadingImage $loadingImage;
            final /* synthetic */ VerticalFileListScrollPane this$0;
            final /* synthetic */ Function1<FileHandle, Unit> $beforeRowCallback;
            {
                this.$files = $files;
                this.$loadingImage = $loadingImage;
                this.this$0 = $receiver;
                this.$beforeRowCallback = $beforeRowCallback;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        List<FileHandle> saves = SequencesKt.toList(this.$files);
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$loadingImage, this.this$0, saves, this.$beforeRowCallback, null){
                            int label;
                            final /* synthetic */ LoadingImage $loadingImage;
                            final /* synthetic */ VerticalFileListScrollPane this$0;
                            final /* synthetic */ List<FileHandle> $saves;
                            final /* synthetic */ Function1<FileHandle, Unit> $beforeRowCallback;
                            {
                                this.$loadingImage = $loadingImage;
                                this.this$0 = $receiver;
                                this.$saves = $saves;
                                this.$beforeRowCallback = $beforeRowCallback;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        LoadingImage.hide$default(this.$loadingImage, null, 1, null);
                                        this.this$0.getExistingSavesTable().clear();
                                        VerticalFileListScrollPane.access$getButtonIndex$p(this.this$0).clear();
                                        VerticalFileListScrollPane.access$getButtonIndex$p(this.this$0).ensureCapacity(this.$saves.size());
                                        Iterator<T> iterator2 = ((Iterable)this.$saves).iterator();
                                        int n = 0;
                                        while (iterator2.hasNext()) {
                                            int index = n++;
                                            FileHandle saveGameFile = (FileHandle)iterator2.next();
                                            FileHandleButton button = new FileHandleButton(saveGameFile, index);
                                            VerticalFileListScrollPane.access$getButtonIndex$p(this.this$0).add(button);
                                            ActivationExtensionsKt.onClick(button, () -> update.1.invokeSuspend$lambda$0(this.this$0, index));
                                            ActivationExtensionsKt.onDoubleClick$default(button, null, () -> update.1.invokeSuspend$lambda$1(this.this$0, index, saveGameFile), 1, null);
                                            Function1<FileHandle, Unit> function1 = this.$beforeRowCallback;
                                            if (function1 != null) {
                                                function1.invoke(saveGameFile);
                                            }
                                            this.this$0.getExistingSavesTable().add((Actor)button).pad(5.0f).row();
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }

                            private static final Unit invokeSuspend$lambda$0(VerticalFileListScrollPane this$0, int $index) {
                                VerticalFileListScrollPane.access$selectExistingSave(this$0, $index);
                                return Unit.INSTANCE;
                            }

                            private static final Unit invokeSuspend$lambda$1(VerticalFileListScrollPane this$0, int $index, FileHandle $saveGameFile) {
                                block0: {
                                    VerticalFileListScrollPane.access$selectExistingSave(this$0, $index);
                                    Function1 function1 = VerticalFileListScrollPane.access$getOnDoubleClickListener$p(this$0);
                                    if (function1 == null) break block0;
                                    function1.invoke($saveGameFile);
                                }
                                return Unit.INSTANCE;
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    public static /* synthetic */ void update$default(VerticalFileListScrollPane verticalFileListScrollPane, Sequence sequence, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: update");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        verticalFileListScrollPane.update(sequence, function1);
    }

    private final void selectExistingSave(int index) {
        FileHandleButton fileHandleButton = this.buttonIndex.get(index);
        Intrinsics.checkNotNullExpressionValue(fileHandleButton, "get(...)");
        this.selectExistingSave(index, fileHandleButton);
    }

    private final void selectExistingSave(FileHandleButton button) {
        this.selectExistingSave(button.getIndex(), button);
    }

    private final void selectExistingSave(int index, FileHandleButton button) {
        block1: {
            this.selectedIndex = index;
            FileHandleButton fileHandleButton = this.selectedButton;
            if (fileHandleButton != null) {
                fileHandleButton.setColor(Color.WHITE);
            }
            button.setColor(Color.GREEN);
            this.selectedButton = button;
            Function1<? super FileHandle, Unit> function1 = this.onChangeListener;
            if (function1 == null) break block1;
            function1.invoke(button.getFile());
        }
    }

    private final ClosedFloatingPointRange<Float> getVerticalSpan(Table $this$getVerticalSpan, FileHandleButton button) {
        float invertedY = $this$getVerticalSpan.getHeight() - button.getY();
        return RangesKt.rangeTo(invertedY - button.getHeight(), invertedY);
    }

    private final ClosedFloatingPointRange<Float> getVerticalSpan() {
        return RangesKt.rangeTo(this.getScrollY(), this.getScrollY() + this.getHeight());
    }

    private final FileHandleButton getButtonAt(float y) {
        int l = 0;
        int h = this.buttonIndex.size() - 1;
        int bestIndex = 0;
        float bestDistance = 1000000.0f;
        while (l <= h) {
            float f;
            FileHandleButton button;
            int index = (l + h) / 2;
            Intrinsics.checkNotNullExpressionValue(this.buttonIndex.get(index), "get(...)");
            ClosedFloatingPointRange<Float> span = this.getVerticalSpan(this.existingSavesTable, button);
            if (((Number)span.getStart()).floatValue() > y) {
                f = y - ((Number)span.getStart()).floatValue();
            } else if (((Number)span.getEndInclusive()).floatValue() < y) {
                f = y - ((Number)span.getEndInclusive()).floatValue();
            } else {
                return button;
            }
            float distance = f;
            if (Math.abs(distance) < bestDistance) {
                bestDistance = Math.abs(distance);
                bestIndex = index;
            }
            if (distance < 0.0f) {
                h = index - 1;
                continue;
            }
            l = index + 1;
        }
        FileHandleButton fileHandleButton = this.buttonIndex.get(bestIndex);
        Intrinsics.checkNotNullExpressionValue(fileHandleButton, "get(...)");
        return fileHandleButton;
    }

    private final void scrollTo() {
        FileHandleButton fileHandleButton = this.selectedButton;
        if (fileHandleButton == null) {
            return;
        }
        FileHandleButton button = fileHandleButton;
        ClosedFloatingPointRange<Float> buttonSpan = this.getVerticalSpan(this.existingSavesTable, button);
        ClosedFloatingPointRange<Float> scrollSpan = this.getVerticalSpan();
        if (((Number)buttonSpan.getStart()).floatValue() < ((Number)scrollSpan.getStart()).floatValue()) {
            this.setScrollY(((Number)buttonSpan.getStart()).floatValue() - 10.0f);
        }
        if (((Number)buttonSpan.getEndInclusive()).floatValue() > ((Number)scrollSpan.getEndInclusive()).floatValue()) {
            this.setScrollY(((Number)buttonSpan.getEndInclusive()).floatValue() - this.getHeight() + 10.0f);
        }
    }

    private final void onArrowKey(int direction) {
        if (this.buttonIndex.size() == 0) {
            return;
        }
        int newIndex = VerticalFileListScrollPane.onArrowKey$wrapAround(this, this.selectedIndex + direction);
        this.selectExistingSave(newIndex);
        this.scrollTo();
    }

    private final void onPageKey(int direction) {
        float distance = (this.getHeight() - 60.0f) * (float)direction;
        this.setScrollY(this.getScrollY() + distance);
        if (this.selectedButton == null) {
            return;
        }
        FileHandleButton fileHandleButton = this.selectedButton;
        Intrinsics.checkNotNull(fileHandleButton);
        ClosedFloatingPointRange<Float> buttonSpan = this.getVerticalSpan(this.existingSavesTable, fileHandleButton);
        float newButtonY = (((Number)buttonSpan.getStart()).floatValue() + ((Number)buttonSpan.getEndInclusive()).floatValue()) / (float)2 + distance;
        this.selectExistingSave(this.getButtonAt(newButtonY));
        this.scrollTo();
    }

    private final void onHomeEndKey(int direction) {
        this.setScrollY((float)direction * this.getMaxY());
        if (this.buttonIndex.size() == 0) {
            return;
        }
        this.selectExistingSave((this.buttonIndex.size() - 1) * direction);
    }

    private static final Unit _init_$lambda$0(VerticalFileListScrollPane this$0) {
        this$0.onArrowKey(-1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(VerticalFileListScrollPane this$0) {
        this$0.onArrowKey(1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(VerticalFileListScrollPane this$0) {
        this$0.onPageKey(-1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(VerticalFileListScrollPane this$0) {
        this$0.onPageKey(1);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(VerticalFileListScrollPane this$0) {
        this$0.onHomeEndKey(0);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$5(VerticalFileListScrollPane this$0) {
        this$0.onHomeEndKey(1);
        return Unit.INSTANCE;
    }

    @Readonly
    private static final int onArrowKey$wrapAround(VerticalFileListScrollPane this$0, int index) {
        return index < 0 ? this$0.buttonIndex.size() - 1 : (index >= this$0.buttonIndex.size() ? 0 : index);
    }

    public VerticalFileListScrollPane() {
        this(null, 1, null);
    }

    public static final /* synthetic */ ArrayList access$getButtonIndex$p(VerticalFileListScrollPane $this) {
        return $this.buttonIndex;
    }

    public static final /* synthetic */ void access$selectExistingSave(VerticalFileListScrollPane $this, int index) {
        $this.selectExistingSave(index);
    }

    public static final /* synthetic */ Function1 access$getOnDoubleClickListener$p(VerticalFileListScrollPane $this) {
        return $this.onDoubleClickListener;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/unciv/ui/screens/savescreens/VerticalFileListScrollPane$FileHandleButton;", "Lcom/badlogic/gdx/scenes/scene2d/ui/TextButton;", "file", "Lcom/badlogic/gdx/files/FileHandle;", "index", "", "<init>", "(Lcom/badlogic/gdx/files/FileHandle;I)V", "getFile", "()Lcom/badlogic/gdx/files/FileHandle;", "getIndex", "()I", "core"})
    private static final class FileHandleButton
    extends TextButton {
        @NotNull
        private final FileHandle file;
        private final int index;

        public FileHandleButton(@NotNull FileHandle file, int index) {
            Intrinsics.checkNotNullParameter(file, "file");
            super(file.name(), BaseScreen.Companion.getSkin());
            this.file = file;
            this.index = index;
        }

        @NotNull
        public final FileHandle getFile() {
            return this.file;
        }

        public final int getIndex() {
            return this.index;
        }
    }
}

