/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.victoryscreen;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.unciv.logic.civilization.Civilization;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.fonts.Fonts;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.screens.victoryscreen.DataPoint;
import com.unciv.ui.screens.victoryscreen.VictoryScreenCivGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010#\u001a\u00020\u0007H\u0016J\b\u0010$\u001a\u00020\u0007H\u0016J\b\u0010%\u001a\u00020\u0007H\u0016J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020(H\u0016J\"\u0010)\u001a\u00020(2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0\u00192\u0006\u0010+\u001a\u00020\u0003J\u001c\u0010,\u001a\u00020(2\u0012\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0\u0019H\u0002J*\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0012\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0\u00192\u0006\u0010/\u001a\u000200H\u0007J\u0010\u00101\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020\u00172\u0006\u0010.\u001a\u00020\u0017H\u0002J\b\u00103\u001a\u00020(H\u0002J\u0010\u00104\u001a\u0002002\u0006\u00105\u001a\u00020\u0003H\u0002J\u001a\u00106\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f07H\u0002J8\u00108\u001a\u00020(2\u0006\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u00072\u0006\u0010=\u001a\u00020\t2\u0006\u0010>\u001a\u00020\u0007H\u0002J0\u0010?\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u00192\u0012\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u00192\u0006\u0010A\u001a\u00020\u0007H\u0002J2\u0010B\u001a\u00020\u00072\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00070\u001fH\u0002J\u0010\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u001f0\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006I"}, d2={"Lcom/unciv/ui/screens/victoryscreen/LineChart;", "Lcom/badlogic/gdx/scenes/scene2d/ui/WidgetGroup;", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "<init>", "(Lcom/unciv/logic/civilization/Civilization;)V", "axisLineWidth", "", "axisColor", "Lcom/badlogic/gdx/graphics/Color;", "kotlin.jvm.PlatformType", "axisLabelColor", "axisLabelStyle", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label$LabelStyle;", "getAxisLabelStyle", "()Lcom/badlogic/gdx/scenes/scene2d/ui/Label$LabelStyle;", "axisLabelStyle$delegate", "Lkotlin/Lazy;", "axisToLabelPadding", "chartLineWidth", "orientationLineWidth", "orientationLineColor", "maxLabels", "", "xLabels", "", "yLabels", "xLabelsAsLabels", "Lcom/badlogic/gdx/scenes/scene2d/ui/Label;", "yLabelsAsLabels", "dataPoints", "Lcom/unciv/ui/screens/victoryscreen/DataPoint;", "selectedCiv", "preparedForWidth", "preparedForHeight", "getMinWidth", "getMinHeight", "getPrefWidth", "getPrefHeight", "validate", "", "update", "newData", "newSelectedCiv", "updateLabels", "generateLabels", "value", "yAxis", "", "getNextNumberDivisibleByPowOfTen", "getPrevNumberDivisibleByPowOfTen", "prepareForDraw", "useActualColor", "civ", "getLastTurnDataPoints", "", "drawLine", "x1", "y1", "x2", "y2", "lineColor", "width", "douglasPeucker", "points", "epsilon", "perpendicularDistance", "point", "start", "end", "getTurnAt", "Lkotlin/ranges/IntRange;", "x", "core"})
@SourceDebugExtension(value={"SMAP\nLineChart.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChart.kt\ncom/unciv/ui/screens/victoryscreen/LineChart\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,392:1\n1586#2:393\n1661#2,3:394\n1586#2:397\n1661#2,3:398\n1586#2:402\n1661#2,3:403\n1586#2:406\n1661#2,3:407\n1586#2:410\n1661#2,3:411\n1586#2:414\n1661#2,3:415\n1924#2,3:418\n1924#2,3:421\n1068#2:424\n1512#2:425\n1538#2,3:426\n1541#2,3:436\n1068#2:439\n1586#2:440\n1661#2,3:441\n1#3:401\n383#4,7:429\n*S KotlinDebug\n*F\n+ 1 LineChart.kt\ncom/unciv/ui/screens/victoryscreen/LineChart\n*L\n81#1:393\n81#1:394,3\n82#1:397\n82#1:398,3\n101#1:402\n101#1:403,3\n103#1:406\n103#1:407,3\n109#1:410\n109#1:411,3\n112#1:414\n112#1:415,3\n172#1:418,3\n201#1:421,3\n228#1:424\n229#1:425\n229#1:426,3\n229#1:436,3\n233#1:439\n241#1:440\n241#1:441,3\n229#1:429,7\n*E\n"})
public final class LineChart
extends WidgetGroup {
    @NotNull
    private final Civilization viewingCiv;
    private final float axisLineWidth;
    private final Color axisColor;
    private final Color axisLabelColor;
    @NotNull
    private final Lazy axisLabelStyle$delegate;
    private final float axisToLabelPadding;
    private final float chartLineWidth;
    private final float orientationLineWidth;
    private final Color orientationLineColor;
    private final int maxLabels;
    @NotNull
    private List<Integer> xLabels;
    @NotNull
    private List<Integer> yLabels;
    @NotNull
    private List<? extends Label> xLabelsAsLabels;
    @NotNull
    private List<? extends Label> yLabelsAsLabels;
    @NotNull
    private List<DataPoint<Integer>> dataPoints;
    @NotNull
    private Civilization selectedCiv;
    private float preparedForWidth;
    private float preparedForHeight;

    public LineChart(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        this.viewingCiv = viewingCiv;
        this.axisLineWidth = 2.0f;
        this.axisLabelColor = this.axisColor = Color.WHITE;
        this.axisLabelStyle$delegate = LazyKt.lazy(() -> LineChart.axisLabelStyle_delegate$lambda$0(this));
        this.axisToLabelPadding = 5.0f;
        this.chartLineWidth = 3.0f;
        this.orientationLineWidth = 1.0f;
        this.orientationLineColor = Color.LIGHT_GRAY;
        this.maxLabels = 10;
        this.xLabels = CollectionsKt.emptyList();
        this.yLabels = CollectionsKt.emptyList();
        this.xLabelsAsLabels = CollectionsKt.emptyList();
        this.yLabelsAsLabels = CollectionsKt.emptyList();
        this.dataPoints = CollectionsKt.emptyList();
        this.selectedCiv = this.viewingCiv;
    }

    private final Label.LabelStyle getAxisLabelStyle() {
        Lazy lazy = this.axisLabelStyle$delegate;
        return (Label.LabelStyle)lazy.getValue();
    }

    @Override
    public float getMinWidth() {
        return (float)this.maxLabels * (21.0f + this.axisToLabelPadding);
    }

    @Override
    public float getMinHeight() {
        return (float)this.maxLabels * (18.0f + this.axisToLabelPadding);
    }

    @Override
    public float getPrefWidth() {
        return this.hasChildren() ? this.getWidth() : this.getMinWidth();
    }

    @Override
    public float getPrefHeight() {
        return this.hasChildren() ? this.getHeight() : this.getMinHeight();
    }

    @Override
    public void validate() {
        if (!(this.preparedForWidth == this.getWidth()) || !(this.preparedForHeight == this.getHeight())) {
            this.prepareForDraw();
        }
        super.validate();
    }

    public final void update(@NotNull List<DataPoint<Integer>> newData, @NotNull Civilization newSelectedCiv) {
        Intrinsics.checkNotNullParameter(newData, "newData");
        Intrinsics.checkNotNullParameter(newSelectedCiv, "newSelectedCiv");
        this.selectedCiv = newSelectedCiv;
        this.dataPoints = newData;
        this.updateLabels(this.dataPoints);
        this.preparedForWidth = 0.0f;
        this.invalidate();
    }

    private final void updateLabels(List<DataPoint<Integer>> newData) {
        int it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        this.xLabels = this.generateLabels(newData, false);
        this.yLabels = this.generateLabels(newData, true);
        Iterable iterable = this.xLabels;
        LineChart lineChart = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Label((CharSequence)TranslationsKt.tr(it), this.getAxisLabelStyle()));
        }
        lineChart.xLabelsAsLabels = (List)destination$iv$iv;
        $this$map$iv = this.yLabels;
        lineChart = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Label((CharSequence)TranslationsKt.tr(it), this.getAxisLabelStyle()));
        }
        lineChart.yLabelsAsLabels = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public final List<Integer> generateLabels(@NotNull List<DataPoint<Integer>> value, boolean yAxis) {
        List list2;
        int it322;
        Intrinsics.checkNotNullParameter(value, "value");
        if (value.isEmpty()) {
            return CollectionsKt.listOf(0);
        }
        Iterable iterable = value;
        Object object = this;
        Iterator iterator2 = iterable.iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        DataPoint it322 = (DataPoint)iterator2.next();
        boolean bl = false;
        int n = it322 = yAxis ? ((Number)it322.getY()).intValue() : ((Number)it322.getX()).intValue();
        while (iterator2.hasNext()) {
            DataPoint it22 = (DataPoint)iterator2.next();
            $i$a$-minOf-LineChart$generateLabels$minLabelValue$1 = false;
            int it22 = yAxis ? ((Number)it22.getY()).intValue() : ((Number)it22.getX()).intValue();
            if (it322 <= it22) continue;
            it322 = it22;
        }
        int n2 = it322;
        int minLabelValue = ((LineChart)object).getPrevNumberDivisibleByPowOfTen(n2);
        iterator2 = value;
        object = this;
        Iterator it322 = iterator2.iterator();
        if (!it322.hasNext()) {
            throw new NoSuchElementException();
        }
        Object it = (DataPoint)it322.next();
        boolean bl2 = false;
        it = yAxis ? ((Number)((DataPoint)it).getY()).intValue() : ((Number)((DataPoint)it).getX()).intValue();
        while (it322.hasNext()) {
            Object it2 = (DataPoint)it322.next();
            $i$a$-maxOf-LineChart$generateLabels$maxLabelValue$1 = false;
            it2 = yAxis ? ((Number)((DataPoint)it2).getY()).intValue() : ((Number)((DataPoint)it2).getX()).intValue();
            if (it.compareTo(it2) >= 0) continue;
            it = it2;
        }
        int maxLabelValue = ((LineChart)object).getNextNumberDivisibleByPowOfTen(((Number)it).intValue());
        int stepSizePositive = 0;
        stepSizePositive = (int)Math.ceil((float)maxLabelValue / (float)this.maxLabels);
        if (minLabelValue < 0) {
            List list3;
            int it4;
            int item$iv$iv;
            Iterable $this$mapTo$iv$iv;
            int stepSizeNegative = 0;
            stepSizeNegative = (int)Math.ceil(-((float)minLabelValue) / (float)this.maxLabels);
            int maxStep = Math.max(stepSizePositive, stepSizeNegative);
            int stepCountNegative = (int)Math.floor((double)minLabelValue / (double)maxStep);
            stepSizeNegative = Math.abs(stepCountNegative) < 2 ? Math.abs(minLabelValue) : maxStep;
            int stepCountPositive = (int)Math.ceil((double)maxLabelValue / (double)maxStep);
            stepSizePositive = Math.abs(stepCountPositive) < 2 ? Math.abs(maxLabelValue) : maxStep;
            Iterable $this$map$iv = RangesKt.until(stepCountNegative, 0);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator3 = $this$mapTo$iv$iv.iterator();
            while (iterator3.hasNext()) {
                int n3 = item$iv$iv = ((IntIterator)iterator3).nextInt();
                object = destination$iv$iv;
                boolean bl3 = false;
                object.add((int)(it4 * stepSizeNegative));
            }
            Object object2 = (List)destination$iv$iv;
            if (maxLabelValue != 0) {
                $this$map$iv = RangesKt.until(0, stepCountPositive + 1);
                object = object2;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                $i$f$mapTo = false;
                iterator3 = $this$mapTo$iv$iv.iterator();
                while (iterator3.hasNext()) {
                    it4 = item$iv$iv = ((IntIterator)iterator3).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(it4 * stepSizePositive);
                }
                list3 = (List)destination$iv$iv;
                object2 = object;
            } else {
                list3 = CollectionsKt.listOf(0);
            }
            list2 = CollectionsKt.plus(object2, (Iterable)list3);
        } else if (maxLabelValue != 0) {
            Iterable $this$map$iv;
            if (minLabelValue < stepSizePositive) {
                void $this$mapTo$iv$iv;
                $this$map$iv = RangesKt.until(0, this.maxLabels + 1);
                boolean $i$f$map = false;
                Iterable stepCountNegative = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator4 = $this$mapTo$iv$iv.iterator();
                while (iterator4.hasNext()) {
                    void it5;
                    int item$iv$iv;
                    int destination$iv$iv2 = item$iv$iv = ((IntIterator)iterator4).nextInt();
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    object.add((int)(it5 * stepSizePositive));
                }
                list2 = (List)destination$iv$iv;
            } else {
                stepSizePositive = (int)Math.ceil((float)(maxLabelValue - minLabelValue) / (float)this.maxLabels);
                $this$map$iv = RangesKt.until(0, this.maxLabels + 1);
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                Iterator iterator5 = $this$mapTo$iv$iv.iterator();
                while (iterator5.hasNext()) {
                    int item$iv$iv;
                    int it5 = item$iv$iv = ((IntIterator)iterator5).nextInt();
                    object = destination$iv$iv;
                    boolean bl6 = false;
                    object.add(minLabelValue + it5 * stepSizePositive);
                }
                list2 = (List)destination$iv$iv;
            }
        } else {
            Integer[] integerArray = new Integer[]{0, 1};
            list2 = CollectionsKt.listOf(integerArray);
        }
        return list2;
    }

    private final int getNextNumberDivisibleByPowOfTen(int value) {
        if (value == 0) {
            return 0;
        }
        int numberOfDigits = RangesKt.coerceIn((int)Math.ceil(Math.log10(Math.abs(value))), 2, 3);
        double oneWithZeros = Math.pow(10.0, numberOfDigits - 1);
        return (int)(Math.ceil((double)value / oneWithZeros) * oneWithZeros);
    }

    private final int getPrevNumberDivisibleByPowOfTen(int value) {
        if (value == 0) {
            return 0;
        }
        int numberOfDigits = RangesKt.coerceIn((int)Math.ceil(Math.log10(Math.abs(value))), 2, 3);
        double oneWithZeros = Math.pow(10.0, numberOfDigits - 1);
        return (int)(Math.floor((double)value / oneWithZeros) * oneWithZeros);
    }

    /*
     * WARNING - void declaration
     */
    private final void prepareForDraw() {
        void $this$groupByTo$iv$iv;
        this.clearChildren();
        if (this.xLabels.isEmpty() || this.yLabels.isEmpty()) {
            return;
        }
        Map<Civilization, DataPoint<Integer>> lastTurnDataPoints = this.getLastTurnDataPoints();
        float labelHeight = CollectionsKt.first(this.yLabelsAsLabels).getHeight();
        Iterator iterator2 = ((Iterable)this.yLabelsAsLabels).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Label it22 = (Label)iterator2.next();
        boolean bl = false;
        float it22 = it22.getWidth();
        while (iterator2.hasNext()) {
            Label it32 = (Label)iterator2.next();
            $i$a$-maxOf-LineChart$prepareForDraw$widestYLabelWidth$1 = false;
            float it32 = it32.getWidth();
            it22 = Math.max(it22, it32);
        }
        float widestYLabelWidth = it22;
        float yAxisLabelMaxY = this.getHeight() - labelHeight;
        float xAxisLabelsHeight = labelHeight;
        float zeroYAxisLabelHeight = labelHeight;
        float yAxisLabelMinY = xAxisLabelsHeight + this.axisToLabelPadding + this.axisLineWidth / (float)2 - zeroYAxisLabelHeight / (float)2;
        float yAxisLabelYRange = yAxisLabelMaxY - yAxisLabelMinY;
        float yAxisLowestOrientationLinePosition = 0.0f;
        float zeroAxisYPosition = 0.0f;
        Iterable $this$forEachIndexed$iv = this.yLabels;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void value;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = ((Number)item$iv).intValue();
            int index = n;
            boolean bl2 = false;
            Label label2 = this.yLabelsAsLabels.get(index);
            float yPos = yAxisLabelMinY + (float)index * (yAxisLabelYRange / (float)(this.yLabels.size() - 1));
            label2.setPosition((widestYLabelWidth - label2.getWidth()) / (float)2, yPos);
            this.addActor(label2);
            boolean zeroIndex = value == false;
            float labelAdjustedYPos = yPos + labelHeight / (float)2;
            float f = this.getWidth();
            Color color = zeroIndex ? this.axisColor : this.orientationLineColor;
            Intrinsics.checkNotNull(color);
            this.drawLine(widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth, labelAdjustedYPos, f, labelAdjustedYPos, color, zeroIndex ? this.axisLineWidth : this.orientationLineWidth);
            if (value > 0) continue;
            if (zeroIndex) {
                zeroAxisYPosition = labelAdjustedYPos;
            }
            yAxisLowestOrientationLinePosition = Math.min(yAxisLowestOrientationLinePosition, labelAdjustedYPos);
        }
        float lastXAxisLabelWidth = CollectionsKt.last(this.xLabelsAsLabels).getWidth();
        float xAxisLabelMinX = widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth / (float)2;
        float xAxisLabelMaxX = this.getWidth() - lastXAxisLabelWidth / (float)2;
        float xAxisLabelXRange = xAxisLabelMaxX - xAxisLabelMinX;
        Iterable $this$forEachIndexed$iv2 = this.xLabelsAsLabels;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv2 = 0;
        for (Object item$iv : $this$forEachIndexed$iv2) {
            void label;
            int label2;
            if ((label2 = index$iv2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Label yPos = (Label)item$iv;
            int index = label2;
            boolean bl3 = false;
            float xPos = xAxisLabelMinX + (float)index * (xAxisLabelXRange / (float)(this.xLabels.size() - 1));
            label.setPosition(xPos - label.getWidth() / (float)2, 0.0f);
            this.addActor((Actor)label);
            float f = this.getHeight();
            Color color = index > 0 ? this.orientationLineColor : this.axisColor;
            Intrinsics.checkNotNull(color);
            this.drawLine(xPos, labelHeight + this.axisToLabelPadding + this.axisLineWidth, xPos, f, color, index > 0 ? this.orientationLineWidth : this.axisLineWidth);
        }
        float linesMinX = widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth;
        float linesMaxX = this.getWidth() - lastXAxisLabelWidth / (float)2;
        float linesMinY = yAxisLowestOrientationLinePosition + labelHeight + this.axisToLabelPadding + this.axisLineWidth;
        float linesMaxY = this.getHeight() - labelHeight / (float)2;
        int minXLabel = ((Number)CollectionsKt.minOrThrow((Iterable)this.xLabels)).intValue();
        int minYLabel = ((Number)CollectionsKt.minOrThrow((Iterable)this.yLabels)).intValue();
        float scaleX = (linesMaxX - linesMinX) / (float)(((Number)CollectionsKt.maxOrThrow((Iterable)this.xLabels)).intValue() - minXLabel);
        float scaleY = (linesMaxY - linesMinY) / (float)(((Number)CollectionsKt.maxOrThrow((Iterable)this.yLabels)).intValue() - minYLabel);
        float negativeOrientationLineYPosition = yAxisLabelMinY + labelHeight / (float)2;
        float negativeScaleY = (negativeOrientationLineYPosition - zeroAxisYPosition) / (float)(minYLabel < 0 ? minYLabel : 1);
        Iterable $this$sortedBy$iv = this.dataPoints;
        boolean $i$f$sortedBy = false;
        List sortedPoints = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                DataPoint it = (DataPoint)a;
                boolean bl = false;
                Comparable comparable = (Integer)it.getX();
                it = (DataPoint)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Integer)it.getX()));
            }
        });
        Iterable $this$groupBy$iv = sortedPoints;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Iterator $this$getOrPut$iv$iv$iv;
            DataPoint it = (DataPoint)element$iv$iv;
            boolean bl4 = false;
            Civilization key$iv$iv = it.getCiv();
            Map map2 = destination$iv$iv;
            Civilization key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl5 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map pointsByCiv = destination$iv$iv;
        Iterable $this$sortedBy$iv2 = pointsByCiv.keySet();
        boolean $i$f$sortedBy2 = false;
        List civIterationOrder = CollectionsKt.toMutableList(CollectionsKt.sortedWith($this$sortedBy$iv2, new Comparator(lastTurnDataPoints){
            final /* synthetic */ Map $lastTurnDataPoints$inlined;
            {
                this.$lastTurnDataPoints$inlined = map2;
            }

            public final int compare(T a, T b) {
                Civilization it = (Civilization)a;
                boolean bl = false;
                V v = this.$lastTurnDataPoints$inlined.get(it);
                Intrinsics.checkNotNull(v);
                it = (Civilization)b;
                Comparable comparable = (Integer)((DataPoint)v).getY();
                bl = false;
                V v2 = this.$lastTurnDataPoints$inlined.get(it);
                Intrinsics.checkNotNull(v2);
                return ComparisonsKt.compareValues(comparable, (Comparable)((Integer)((DataPoint)v2).getY()));
            }
        }));
        if (civIterationOrder.remove(this.selectedCiv)) {
            civIterationOrder.add(this.selectedCiv);
        }
        for (Object t : civIterationOrder) {
            DataPoint<Float> b;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullExpressionValue(t, "next(...)");
            Civilization civ = (Civilization)t;
            Object v = pointsByCiv.get(civ);
            Intrinsics.checkNotNull(v);
            List points = (List)v;
            Iterable $this$map$iv = points;
            boolean $i$f$map = false;
            Iterable list$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DataPoint $i$f$getOrPut = (DataPoint)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl6 = false;
                float y = (float)((Number)it.getY()).intValue() >= 0.0f ? linesMinY + (float)(((Number)it.getY()).intValue() - minYLabel) * scaleY : zeroAxisYPosition + ((Number)it.getY()).floatValue() * negativeScaleY;
                collection.add(new DataPoint<Float>(Float.valueOf(linesMinX + (float)(((Number)it.getX()).intValue() - minXLabel) * scaleX), Float.valueOf(y), it.getCiv()));
            }
            List scaledPoints = (List)destination$iv$iv2;
            List<DataPoint<Float>> simplifiedScaledPoints = this.douglasPeucker(scaledPoints, 1.0f);
            if (Intrinsics.areEqual(civ, this.selectedCiv)) {
                Color selectedCivBackgroundColor = this.useActualColor(civ) ? (Color)civ.getNation().getInnerColor() : Color.LIGHT_GRAY;
                int n = simplifiedScaledPoints.size();
                for (int i = 1; i < n; ++i) {
                    DataPoint<Float> a = simplifiedScaledPoints.get(i - 1);
                    b = simplifiedScaledPoints.get(i);
                    float f = ((Number)a.getX()).floatValue();
                    float f2 = ((Number)a.getY()).floatValue();
                    float f3 = ((Number)b.getX()).floatValue();
                    float f4 = ((Number)b.getY()).floatValue();
                    Intrinsics.checkNotNull(selectedCivBackgroundColor);
                    this.drawLine(f, f2, f3, f4, selectedCivBackgroundColor, this.chartLineWidth * (float)3);
                }
            }
            Color civLineColor = this.useActualColor(civ) ? (Color)civ.getNation().getOuterColor() : Color.DARK_GRAY;
            int n = simplifiedScaledPoints.size();
            for (int i = 1; i < n; ++i) {
                Actor selectedCivIcon;
                Actor actor;
                DataPoint<Float> a = simplifiedScaledPoints.get(i - 1);
                b = simplifiedScaledPoints.get(i);
                float f = ((Number)a.getX()).floatValue();
                float f5 = ((Number)a.getY()).floatValue();
                float f6 = ((Number)b.getX()).floatValue();
                float f7 = ((Number)b.getY()).floatValue();
                Intrinsics.checkNotNull(civLineColor);
                this.drawLine(f, f5, f6, f7, civLineColor, this.chartLineWidth);
                if (i != simplifiedScaledPoints.size() - 1 || !Intrinsics.areEqual(this.selectedCiv, civ) || !lastTurnDataPoints.containsKey(this.selectedCiv)) continue;
                Actor $this$prepareForDraw_u24lambda_u247 = actor = (selectedCivIcon = VictoryScreenCivGroup.Companion.getCivImageAndColors(this.selectedCiv, this.viewingCiv, VictoryScreenCivGroup.DefeatedPlayerStyle.REGULAR).getFirst());
                boolean bl7 = false;
                $this$prepareForDraw_u24lambda_u247.setPosition(((Number)b.getX()).floatValue(), ((Number)b.getY()).floatValue(), 1);
                $this$prepareForDraw_u24lambda_u247.setSize(33.0f, 33.0f);
                this.addActor(selectedCivIcon);
            }
        }
        this.preparedForWidth = this.getWidth();
        this.preparedForHeight = this.getHeight();
    }

    private final boolean useActualColor(Civilization civ) {
        return this.viewingCiv.isSpectator() || this.viewingCiv.isDefeated() || this.viewingCiv.getVictoryManager().hasWon() || Intrinsics.areEqual(this.viewingCiv, civ) || this.viewingCiv.knows(civ) || civ.isDefeated();
    }

    private final Map<Civilization, DataPoint<Integer>> getLastTurnDataPoints() {
        Map lastDataPoints = new LinkedHashMap();
        for (DataPoint<Integer> dataPoint : this.dataPoints) {
            if (lastDataPoints.containsKey(dataPoint.getCiv())) {
                Object v = lastDataPoints.get(dataPoint.getCiv());
                Intrinsics.checkNotNull(v);
                if (((Number)((DataPoint)v).getX()).intValue() >= ((Number)dataPoint.getX()).intValue()) continue;
            }
            lastDataPoints.put(dataPoint.getCiv(), dataPoint);
        }
        return lastDataPoints;
    }

    private final void drawLine(float x1, float y1, float x2, float y2, Color lineColor, float width) {
        Image line = ImageGetter.INSTANCE.getLine(x1, y1, x2, y2, width);
        line.setColor(lineColor);
        this.addActor(line);
        Image edgeRounding = ImageGetter.INSTANCE.getCircle(lineColor, Float.valueOf(width));
        edgeRounding.setPosition(x1 - width / 2.0f, y1 - width / 2.0f);
        this.addActor(edgeRounding);
    }

    private final List<DataPoint<Float>> douglasPeucker(List<DataPoint<Float>> points, float epsilon) {
        boolean bl;
        if (points.size() < 3) {
            return points;
        }
        float[] dMax = new float[points.size()];
        int index = 0;
        float maxDistance = 0.0f;
        int n = CollectionsKt.getLastIndex(points);
        for (int i = 1; i < n; ++i) {
            float distance;
            dMax[i] = distance = this.perpendicularDistance(points.get(i), points.get(0), CollectionsKt.last(points));
            if (!(distance > maxDistance)) continue;
            index = i;
            maxDistance = distance;
        }
        List resultList = new ArrayList();
        if (maxDistance > epsilon) {
            List<DataPoint<Float>> recursiveList1 = this.douglasPeucker(points.subList(0, index + 1), epsilon);
            List<DataPoint<Float>> recursiveList2 = this.douglasPeucker(points.subList(index, points.size()), epsilon);
            resultList.addAll((Collection)recursiveList1.subList(0, CollectionsKt.getLastIndex(recursiveList1)));
            bl = resultList.addAll((Collection)recursiveList2);
        } else {
            resultList.add(CollectionsKt.first(points));
            bl = resultList.add(CollectionsKt.last(points));
        }
        return resultList;
    }

    private final float perpendicularDistance(DataPoint<Float> point, DataPoint<Float> start2, DataPoint<Float> end) {
        float xx;
        float param;
        float x = ((Number)point.getX()).floatValue();
        float y = ((Number)point.getY()).floatValue();
        float x1 = ((Number)start2.getX()).floatValue();
        float y1 = ((Number)start2.getY()).floatValue();
        float x2 = ((Number)end.getX()).floatValue();
        float y2 = ((Number)end.getY()).floatValue();
        float a = x - x1;
        float b = y - y1;
        float c = x2 - x1;
        float d = y2 - y1;
        float dot = a * c + b * d;
        float lenSq = c * c + d * d;
        float f = param = lenSq == 0.0f ? 0.0f : dot / lenSq;
        float f2 = param < 0.0f ? x1 : (xx = param > 1.0f ? x2 : x1 + param * c);
        float yy = param < 0.0f ? y1 : (param > 1.0f ? y2 : y1 + param * d);
        float dx = x - xx;
        float dy = y - yy;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    @Nullable
    public final IntRange getTurnAt(float x) {
        if (this.xLabels.isEmpty() || this.xLabelsAsLabels.isEmpty() || this.yLabelsAsLabels.isEmpty()) {
            return null;
        }
        Iterator iterator2 = ((Iterable)this.yLabelsAsLabels).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        Label it22 = (Label)iterator2.next();
        boolean bl = false;
        float it22 = it22.getWidth();
        while (iterator2.hasNext()) {
            Label it32 = (Label)iterator2.next();
            $i$a$-maxOf-LineChart$getTurnAt$widestYLabelWidth$1 = false;
            float it32 = it32.getWidth();
            it22 = Math.max(it22, it32);
        }
        float widestYLabelWidth = it22;
        float linesMinX = widestYLabelWidth + this.axisToLabelPadding + this.axisLineWidth;
        float linesMaxX = this.getWidth() - CollectionsKt.last(this.xLabelsAsLabels).getWidth() / (float)2;
        if (Float.compare(linesMinX, linesMaxX) == 0) {
            return new IntRange(((Number)CollectionsKt.first(this.xLabels)).intValue(), ((Number)CollectionsKt.last(this.xLabels)).intValue());
        }
        float ratio = (x - linesMinX) / (linesMaxX - linesMinX);
        int turn = RangesKt.coerceAtLeast((int)MathUtils.lerp(((Number)CollectionsKt.first(this.xLabels)).intValue(), ((Number)CollectionsKt.last(this.xLabels)).intValue(), ratio), 1);
        return new IntRange(this.getPrevNumberDivisibleByPowOfTen(turn - 1), this.getNextNumberDivisibleByPowOfTen(turn + 1));
    }

    private static final Label.LabelStyle axisLabelStyle_delegate$lambda$0(LineChart this$0) {
        return new Label.LabelStyle(Fonts.INSTANCE.getFont(), this$0.axisLabelColor);
    }
}

