/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.screens.worldscreen.worldmap;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.scenes.scene2d.Action;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.actions.Actions;
import com.badlogic.gdx.scenes.scene2d.actions.MoveToAction;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.SnapshotArray;
import com.unciv.UncivGame;
import com.unciv.logic.battle.AttackableTile;
import com.unciv.logic.battle.Battle;
import com.unciv.logic.battle.MapUnitCombatant;
import com.unciv.logic.battle.TargetHelper;
import com.unciv.logic.city.City;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.civilization.ExploredRegion;
import com.unciv.logic.map.HexCoord;
import com.unciv.logic.map.MapPathing;
import com.unciv.logic.map.TileMap;
import com.unciv.logic.map.mapunit.MapUnit;
import com.unciv.logic.map.mapunit.movement.UnitMovement;
import com.unciv.logic.map.tile.Tile;
import com.unciv.models.Spy;
import com.unciv.models.UncivSound;
import com.unciv.ui.audio.SoundPlayer;
import com.unciv.ui.components.MapArrowType;
import com.unciv.ui.components.MiscArrowTypes;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.input.ActivationTypes;
import com.unciv.ui.components.input.ClickableCircle;
import com.unciv.ui.components.tilegroups.TileGroup;
import com.unciv.ui.components.tilegroups.TileGroupMap;
import com.unciv.ui.components.tilegroups.TileSetStrings;
import com.unciv.ui.components.tilegroups.WorldTileGroup;
import com.unciv.ui.components.tilegroups.layers.TileLayerMisc;
import com.unciv.ui.components.tilegroups.layers.TileLayerOverlay;
import com.unciv.ui.components.tilegroups.layers.UnitSpriteSlot;
import com.unciv.ui.components.widgets.UnitIconGroup;
import com.unciv.ui.components.widgets.ZoomableScrollPane;
import com.unciv.ui.images.IconCircleGroup;
import com.unciv.ui.screens.basescreen.UncivStage;
import com.unciv.ui.screens.worldscreen.UndoHandler;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import com.unciv.ui.screens.worldscreen.bottombar.BattleTableHelpers;
import com.unciv.ui.screens.worldscreen.unit.UnitTable;
import com.unciv.ui.screens.worldscreen.worldmap.ConnectRoadOverlayButtonData;
import com.unciv.ui.screens.worldscreen.worldmap.MoveHereOverlayButtonData;
import com.unciv.ui.screens.worldscreen.worldmap.MoveSpyOverlayButtonData;
import com.unciv.ui.screens.worldscreen.worldmap.OverlayButtonData;
import com.unciv.ui.screens.worldscreen.worldmap.SwapWithOverlayButtonData;
import com.unciv.utils.Concurrency;
import com.unciv.utils.ConcurrencyKt;
import com.unciv.utils.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010,\u001a\u00020-H\u0002J\r\u0010.\u001a\u00020-H\u0000\u00a2\u0006\u0002\b/J\u000e\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\rJ\u0018\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\rH\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00103\u001a\u00020\u001fH\u0002J#\u00105\u001a\u00020-2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u00107\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b8J.\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\r2\f\u0010<\u001a\b\u0012\u0004\u0012\u00020\r0\"H\u0002J\u001d\u0010=\u001a\u00020-2\u0006\u0010;\u001a\u00020\u001f2\u0006\u00107\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b>J\u001e\u0010?\u001a\u00020-2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001f0\"2\u0006\u00101\u001a\u00020\rH\u0002J\u0018\u0010@\u001a\u00020-2\u0006\u0010;\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\rH\u0002J\u0018\u0010A\u001a\u00020-2\u0006\u0010;\u001a\u00020\u001f2\u0006\u00101\u001a\u00020\rH\u0002J\u0018\u0010B\u001a\u00020-2\u0006\u0010C\u001a\u00020D2\u0006\u00101\u001a\u00020\rH\u0002J\u001c\u0010E\u001a\u00020-2\u0006\u00101\u001a\u00020\r2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010GH\u0002J\u0016\u0010H\u001a\u00020-2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020\u001aJ\u0010\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020OH\u0007J\u0006\u0010P\u001a\u00020-J\u001e\u0010Q\u001a\u00020-2\u0006\u0010R\u001a\u00020\r2\u0006\u0010S\u001a\u00020\r2\u0006\u0010T\u001a\u00020UJC\u0010V\u001a\u00020-2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020\u001f0X2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00020\u001f0X2\u0018\u0010Z\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u00020\\0[0XH\u0000\u00a2\u0006\u0002\b]J.\u0010d\u001a\u00020M2\u0006\u0010e\u001a\u00020\\2\b\b\u0002\u0010f\u001a\u00020M2\b\b\u0002\u0010g\u001a\u00020M2\n\b\u0002\u0010h\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010i\u001a\u00020-2\u0006\u0010j\u001a\u00020kH\u0016J\b\u0010l\u001a\u00020-H\u0002J\u0006\u0010m\u001a\u00020-J\b\u0010n\u001a\u00020-H\u0016J\u0010\u0010o\u001a\u00020k2\u0006\u0010p\u001a\u00020kH\u0016J\u0010\u0010q\u001a\u00020k2\u0006\u0010r\u001a\u00020kH\u0016J\u001a\u0010s\u001a\u00020-2\b\u0010t\u001a\u0004\u0018\u00010u2\u0006\u0010v\u001a\u00020kH\u0016J\u0010\u0010w\u001a\u00020-2\u0006\u0010x\u001a\u00020kH\u0016J\b\u0010y\u001a\u00020-H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R-\u0010\u0012\u001a\u001e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013j\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0014`\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R$\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u001a0\u0019j\b\u0012\u0004\u0012\u00020\u001a`\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dRP\u0010\u001e\u001a>\u0012\u0004\u0012\u00020\u001f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\u0019j\b\u0012\u0004\u0012\u00020\r`\u001b0\u0013j\u001e\u0012\u0004\u0012\u00020\u001f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r0\u0019j\b\u0012\u0004\u0012\u00020\r`\u001b`\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0017R<\u0010!\u001a*\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\"0\u0013j\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\"`\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u00020'X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001c\u0010^\u001a\u0004\u0018\u00010_X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010a\"\u0004\bb\u0010c\u00a8\u0006z"}, d2={"Lcom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder;", "Lcom/unciv/ui/components/widgets/ZoomableScrollPane;", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "tileMap", "Lcom/unciv/logic/map/TileMap;", "<init>", "(Lcom/unciv/ui/screens/worldscreen/WorldScreen;Lcom/unciv/logic/map/TileMap;)V", "getWorldScreen$core", "()Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "getTileMap$core", "()Lcom/unciv/logic/map/TileMap;", "selectedTile", "Lcom/unciv/logic/map/tile/Tile;", "getSelectedTile$core", "()Lcom/unciv/logic/map/tile/Tile;", "setSelectedTile$core", "(Lcom/unciv/logic/map/tile/Tile;)V", "tileGroups", "Ljava/util/HashMap;", "Lcom/unciv/ui/components/tilegroups/WorldTileGroup;", "Lkotlin/collections/HashMap;", "getTileGroups", "()Ljava/util/HashMap;", "unitActionOverlays", "Ljava/util/ArrayList;", "Lcom/badlogic/gdx/scenes/scene2d/Actor;", "Lkotlin/collections/ArrayList;", "getUnitActionOverlays$core", "()Ljava/util/ArrayList;", "unitMovementPaths", "Lcom/unciv/logic/map/mapunit/MapUnit;", "getUnitMovementPaths$core", "unitConnectRoadPaths", "", "getUnitConnectRoadPaths$core", "tileGroupMap", "Lcom/unciv/ui/components/tilegroups/TileGroupMap;", "currentTileSetStrings", "Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "getCurrentTileSetStrings", "()Lcom/unciv/ui/components/tilegroups/TileSetStrings;", "setCurrentTileSetStrings", "(Lcom/unciv/ui/components/tilegroups/TileSetStrings;)V", "setupZoomPanListeners", "", "addTiles", "addTiles$core", "onTileClicked", "tile", "onTileRightClicked", "unit", "markUnitMoveTutorialComplete", "moveUnitToTargetTile", "selectedUnits", "targetTile", "moveUnitToTargetTile$core", "animateMovement", "previousTile", "selectedUnit", "pathToTile", "swapMoveUnitToTargetTile", "swapMoveUnitToTargetTile$core", "addTileOverlaysWithUnitMovement", "addTileOverlaysWithUnitSwapping", "addTileOverlaysWithUnitRoadConnecting", "addMovingSpyOverlay", "spy", "Lcom/unciv/models/Spy;", "addTileOverlays", "buttonDto", "Lcom/unciv/ui/screens/worldscreen/worldmap/OverlayButtonData;", "addOverlayOnTileGroup", "group", "Lcom/unciv/ui/components/tilegroups/TileGroup;", "actor", "isMapRevealEnabled", "", "viewingCiv", "Lcom/unciv/logic/civilization/Civilization;", "resetArrows", "addArrow", "fromTile", "toTile", "arrowType", "Lcom/unciv/ui/components/MapArrowType;", "updateMovementOverlay", "pastVisibleUnits", "Lkotlin/sequences/Sequence;", "targetVisibleUnits", "visibleAttacks", "Lkotlin/Pair;", "Lcom/unciv/logic/map/HexCoord;", "updateMovementOverlay$core", "blinkAction", "Lcom/badlogic/gdx/scenes/scene2d/Action;", "getBlinkAction", "()Lcom/badlogic/gdx/scenes/scene2d/Action;", "setBlinkAction", "(Lcom/badlogic/gdx/scenes/scene2d/Action;)V", "setCenterPosition", "vector", "immediately", "selectUnit", "forceSelectUnit", "zoom", "zoomScale", "", "clampCityButtonSize", "removeUnitActionOverlay", "reloadMaxZoom", "restrictX", "deltaX", "restrictY", "deltaY", "draw", "batch", "Lcom/badlogic/gdx/graphics/g2d/Batch;", "parentAlpha", "act", "delta", "clear", "core"})
@SourceDebugExtension(value={"SMAP\nWorldMapHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorldMapHolder.kt\ncom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,732:1\n1586#2:733\n1661#2,3:734\n1807#2,3:739\n1807#2,3:742\n1807#2,3:745\n296#2,2:748\n1586#2:751\n1661#2,3:752\n296#2,2:757\n1253#3,2:737\n1#4:750\n37#5,2:755\n*S KotlinDebug\n*F\n+ 1 WorldMapHolder.kt\ncom/unciv/ui/screens/worldscreen/worldmap/WorldMapHolder\n*L\n107#1:733\n107#1:734,3\n162#1:739,3\n164#1:742,3\n172#1:745,3\n233#1:748,2\n368#1:751\n368#1:752,3\n617#1:757,2\n140#1:737,2\n374#1:755,2\n*E\n"})
public final class WorldMapHolder
extends ZoomableScrollPane {
    @NotNull
    private final WorldScreen worldScreen;
    @NotNull
    private final TileMap tileMap;
    @Nullable
    private Tile selectedTile;
    @NotNull
    private final HashMap<Tile, WorldTileGroup> tileGroups;
    @NotNull
    private final ArrayList<Actor> unitActionOverlays;
    @NotNull
    private final HashMap<MapUnit, ArrayList<Tile>> unitMovementPaths;
    @NotNull
    private final HashMap<MapUnit, List<Tile>> unitConnectRoadPaths;
    private TileGroupMap<WorldTileGroup> tileGroupMap;
    public TileSetStrings currentTileSetStrings;
    @Nullable
    private Action blinkAction;

    public WorldMapHolder(@NotNull WorldScreen worldScreen, @NotNull TileMap tileMap) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        Intrinsics.checkNotNullParameter(tileMap, "tileMap");
        super(20.0f, 20.0f, 0.0f, 0.0f, 12, null);
        this.worldScreen = worldScreen;
        this.tileMap = tileMap;
        this.tileGroups = new HashMap();
        this.unitActionOverlays = new ArrayList();
        this.unitMovementPaths = new HashMap();
        this.unitConnectRoadPaths = new HashMap();
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            this.setFlingTime(0.0f);
        }
        this.setContinuousScrollingX(this.tileMap.getMapParameters().getWorldWrap());
        this.setupZoomPanListeners();
    }

    @NotNull
    public final WorldScreen getWorldScreen$core() {
        return this.worldScreen;
    }

    @NotNull
    public final TileMap getTileMap$core() {
        return this.tileMap;
    }

    @Nullable
    public final Tile getSelectedTile$core() {
        return this.selectedTile;
    }

    public final void setSelectedTile$core(@Nullable Tile tile) {
        this.selectedTile = tile;
    }

    @NotNull
    public final HashMap<Tile, WorldTileGroup> getTileGroups() {
        return this.tileGroups;
    }

    @NotNull
    public final ArrayList<Actor> getUnitActionOverlays$core() {
        return this.unitActionOverlays;
    }

    @NotNull
    public final HashMap<MapUnit, ArrayList<Tile>> getUnitMovementPaths$core() {
        return this.unitMovementPaths;
    }

    @NotNull
    public final HashMap<MapUnit, List<Tile>> getUnitConnectRoadPaths$core() {
        return this.unitConnectRoadPaths;
    }

    @NotNull
    public final TileSetStrings getCurrentTileSetStrings() {
        TileSetStrings tileSetStrings = this.currentTileSetStrings;
        if (tileSetStrings != null) {
            return tileSetStrings;
        }
        Intrinsics.throwUninitializedPropertyAccessException("currentTileSetStrings");
        return null;
    }

    public final void setCurrentTileSetStrings(@NotNull TileSetStrings tileSetStrings) {
        Intrinsics.checkNotNullParameter(tileSetStrings, "<set-?>");
        this.currentTileSetStrings = tileSetStrings;
    }

    private final void setupZoomPanListeners() {
        this.setOnPanStartListener(() -> WorldMapHolder.setupZoomPanListeners$lambda$0(this));
        this.setOnPanStopListener(() -> WorldMapHolder.setupZoomPanListeners$lambda$1(this));
        this.setOnZoomStartListener(() -> WorldMapHolder.setupZoomPanListeners$lambda$2(this));
        this.setOnZoomStopListener(() -> WorldMapHolder.setupZoomPanListeners$lambda$3(this));
    }

    /*
     * WARNING - void declaration
     */
    public final void addTiles$core() {
        void $this$mapTo$iv$iv;
        TileSetStrings tileSetStrings = new TileSetStrings(this.worldScreen.getGameInfo().getRuleset(), this.worldScreen.getGame().getSettings());
        this.setCurrentTileSetStrings(tileSetStrings);
        Iterable $this$map$iv = this.tileMap.getValues();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Tile tile = (Tile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new WorldTileGroup((Tile)it, tileSetStrings));
        }
        List tileGroupsNew = (List)destination$iv$iv;
        this.tileGroupMap = new TileGroupMap(this, tileGroupsNew, this.getContinuousScrollingX(), null, 8, null);
        for (WorldTileGroup tileGroup : tileGroupsNew) {
            ((Map)this.tileGroups).put(tileGroup.getTile(), tileGroup);
            ActivationExtensionsKt.onClick(tileGroup.getLayerCityButton(), UncivSound.Companion.getSilent(), () -> WorldMapHolder.addTiles$lambda$1(this, tileGroup));
            ActivationExtensionsKt.onClick(tileGroup, () -> WorldMapHolder.addTiles$lambda$2(this, tileGroup));
            ActivationExtensionsKt.onActivation$default(tileGroup, Gdx.app.getType() == Application.ApplicationType.Android ? ActivationTypes.Longpress : ActivationTypes.RightClick, null, true, () -> WorldMapHolder.addTiles$lambda$3(this, tileGroup), 2, null);
        }
        TileGroupMap<WorldTileGroup> tileGroupMap = this.tileGroupMap;
        if (tileGroupMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap = null;
        }
        this.setActor(tileGroupMap);
        this.setSize(this.worldScreen.getStage().getWidth(), this.worldScreen.getStage().getHeight());
        this.layout();
    }

    public final void onTileClicked(@NotNull Tile tile) {
        boolean movingSpyOnMap;
        Intrinsics.checkNotNullParameter(tile, "tile");
        if (!this.worldScreen.getViewingCiv().hasExplored(tile)) {
            boolean bl;
            block30: {
                Sequence<Tile> $this$all$iv = tile.getNeighbors();
                boolean $i$f$all = false;
                Iterator<Tile> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Tile element$iv;
                    Tile it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.worldScreen.getViewingCiv().hasExplored(it)) continue;
                    bl = false;
                    break block30;
                }
                bl = true;
            }
            if (bl) {
                return;
            }
        }
        this.removeUnitActionOverlay();
        this.selectedTile = tile;
        this.unitMovementPaths.clear();
        this.unitConnectRoadPaths.clear();
        UnitTable unitTable = this.worldScreen.getBottomUnitTable$core();
        List<MapUnit> previousSelectedUnits = CollectionsKt.toList((Iterable)unitTable.getSelectedUnits());
        City previousSelectedCity = unitTable.getSelectedCity();
        boolean previousSelectedUnitIsSwapping = unitTable.getSelectedUnitIsSwapping();
        boolean previousSelectedUnitIsConnectingRoad = unitTable.getSelectedUnitIsConnectingRoad();
        boolean bl = movingSpyOnMap = unitTable.getSelectedSpy() != null;
        if (!movingSpyOnMap) {
            UnitTable.tileSelected$default(unitTable, tile, null, 2, null);
        }
        MapUnit newSelectedUnit = unitTable.getSelectedUnit();
        if (previousSelectedCity != null && !Intrinsics.areEqual(tile, previousSelectedCity.getCenterTile()) && !movingSpyOnMap) {
            WorldTileGroup worldTileGroup = this.tileGroups.get(previousSelectedCity.getCenterTile());
            Intrinsics.checkNotNull(worldTileGroup);
            worldTileGroup.getLayerCityButton().moveUp();
        }
        if (!((Collection)previousSelectedUnits).isEmpty()) {
            boolean canPerformActionsOnTile;
            boolean existsUnitNotPreparingAirSweep;
            boolean isPlayerTurn;
            boolean isTileDifferent;
            block33: {
                boolean bl3;
                block32: {
                    boolean bl4;
                    boolean bl5;
                    block31: {
                        Iterable $this$any$iv = previousSelectedUnits;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl5 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                MapUnit it = (MapUnit)element$iv;
                                boolean bl6 = false;
                                if (!(!Intrinsics.areEqual(it.getTile(), tile))) continue;
                                bl5 = true;
                                break block31;
                            }
                            bl5 = false;
                        }
                    }
                    isTileDifferent = bl5;
                    isPlayerTurn = this.worldScreen.isPlayersTurn();
                    Iterable $this$any$iv = previousSelectedUnits;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MapUnit it = (MapUnit)element$iv;
                            boolean bl7 = false;
                            if (!(!it.isPreparingAirSweep())) continue;
                            bl4 = true;
                            break block32;
                        }
                        bl4 = existsUnitNotPreparingAirSweep = false;
                    }
                }
                if (previousSelectedUnitIsSwapping) {
                    bl3 = ((MapUnit)CollectionsKt.first(previousSelectedUnits)).getMovement().canUnitSwapTo(tile);
                } else if (previousSelectedUnitIsConnectingRoad) {
                    bl3 = true;
                } else {
                    Iterable $this$any$iv = previousSelectedUnits;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            MapUnit it = (MapUnit)element$iv;
                            boolean bl8 = false;
                            if (!(UnitMovement.canMoveTo$default(it.getMovement(), tile, false, false, false, 14, null) || it.getMovement().isUnknownTileWeShouldAssumeToBePassable(tile) && !it.getBaseUnit().getMovesLikeAirUnits())) continue;
                            bl3 = true;
                            break block33;
                        }
                        bl3 = canPerformActionsOnTile = false;
                    }
                }
            }
            if (isTileDifferent && isPlayerTurn && canPerformActionsOnTile && existsUnitNotPreparingAirSweep) {
                if (previousSelectedUnitIsSwapping) {
                    this.addTileOverlaysWithUnitSwapping((MapUnit)CollectionsKt.first(previousSelectedUnits), tile);
                } else if (previousSelectedUnitIsConnectingRoad) {
                    this.addTileOverlaysWithUnitRoadConnecting((MapUnit)CollectionsKt.first(previousSelectedUnits), tile);
                } else {
                    this.addTileOverlaysWithUnitMovement(previousSelectedUnits, tile);
                }
            }
        } else if (movingSpyOnMap) {
            Spy spy = unitTable.getSelectedSpy();
            Intrinsics.checkNotNull(spy);
            this.addMovingSpyOverlay(spy, tile);
        } else {
            WorldMapHolder.addTileOverlays$default(this, tile, null, 2, null);
        }
        if (newSelectedUnit == null || newSelectedUnit.isCivilian()) {
            Tile tile2 = this.selectedTile;
            Intrinsics.checkNotNull(tile2);
            Sequence<MapUnit> unitsInTile = tile2.getUnits();
            if (previousSelectedCity != null && previousSelectedCity.canBombard()) {
                Tile tile3 = this.selectedTile;
                Intrinsics.checkNotNull(tile3);
                if (SequencesKt.contains(tile3.getTilesInDistance(2), previousSelectedCity.getCenterTile()) && SequencesKt.any(unitsInTile) && SequencesKt.first(unitsInTile).getCiv().isAtWarWith(this.worldScreen.getViewingCiv())) {
                    unitTable.citySelected(previousSelectedCity);
                }
            }
        }
        this.worldScreen.setShouldUpdate(true);
    }

    /*
     * WARNING - void declaration
     */
    private final void onTileRightClicked(MapUnit unit, Tile tile) {
        if (Intrinsics.areEqual(unit.getCurrentTile().getPosition(), tile.getPosition())) {
            return;
        }
        this.removeUnitActionOverlay();
        this.selectedTile = tile;
        this.unitMovementPaths.clear();
        this.unitConnectRoadPaths.clear();
        if (!this.worldScreen.getCanChangeState()) {
            return;
        }
        boolean localShouldUpdate = this.worldScreen.getShouldUpdate();
        this.worldScreen.setShouldUpdate(false);
        if (this.worldScreen.getBottomUnitTable$core().getSelectedUnitIsSwapping()) {
            if (unit.getMovement().canUnitSwapTo(tile)) {
                this.swapMoveUnitToTargetTile$core(unit, tile);
                localShouldUpdate = true;
            }
        } else {
            Object v0;
            block12: {
                void $this$firstOrNull$iv;
                Iterable iterable = TargetHelper.getAttackableEnemies$default(TargetHelper.INSTANCE, unit, UnitMovement.getDistanceToTiles$default(unit.getMovement(), false, null, null, false, 15, null), null, false, 12, null);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    AttackableTile it = (AttackableTile)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual(it.getTileToAttack(), tile)) continue;
                    v0 = element$iv;
                    break block12;
                }
                v0 = null;
            }
            AttackableTile attackableTile = v0;
            if (unit.canAttack() && attackableTile != null) {
                MapUnitCombatant attacker = new MapUnitCombatant(unit);
                if (!Battle.movePreparingAttack$default(Battle.INSTANCE, attacker, attackableTile, false, 4, null)) {
                    return;
                }
                if (!SoundPlayer.INSTANCE.play(new UncivSound(attacker.getName()))) {
                    SoundPlayer.INSTANCE.play(attacker.getAttackSound());
                }
                Battle.DamageDealt damageDealt = Battle.INSTANCE.attackOrNuke(attacker, attackableTile);
                int damageToDefender = damageDealt.component1();
                int damageToAttacker = damageDealt.component2();
                if (attackableTile.getCombatant() != null) {
                    BattleTableHelpers.INSTANCE.battleAnimationDeferred(this.worldScreen, attacker, damageToAttacker, attackableTile.getCombatant(), damageToDefender);
                }
                localShouldUpdate = true;
            } else if (unit.getMovement().canReach(tile)) {
                this.moveUnitToTargetTile$core(CollectionsKt.listOf(unit), tile);
                localShouldUpdate = true;
            }
        }
        this.worldScreen.setShouldUpdate(localShouldUpdate);
    }

    private final void markUnitMoveTutorialComplete(MapUnit unit) {
        String key = unit.getBaseUnit().getMovesLikeAirUnits() ? "Move an air unit" : "Move unit";
        UncivGame.Companion.getCurrent().getSettings().addCompletedTutorialTask(key);
    }

    public final void moveUnitToTargetTile$core(@NotNull List<MapUnit> selectedUnits, @NotNull Tile targetTile) {
        Intrinsics.checkNotNullParameter(selectedUnits, "selectedUnits");
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        MapUnit selectedUnit = CollectionsKt.first(selectedUnits);
        this.markUnitMoveTutorialComplete(selectedUnit);
        Concurrency.run$default(Concurrency.INSTANCE, "TileToMoveTo", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedUnit, targetTile, this, selectedUnits, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MapUnit $selectedUnit;
            final /* synthetic */ Tile $targetTile;
            final /* synthetic */ WorldMapHolder this$0;
            final /* synthetic */ List<MapUnit> $selectedUnits;
            {
                this.$selectedUnit = $selectedUnit;
                this.$targetTile = $targetTile;
                this.this$0 = $receiver;
                this.$selectedUnits = $selectedUnits;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        Tile tileToMoveTo = null;
                        Ref.ObjectRef<List<Tile>> pathToTile = new Ref.ObjectRef<List<Tile>>();
                        try {
                            tileToMoveTo = this.$selectedUnit.getMovement().getTileToMoveToThisTurn(this.$targetTile);
                            if (!this.$selectedUnit.getType().isAirUnit() && !this.$selectedUnit.isPreparingParadrop()) {
                                pathToTile.element = UnitMovement.getDistanceToTiles$default(this.$selectedUnit.getMovement(), false, null, null, false, 15, null).getPathToTile(tileToMoveTo);
                            }
                        }
                        catch (Exception ex) {
                            if (!(ex instanceof UnitMovement.UnreachableDestinationException)) {
                                Log.INSTANCE.error("Exception in getTileToMoveToThisTurn", ex);
                            }
                            return Unit.INSTANCE;
                        }
                        UndoHandler.Companion.recordUndoCheckpoint(this.this$0.getWorldScreen$core());
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$selectedUnit, tileToMoveTo, this.this$0, this.$targetTile, pathToTile, this.$selectedUnits, null){
                            int label;
                            final /* synthetic */ MapUnit $selectedUnit;
                            final /* synthetic */ Tile $tileToMoveTo;
                            final /* synthetic */ WorldMapHolder this$0;
                            final /* synthetic */ Tile $targetTile;
                            final /* synthetic */ Ref.ObjectRef<List<Tile>> $pathToTile;
                            final /* synthetic */ List<MapUnit> $selectedUnits;
                            {
                                this.$selectedUnit = $selectedUnit;
                                this.$tileToMoveTo = $tileToMoveTo;
                                this.this$0 = $receiver;
                                this.$targetTile = $targetTile;
                                this.$pathToTile = $pathToTile;
                                this.$selectedUnits = $selectedUnits;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure($result);
                                        try {
                                            Tile previousTile = this.$selectedUnit.getCurrentTile();
                                            UnitMovement.moveToTile$default(this.$selectedUnit.getMovement(), this.$tileToMoveTo, false, 2, null);
                                            if (Intrinsics.areEqual(previousTile, this.$selectedUnit.getCurrentTile())) {
                                                this.this$0.removeUnitActionOverlay();
                                                return Unit.INSTANCE;
                                            }
                                            if (this.$selectedUnit.isExploring() || this.$selectedUnit.isMoving()) {
                                                this.$selectedUnit.setAction(null);
                                            }
                                            SoundPlayer.INSTANCE.play(UncivSound.Companion.getWhoosh());
                                            if (!Intrinsics.areEqual(this.$selectedUnit.getCurrentTile(), this.$targetTile)) {
                                                this.$selectedUnit.setAction("moveTo " + this.$targetTile.getPosition().getX() + ',' + this.$targetTile.getPosition().getY());
                                            }
                                            if (this.$selectedUnit.hasMovement()) {
                                                UnitTable.selectUnit$default(this.this$0.getWorldScreen$core().getBottomUnitTable$core(), this.$selectedUnit, false, 2, null);
                                            }
                                            this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                            if (this.$pathToTile.element != null) {
                                                WorldMapHolder.access$animateMovement(this.this$0, previousTile, this.$selectedUnit, this.$tileToMoveTo, (List)this.$pathToTile.element);
                                                if (this.$selectedUnit.isEscorting()) {
                                                    MapUnit mapUnit = this.$selectedUnit.getOtherEscortUnit();
                                                    Intrinsics.checkNotNull(mapUnit);
                                                    WorldMapHolder.access$animateMovement(this.this$0, previousTile, mapUnit, this.$tileToMoveTo, (List)this.$pathToTile.element);
                                                }
                                            }
                                            if (this.$selectedUnits.size() > 1) {
                                                this.this$0.moveUnitToTargetTile$core(this.$selectedUnits.subList(1, this.$selectedUnits.size()), this.$targetTile);
                                            } else {
                                                this.this$0.removeUnitActionOverlay();
                                            }
                                            if (UncivGame.Companion.getCurrent().getSettings().getAutoUnitCycle() && !this.$selectedUnit.hasMovement()) {
                                                WorldScreen.switchToNextUnit$default(this.this$0.getWorldScreen$core(), false, 1, null);
                                            }
                                        }
                                        catch (Exception ex) {
                                            Log.INSTANCE.error("Exception in moveUnitToTargetTile", ex);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void animateMovement(Tile previousTile, MapUnit selectedUnit, Tile targetTile, List<Tile> pathToTile) {
        void $this$toTypedArray$iv;
        Collection<MoveToAction> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        Group group;
        WorldTileGroup worldTileGroup = this.tileGroups.get(previousTile);
        Intrinsics.checkNotNull(worldTileGroup);
        WorldTileGroup tileGroup = worldTileGroup;
        Group $this$animateMovement_u24lambda_u240 = group = new Group();
        boolean bl = false;
        $this$animateMovement_u24lambda_u240.setPosition(tileGroup.getX(), tileGroup.getY());
        Group unitSpriteAndIcon = group;
        UnitSpriteSlot unitSpriteSlot = tileGroup.getLayerUnitArt().getSpriteSlot(selectedUnit);
        if (unitSpriteSlot == null) {
            return;
        }
        UnitSpriteSlot unitSpriteSlot2 = unitSpriteSlot;
        SnapshotArray<Actor> snapshotArray = unitSpriteSlot2.getSpriteGroup().getChildren();
        Intrinsics.checkNotNullExpressionValue(snapshotArray, "getChildren(...)");
        for (Actor spriteImage : CollectionsKt.toList((Iterable)snapshotArray)) {
            unitSpriteAndIcon.addActor(spriteImage);
        }
        tileGroup.getParent().addActor(unitSpriteAndIcon);
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add(Actions.run(() -> WorldMapHolder.animateMovement$lambda$1(this, targetTile, selectedUnit)));
        Iterable spriteImage = pathToTile;
        Object object = spreadBuilder;
        Group group2 = unitSpriteAndIcon;
        boolean $i$f$map = false;
        void var11_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tile;
            Tile tile2 = (Tile)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            WorldTileGroup worldTileGroup2 = this.tileGroups.get(tile);
            Intrinsics.checkNotNull(worldTileGroup2);
            float f = worldTileGroup2.getX();
            WorldTileGroup worldTileGroup3 = this.tileGroups.get(tile);
            Intrinsics.checkNotNull(worldTileGroup3);
            collection.add(Actions.moveTo(f, worldTileGroup3.getY(), 0.5f / (float)pathToTile.size()));
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        ((SpreadBuilder)object).addSpread(thisCollection$iv.toArray(new MoveToAction[0]));
        spreadBuilder.add(Actions.run(() -> WorldMapHolder.animateMovement$lambda$3(this, targetTile, selectedUnit)));
        spreadBuilder.add(Actions.removeActor());
        group2.addAction(Actions.sequence((Action[])spreadBuilder.toArray(new Action[spreadBuilder.size()])));
    }

    public final void swapMoveUnitToTargetTile$core(@NotNull MapUnit selectedUnit, @NotNull Tile targetTile) {
        Intrinsics.checkNotNullParameter(selectedUnit, "selectedUnit");
        Intrinsics.checkNotNullParameter(targetTile, "targetTile");
        this.markUnitMoveTutorialComplete(selectedUnit);
        selectedUnit.getMovement().swapMoveToTile(targetTile, true);
        if (selectedUnit.isExploring() || selectedUnit.isMoving()) {
            selectedUnit.setAction(null);
        }
        SoundPlayer.INSTANCE.play(UncivSound.Companion.getSwap());
        if (selectedUnit.hasMovement()) {
            UnitTable.selectUnit$default(this.worldScreen.getBottomUnitTable$core(), selectedUnit, false, 2, null);
        }
        this.worldScreen.setShouldUpdate(true);
        this.removeUnitActionOverlay();
    }

    private final void addTileOverlaysWithUnitMovement(List<MapUnit> selectedUnits, Tile tile) {
        Concurrency.run$default(Concurrency.INSTANCE, "TurnsToGetThere", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(selectedUnits, tile, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ List<MapUnit> $selectedUnits;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.$selectedUnits = $selectedUnits;
                this.$tile = $tile;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$run;
                        ResultKt.throwOnFailure($result);
                        HashMap<MapUnit, Integer> unitToTurnsToTile = new HashMap<MapUnit, Integer>();
                        for (MapUnit unit : this.$selectedUnits) {
                            int n;
                            ArrayList<E> shortestPath = new ArrayList<E>();
                            if (unit.getBaseUnit().getMovesLikeAirUnits()) {
                                n = unit.getMovement().canReach(this.$tile) ? 1 : 0;
                            } else if (unit.isPreparingParadrop()) {
                                n = unit.getMovement().canReach(this.$tile) ? 1 : 0;
                            } else {
                                shortestPath.addAll(UnitMovement.getShortestPath$default(unit.getMovement(), this.$tile, false, 2, null));
                                n = shortestPath.size();
                            }
                            int turnsToGetThere = n;
                            ((Map)this.this$0.getUnitMovementPaths$core()).put(unit, shortestPath);
                            ((Map)unitToTurnsToTile).put(unit, Boxing.boxInt(turnsToGetThere));
                        }
                        ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(unitToTurnsToTile, this.this$0, this.$tile, null){
                            int label;
                            final /* synthetic */ HashMap<MapUnit, Integer> $unitToTurnsToTile;
                            final /* synthetic */ WorldMapHolder this$0;
                            final /* synthetic */ Tile $tile;
                            {
                                this.$unitToTurnsToTile = $unitToTurnsToTile;
                                this.this$0 = $receiver;
                                this.$tile = $tile;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$filterTo$iv$iv;
                                        ResultKt.throwOnFailure($result);
                                        Map $this$filter$iv = this.$unitToTurnsToTile;
                                        boolean $i$f$filter = false;
                                        Map map2 = $this$filter$iv;
                                        Map destination$iv$iv = new LinkedHashMap<K, V>();
                                        boolean $i$f$filterTo = false;
                                        Iterator<Map.Entry<K, V>> iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
                                        while (iterator2.hasNext()) {
                                            Map.Entry<K, V> element$iv$iv;
                                            Map.Entry<K, V> it = element$iv$iv = iterator2.next();
                                            boolean bl = false;
                                            if (!(((Number)it.getValue()).intValue() != 0)) continue;
                                            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                                        }
                                        Map map3 = destination$iv$iv;
                                        HashMap<MapUnit, Integer> unitsWhoCanMoveThere = new HashMap<MapUnit, Integer>(map3);
                                        if (unitsWhoCanMoveThere.isEmpty()) {
                                            WorldMapHolder.addTileOverlays$default(this.this$0, this.$tile, null, 2, null);
                                            this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                            return Unit.INSTANCE;
                                        }
                                        Collection<V> collection = unitsWhoCanMoveThere.values();
                                        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
                                        T t = CollectionsKt.maxOrNull((Iterable)collection);
                                        Intrinsics.checkNotNull(t);
                                        int turnsToGetThere = ((Number)t).intValue();
                                        if (UncivGame.Companion.getCurrent().getSettings().getSingleTapMove() && turnsToGetThere == 1) {
                                            Set<K> set = unitsWhoCanMoveThere.keySet();
                                            Intrinsics.checkNotNullExpressionValue(set, "<get-keys>(...)");
                                            MapUnit selectedUnit = (MapUnit)CollectionsKt.first((Iterable)set);
                                            for (MapUnit unit : unitsWhoCanMoveThere.keySet()) {
                                                unit.getMovement().headTowards(this.$tile);
                                            }
                                            UnitTable.selectUnit$default(this.this$0.getWorldScreen$core().getBottomUnitTable$core(), selectedUnit, false, 2, null);
                                        } else {
                                            MoveHereOverlayButtonData moveHereButtonDto = new MoveHereOverlayButtonData(unitsWhoCanMoveThere, this.$tile);
                                            WorldMapHolder.access$addTileOverlays(this.this$0, this.$tile, moveHereButtonDto);
                                        }
                                        this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }, 1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final void addTileOverlaysWithUnitSwapping(MapUnit selectedUnit, Tile tile) {
        if (!selectedUnit.getMovement().canUnitSwapTo(tile)) {
            WorldMapHolder.addTileOverlays$default(this, tile, null, 2, null);
            this.worldScreen.setShouldUpdate(true);
            return;
        }
        if (UncivGame.Companion.getCurrent().getSettings().getSingleTapMove()) {
            this.swapMoveUnitToTargetTile$core(selectedUnit, tile);
        } else {
            SwapWithOverlayButtonData swapWithButtonDto = new SwapWithOverlayButtonData(selectedUnit, tile);
            this.addTileOverlays(tile, swapWithButtonDto);
        }
        this.worldScreen.setShouldUpdate(true);
    }

    private final void addTileOverlaysWithUnitRoadConnecting(MapUnit selectedUnit, Tile tile) {
        Concurrency.run$default(Concurrency.INSTANCE, "ConnectRoad", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(tile, selectedUnit, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Tile $tile;
            final /* synthetic */ MapUnit $selectedUnit;
            final /* synthetic */ WorldMapHolder this$0;
            {
                this.$tile = $tile;
                this.$selectedUnit = $selectedUnit;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        boolean validTile;
                        ResultKt.throwOnFailure($result);
                        boolean bl = validTile = this.$tile.isLand() && !this.$tile.isImpassible() && this.$selectedUnit.getCiv().hasExplored(this.$tile);
                        if (validTile) {
                            void $this$run;
                            List<Tile> roadPath = UncivGame.Companion.getCurrent().getSettings().getUseAStarPathfinding() ? this.$selectedUnit.getMovement().getRoadPath(this.$selectedUnit.getTile()) : MapPathing.INSTANCE.getRoadPath(this.$selectedUnit.getCiv(), this.$selectedUnit.getTile(), this.$tile);
                            ConcurrencyKt.launchOnGLThread$default((CoroutineScope)$this$run, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(roadPath, this.this$0, this.$tile, this.$selectedUnit, null){
                                int label;
                                final /* synthetic */ List<Tile> $roadPath;
                                final /* synthetic */ WorldMapHolder this$0;
                                final /* synthetic */ Tile $tile;
                                final /* synthetic */ MapUnit $selectedUnit;
                                {
                                    this.$roadPath = $roadPath;
                                    this.this$0 = $receiver;
                                    this.$tile = $tile;
                                    this.$selectedUnit = $selectedUnit;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure($result);
                                            if (this.$roadPath == null) {
                                                WorldMapHolder.addTileOverlays$default(this.this$0, this.$tile, null, 2, null);
                                                this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                                return Unit.INSTANCE;
                                            }
                                            ((Map)this.this$0.getUnitConnectRoadPaths$core()).put(this.$selectedUnit, this.$roadPath);
                                            ConnectRoadOverlayButtonData connectRoadButtonDto = new ConnectRoadOverlayButtonData(this.$selectedUnit, this.$tile);
                                            WorldMapHolder.access$addTileOverlays(this.this$0, this.$tile, connectRoadButtonDto);
                                            this.this$0.getWorldScreen$core().setShouldUpdate(true);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 1, null);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)((Object)function2);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    private final void addMovingSpyOverlay(Spy spy, Tile tile) {
        if (!tile.isCityCenter()) ** GOTO lbl-1000
        v0 = tile.getCity();
        Intrinsics.checkNotNull(v0);
        if (spy.canMoveTo(v0)) {
            v1 = tile.getCity();
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        city = v1;
        this.addTileOverlays(tile, new MoveSpyOverlayButtonData(spy, city));
        this.worldScreen.setShouldUpdate(true);
    }

    private final void addTileOverlays(Tile tile, OverlayButtonData buttonDto) {
        Table table2;
        Table $this$addTileOverlays_u24lambda_u240 = table2 = new Table();
        boolean bl = false;
        $this$addTileOverlays_u24lambda_u240.defaults().pad(10.0f);
        Table table3 = table2;
        if (buttonDto != null && this.worldScreen.getCanChangeState()) {
            table3.add(buttonDto.createButton(this));
        }
        ArrayList unitList = new ArrayList();
        if (tile.isCityCenter() && (Intrinsics.areEqual(tile.getOwner(), this.worldScreen.getViewingCiv()) || this.worldScreen.getViewingCiv().isSpectator())) {
            Collection collection = unitList;
            City city = tile.getCity();
            Intrinsics.checkNotNull(city);
            CollectionsKt.addAll(collection, city.getCenterTile().getUnits());
        } else if (!((Collection)tile.getAirUnits()).isEmpty() && (Intrinsics.areEqual(((MapUnit)CollectionsKt.first((List)tile.getAirUnits())).getCiv(), this.worldScreen.getViewingCiv()) || this.worldScreen.getViewingCiv().isSpectator())) {
            CollectionsKt.addAll((Collection)unitList, tile.getUnits());
        }
        Iterator iterator2 = unitList.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Color color;
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            MapUnit unit = (MapUnit)e;
            IconCircleGroup unitIconGroup = Scene2dExtensionsKt.surroundWithCircle$default(new UnitIconGroup(unit, 48.0f), 68.0f, false, null, null, 12, null);
            Color color2 = color = Color.GRAY.cpy();
            Image image = unitIconGroup.getCircle();
            boolean bl2 = false;
            $this$addTileOverlays_u24lambda_u241.a = 0.5f;
            image.setColor(color);
            if (!unit.hasMovement()) {
                unitIconGroup.getColor().a = 0.66f;
            }
            ClickableCircle clickableCircle = new ClickableCircle(68.0f);
            clickableCircle.setTouchable(Touchable.enabled);
            ActivationExtensionsKt.onClick(clickableCircle, () -> WorldMapHolder.addTileOverlays$lambda$2(this, unit));
            unitIconGroup.addActor(clickableCircle);
            table3.add((Actor)unitIconGroup);
        }
        WorldTileGroup worldTileGroup = this.tileGroups.get(tile);
        Intrinsics.checkNotNull(worldTileGroup);
        this.addOverlayOnTileGroup(worldTileGroup, table3);
        if (UncivGame.Companion.getCurrent().getSettings().getUnitMovementButtonAnimation()) {
            table3.getColor().a = 0.0f;
            table3.addAction(Actions.moveBy(0.0f, 48.0f, 0.15f, Interpolation.smooth));
            table3.addAction(Actions.alpha(1.0f, 0.15f, Interpolation.smooth));
        } else {
            table3.moveBy(0.0f, 48.0f);
        }
    }

    static /* synthetic */ void addTileOverlays$default(WorldMapHolder worldMapHolder, Tile tile, OverlayButtonData overlayButtonData, int n, Object object) {
        if ((n & 2) != 0) {
            overlayButtonData = null;
        }
        worldMapHolder.addTileOverlays(tile, overlayButtonData);
    }

    public final void addOverlayOnTileGroup(@NotNull TileGroup group, @NotNull Actor actor) {
        Intrinsics.checkNotNullParameter(group, "group");
        Intrinsics.checkNotNullParameter(actor, "actor");
        Scene2dExtensionsKt.center(actor, group);
        actor.setX(actor.getX() + group.getX());
        actor.setY(actor.getY() + group.getY());
        group.getParent().addActor(actor);
        actor.toFront();
        actor.setY(actor.getY() + actor.getHeight());
        actor.setOrigin(4);
        this.unitActionOverlays.add(actor);
    }

    @Readonly
    public final boolean isMapRevealEnabled(@NotNull Civilization viewingCiv) {
        Intrinsics.checkNotNullParameter(viewingCiv, "viewingCiv");
        return !viewingCiv.getGameInfo().getGameParameters().isOnlineMultiplayer() && viewingCiv.isCurrentPlayer() && viewingCiv.isDefeated();
    }

    public final void resetArrows() {
        Iterator iterator2 = MapsKt.asSequence((Map)this.tileGroups).iterator();
        while (iterator2.hasNext()) {
            Map.Entry tile = iterator2.next();
            ((WorldTileGroup)tile.getValue()).getLayerMisc().resetArrows();
        }
    }

    public final void addArrow(@NotNull Tile fromTile, @NotNull Tile toTile, @NotNull MapArrowType arrowType) {
        block0: {
            Intrinsics.checkNotNullParameter(fromTile, "fromTile");
            Intrinsics.checkNotNullParameter(toTile, "toTile");
            Intrinsics.checkNotNullParameter(arrowType, "arrowType");
            Group group = this.tileGroups.get(fromTile);
            if (group == null || (group = ((TileGroup)group).getLayerMisc()) == null) break block0;
            ((TileLayerMisc)group).addArrow(toTile, arrowType);
        }
    }

    public final void updateMovementOverlay$core(@NotNull Sequence<MapUnit> pastVisibleUnits, @NotNull Sequence<MapUnit> targetVisibleUnits, @NotNull Sequence<Pair<HexCoord, HexCoord>> visibleAttacks) {
        MapUnit unit;
        Intrinsics.checkNotNullParameter(pastVisibleUnits, "pastVisibleUnits");
        Intrinsics.checkNotNullParameter(targetVisibleUnits, "targetVisibleUnits");
        Intrinsics.checkNotNullParameter(visibleAttacks, "visibleAttacks");
        MapUnit selectedUnit = this.worldScreen.getBottomUnitTable$core().getSelectedUnit();
        Iterator<Object> iterator2 = pastVisibleUnits.iterator();
        while (iterator2.hasNext()) {
            MapUnit.UnitMovementMemory previous;
            Iterator<MapUnit.UnitMovementMemory> stepIter;
            unit = iterator2.next();
            if (unit.getMovementMemories().isEmpty() || selectedUnit != null && !Intrinsics.areEqual(selectedUnit, unit)) continue;
            Intrinsics.checkNotNullExpressionValue(unit.getMovementMemories().iterator(), "iterator(...)");
            Intrinsics.checkNotNullExpressionValue(stepIter.next(), "next(...)");
            while (stepIter.hasNext()) {
                MapUnit.UnitMovementMemory next;
                Intrinsics.checkNotNullExpressionValue(stepIter.next(), "next(...)");
                this.addArrow(this.tileMap.get(previous.getPosition()), this.tileMap.get(next.getPosition()), next.getType());
                previous = next;
            }
            this.addArrow(this.tileMap.get(previous.getPosition()), unit.getTile(), unit.getMostRecentMoveType());
        }
        iterator2 = targetVisibleUnits.iterator();
        while (iterator2.hasNext()) {
            unit = iterator2.next();
            if (!unit.isMoving()) continue;
            Tile toTile = unit.getMovementDestination();
            this.addArrow(unit.getTile(), toTile, MiscArrowTypes.UnitMoving);
        }
        iterator2 = visibleAttacks.iterator();
        while (iterator2.hasNext()) {
            Pair pair = (Pair)iterator2.next();
            HexCoord from = (HexCoord)pair.component1();
            HexCoord to = (HexCoord)pair.component2();
            if (selectedUnit != null && !Intrinsics.areEqual(selectedUnit.getCurrentTile().getPosition(), from) && !Intrinsics.areEqual(selectedUnit.getCurrentTile().getPosition(), to)) continue;
            this.addArrow(this.tileMap.get(from), this.tileMap.get(to), MiscArrowTypes.UnitHasAttacked);
        }
    }

    @Nullable
    public final Action getBlinkAction() {
        return this.blinkAction;
    }

    public final void setBlinkAction(@Nullable Action action2) {
        this.blinkAction = action2;
    }

    public final boolean setCenterPosition(@NotNull HexCoord vector, boolean immediately, boolean selectUnit, @Nullable MapUnit forceSelectUnit) {
        Object v1;
        block4: {
            Intrinsics.checkNotNullParameter(vector, "vector");
            Collection<WorldTileGroup> collection = this.tileGroups.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                WorldTileGroup it = (WorldTileGroup)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getTile().getPosition(), vector)) continue;
                v1 = element$iv;
                break block4;
            }
            v1 = null;
        }
        WorldTileGroup worldTileGroup = v1;
        if (worldTileGroup == null) {
            return false;
        }
        WorldTileGroup tileGroup = worldTileGroup;
        this.selectedTile = tileGroup.getTile();
        if (selectUnit || forceSelectUnit != null) {
            UnitTable unitTable = this.worldScreen.getBottomUnitTable$core();
            Tile tile = this.selectedTile;
            Intrinsics.checkNotNull(tile);
            unitTable.tileSelected(tile, forceSelectUnit);
        }
        if (!this.scrollTo(tileGroup.getX() + tileGroup.getWidth() / (float)2, this.getMaxY() - (tileGroup.getY() + tileGroup.getWidth() / (float)2), immediately)) {
            return false;
        }
        this.removeAction(this.blinkAction);
        this.blinkAction = Actions.repeat(3, Actions.sequence((Action)Actions.run(() -> WorldMapHolder.setCenterPosition$lambda$1(tileGroup)), (Action)Actions.delay(0.3f), (Action)Actions.run(() -> WorldMapHolder.setCenterPosition$lambda$2(tileGroup)), (Action)Actions.delay(0.3f)));
        this.addAction(this.blinkAction);
        this.worldScreen.setShouldUpdate(true);
        return true;
    }

    public static /* synthetic */ boolean setCenterPosition$default(WorldMapHolder worldMapHolder, HexCoord hexCoord, boolean bl, boolean bl2, MapUnit mapUnit, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            mapUnit = null;
        }
        return worldMapHolder.setCenterPosition(hexCoord, bl, bl2, mapUnit);
    }

    @Override
    public void zoom(float zoomScale) {
        super.zoom(zoomScale);
        this.clampCityButtonSize();
    }

    private final void clampCityButtonSize() {
        block4: {
            float clampedCityButtonZoom;
            block3: {
                clampedCityButtonZoom = 1.0f / this.getScaleX();
                if (!(clampedCityButtonZoom >= 1.0f)) break block3;
                Iterator<WorldTileGroup> iterator2 = this.tileGroups.values().iterator();
                while (iterator2.hasNext()) {
                    WorldTileGroup tileGroup;
                    Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                    tileGroup.getLayerCityButton().setTransform(false);
                }
                break block4;
            }
            if (!(clampedCityButtonZoom >= this.getMinZoom())) break block4;
            Iterator<WorldTileGroup> iterator3 = this.tileGroups.values().iterator();
            while (iterator3.hasNext()) {
                WorldTileGroup tileGroup;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
                if (tileGroup.getLayerCityButton().hasChildren()) {
                    tileGroup.getLayerCityButton().setTransform(true);
                }
                tileGroup.getLayerCityButton().setScale(clampedCityButtonZoom);
            }
        }
    }

    public final void removeUnitActionOverlay() {
        Iterator<Actor> iterator2 = this.unitActionOverlays.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<Actor> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Actor overlay = iterator3.next();
            overlay.remove();
        }
        this.unitActionOverlays.clear();
    }

    @Override
    public void reloadMaxZoom() {
        boolean enableZoomLimit;
        float maxWorldZoomOut = UncivGame.Companion.getCurrent().getSettings().getMaxWorldZoomOut();
        int mapRadius = this.tileMap.getMapParameters().getMapSize().getRadius();
        boolean bl = enableZoomLimit = mapRadius < 21 && maxWorldZoomOut < 3.0f || mapRadius > 20 && maxWorldZoomOut < 4.0f;
        if (enableZoomLimit) {
            float pad = this.getContinuousScrollingX() ? this.getWidth() / (float)mapRadius * 0.7f : 0.0f;
            this.setMinZoom(Float.max((this.getWidth() + pad) * this.getScaleX() / this.getMaxX(), 1.0f / maxWorldZoomOut));
            this.setMaxZoom(Float.max(2.0f * this.getMinZoom(), maxWorldZoomOut));
        } else {
            super.reloadMaxZoom();
        }
    }

    @Override
    public float restrictX(float deltaX) {
        float result2 = this.getScrollX() - deltaX;
        if (this.worldScreen.getViewingCiv().isSpectator()) {
            return result2;
        }
        ExploredRegion exploredRegion = this.worldScreen.getViewingCiv().getExploredRegion();
        if (exploredRegion.shouldRecalculateCoords()) {
            exploredRegion.calculateStageCoords(this.getMaxX(), this.getMaxY());
        }
        if (!exploredRegion.shouldRestrictX()) {
            return result2;
        }
        float leftX = exploredRegion.getLeftX();
        float rightX = exploredRegion.getRightX();
        if (deltaX < 0.0f && this.getScrollX() <= rightX && result2 > rightX) {
            result2 = rightX;
        } else if (deltaX > 0.0f && this.getScrollX() >= leftX && result2 < leftX) {
            result2 = leftX;
        }
        return result2;
    }

    @Override
    public float restrictY(float deltaY) {
        float result2 = this.getScrollY() + deltaY;
        if (this.worldScreen.getViewingCiv().isSpectator()) {
            return result2;
        }
        ExploredRegion exploredRegion = this.worldScreen.getViewingCiv().getExploredRegion();
        if (exploredRegion.shouldRecalculateCoords()) {
            exploredRegion.calculateStageCoords(this.getMaxX(), this.getMaxY());
        }
        float topY = exploredRegion.getTopY();
        float bottomY = exploredRegion.getBottomY();
        if (result2 < topY) {
            result2 = topY;
        } else if (result2 > bottomY) {
            result2 = bottomY;
        }
        return result2;
    }

    @Override
    public void draw(@Nullable Batch batch, float parentAlpha) {
        super.draw(batch, parentAlpha);
    }

    @Override
    public void act(float delta) {
        super.act(delta);
    }

    @Override
    public void clear() {
        super.clear();
    }

    private static final void setupZoomPanListeners$setActHit(WorldMapHolder this$0) {
        boolean isEnabled = !this$0.isZooming() && !this$0.isPanning();
        Stage stage = this$0.getStage();
        Intrinsics.checkNotNull(stage, "null cannot be cast to non-null type com.unciv.ui.screens.basescreen.UncivStage");
        ((UncivStage)stage).setPerformPointerEnterExitEvents(isEnabled);
        TileGroupMap<WorldTileGroup> tileGroupMap = this$0.tileGroupMap;
        if (tileGroupMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap = null;
        }
        tileGroupMap.setShouldAct(isEnabled);
        TileGroupMap<WorldTileGroup> tileGroupMap2 = this$0.tileGroupMap;
        if (tileGroupMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("tileGroupMap");
            tileGroupMap2 = null;
        }
        tileGroupMap2.setShouldHit(isEnabled);
    }

    private static final Unit setupZoomPanListeners$lambda$0(WorldMapHolder this$0) {
        WorldMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit setupZoomPanListeners$lambda$1(WorldMapHolder this$0) {
        WorldMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit setupZoomPanListeners$lambda$2(WorldMapHolder this$0) {
        WorldMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit setupZoomPanListeners$lambda$3(WorldMapHolder this$0) {
        WorldMapHolder.setupZoomPanListeners$setActHit(this$0);
        return Unit.INSTANCE;
    }

    private static final Unit addTiles$lambda$1(WorldMapHolder this$0, WorldTileGroup $tileGroup) {
        this$0.onTileClicked($tileGroup.getTile());
        return Unit.INSTANCE;
    }

    private static final Unit addTiles$lambda$2(WorldMapHolder this$0, WorldTileGroup $tileGroup) {
        this$0.onTileClicked($tileGroup.getTile());
        return Unit.INSTANCE;
    }

    private static final Unit addTiles$lambda$3(WorldMapHolder this$0, WorldTileGroup $tileGroup) {
        if (!UncivGame.Companion.getCurrent().getSettings().getLongTapMove()) {
            return Unit.INSTANCE;
        }
        MapUnit mapUnit = this$0.worldScreen.getBottomUnitTable$core().getSelectedUnit();
        if (mapUnit == null) {
            return Unit.INSTANCE;
        }
        MapUnit unit = mapUnit;
        Concurrency.run$default(Concurrency.INSTANCE, "WorldScreenClick", null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, unit, $tileGroup, null){
            int label;
            final /* synthetic */ WorldMapHolder this$0;
            final /* synthetic */ MapUnit $unit;
            final /* synthetic */ WorldTileGroup $tileGroup;
            {
                this.this$0 = $receiver;
                this.$unit = $unit;
                this.$tileGroup = $tileGroup;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure($result);
                        WorldMapHolder.access$onTileRightClicked(this.this$0, this.$unit, this.$tileGroup.getTile());
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
        return Unit.INSTANCE;
    }

    private static final void animateMovement$lambda$1(WorldMapHolder this$0, Tile $targetTile, MapUnit $selectedUnit) {
        block0: {
            WorldTileGroup worldTileGroup = this$0.tileGroups.get($targetTile);
            Intrinsics.checkNotNull(worldTileGroup);
            UnitSpriteSlot targetTileSpriteSlot = worldTileGroup.getLayerUnitArt().getSpriteSlot($selectedUnit);
            Object object = targetTileSpriteSlot;
            if (object == null || (object = ((UnitSpriteSlot)object).getSpriteGroup()) == null) break block0;
            ((Actor)object).setVisible(false);
        }
    }

    private static final void animateMovement$lambda$3(WorldMapHolder this$0, Tile $targetTile, MapUnit $selectedUnit) {
        WorldTileGroup worldTileGroup = this$0.tileGroups.get($targetTile);
        Intrinsics.checkNotNull(worldTileGroup);
        UnitSpriteSlot targetTileSpriteSlot = worldTileGroup.getLayerUnitArt().getSpriteSlot($selectedUnit);
        Object object = targetTileSpriteSlot;
        if (object != null && (object = ((UnitSpriteSlot)object).getSpriteGroup()) != null) {
            ((Actor)object).setVisible(true);
        }
        this$0.worldScreen.setShouldUpdate(true);
    }

    private static final Unit addTileOverlays$lambda$2(WorldMapHolder this$0, MapUnit $unit) {
        UnitTable unitTable = this$0.worldScreen.getBottomUnitTable$core();
        Input input2 = Gdx.input;
        Intrinsics.checkNotNullExpressionValue(input2, "input");
        unitTable.selectUnit($unit, Scene2dExtensionsKt.isShiftKeyPressed(input2));
        this$0.worldScreen.setShouldUpdate(true);
        this$0.removeUnitActionOverlay();
        return Unit.INSTANCE;
    }

    private static final void setCenterPosition$lambda$1(WorldTileGroup $tileGroup) {
        $tileGroup.getLayerOverlay().hideHighlight();
    }

    private static final void setCenterPosition$lambda$2(WorldTileGroup $tileGroup) {
        TileLayerOverlay.showHighlight$default($tileGroup.getLayerOverlay(), null, 0.0f, 3, null);
    }

    public static final /* synthetic */ void access$animateMovement(WorldMapHolder $this, Tile previousTile, MapUnit selectedUnit, Tile targetTile, List pathToTile) {
        $this.animateMovement(previousTile, selectedUnit, targetTile, pathToTile);
    }

    public static final /* synthetic */ void access$addTileOverlays(WorldMapHolder $this, Tile tile, OverlayButtonData buttonDto) {
        $this.addTileOverlays(tile, buttonDto);
    }

    public static final /* synthetic */ void access$onTileRightClicked(WorldMapHolder $this, MapUnit unit, Tile tile) {
        $this.onTileRightClicked(unit, tile);
    }
}

