/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.LifecycleListener;
import com.unciv.ui.crashhandling.CrashHandlingExtensionsKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001b\u0010\r\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/unciv/utils/Dispatchers;", "", "<init>", "()V", "EXECUTORS", "", "Ljava/util/concurrent/ExecutorService;", "DAEMON", "Lkotlinx/coroutines/CoroutineDispatcher;", "getDAEMON", "()Lkotlinx/coroutines/CoroutineDispatcher;", "NON_DAEMON", "getNON_DAEMON", "GL", "getGL", "GL$delegate", "Lkotlin/Lazy;", "stopThreadPools", "", "isStopped", "", "createThreadpoolDispatcher", "Lcom/unciv/utils/Dispatchers$CrashHandlingDispatcher;", "threadPrefix", "", "isDaemon", "CrashHandlingDispatcher", "GLDispatcher", "core"})
final class Dispatchers {
    @NotNull
    private final List<ExecutorService> EXECUTORS = new ArrayList();
    @NotNull
    private final CoroutineDispatcher DAEMON = this.createThreadpoolDispatcher("threadpool-daemon-", true);
    @NotNull
    private final CoroutineDispatcher NON_DAEMON = this.createThreadpoolDispatcher("threadpool-nondaemon-", false);
    @NotNull
    private final Lazy GL$delegate = LazyKt.lazy(() -> Dispatchers.GL_delegate$lambda$0(this));

    @NotNull
    public final CoroutineDispatcher getDAEMON() {
        return this.DAEMON;
    }

    @NotNull
    public final CoroutineDispatcher getNON_DAEMON() {
        return this.NON_DAEMON;
    }

    @NotNull
    public final CoroutineDispatcher getGL() {
        Lazy lazy = this.GL$delegate;
        return (CoroutineDispatcher)lazy.getValue();
    }

    public final void stopThreadPools() {
        Iterator<ExecutorService> iterator2 = this.EXECUTORS.iterator();
        while (iterator2.hasNext()) {
            ExecutorService executor2 = iterator2.next();
            executor2.shutdown();
            iterator2.remove();
        }
    }

    @Readonly
    public final boolean isStopped() {
        return this.EXECUTORS.isEmpty();
    }

    private final CrashHandlingDispatcher createThreadpoolDispatcher(String threadPrefix, boolean isDaemon) {
        ExecutorService executor2 = Executors.newCachedThreadPool(new ThreadFactory(threadPrefix, isDaemon){
            private int n;
            final /* synthetic */ String $threadPrefix;
            final /* synthetic */ boolean $isDaemon;
            {
                this.$threadPrefix = $threadPrefix;
                this.$isDaemon = $isDaemon;
            }

            public final int getN() {
                return this.n;
            }

            public final void setN(int n) {
                this.n = n;
            }

            public Thread newThread(Runnable r) {
                Intrinsics.checkNotNullParameter(r, "r");
                int n = this.n;
                this.n = n + 1;
                Thread thread2 = new Thread(r, this.$threadPrefix + n);
                thread2.setDaemon(this.$isDaemon);
                return thread2;
            }
        });
        Intrinsics.checkNotNull(executor2);
        this.EXECUTORS.add(executor2);
        return new CrashHandlingDispatcher(ExecutorsKt.from(executor2));
    }

    private static final CrashHandlingDispatcher GL_delegate$lambda$0(Dispatchers this$0) {
        return new CrashHandlingDispatcher(new GLDispatcher(this$0.DAEMON));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u00060\nj\u0002`\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/unciv/utils/Dispatchers$CrashHandlingDispatcher;", "Lkotlinx/coroutines/CoroutineDispatcher;", "decoratedDispatcher", "<init>", "(Lkotlinx/coroutines/CoroutineDispatcher;)V", "dispatch", "", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "core"})
    private static final class CrashHandlingDispatcher
    extends CoroutineDispatcher {
        @NotNull
        private final CoroutineDispatcher decoratedDispatcher;

        public CrashHandlingDispatcher(@NotNull CoroutineDispatcher decoratedDispatcher) {
            Intrinsics.checkNotNullParameter(decoratedDispatcher, "decoratedDispatcher");
            this.decoratedDispatcher = decoratedDispatcher;
        }

        @Override
        public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(block, "block");
            this.decoratedDispatcher.dispatch(context, () -> CrashHandlingDispatcher.dispatch$lambda$0(CrashHandlingExtensionsKt.wrapCrashHandlingUnit(new Function0<Unit>((Object)block){

                public final void invoke() {
                    ((Runnable)this.receiver).run();
                }
            })));
        }

        private static final void dispatch$lambda$0(Function0 $tmp0) {
            $tmp0.invoke();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011H\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\b\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/unciv/utils/Dispatchers$GLDispatcher;", "Lkotlinx/coroutines/CoroutineDispatcher;", "Lcom/badlogic/gdx/LifecycleListener;", "fallbackDispatcher", "<init>", "(Lkotlinx/coroutines/CoroutineDispatcher;)V", "isDisposed", "", "()Z", "setDisposed", "(Z)V", "dispatch", "", "context", "Lkotlin/coroutines/CoroutineContext;", "block", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "dispose", "pause", "resume", "core"})
    private static final class GLDispatcher
    extends CoroutineDispatcher
    implements LifecycleListener {
        @NotNull
        private final CoroutineDispatcher fallbackDispatcher;
        private boolean isDisposed;

        public GLDispatcher(@NotNull CoroutineDispatcher fallbackDispatcher) {
            Intrinsics.checkNotNullParameter(fallbackDispatcher, "fallbackDispatcher");
            this.fallbackDispatcher = fallbackDispatcher;
            Gdx.app.addLifecycleListener(this);
        }

        public final boolean isDisposed() {
            return this.isDisposed;
        }

        public final void setDisposed(boolean bl) {
            this.isDisposed = bl;
        }

        @Override
        public void dispatch(@NotNull CoroutineContext context, @NotNull Runnable block) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(block, "block");
            if (this.isDisposed) {
                JobKt.cancel(context, new CancellationException("GDX GL thread is not handling runnables anymore"));
                this.fallbackDispatcher.dispatch(context, block);
                return;
            }
            Gdx.app.postRunnable(block);
        }

        @Override
        public void dispose() {
            this.isDisposed = true;
        }

        @Override
        public void pause() {
        }

        @Override
        public void resume() {
        }
    }
}

