/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.tiledmappacker;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.maps.tiled.AtlasTmjMapLoader;
import com.badlogic.gdx.maps.tiled.AtlasTmxMapLoader;
import com.badlogic.gdx.maps.tiled.BaseTiledMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.renderers.OrthogonalTiledMapRenderer;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import java.io.File;

public class TiledMapPackerTestRender
extends ApplicationAdapter {
    private final boolean DELETE_DELETEME_FOLDER_ON_EXIT = false;
    private static final String MAP_PATH = "data/maps/tiled-atlas-processed/deleteMe/";
    private final TestMapType TEST_MAP_TYPE = TestMapType.DEFAULT_TMX_MAP;
    private static final String PROJECT_FILE_PATH = "data/maps/tiled-atlas-processed/tiled-prop-test.tiled-project";
    private final boolean CENTER_CAM = true;
    private final float WORLD_WIDTH = 16.0f;
    private final float WORLD_HEIGHT = 8.0f;
    private final float PIXELS_PER_METER = 32.0f;
    private final float UNIT_SCALE = 0.03125f;
    private BaseTiledMapLoader.Parameters params;
    private AtlasTmxMapLoader atlasTmxMapLoader;
    private BaseTiledMapLoader.Parameters paramsTmj;
    private AtlasTmjMapLoader atlasTmjMapLoader;
    private TiledMap map;
    private Viewport viewport;
    private OrthogonalTiledMapRenderer mapRenderer;
    private OrthographicCamera cam;

    @Override
    public void create() {
        String mapLocation = "";
        switch (this.TEST_MAP_TYPE) {
            case DEFAULT_TMX_MAP: {
                this.atlasTmxMapLoader = new AtlasTmxMapLoader(new InternalFileHandleResolver());
                this.params = new BaseTiledMapLoader.Parameters();
                this.params.generateMipMaps = false;
                this.params.convertObjectToTileSpace = false;
                this.params.flipY = true;
                this.params.projectFilePath = "";
                mapLocation = "data/maps/tiled-atlas-processed/deleteMe/test.tmx";
                this.map = this.atlasTmxMapLoader.load(mapLocation, this.params);
                break;
            }
            case DEFAULT_TMJ_MAP: {
                this.atlasTmjMapLoader = new AtlasTmjMapLoader(new InternalFileHandleResolver());
                this.paramsTmj = new BaseTiledMapLoader.Parameters();
                this.paramsTmj.generateMipMaps = false;
                this.paramsTmj.convertObjectToTileSpace = false;
                this.paramsTmj.flipY = true;
                this.paramsTmj.projectFilePath = "";
                mapLocation = "data/maps/tiled-atlas-processed/deleteMe/test.tmj";
                this.map = this.atlasTmjMapLoader.load(mapLocation, this.paramsTmj);
                break;
            }
            case DEFAULT_TMX_IMGLAYER_MAP: {
                this.atlasTmxMapLoader = new AtlasTmxMapLoader(new InternalFileHandleResolver());
                this.params = new BaseTiledMapLoader.Parameters();
                this.params.generateMipMaps = false;
                this.params.convertObjectToTileSpace = false;
                this.params.flipY = true;
                this.params.projectFilePath = "";
                mapLocation = "data/maps/tiled-atlas-processed/deleteMe/test_w_imglayers.tmx";
                this.map = this.atlasTmxMapLoader.load(mapLocation, this.params);
                break;
            }
            case DEFAULT_TMX_IMGLAYERS_COLLECTION_TILESET: {
                this.atlasTmxMapLoader = new AtlasTmxMapLoader(new InternalFileHandleResolver());
                this.params = new BaseTiledMapLoader.Parameters();
                this.params.generateMipMaps = false;
                this.params.convertObjectToTileSpace = false;
                this.params.flipY = true;
                this.params.projectFilePath = "";
                mapLocation = "data/maps/tiled-atlas-processed/deleteMe/test_w_imglayers_coi.tmx";
                this.map = this.atlasTmxMapLoader.load(mapLocation, this.params);
                break;
            }
            case DEFAULT_TMJ_IMGLAYER_WITH_PROPS_MAP: {
                this.atlasTmjMapLoader = new AtlasTmjMapLoader(new InternalFileHandleResolver());
                this.paramsTmj = new BaseTiledMapLoader.Parameters();
                this.paramsTmj.generateMipMaps = false;
                this.paramsTmj.convertObjectToTileSpace = false;
                this.paramsTmj.flipY = true;
                this.paramsTmj.projectFilePath = PROJECT_FILE_PATH;
                mapLocation = "data/maps/tiled-atlas-processed/deleteMe/test_w_imglayer_props.tmj";
                this.map = this.atlasTmjMapLoader.load(mapLocation, this.paramsTmj);
            }
        }
        this.viewport = new FitViewport(16.0f, 8.0f);
        this.cam = (OrthographicCamera)this.viewport.getCamera();
        this.mapRenderer = new OrthogonalTiledMapRenderer(this.map, 0.03125f);
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.viewport.apply();
        this.mapRenderer.setView(this.cam);
        this.mapRenderer.render();
        if (Gdx.input.isKeyPressed(111)) {
            this.dispose();
            Gdx.app.exit();
        }
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height, true);
    }

    @Override
    public void dispose() {
        this.map.dispose();
    }

    public static void main(String[] args) throws Exception {
        File file = new File(MAP_PATH);
        if (!file.exists()) {
            System.out.println("Please run TiledMapPackerTest.");
            return;
        }
        new LwjglApplication((ApplicationListener)new TiledMapPackerTestRender(), "", 640, 480);
    }

    public static enum TestMapType {
        DEFAULT_TMX_MAP,
        DEFAULT_TMJ_MAP,
        DEFAULT_TMX_IMGLAYER_MAP,
        DEFAULT_TMJ_IMGLAYER_WITH_PROPS_MAP,
        DEFAULT_TMX_IMGLAYERS_COLLECTION_TILESET;

    }
}

