/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.logic.civilization;

import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;
import com.unciv.logic.IsPartOfGameInfoSerialization;
import com.unciv.logic.civilization.NotificationAction;
import com.unciv.logic.civilization.NotificationActionsDeserializer;
import com.unciv.logic.civilization.NotificationIcon;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.ui.screens.worldscreen.WorldScreen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Pure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002:\u00010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004B;\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\b\u0012\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u0003\u0010\u000eJ\u001e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&J\u0006\u0010'\u001a\u00020\u001dJ\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u0010,\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010/\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010-\u001a\u00020.H\u0002R\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R>\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0014j\b\u0012\u0004\u0012\u00020\u0006`\u00152\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0014j\b\u0012\u0004\u0012\u00020\u0006`\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R>\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0014j\b\u0012\u0004\u0012\u00020\u000b`\u00152\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\u0014j\b\u0012\u0004\u0012\u00020\u000b`\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/unciv/logic/civilization/Notification;", "Lcom/unciv/logic/IsPartOfGameInfoSerialization;", "Lcom/badlogic/gdx/utils/Json$Serializable;", "<init>", "()V", "text", "", "notificationIcons", "", "actions", "", "Lcom/unciv/logic/civilization/NotificationAction;", "category", "Lcom/unciv/logic/civilization/Notification$NotificationCategory;", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/Iterable;Lcom/unciv/logic/civilization/Notification$NotificationCategory;)V", "value", "getCategory", "()Lcom/unciv/logic/civilization/Notification$NotificationCategory;", "getText", "()Ljava/lang/String;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "icons", "getIcons", "()Ljava/util/ArrayList;", "getActions", "index", "", "addNotificationIconsTo", "", "table", "Lcom/badlogic/gdx/scenes/scene2d/ui/Table;", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "iconSize", "", "execute", "worldScreen", "Lcom/unciv/ui/screens/worldscreen/WorldScreen;", "resetExecuteRoundRobin", "write", "json", "Lcom/badlogic/gdx/utils/Json;", "writeActions", "read", "jsonData", "Lcom/badlogic/gdx/utils/JsonValue;", "readActions", "NotificationCategory", "core"})
public final class Notification
implements IsPartOfGameInfoSerialization,
Json.Serializable {
    @NotNull
    private NotificationCategory category;
    @NotNull
    private String text;
    @NotNull
    private ArrayList<String> icons;
    @NotNull
    private ArrayList<NotificationAction> actions;
    private transient int index;

    public Notification() {
        this.category = NotificationCategory.General;
        this.text = "";
        this.icons = new ArrayList();
        this.actions = new ArrayList();
    }

    @NotNull
    public final NotificationCategory getCategory() {
        return this.category;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final ArrayList<String> getIcons() {
        return this.icons;
    }

    @NotNull
    public final ArrayList<NotificationAction> getActions() {
        return this.actions;
    }

    public Notification(@NotNull String text2, @NotNull String[] notificationIcons, @Nullable Iterable<? extends NotificationAction> actions, @NotNull NotificationCategory category) {
        block0: {
            Intrinsics.checkNotNullParameter(text2, "text");
            Intrinsics.checkNotNullParameter(notificationIcons, "notificationIcons");
            Intrinsics.checkNotNullParameter((Object)category, "category");
            this();
            this.category = category;
            this.text = text2;
            ArraysKt.toCollection(notificationIcons, (Collection)this.icons);
            Iterable<? extends NotificationAction> iterable = actions;
            if (iterable == null) break block0;
            ArrayList cfr_ignored_0 = (ArrayList)CollectionsKt.toCollection(iterable, (Collection)this.actions);
        }
    }

    public /* synthetic */ Notification(String string, String[] stringArray, Iterable iterable, NotificationCategory notificationCategory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            notificationCategory = NotificationCategory.General;
        }
        this(string, stringArray, iterable, notificationCategory);
    }

    public final void addNotificationIconsTo(@NotNull Table table2, @NotNull Ruleset ruleset, float iconSize) {
        Intrinsics.checkNotNullParameter(table2, "table");
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        if (this.icons.isEmpty()) {
            return;
        }
        for (String icon : CollectionsKt.reversed((Iterable)this.icons)) {
            table2.add(NotificationIcon.INSTANCE.getImage(icon, ruleset, iconSize)).size(iconSize).padRight(5.0f);
        }
    }

    public final void execute(@NotNull WorldScreen worldScreen) {
        Intrinsics.checkNotNullParameter(worldScreen, "worldScreen");
        if (this.actions.isEmpty()) {
            return;
        }
        this.actions.get(this.index).execute(worldScreen);
        ++this.index;
        this.index %= this.actions.size();
    }

    public final void resetExecuteRoundRobin() {
        this.index = 0;
    }

    @Override
    public void write(@NotNull Json json) {
        Intrinsics.checkNotNullParameter(json, "json");
        if (this.category != NotificationCategory.General) {
            json.writeValue("category", (Object)this.category);
        }
        if (((CharSequence)this.text).length() > 0) {
            json.writeValue("text", this.text);
        }
        if (!((Collection)this.icons).isEmpty()) {
            json.writeValue("icons", this.icons, null, String.class);
        }
        this.writeActions(json);
    }

    private final void writeActions(Json json) {
        if (this.actions.isEmpty()) {
            return;
        }
        json.writeArrayStart("actions");
        Iterator<NotificationAction> iterator2 = this.actions.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator<NotificationAction> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            NotificationAction action2;
            Intrinsics.checkNotNullExpressionValue(iterator3.next(), "next(...)");
            json.writeObjectStart();
            json.writeObjectStart(action2.getClass().getSimpleName());
            json.writeFields(action2);
            json.writeObjectEnd();
            json.writeObjectEnd();
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(@NotNull Json json, @NotNull JsonValue jsonData) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(jsonData, "jsonData");
        json.readField(this, "category", jsonData);
        json.readField(this, "text", jsonData);
        this.readActions(json, jsonData);
        json.readField(this, "icons", jsonData);
    }

    private final void readActions(Json json, JsonValue jsonData) {
        if (!jsonData.hasChild("actions")) {
            return;
        }
        JsonValue entry = jsonData.get((String)"actions").child;
        while (entry != null) {
            this.actions.addAll((Collection<NotificationAction>)new NotificationActionsDeserializer().read(json, entry));
            entry = entry.next;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Lcom/unciv/logic/civilization/Notification$NotificationCategory;", "", "<init>", "(Ljava/lang/String;I)V", "General", "Trade", "Diplomacy", "Production", "Units", "War", "Religion", "Espionage", "Cities", "Companion", "core"})
    public static final class NotificationCategory
    extends Enum<NotificationCategory> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ NotificationCategory General;
        public static final /* enum */ NotificationCategory Trade;
        public static final /* enum */ NotificationCategory Diplomacy;
        public static final /* enum */ NotificationCategory Production;
        public static final /* enum */ NotificationCategory Units;
        public static final /* enum */ NotificationCategory War;
        public static final /* enum */ NotificationCategory Religion;
        public static final /* enum */ NotificationCategory Espionage;
        public static final /* enum */ NotificationCategory Cities;
        private static final /* synthetic */ NotificationCategory[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NotificationCategory[] values() {
            return (NotificationCategory[])$VALUES.clone();
        }

        public static NotificationCategory valueOf(String value) {
            return Enum.valueOf(NotificationCategory.class, value);
        }

        @NotNull
        public static EnumEntries<NotificationCategory> getEntries() {
            return $ENTRIES;
        }

        static {
            General = new NotificationCategory();
            Trade = new NotificationCategory();
            Diplomacy = new NotificationCategory();
            Production = new NotificationCategory();
            Units = new NotificationCategory();
            War = new NotificationCategory();
            Religion = new NotificationCategory();
            Espionage = new NotificationCategory();
            Cities = new NotificationCategory();
            $VALUES = notificationCategoryArray = new NotificationCategory[]{NotificationCategory.General, NotificationCategory.Trade, NotificationCategory.Diplomacy, NotificationCategory.Production, NotificationCategory.Units, NotificationCategory.War, NotificationCategory.Religion, NotificationCategory.Espionage, NotificationCategory.Cities};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/unciv/logic/civilization/Notification$NotificationCategory$Companion;", "", "<init>", "()V", "safeValueOf", "Lcom/unciv/logic/civilization/Notification$NotificationCategory;", "name", "", "core"})
        @SourceDebugExtension(value={"SMAP\nNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Notification.kt\ncom/unciv/logic/civilization/Notification$NotificationCategory$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n295#2,2:141\n*S KotlinDebug\n*F\n+ 1 Notification.kt\ncom/unciv/logic/civilization/Notification$NotificationCategory$Companion\n*L\n59#1:141,2\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Pure
            @Nullable
            public final NotificationCategory safeValueOf(@NotNull String name) {
                Object v0;
                block1: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    Iterable $this$firstOrNull$iv = NotificationCategory.getEntries();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        NotificationCategory it = (NotificationCategory)((Object)element$iv);
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.name(), name)) continue;
                        v0 = element$iv;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

