/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.models.ruleset.tile;

import com.unciv.logic.MultiFilter;
import com.unciv.logic.civilization.Civilization;
import com.unciv.logic.map.tile.Tile;
import com.unciv.logic.map.tile.TileImprovementFunctions;
import com.unciv.models.ruleset.Ruleset;
import com.unciv.models.ruleset.RulesetStatsObject;
import com.unciv.models.ruleset.tile.ResourceType;
import com.unciv.models.ruleset.tile.Terrain;
import com.unciv.models.ruleset.tile.TileImprovement;
import com.unciv.models.ruleset.unique.GameContext;
import com.unciv.models.ruleset.unique.IHasUniques;
import com.unciv.models.ruleset.unique.Unique;
import com.unciv.models.ruleset.unique.UniqueTarget;
import com.unciv.models.ruleset.unique.UniqueType;
import com.unciv.models.stats.GameResource;
import com.unciv.models.stats.Stats;
import com.unciv.ui.objectdescriptions.ResourceDescriptions;
import com.unciv.ui.screens.civilopediascreen.FormattedLine;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yairm210.purity.annotations.Cache;
import yairm210.purity.annotations.Readonly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001OB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u00108\u001a\b\u0012\u0004\u0012\u00020\r04H\u0007J\u000e\u00109\u001a\u00020:2\u0006\u00106\u001a\u000207J\b\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\rH\u0016J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\f2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u00106\u001a\u000207H\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\r2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010C\u001a\u00020-2\u0006\u0010D\u001a\u00020\rH\u0007J\u001a\u0010E\u001a\u0004\u0018\u00010\r2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0007J\u001c\u0010J\u001a\u00020-2\u0006\u0010K\u001a\u00020\r2\n\b\u0002\u0010L\u001a\u0004\u0018\u00010IH\u0007J\u0010\u0010M\u001a\u00020-2\u0006\u0010K\u001a\u00020\rH\u0007J\u0010\u0010N\u001a\u00020-2\u0006\u0010F\u001a\u00020GH\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR \u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u000f\"\u0004\b\"\u0010\u0011R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001b\u0010,\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b,\u0010.R\u001b\u00101\u001a\u00020-8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b2\u00100\u001a\u0004\b1\u0010.R \u00103\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u0001048\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b5\u0010\u0004R\u0010\u00106\u001a\u0004\u0018\u000107X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/unciv/models/ruleset/tile/TileResource;", "Lcom/unciv/models/ruleset/RulesetStatsObject;", "Lcom/unciv/models/stats/GameResource;", "<init>", "()V", "resourceType", "Lcom/unciv/models/ruleset/tile/ResourceType;", "getResourceType", "()Lcom/unciv/models/ruleset/tile/ResourceType;", "setResourceType", "(Lcom/unciv/models/ruleset/tile/ResourceType;)V", "terrainsCanBeFoundOn", "", "", "getTerrainsCanBeFoundOn", "()Ljava/util/List;", "setTerrainsCanBeFoundOn", "(Ljava/util/List;)V", "improvementStats", "Lcom/unciv/models/stats/Stats;", "getImprovementStats", "()Lcom/unciv/models/stats/Stats;", "setImprovementStats", "(Lcom/unciv/models/stats/Stats;)V", "revealedBy", "getRevealedBy", "()Ljava/lang/String;", "setRevealedBy", "(Ljava/lang/String;)V", "improvement", "getImprovement", "setImprovement", "improvedBy", "getImprovedBy", "setImprovedBy", "majorDepositAmount", "Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;", "getMajorDepositAmount", "()Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;", "setMajorDepositAmount", "(Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;)V", "minorDepositAmount", "getMinorDepositAmount", "setMinorDepositAmount", "isCityWide", "", "()Z", "isCityWide$delegate", "Lkotlin/Lazy;", "isStockpiled", "isStockpiled$delegate", "allImprovements", "", "getAllImprovements$annotations", "ruleset", "Lcom/unciv/models/ruleset/Ruleset;", "getImprovements", "setTransients", "", "getUniqueTarget", "Lcom/unciv/models/ruleset/unique/UniqueTarget;", "makeLink", "getCivilopediaTextLines", "Lcom/unciv/ui/screens/civilopediascreen/FormattedLine;", "getSortGroup", "", "getSubCategory", "isImprovedBy", "improvementName", "getImprovingImprovement", "tile", "Lcom/unciv/logic/map/tile/Tile;", "gameContext", "Lcom/unciv/models/ruleset/unique/GameContext;", "matchesFilter", "filter", "state", "matchesSingleFilter", "generatesNaturallyOn", "DepositAmount", "core"})
@SourceDebugExtension(value={"SMAP\nTileResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TileResource.kt\ncom/unciv/models/ruleset/tile/TileResource\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1255#2,2:163\n1255#2,2:170\n295#3,2:165\n1761#3,3:167\n*S KotlinDebug\n*F\n+ 1 TileResource.kt\ncom/unciv/models/ruleset/tile/TileResource\n*L\n72#1:163,2\n145#1:170,2\n116#1:165,2\n137#1:167,3\n*E\n"})
public final class TileResource
extends RulesetStatsObject
implements GameResource {
    @NotNull
    private ResourceType resourceType = ResourceType.Bonus;
    @NotNull
    private List<String> terrainsCanBeFoundOn = CollectionsKt.emptyList();
    @Nullable
    private Stats improvementStats;
    @Nullable
    private String revealedBy;
    @Nullable
    private String improvement;
    @NotNull
    private List<String> improvedBy = CollectionsKt.emptyList();
    @NotNull
    private DepositAmount majorDepositAmount = new DepositAmount();
    @NotNull
    private DepositAmount minorDepositAmount = new DepositAmount();
    @NotNull
    private final Lazy isCityWide$delegate = LazyKt.lazy(() -> TileResource.isCityWide_delegate$lambda$0(this));
    @NotNull
    private final Lazy isStockpiled$delegate = LazyKt.lazy(() -> TileResource.isStockpiled_delegate$lambda$0(this));
    @Nullable
    private Set<String> allImprovements;
    @Nullable
    private Ruleset ruleset;

    @NotNull
    public final ResourceType getResourceType() {
        return this.resourceType;
    }

    public final void setResourceType(@NotNull ResourceType resourceType) {
        Intrinsics.checkNotNullParameter((Object)resourceType, "<set-?>");
        this.resourceType = resourceType;
    }

    @NotNull
    public final List<String> getTerrainsCanBeFoundOn() {
        return this.terrainsCanBeFoundOn;
    }

    public final void setTerrainsCanBeFoundOn(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.terrainsCanBeFoundOn = list2;
    }

    @Nullable
    public final Stats getImprovementStats() {
        return this.improvementStats;
    }

    public final void setImprovementStats(@Nullable Stats stats) {
        this.improvementStats = stats;
    }

    @Nullable
    public final String getRevealedBy() {
        return this.revealedBy;
    }

    public final void setRevealedBy(@Nullable String string) {
        this.revealedBy = string;
    }

    @Nullable
    public final String getImprovement() {
        return this.improvement;
    }

    public final void setImprovement(@Nullable String string) {
        this.improvement = string;
    }

    @NotNull
    public final List<String> getImprovedBy() {
        return this.improvedBy;
    }

    public final void setImprovedBy(@NotNull List<String> list2) {
        Intrinsics.checkNotNullParameter(list2, "<set-?>");
        this.improvedBy = list2;
    }

    @NotNull
    public final DepositAmount getMajorDepositAmount() {
        return this.majorDepositAmount;
    }

    public final void setMajorDepositAmount(@NotNull DepositAmount depositAmount) {
        Intrinsics.checkNotNullParameter(depositAmount, "<set-?>");
        this.majorDepositAmount = depositAmount;
    }

    @NotNull
    public final DepositAmount getMinorDepositAmount() {
        return this.minorDepositAmount;
    }

    public final void setMinorDepositAmount(@NotNull DepositAmount depositAmount) {
        Intrinsics.checkNotNullParameter(depositAmount, "<set-?>");
        this.minorDepositAmount = depositAmount;
    }

    public final boolean isCityWide() {
        Lazy lazy = this.isCityWide$delegate;
        return (Boolean)lazy.getValue();
    }

    public final boolean isStockpiled() {
        Lazy lazy = this.isStockpiled$delegate;
        return (Boolean)lazy.getValue();
    }

    @Cache
    private static /* synthetic */ void getAllImprovements$annotations() {
    }

    @Readonly
    @NotNull
    public final Set<String> getImprovements() {
        if (this.allImprovements != null) {
            Set<String> set = this.allImprovements;
            Intrinsics.checkNotNull(set);
            return set;
        }
        Ruleset ruleset = this.ruleset;
        if (ruleset == null) {
            throw new IllegalStateException("No ruleset on TileResource when initializing improvements");
        }
        Ruleset ruleset2 = ruleset;
        Set allImprovementsLocal = new LinkedHashSet();
        if (this.improvement != null) {
            Collection collection = allImprovementsLocal;
            String string = this.improvement;
            Intrinsics.checkNotNull(string);
            collection.add(string);
        }
        allImprovementsLocal.addAll((Collection)this.improvedBy);
        Iterator<TileImprovement> iterator2 = ruleset2.getTileImprovements().values().iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            TileImprovement improvement;
            block5: {
                Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
                Sequence $this$any$iv = IHasUniques.getMatchingUniques$default(improvement, UniqueType.ImprovesResources, null, 2, null);
                boolean $i$f$any = false;
                Iterator iterator3 = $this$any$iv.iterator();
                while (iterator3.hasNext()) {
                    Object element$iv = iterator3.next();
                    Unique it = (Unique)element$iv;
                    boolean bl2 = false;
                    if (!TileResource.matchesFilter$default(this, it.getParams().get(0), null, 2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (!bl && !CollectionsKt.contains(allImprovementsLocal, improvement.getReplaces())) continue;
            ((Collection)allImprovementsLocal).add(improvement.getName());
        }
        this.allImprovements = allImprovementsLocal;
        return allImprovementsLocal;
    }

    public final void setTransients(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        this.allImprovements = null;
        this.ruleset = ruleset;
    }

    @Override
    @NotNull
    public UniqueTarget getUniqueTarget() {
        return UniqueTarget.Resource;
    }

    @Override
    @NotNull
    public String makeLink() {
        return "Resource/" + this.getName();
    }

    @Override
    @NotNull
    public List<FormattedLine> getCivilopediaTextLines(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return ResourceDescriptions.INSTANCE.getCivilopediaTextLines(this, ruleset);
    }

    @Override
    public int getSortGroup(@NotNull Ruleset ruleset) {
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        return this.resourceType.ordinal();
    }

    @Override
    @Nullable
    public String getSubCategory(@NotNull Ruleset ruleset) {
        String string;
        Intrinsics.checkNotNullParameter(ruleset, "ruleset");
        switch (WhenMappings.$EnumSwitchMapping$0[this.resourceType.ordinal()]) {
            case 1: {
                string = "Luxury resource";
                break;
            }
            case 2: {
                string = "Strategic resource";
                break;
            }
            case 3: {
                string = "Bonus resource";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Readonly
    public final boolean isImprovedBy(@NotNull String improvementName) {
        Intrinsics.checkNotNullParameter(improvementName, "improvementName");
        return this.getImprovements().contains(improvementName);
    }

    @Readonly
    @Nullable
    public final String getImprovingImprovement(@NotNull Tile tile, @NotNull GameContext gameContext) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter(gameContext, "gameContext");
        if (gameContext.getCivInfo() != null) {
            Object v2;
            block2: {
                Civilization civ = gameContext.getCivInfo();
                Iterable $this$firstOrNull$iv = this.getImprovements();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    TileImprovementFunctions tileImprovementFunctions = tile.getImprovementFunctions();
                    TileImprovement tileImprovement = civ.getGameInfo().getRuleset().getTileImprovements().get(it);
                    Intrinsics.checkNotNull(tileImprovement);
                    if (!tileImprovementFunctions.canBuildImprovement(tileImprovement, gameContext)) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            return v2;
        }
        return null;
    }

    @Readonly
    public final boolean matchesFilter(@NotNull String filter2, @Nullable GameContext state) {
        Intrinsics.checkNotNullParameter(filter2, "filter");
        return MultiFilter.multiFilter$default(MultiFilter.INSTANCE, filter2, arg_0 -> TileResource.matchesFilter$lambda$0(this, filter2, state, arg_0), false, 4, null);
    }

    public static /* synthetic */ boolean matchesFilter$default(TileResource tileResource, String string, GameContext gameContext, int n, Object object) {
        if ((n & 2) != 0) {
            gameContext = null;
        }
        return tileResource.matchesFilter(string, gameContext);
    }

    @Readonly
    public final boolean matchesSingleFilter(@NotNull String filter2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(filter2, "filter");
        String string = filter2;
        if (Intrinsics.areEqual(string, this.getName())) {
            bl = true;
        } else if (Intrinsics.areEqual(string, "any")) {
            bl = true;
        } else if (Intrinsics.areEqual(string, "all")) {
            bl = true;
        } else if (Intrinsics.areEqual(string, this.resourceType.name())) {
            bl = true;
        } else {
            Stats stats = this.improvementStats;
            if (stats != null) {
                boolean bl2;
                block13: {
                    Iterable $this$any$iv = stats;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Stats.StatValuePair it = (Stats.StatValuePair)element$iv;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual(filter2, it.getKey().name())) continue;
                            bl2 = true;
                            break block13;
                        }
                        bl2 = false;
                    }
                }
                bl = bl2;
            } else {
                bl = false;
            }
        }
        return bl;
    }

    @Readonly
    public final boolean generatesNaturallyOn(@NotNull Tile tile) {
        boolean bl;
        GameContext gameContext;
        block7: {
            Intrinsics.checkNotNullParameter(tile, "tile");
            if (!this.terrainsCanBeFoundOn.contains(tile.getLastTerrain().getName())) {
                return false;
            }
            gameContext = new GameContext(null, null, null, tile, null, null, null, null, null, null, false, 2039, null);
            if (this.hasUnique(UniqueType.NoNaturalGeneration, gameContext)) {
                return false;
            }
            Sequence<Terrain> $this$any$iv = tile.getAllTerrains();
            boolean $i$f$any = false;
            Iterator<Terrain> iterator2 = $this$any$iv.iterator();
            while (iterator2.hasNext()) {
                Terrain element$iv;
                Terrain it = element$iv = iterator2.next();
                boolean bl2 = false;
                if (!it.hasUnique(UniqueType.BlocksResources, gameContext)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        if (tile.getTemperature() != null && tile.getHumidity() != null) {
            Iterator<Unique> iterator3 = this.getMatchingUniques(UniqueType.TileGenerationConditions, gameContext).iterator();
            while (iterator3.hasNext()) {
                Unique unique = iterator3.next();
                double d = Double.parseDouble(unique.getParams().get(0));
                double d2 = Double.parseDouble(unique.getParams().get(1));
                Double d3 = tile.getTemperature();
                Intrinsics.checkNotNull(d3);
                double d4 = d3;
                if (!(d <= d4 ? d4 <= d2 : false)) {
                    return false;
                }
                d = Double.parseDouble(unique.getParams().get(2));
                d2 = Double.parseDouble(unique.getParams().get(3));
                Double d5 = tile.getHumidity();
                Intrinsics.checkNotNull(d5);
                d4 = d5;
                if (d <= d4 ? d4 <= d2 : false) continue;
                return false;
            }
        }
        return true;
    }

    private static final boolean isCityWide_delegate$lambda$0(TileResource this$0) {
        return this$0.hasUnique(UniqueType.CityResource, GameContext.Companion.getIgnoreConditionals());
    }

    private static final boolean isStockpiled_delegate$lambda$0(TileResource this$0) {
        return this$0.hasUnique(UniqueType.Stockpiled, GameContext.Companion.getIgnoreConditionals());
    }

    private static final boolean matchesFilter$lambda$0(TileResource this$0, String $filter, GameContext $state, String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.matchesSingleFilter($filter) || $state != null && this$0.hasTagUnique($filter, $state) || $state == null && this$0.hasTagUnique($filter);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/unciv/models/ruleset/tile/TileResource$DepositAmount;", "", "<init>", "()V", "sparse", "", "getSparse", "()I", "setSparse", "(I)V", "default", "getDefault", "setDefault", "abundant", "getAbundant", "setAbundant", "core"})
    public static final class DepositAmount {
        private int sparse = 1;
        private int default = 2;
        private int abundant = 3;

        public final int getSparse() {
            return this.sparse;
        }

        public final void setSparse(int n) {
            this.sparse = n;
        }

        public final int getDefault() {
            return this.default;
        }

        public final void setDefault(int n) {
            this.default = n;
        }

        public final int getAbundant() {
            return this.abundant;
        }

        public final void setAbundant(int n) {
            this.abundant = n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            try {
                nArray[ResourceType.Luxury.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Strategic.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResourceType.Bonus.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

