/*
 * Decompiled with CFR 0.152.
 */
package com.unciv.ui.popups.options;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.unciv.GUI;
import com.unciv.models.metadata.GameSettings;
import com.unciv.models.skins.SkinCache;
import com.unciv.models.tilesets.TileSetCache;
import com.unciv.models.translations.TranslationsKt;
import com.unciv.ui.components.extensions.Scene2dExtensionsKt;
import com.unciv.ui.components.input.ActivationExtensionsKt;
import com.unciv.ui.components.widgets.UncivSlider;
import com.unciv.ui.components.widgets.WrappableLabel;
import com.unciv.ui.images.ImageGetter;
import com.unciv.ui.popups.ConfirmPopup;
import com.unciv.ui.popups.options.OptionsPopup;
import com.unciv.ui.popups.options.OptionsPopupHelpers;
import com.unciv.ui.popups.options.OptionsPopupTab;
import com.unciv.ui.screens.worldscreen.NotificationsScroll;
import com.unciv.utils.Display;
import com.unciv.utils.ScreenMode;
import com.unciv.utils.ScreenOrientation;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0002J\b\u0010\t\u001a\u00020\u0007H\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\b\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\b\u0010\u000f\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/unciv/ui/popups/options/DisplayTab;", "Lcom/unciv/ui/popups/options/OptionsPopupTab;", "optionsPopup", "Lcom/unciv/ui/popups/options/OptionsPopup;", "<init>", "(Lcom/unciv/ui/popups/options/OptionsPopup;)V", "lateInitialize", "", "addScrollSpeedSlider", "addUnitIconAlphaSlider", "addPediaUnitArtSizeSlider", "addScreenModeSelectBox", "addScreenSizeSelectBox", "addScreenOrientationSelectBox", "addTileSetSelectBox", "addUnitSetSelectBox", "addSkinSelectBox", "addResetTutorials", "addNotificationScrollSelect", "core"})
public final class DisplayTab
extends OptionsPopupTab {
    public DisplayTab(@NotNull OptionsPopup optionsPopup) {
        Intrinsics.checkNotNullParameter(optionsPopup, "optionsPopup");
        super(optionsPopup);
    }

    @Override
    public void lateInitialize() {
        this.defaults().pad(2.5f);
        this.addHeader(this, "Screen");
        this.addScreenSizeSelectBox();
        this.addScreenOrientationSelectBox();
        this.addScreenModeSelectBox();
        if (Gdx.app.getType() == Application.ApplicationType.Desktop) {
            this.addCheckbox(this, "Map mouse auto-scroll", new MutablePropertyReference0Impl(this.getSettings()){

                public Object get() {
                    return ((GameSettings)this.receiver).getMapAutoScroll();
                }

                public void set(Object value) {
                    ((GameSettings)this.receiver).setMapAutoScroll((Boolean)value);
                }
            }, true, DisplayTab::lateInitialize$lambda$0);
            this.addScrollSpeedSlider();
        }
        this.addHeader(this, "Graphics");
        this.addTileSetSelectBox();
        this.addUnitSetSelectBox();
        this.addSkinSelectBox();
        this.addHeader(this, "UI");
        this.addNotificationScrollSelect();
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show minimap", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowMinimap();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowMinimap((Boolean)value);
            }
        }, true, null, 8, null);
        this.addCheckbox(this, "Show tutorials", this.getSettings().getShowTutorials(), true, false, arg_0 -> DisplayTab.lateInitialize$lambda$1(this, arg_0));
        this.addResetTutorials();
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show zoom buttons in world screen", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowZoomButtons();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowZoomButtons((Boolean)value);
            }
        }, true, null, 8, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Never close popups by clicking outside", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getForbidPopupClickBehindToClose();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setForbidPopupClickBehindToClose((Boolean)value);
            }
        }, false, null, 12, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Use circles to indicate movable tiles", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getUseCirclesToIndicateMovableTiles();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setUseCirclesToIndicateMovableTiles((Boolean)value);
            }
        }, true, null, 8, null);
        this.addPediaUnitArtSizeSlider();
        this.addHeader(this, "Visual Hints");
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show unit movement arrows", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowUnitMovements();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowUnitMovements((Boolean)value);
            }
        }, true, null, 8, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show suggested city locations for units that can found cities", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowSettlersSuggestedCityLocations();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowSettlersSuggestedCityLocations((Boolean)value);
            }
        }, true, null, 8, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show tile yields", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowTileYields();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowTileYields((Boolean)value);
            }
        }, true, null, 8, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show worked tiles", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowWorkedTiles();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowWorkedTiles((Boolean)value);
            }
        }, true, null, 8, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show resources and improvements", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowResourcesAndImprovements();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowResourcesAndImprovements((Boolean)value);
            }
        }, true, null, 8, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Show pixel improvements", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getShowPixelImprovements();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setShowPixelImprovements((Boolean)value);
            }
        }, true, null, 8, null);
        this.addUnitIconAlphaSlider();
        this.addHeader(this, "Performance");
        OptionsPopupHelpers.addCheckbox$default(this, this, "Continuous rendering", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getContinuousRendering();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setContinuousRendering((Boolean)value);
            }
        }, false, DisplayTab::lateInitialize$lambda$2, 4, null);
        String continuousRenderingDescription = "When disabled, saves battery life but certain animations will be suspended";
        float f = this.getOptionsPopup$core().getTabs().getPrefWidth();
        Color color = Color.ORANGE;
        Intrinsics.checkNotNullExpressionValue(color, "ORANGE");
        WrappableLabel continuousRenderingLabel = new WrappableLabel(continuousRenderingDescription, f, Scene2dExtensionsKt.brighten(color, 0.7f), 14, false, 16, null);
        continuousRenderingLabel.setWrap(true);
        this.add((Actor)continuousRenderingLabel).colspan(2).padTop(10.0f).row();
        this.addHeader(this, "Experimental");
        OptionsPopupHelpers.addCheckbox$default(this, this, "Experimental Demographics scoreboard", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getUseDemographics();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setUseDemographics((Boolean)value);
            }
        }, false, null, 12, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Animate Unit movement button", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getUnitMovementButtonAnimation();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setUnitMovementButtonAnimation((Boolean)value);
            }
        }, false, null, 12, null);
        OptionsPopupHelpers.addCheckbox$default(this, this, "Animate Unit actions menu", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getUnitActionsTableAnimation();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setUnitActionsTableAnimation((Boolean)value);
            }
        }, false, null, 12, null);
        super.lateInitialize();
    }

    private final void addScrollSpeedSlider() {
        OptionsPopupHelpers.addSlider$default((OptionsPopupHelpers)this, (Table)this, "Map panning speed", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return Float.valueOf(((GameSettings)this.receiver).getMapPanningSpeed());
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setMapPanningSpeed(((Number)value).floatValue());
            }
        }, 0.2f, 25.0f, 0.2f, null, arg_0 -> DisplayTab.addScrollSpeedSlider$lambda$0(this, arg_0), 32, null);
    }

    private final void addUnitIconAlphaSlider() {
        Function1<Float, String> getTipText = DisplayTab::addUnitIconAlphaSlider$lambda$0;
        this.addSlider((Table)this, "Unit icon opacity", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return Float.valueOf(((GameSettings)this.receiver).getUnitIconOpacity());
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setUnitIconOpacity(((Number)value).floatValue());
            }
        }, 0.0f, 1.0f, 0.1f, getTipText, DisplayTab::addUnitIconAlphaSlider$lambda$1);
    }

    private final void addPediaUnitArtSizeSlider() {
        Object t = OptionsPopupHelpers.addSlider$default((OptionsPopupHelpers)this, (Table)this, "Size of Unitset art in Civilopedia", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return Float.valueOf(((GameSettings)this.receiver).getPediaUnitArtSize());
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setPediaUnitArtSize(((Number)value).floatValue());
            }
        }, 0.0f, 360.0f, 0.0f, null, DisplayTab::addPediaUnitArtSizeSlider$lambda$0, 48, null).getActor();
        UncivSlider $this$addPediaUnitArtSizeSlider_u24lambda_u241 = (UncivSlider)t;
        boolean bl = false;
        float[] fArray = new float[]{0.0f, 32.0f, 48.0f, 64.0f, 96.0f, 120.0f, 180.0f, 240.0f, 360.0f};
        $this$addPediaUnitArtSizeSlider_u24lambda_u241.setSnapToValues(60.0f, fArray);
    }

    private final void addScreenModeSelectBox() {
        Map<Integer, ScreenMode> modes = Display.INSTANCE.getScreenModes();
        Object proxy2 = new Object(modes, this){
            final /* synthetic */ Map<Integer, ScreenMode> $modes;
            final /* synthetic */ DisplayTab this$0;
            {
                this.$modes = $modes;
                this.this$0 = $receiver;
            }

            public final ScreenMode getValue() {
                ScreenMode screenMode = this.$modes.get(this.this$0.getSettings().getScreenMode());
                if (screenMode == null) {
                    screenMode = (ScreenMode)CollectionsKt.first((Iterable)this.$modes.values());
                }
                return screenMode;
            }

            public final void setValue(ScreenMode value) {
                Intrinsics.checkNotNullParameter(value, "value");
                this.this$0.getSettings().setScreenMode(value.getId());
            }
        };
        this.addSelectBox(this, "Screen Mode", new MutablePropertyReference0Impl(proxy2){

            public Object get() {
                return (this.receiver).getValue();
            }

            public void set(Object value) {
                (this.receiver).setValue((ScreenMode)value);
            }
        }, (Iterable)modes.values(), (arg_0, arg_1) -> DisplayTab.addScreenModeSelectBox$lambda$0(this, arg_0, arg_1));
    }

    private final void addScreenSizeSelectBox() {
        this.addSelectBox(this, "UI Scale", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getScreenSize();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setScreenSize((GameSettings.ScreenSize)((Object)value));
            }
        }, (Iterable)GameSettings.ScreenSize.getEntries(), (arg_0, arg_1) -> DisplayTab.addScreenSizeSelectBox$lambda$0(this, arg_0, arg_1));
    }

    private final void addScreenOrientationSelectBox() {
        if (!Display.INSTANCE.hasOrientation()) {
            return;
        }
        this.addSelectBox(this, "Screen orientation", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getDisplayOrientation();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setDisplayOrientation((ScreenOrientation)((Object)value));
            }
        }, (Iterable)ScreenOrientation.getEntries(), (arg_0, arg_1) -> DisplayTab.addScreenOrientationSelectBox$lambda$0(this, arg_0, arg_1));
    }

    private final void addTileSetSelectBox() {
        Sequence<String> unitSets = ImageGetter.INSTANCE.getAvailableUnitsets();
        this.addSelectBox(this, "Tileset", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getTileSet();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setTileSet((String)value);
            }
        }, SequencesKt.asIterable(ImageGetter.INSTANCE.getAvailableTilesets()), (arg_0, arg_1) -> DisplayTab.addTileSetSelectBox$lambda$0(this, unitSets, arg_0, arg_1));
    }

    private final void addUnitSetSelectBox() {
        String nullValue = TranslationsKt.tr$default("None", false, false, 3, null);
        this.addSelectBox(this, "Unitset", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getUnitSet();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setUnitSet((String)value);
            }
        }, SequencesKt.asIterable(ImageGetter.INSTANCE.getAvailableUnitsets()), (arg_0, arg_1) -> DisplayTab.addUnitSetSelectBox$lambda$0(nullValue, this, arg_0, arg_1));
    }

    private final void addSkinSelectBox() {
        this.addSelectBox(this, "UI Skin", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getSkin();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setSkin((String)value);
            }
        }, SequencesKt.asIterable(ImageGetter.INSTANCE.getAvailableSkins()), (arg_0, arg_1) -> DisplayTab.addSkinSelectBox$lambda$0(this, arg_0, arg_1));
    }

    private final void addResetTutorials() {
        TextButton resetTutorialsButton = Scene2dExtensionsKt.toTextButton$default("Reset tutorials", null, false, 3, null);
        ActivationExtensionsKt.onClick(resetTutorialsButton, () -> DisplayTab.addResetTutorials$lambda$0(this, resetTutorialsButton));
        this.add((Actor)resetTutorialsButton).center().row();
    }

    private final void addNotificationScrollSelect() {
        this.addEnumAsStringSelectBox(this, "Notifications on world screen", new MutablePropertyReference0Impl(this.getSettings()){

            public Object get() {
                return ((GameSettings)this.receiver).getNotificationScroll();
            }

            public void set(Object value) {
                ((GameSettings)this.receiver).setNotificationScroll((String)value);
            }
        }, (Iterable)NotificationsScroll.UserSetting.getEntries(), DisplayTab::addNotificationScrollSelect$lambda$0);
    }

    private static final Unit lateInitialize$lambda$0(boolean it) {
        if (GUI.INSTANCE.isWorldLoaded()) {
            GUI.INSTANCE.getMap().setAutoScrollEnabled(it);
        }
        return Unit.INSTANCE;
    }

    private static final Unit lateInitialize$lambda$1(DisplayTab this$0, boolean it) {
        this$0.getSettings().setShowTutorials(it);
        return Unit.INSTANCE;
    }

    private static final Unit lateInitialize$lambda$2(boolean it) {
        Gdx.graphics.setContinuousRendering(it);
        return Unit.INSTANCE;
    }

    private static final Unit addScrollSpeedSlider$lambda$0(DisplayTab this$0, float it) {
        this$0.getSettings().save();
        if (GUI.INSTANCE.isWorldLoaded()) {
            GUI.INSTANCE.getMap().setMapPanningSpeed(this$0.getSettings().getMapPanningSpeed());
        }
        return Unit.INSTANCE;
    }

    private static final String addUnitIconAlphaSlider$lambda$0(float it) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = "%.0f";
        Object[] objectArray = new Object[]{Float.valueOf(it * (float)100)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return stringBuilder.append(string2).append('%').toString();
    }

    private static final Unit addUnitIconAlphaSlider$lambda$1(float it) {
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }

    private static final Unit addPediaUnitArtSizeSlider$lambda$0(float it) {
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }

    private static final Unit addScreenModeSelectBox$lambda$0(DisplayTab this$0, ScreenMode mode, ScreenMode screenMode) {
        Intrinsics.checkNotNullParameter(mode, "mode");
        Intrinsics.checkNotNullParameter(screenMode, "<unused var>");
        this$0.getSettings().refreshWindowSize();
        Display.INSTANCE.setScreenMode(mode.getId(), this$0.getSettings());
        return Unit.INSTANCE;
    }

    private static final Unit addScreenSizeSelectBox$lambda$0(DisplayTab this$0, GameSettings.ScreenSize screenSize, GameSettings.ScreenSize screenSize2) {
        Intrinsics.checkNotNullParameter((Object)screenSize, "<unused var>");
        Intrinsics.checkNotNullParameter((Object)screenSize2, "<unused var>");
        this$0.reloadWorldAndOptions();
        return Unit.INSTANCE;
    }

    private static final Unit addScreenOrientationSelectBox$lambda$0(DisplayTab this$0, ScreenOrientation orientation, ScreenOrientation screenOrientation) {
        Intrinsics.checkNotNullParameter((Object)orientation, "orientation");
        Intrinsics.checkNotNullParameter((Object)screenOrientation, "<unused var>");
        Display.INSTANCE.setOrientation(orientation);
        this$0.reloadWorldAndOptions();
        return Unit.INSTANCE;
    }

    private static final Unit addTileSetSelectBox$lambda$0(DisplayTab this$0, Sequence $unitSets, String newValue, String oldValue) {
        Intrinsics.checkNotNullParameter(newValue, "newValue");
        Intrinsics.checkNotNullParameter(oldValue, "oldValue");
        if (Intrinsics.areEqual(oldValue, this$0.getSettings().getUnitSet()) && SequencesKt.contains($unitSets, newValue)) {
            this$0.getSettings().setUnitSet(newValue);
        }
        TileSetCache.INSTANCE.assembleTileSetConfigs((Set<String>)ImageGetter.INSTANCE.getRuleset().getMods());
        this$0.reloadWorldAndOptions();
        return Unit.INSTANCE;
    }

    private static final Unit addUnitSetSelectBox$lambda$0(String $nullValue, DisplayTab this$0, String value, String string) {
        if (Intrinsics.areEqual(value, $nullValue)) {
            this$0.getSettings().setUnitSet(null);
        }
        TileSetCache.INSTANCE.assembleTileSetConfigs((Set<String>)ImageGetter.INSTANCE.getRuleset().getMods());
        this$0.reloadWorldAndOptions();
        return Unit.INSTANCE;
    }

    private static final Unit addSkinSelectBox$lambda$0(DisplayTab this$0, String string, String string2) {
        Intrinsics.checkNotNullParameter(string, "<unused var>");
        Intrinsics.checkNotNullParameter(string2, "<unused var>");
        SkinCache.INSTANCE.assembleSkinConfigs((Set<String>)ImageGetter.INSTANCE.getRuleset().getMods());
        this$0.reloadWorldAndOptions();
        return Unit.INSTANCE;
    }

    private static final Unit addResetTutorials$lambda$0(DisplayTab this$0, TextButton $resetTutorialsButton) {
        Stage stage = this$0.getStage();
        Intrinsics.checkNotNullExpressionValue(stage, "getStage(...)");
        new ConfirmPopup(stage, "Do you want to reset completed tutorials?", "Reset", false, null, () -> DisplayTab.addResetTutorials$lambda$0$0(this$0, $resetTutorialsButton), 24, null).open(true);
        return Unit.INSTANCE;
    }

    private static final Unit addResetTutorials$lambda$0$0(DisplayTab this$0, TextButton $resetTutorialsButton) {
        this$0.getSettings().getTutorialsShown().clear();
        this$0.getSettings().getTutorialTasksCompleted().clear();
        $resetTutorialsButton.setText(TranslationsKt.tr$default("Done!", false, false, 3, null));
        $resetTutorialsButton.clearListeners();
        return Unit.INSTANCE;
    }

    private static final Unit addNotificationScrollSelect$lambda$0(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        GUI.INSTANCE.setUpdateWorldOnNextRender();
        return Unit.INSTANCE;
    }
}

