# logger.py
#
# Copyright (C) 2025 The Upscaler Contributors
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <https://www.gnu.org/licenses/>.
#
# SPDX-License-Identifier: GPL-3.0-only

import logging
import os
import sys

from upscaler import PROFILE


class PackageNameFilter(logging.Filter):
    """The path name of the package."""

    def filter(self, record: logging.LogRecord) -> bool | logging.LogRecord:
        """Get the path name of the package."""
        package_absolute_path = sys.path[1] + os.sep
        record.packagename = record.pathname.replace(package_absolute_path, "")
        return True


logger = logging.getLogger()
format = "%(packagename)s:%(lineno)d:0:\n%(levelname)8s: %(funcName)s(): %(message)s"

if PROFILE == "development":
    logging.basicConfig(
        format=format,
        level=logging.DEBUG,
    )
else:
    logging.basicConfig(
        format=format,
    )
logger.handlers[0].addFilter(PackageNameFilter())
