import { BaseApiClient } from "./BaseApiClient.js";
import { RegisterIntrospectRequest, RegisterChallengeRequest, RegisterContinueRequest } from "./types/ApiRequestTypes.js";
import { RegisterIntrospectResponse, RegisterChallengeResponse, RegisterContinueResponse } from "./types/ApiResponseTypes.js";
export declare class RegisterApiClient extends BaseApiClient {
    /**
     * Gets available authentication methods for registration
     */
    introspect(params: RegisterIntrospectRequest): Promise<RegisterIntrospectResponse>;
    /**
     * Sends challenge to specified authentication method
     */
    challenge(params: RegisterChallengeRequest): Promise<RegisterChallengeResponse>;
    /**
     * Submits challenge response and continues registration
     */
    continue(params: RegisterContinueRequest): Promise<RegisterContinueResponse>;
}
//# sourceMappingURL=RegisterApiClient.d.ts.map