/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

// Sign in state types
export const SIGN_IN_CODE_REQUIRED_STATE_TYPE = "SignInCodeRequiredState";
export const SIGN_IN_PASSWORD_REQUIRED_STATE_TYPE =
    "SignInPasswordRequiredState";
export const SIGN_IN_CONTINUATION_STATE_TYPE = "SignInContinuationState";
export const SIGN_IN_COMPLETED_STATE_TYPE = "SignInCompletedState";
export const SIGN_IN_FAILED_STATE_TYPE = "SignInFailedState";

// Sign up state types
export const SIGN_UP_CODE_REQUIRED_STATE_TYPE = "SignUpCodeRequiredState";
export const SIGN_UP_PASSWORD_REQUIRED_STATE_TYPE =
    "SignUpPasswordRequiredState";
export const SIGN_UP_ATTRIBUTES_REQUIRED_STATE_TYPE =
    "SignUpAttributesRequiredState";
export const SIGN_UP_COMPLETED_STATE_TYPE = "SignUpCompletedState";
export const SIGN_UP_FAILED_STATE_TYPE = "SignUpFailedState";

// Reset password state types
export const RESET_PASSWORD_CODE_REQUIRED_STATE_TYPE =
    "ResetPasswordCodeRequiredState";
export const RESET_PASSWORD_PASSWORD_REQUIRED_STATE_TYPE =
    "ResetPasswordPasswordRequiredState";
export const RESET_PASSWORD_COMPLETED_STATE_TYPE =
    "ResetPasswordCompletedState";
export const RESET_PASSWORD_FAILED_STATE_TYPE = "ResetPasswordFailedState";

// Get account state types
export const GET_ACCOUNT_COMPLETED_STATE_TYPE = "GetAccountCompletedState";
export const GET_ACCOUNT_FAILED_STATE_TYPE = "GetAccountFailedState";

// Get access token state types
export const GET_ACCESS_TOKEN_COMPLETED_STATE_TYPE =
    "GetAccessTokenCompletedState";
export const GET_ACCESS_TOKEN_FAILED_STATE_TYPE = "GetAccessTokenFailedState";

// Sign out state types
export const SIGN_OUT_COMPLETED_STATE_TYPE = "SignOutCompletedState";
export const SIGN_OUT_FAILED_STATE_TYPE = "SignOutFailedState";

// MFA state types
export const MFA_AWAITING_STATE_TYPE = "MfaAwaitingState";
export const MFA_VERIFICATION_REQUIRED_STATE_TYPE =
    "MfaVerificationRequiredState";
export const MFA_COMPLETED_STATE_TYPE = "MfaCompletedState";
export const MFA_FAILED_STATE_TYPE = "MfaFailedState";

// Auth method registration (JIT) state types
export const AUTH_METHOD_REGISTRATION_REQUIRED_STATE_TYPE =
    "AuthMethodRegistrationRequiredState";
export const AUTH_METHOD_VERIFICATION_REQUIRED_STATE_TYPE =
    "AuthMethodVerificationRequiredState";
export const AUTH_METHOD_REGISTRATION_COMPLETED_STATE_TYPE =
    "AuthMethodRegistrationCompletedState";
export const AUTH_METHOD_REGISTRATION_FAILED_STATE_TYPE =
    "AuthMethodRegistrationFailedState";
