/*
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 */

import { AuthFlowStateBase } from "../../../core/auth_flow/AuthFlowState.js";
import {
    SIGN_OUT_COMPLETED_STATE_TYPE,
    SIGN_OUT_FAILED_STATE_TYPE,
} from "../../../core/auth_flow/AuthFlowStateTypes.js";

/**
 * The completed state of the sign-out flow.
 */
export class SignOutCompletedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = SIGN_OUT_COMPLETED_STATE_TYPE;
}

/**
 * The failed state of the sign-out flow.
 */
export class SignOutFailedState extends AuthFlowStateBase {
    /**
     * The type of the state.
     */
    stateType = SIGN_OUT_FAILED_STATE_TYPE;
}
