### Supported

<!--- BEGIN GENERATED GAMES -->
| GameDig Type ID      | Name                                             | See Also                                         |
|----------------------|--------------------------------------------------|--------------------------------------------------|
| a2oa                 | ARMA 2: Operation Arrowhead                      | [Valve Protocol](#valve)                         |
| aaa                  | ARMA: Armed Assault                              |                                                  |
| aapg                 | America's Army: Proving Grounds                  | [Valve Protocol](#valve)                         |
| abioticfactor        | Abiotic Factor                                   | [Valve Protocol](#valve)                         |
| actionsource         | Action: Source                                   | [Valve Protocol](#valve)                         |
| acwa                 | ARMA: Cold War Assault                           |                                                  |
| ahl                  | Action Half-Life                                 | [Valve Protocol](#valve)                         |
| alienarena           | Alien Arena                                      |                                                  |
| alienswarm           | Alien Swarm                                      | [Valve Protocol](#valve)                         |
| americasarmy         | America's Army                                   |                                                  |
| americasarmy2        | America's Army 2                                 |                                                  |
| americasarmy3        | America's Army 3                                 | [Valve Protocol](#valve)                         |
| aoc                  | Age of Chivalry                                  | [Valve Protocol](#valve)                         |
| aoe2                 | Age of Empires 2                                 |                                                  |
| aosc                 | Ace of Spades Classic                            | [Notes](#aosc-buildandshoot)                     |
| arma2                | ARMA 2                                           | [Valve Protocol](#valve)                         |
| arma3                | ARMA 3                                           | [Valve Protocol](#valve)                         |
| armagetronadvanced   | Armagetron Advanced                              |                                                  |
| armareforger         | ARMA: Reforger                                   | [Notes](#armareforger), [Valve Protocol](#valve) |
| armaresistance       | ARMA: Resistance                                 |                                                  |
| asa                  | Ark: Survival Ascended                           | [EOS Protocol](#epic)                            |
| ase                  | Ark: Survival Evolved                            | [Valve Protocol](#valve)                         |
| asr08                | Arca Sim Racing '08                              |                                                  |
| assettocorsa         | Assetto Corsa                                    |                                                  |
| atlas                | Atlas                                            | [Valve Protocol](#valve)                         |
| avorion              | Avorion                                          | [Valve Protocol](#valve)                         |
| avp2                 | Aliens versus Predator 2                         |                                                  |
| avp2010              | Aliens vs. Predator 2010                         | [Valve Protocol](#valve)                         |
| baldursgate          | Baldur's Gate                                    |                                                  |
| ballisticoverkill    | Ballistic Overkill                               | [Valve Protocol](#valve)                         |
| barotrauma           | Barotrauma                                       | [Valve Protocol](#valve)                         |
| bas                  | Build and Shoot                                  | [Notes](#aosc-buildandshoot)                     |
| basedefense          | Base Defense                                     | [Valve Protocol](#valve)                         |
| battalion1944        | Battalion 1944                                   | [Valve Protocol](#valve)                         |
| battlefield1942      | Battlefield 1942                                 |                                                  |
| battlefield2         | Battlefield 2                                    |                                                  |
| battlefield2142      | Battlefield 2142                                 |                                                  |
| battlefield3         | Battlefield 3                                    |                                                  |
| battlefield4         | Battlefield 4                                    |                                                  |
| battlefieldhardline  | Battlefield Hardline                             |                                                  |
| battlefieldvietnam   | Battlefield Vietnam                              |                                                  |
| bbc2                 | Battlefield: Bad Company 2                       |                                                  |
| beammp               | BeamMP (2021)                                    |                                                  |
| blackmesa            | Black Mesa                                       | [Valve Protocol](#valve)                         |
| bladesymphony        | Blade Symphony                                   | [Valve Protocol](#valve)                         |
| brainbread           | BrainBread                                       | [Valve Protocol](#valve)                         |
| brainbread2          | BrainBread 2                                     | [Valve Protocol](#valve)                         |
| breach               | Breach                                           | [Valve Protocol](#valve)                         |
| breed                | Breed                                            |                                                  |
| brink                | Brink                                            | [Valve Protocol](#valve)                         |
| brokeprotocol        | BROKE PROTOCOL                                   | [Notes](#brokeprotocol)                          |
| c2d                  | CS2D                                             |                                                  |
| c3db                 | Commandos 3: Destination Berlin                  |                                                  |
| cacr                 | Command and Conquer: Renegade                    |                                                  |
| cbu                  | Clive Barker's Undying                           |                                                  |
| chaser               | Chaser                                           |                                                  |
| chrome               | Chrome                                           |                                                  |
| cmw                  | Chivalry: Medieval Warfare                       | [Valve Protocol](#valve)                         |
| cod                  | Call of Duty                                     |                                                  |
| cod2                 | Call of Duty 2                                   |                                                  |
| cod3                 | Call of Duty 3                                   |                                                  |
| cod4mw               | Call of Duty 4: Modern Warfare                   |                                                  |
| codbo3               | Call of Duty: Black Ops 3                        | [Valve Protocol](#valve)                         |
| codenamecure         | Codename CURE                                    | [Valve Protocol](#valve)                         |
| codenameeagle        | Codename Eagle                                   |                                                  |
| codmw2               | Call of Duty: Modern Warfare 2                   |                                                  |
| codmw3               | Call of Duty: Modern Warfare 3                   | [Valve Protocol](#valve)                         |
| coduo                | Call of Duty: United Offensive                   |                                                  |
| codwaw               | Call of Duty: World at War                       |                                                  |
| coj                  | Call of Juarez                                   |                                                  |
| colonysurvival       | Colony Survival                                  | [Valve Protocol](#valve)                         |
| conanexiles          | Conan Exiles                                     | [Notes](#conanexiles), [Valve Protocol](#valve)  |
| contagion            | Contagion                                        | [Valve Protocol](#valve)                         |
| contractjack         | Contract J.A.C.K.                                |                                                  |
| corekeeper           | Core Keeper                                      | [Valve Protocol](#valve)                         |
| counterstrike15      | Counter-Strike 1.5                               |                                                  |
| counterstrike16      | Counter-Strike 1.6                               | [Valve Protocol](#valve)                         |
| counterstrike2       | Counter-Strike 2                                 | [Notes](#cs2), [Valve Protocol](#valve)          |
| crce                 | Cross Racing Championship Extreme                |                                                  |
| creativerse          | Creativerse                                      | [Valve Protocol](#valve)                         |
| crysis               | Crysis                                           |                                                  |
| crysis2              | Crysis 2                                         |                                                  |
| crysiswars           | Crysis Wars                                      |                                                  |
| cscz                 | Counter-Strike: Condition Zero                   | [Valve Protocol](#valve)                         |
| csgo                 | Counter-Strike: Global Offensive                 | [Notes](#csgo), [Valve Protocol](#valve)         |
| css                  | Counter-Strike: Source                           | [Valve Protocol](#valve)                         |
| dab                  | Double Action: Boogaloo                          | [Valve Protocol](#valve)                         |
| daikatana            | Daikatana                                        |                                                  |
| dal                  | Dark and Light                                   | [Valve Protocol](#valve)                         |
| dayofdragons         | Day of Dragons                                   | [Valve Protocol](#valve)                         |
| dayz                 | DayZ                                             | [Notes](#dayz), [Valve Protocol](#valve)         |
| dayzmod              | DayZ Mod                                         | [Valve Protocol](#valve)                         |
| ddd                  | Dino D-Day                                       | [Valve Protocol](#valve)                         |
| ddpt                 | Deadly Dozen: Pacific Theater                    |                                                  |
| deathmatchclassic    | Deathmatch Classic                               | [Valve Protocol](#valve)                         |
| deerhunter2005       | Deer Hunter 2005                                 |                                                  |
| descent3             | Descent 3                                        |                                                  |
| deusex               | Deus Ex                                          |                                                  |
| devastation          | Devastation                                      |                                                  |
| dhe4445              | Darkest Hour: Europe '44-'45                     |                                                  |
| discord              | Discord                                          | [Notes](#discord)                                |
| dmomam               | Dark Messiah of Might and Magic                  | [Valve Protocol](#valve)                         |
| dnf2001              | Duke Nukem Forever 2001                          |                                                  |
| dod                  | Day of Defeat                                    | [Valve Protocol](#valve)                         |
| dods                 | Day of Defeat: Source                            | [Valve Protocol](#valve)                         |
| doi                  | Day of Infamy                                    | [Valve Protocol](#valve)                         |
| doom3                | Doom 3                                           |                                                  |
| dootf                | Drakan: Order of the Flame                       |                                                  |
| dota2                | Dota 2                                           | [Valve Protocol](#valve)                         |
| dow                  | Days of War                                      | [Valve Protocol](#valve)                         |
| dst                  | Don't Starve Together                            | [Valve Protocol](#valve)                         |
| dtr2                 | Dirt Track Racing 2                              |                                                  |
| dystopia             | Dystopia                                         | [Valve Protocol](#valve)                         |
| eco                  | Eco                                              |                                                  |
| egs                  | Empyrion - Galactic Survival                     | [Valve Protocol](#valve)                         |
| eldewrito            | Halo Online - ElDewrito                          |                                                  |
| empiresmod           | Empires Mod                                      | [Valve Protocol](#valve)                         |
| enshrouded           | enshrouded                                       | [Valve Protocol](#valve)                         |
| etqw                 | Enemy Territory: Quake Wars                      |                                                  |
| ets2                 | Euro Truck Simulator 2                           | [Valve Protocol](#valve)                         |
| exfil                | Exfil                                            | [Valve Protocol](#valve)                         |
| f1c9902              | F1 Challenge '99-'02                             |                                                  |
| factorio             | Factorio                                         |                                                  |
| farcry               | Far Cry                                          |                                                  |
| farcry2              | Far Cry 2                                        |                                                  |
| farmingsimulator19   | Farming Simulator 19                             |                                                  |
| farmingsimulator22   | Farming Simulator 22                             |                                                  |
| farmingsimulator25   | Farming Simulator 25                             |                                                  |
| fear                 | F.E.A.R.                                         |                                                  |
| ffow                 | Frontlines: Fuel of War                          |                                                  |
| fof                  | Fistful of Frags                                 | [Valve Protocol](#valve)                         |
| formulaone2002       | Formula One 2002                                 |                                                  |
| fortressforever      | Fortress Forever                                 | [Valve Protocol](#valve)                         |
| foundry              | FOUNDRY                                          | [Valve Protocol](#valve)                         |
| garrysmod            | Garry's Mod                                      | [Valve Protocol](#valve)                         |
| gck                  | Giants: Citizen Kabuto                           |                                                  |
| geneshift            | Geneshift                                        |                                                  |
| globaloperations     | Global Operations                                |                                                  |
| goldeneyesource      | GoldenEye: Source                                | [Valve Protocol](#valve)                         |
| groundbreach         | Ground Breach                                    | [Valve Protocol](#valve)                         |
| gta5am               | Grand Theft Auto V - alt:V Multiplayer           | [Notes](#gta5am)                                 |
| gta5f                | Grand Theft Auto V - FiveM                       | [Notes](#gta5f)                                  |
| gta5r                | Grand Theft Auto V - RageMP                      | [Notes](#gta5r)                                  |
| gtasam               | Grand Theft Auto: San Andreas Multiplayer        |                                                  |
| gtasamta             | Grand Theft Auto: San Andreas - Multi Theft Auto |                                                  |
| gtasao               | Grand Theft Auto: San Andreas OpenMP             |                                                  |
| gtavcmta             | Grand Theft Auto: Vice City - Multi Theft Auto   |                                                  |
| gunmanchronicles     | Gunman Chronicles                                | [Valve Protocol](#valve)                         |
| gus                  | Gore: Ultimate Soldier                           |                                                  |
| halo                 | Halo                                             |                                                  |
| halo2                | Halo 2                                           |                                                  |
| hawakening           | Hawakening                                       | [Notes](#hawakening)                             |
| heretic2             | Heretic II                                       |                                                  |
| hexen2               | Hexen II                                         |                                                  |
| hiddendangerous2     | Hidden & Dangerous 2                             |                                                  |
| hl2d                 | Half-Life 2: Deathmatch                          | [Valve Protocol](#valve)                         |
| hld                  | Half-Life Deathmatch                             | [Valve Protocol](#valve)                         |
| hlds                 | Half-Life Deathmatch: Source                     | [Valve Protocol](#valve)                         |
| hll                  | Hell Let Loose                                   | [Valve Protocol](#valve)                         |
| hlof                 | Half-Life: Opposing Force                        | [Valve Protocol](#valve)                         |
| homefront            | Homefront                                        | [Valve Protocol](#valve)                         |
| homeworld2           | Homeworld 2                                      |                                                  |
| hurtworld            | Hurtworld                                        | [Valve Protocol](#valve)                         |
| i2cs                 | IGI 2: Covert Strike                             |                                                  |
| i2s                  | IL-2 Sturmovik                                   |                                                  |
| icarus               | Icarus                                           | [Valve Protocol](#valve)                         |
| imic                 | Insurgency: Modern Infantry Combat               | [Valve Protocol](#valve)                         |
| insurgency           | Insurgency                                       | [Valve Protocol](#valve)                         |
| insurgencysandstorm  | Insurgency: Sandstorm                            | [Valve Protocol](#valve)                         |
| ironstorm            | Iron Storm                                       |                                                  |
| jb0n                 | James Bond 007: Nightfire                        |                                                  |
| jc2m                 | Just Cause 2 - Multiplayer                       |                                                  |
| jc3m                 | Just Cause 3 - Multiplayer                       | [Valve Protocol](#valve)                         |
| killingfloor         | Killing Floor                                    |                                                  |
| killingfloor2        | Killing Floor 2                                  | [Valve Protocol](#valve)                         |
| kloc                 | Kingpin: Life of Crime                           |                                                  |
| kpctnc               | Kiss: Psycho Circus: The Nightmare Child         |                                                  |
| kreedzclimbing       | Kreedz Climbing                                  | [Valve Protocol](#valve)                         |
| kspd                 | Kerbal Space Program - DMP                       |                                                  |
| l4d                  | Left 4 Dead                                      | [Valve Protocol](#valve)                         |
| l4d2                 | Left 4 Dead 2                                    | [Valve Protocol](#valve)                         |
| m2m                  | Mafia II - Multiplayer                           |                                                  |
| m2o                  | Mafia II - Online                                |                                                  |
| mbe                  | Minecraft: Bedrock Edition                       |                                                  |
| medievalengineers    | Medieval Engineers                               | [Valve Protocol](#valve)                         |
| mgm                  | Mumble - GT Murmur                               | [Notes](#mumble)                                 |
| minecraft            | Minecraft                                        | [Notes](#minecraft)                              |
| minetest             | Minetest                                         |                                                  |
| mnc                  | Monday Night Combat                              | [Valve Protocol](#valve)                         |
| moe                  | Myth of Empires                                  | [Valve Protocol](#valve)                         |
| moh                  | Medal of Honor                                   |                                                  |
| moha                 | Medal of Honor: Airborne                         |                                                  |
| mohaa                | Medal of Honor: Allied Assault                   |                                                  |
| mohaab               | Medal of Honor: Allied Assault Breakthrough      |                                                  |
| mohaas               | Medal of Honor: Allied Assault Spearhead         |                                                  |
| mohpa                | Medal of Honor: Pacific Assault                  |                                                  |
| mohw                 | Medal of Honor: Warfighter                       |                                                  |
| mordhau              | Mordhau                                          | [Valve Protocol](#valve)                         |
| mumble               | Mumble                                           | [Notes](#mumble)                                 |
| mutantfactions       | Mutant Factions                                  |                                                  |
| nab                  | Nerf Arena Blast                                 |                                                  |
| nascarthunder2004    | NASCAR Thunder 2004                              |                                                  |
| naturalselection     | Natural Selection                                | [Valve Protocol](#valve)                         |
| naturalselection2    | Natural Selection 2                              | [Valve Protocol](#valve)                         |
| netpanzer            | netPanzer                                        |                                                  |
| neverwinternights    | Neverwinter Nights                               |                                                  |
| neverwinternights2   | Neverwinter Nights 2                             |                                                  |
| nexuiz               | Nexuiz                                           |                                                  |
| nfshp2               | Need for Speed: Hot Pursuit 2                    |                                                  |
| nitrofamily          | Nitro Family                                     |                                                  |
| nla                  | Nova-Life: Amboise                               | [Valve Protocol](#valve)                         |
| nmrih                | No More Room in Hell                             | [Valve Protocol](#valve)                         |
| nolf2asihw           | No One Lives Forever 2: A Spy in H.A.R.M.'s Way  |                                                  |
| nucleardawn          | Nuclear Dawn                                     | [Valve Protocol](#valve)                         |
| ofcwc                | Operation Flashpoint: Cold War Crisis            |                                                  |
| ofr                  | Operation Flashpoint: Resistance                 |                                                  |
| ohd                  | Operation: Harsh Doorstop                        | [Valve Protocol](#valve)                         |
| onset                | Onset                                            | [Valve Protocol](#valve)                         |
| openarena            | OpenArena                                        |                                                  |
| openttd              | OpenTTD                                          |                                                  |
| painkiller           | Painkiller                                       |                                                  |
| palworld             | Palworld                                         | [Notes](#palworld)                               |
| pce                  | Primal Carnage: Extinction                       | [Valve Protocol](#valve)                         |
| pixark               | PixARK                                           | [Valve Protocol](#valve)                         |
| postal2              | Postal 2                                         |                                                  |
| postscriptum         | Post Scriptum                                    | [Valve Protocol](#valve)                         |
| prb2                 | Project Reality: Battlefield 2                   |                                                  |
| prey                 | Prey                                             |                                                  |
| projectcars          | Project Cars                                     | [Valve Protocol](#valve)                         |
| projectcars2         | Project Cars 2                                   | [Valve Protocol](#valve)                         |
| projectzomboid       | Project Zomboid                                  | [Valve Protocol](#valve)                         |
| pvak2                | Pirates, Vikings, and Knights II                 | [Valve Protocol](#valve)                         |
| q3a                  | Quake 3: Arena                                   |                                                  |
| quake                | Quake                                            |                                                  |
| quake2               | Quake 2                                          |                                                  |
| quake4               | Quake 4                                          |                                                  |
| quakelive            | Quake Live                                       | [Valve Protocol](#valve)                         |
| rainbowsix           | Rainbow Six                                      |                                                  |
| rallisportchallenge  | RalliSport Challenge                             |                                                  |
| rallymasters         | Rally Masters                                    |                                                  |
| rdkf                 | Rag Doll Kung Fu                                 | [Valve Protocol](#valve)                         |
| rdr2r                | Red Dead Redemption 2 - RedM                     |                                                  |
| redline              | Redline                                          |                                                  |
| redorchestra         | Red Orchestra                                    |                                                  |
| redorchestra2        | Red Orchestra 2                                  | [Valve Protocol](#valve)                         |
| renegade10           | Renegade X                                       |                                                  |
| renown               | Renown                                           | [EOS Protocol](#epic)                            |
| rfactor              | rFactor                                          |                                                  |
| rfactor2             | rFactor 2                                        | [Valve Protocol](#valve)                         |
| ricochet             | Ricochet                                         | [Valve Protocol](#valve)                         |
| risingworld          | Rising World                                     | [Valve Protocol](#valve)                         |
| ron                  | Rise of Nations                                  |                                                  |
| roo4145              | Red Orchestra: Ostfront 41-45                    |                                                  |
| ror2                 | Risk of Rain 2                                   | [Valve Protocol](#valve)                         |
| rs2rs                | Rainbow Six 2: Rogue Spear                       |                                                  |
| rs2v                 | Rising Storm 2: Vietnam                          | [Valve Protocol](#valve)                         |
| rs3rs                | Rainbow Six 3: Raven Shield                      |                                                  |
| rtcw                 | Return to Castle Wolfenstein                     |                                                  |
| rune                 | Rune                                             |                                                  |
| rust                 | Rust                                             | [Valve Protocol](#valve)                         |
| s2ats                | Savage 2: A Tortured Soul                        |                                                  |
| satisfactory         | Satisfactory                                     | [Notes](#satisfactory)                           |
| sdtd                 | 7 Days to Die                                    | [Notes](#sdtd), [Valve Protocol](#valve)         |
| serioussam           | Serious Sam                                      |                                                  |
| serioussam2          | Serious Sam 2                                    |                                                  |
| shatteredhorizon     | Shattered Horizon                                | [Valve Protocol](#valve)                         |
| shogo                | Shogo                                            |                                                  |
| shootmania           | Shootmania                                       | [Notes](#nadeo)                                  |
| sin                  | SiN                                              |                                                  |
| sinepisodes          | SiN Episodes                                     | [Valve Protocol](#valve)                         |
| sof                  | Soldier of Fortune                               |                                                  |
| sof2                 | Soldier of Fortune 2                             |                                                  |
| soldat               | Soldat                                           | [Notes](#soldat)                                 |
| sotf                 | Sons Of The Forest                               | [Valve Protocol](#valve)                         |
| soulmask             | Soulmask                                         | [Valve Protocol](#valve)                         |
| spaceengineers       | Space Engineers                                  | [Valve Protocol](#valve)                         |
| squad                | Squad                                            | [EOS Protocol](#epic)                            |
| ssl                  | SCP: Secret Labratory                            | [Notes](#ssl)                                    |
| sstse                | Serious Sam: The Second Encounter                |                                                  |
| stalker              | S.T.A.L.K.E.R.                                   |                                                  |
| starbound            | Starbound                                        | [Valve Protocol](#valve)                         |
| starmade             | StarMade                                         |                                                  |
| starsiege            | Starsiege                                        |                                                  |
| stbc                 | Star Trek: Bridge Commander                      |                                                  |
| stn                  | Survive the Nights                               | [Valve Protocol](#valve)                         |
| stvef                | Star Trek: Voyager - Elite Force                 |                                                  |
| stvef2               | Star Trek: Voyager - Elite Force 2               |                                                  |
| suicidesurvival      | Suicide Survival                                 | [Valve Protocol](#valve)                         |
| svencoop             | Sven Coop                                        | [Valve Protocol](#valve)                         |
| swat4                | SWAT 4                                           |                                                  |
| swb                  | Star Wars: Battlefront                           |                                                  |
| swb2                 | Star Wars: Battlefront 2                         |                                                  |
| swjk2jo              | Star Wars Jedi Knight II: Jedi Outcast           |                                                  |
| swjkja               | Star Wars Jedi Knight: Jedi Academy              |                                                  |
| swrc                 | Star Wars: Republic Commando                     |                                                  |
| synergy              | Synergy                                          | [Valve Protocol](#valve)                         |
| t1s                  | Tribes 1: Starsiege                              |                                                  |
| tacticalops          | Tactical Ops                                     |                                                  |
| tcgraw               | Tom Clancy's Ghost Recon Advanced Warfighter     |                                                  |
| tcgraw2              | Tom Clancy's Ghost Recon Advanced Warfighter 2   |                                                  |
| teamfactor           | Team Factor                                      |                                                  |
| teamfortress2        | Team Fortress 2                                  | [Valve Protocol](#valve)                         |
| teamspeak2           | Teamspeak 2                                      |                                                  |
| teamspeak3           | Teamspeak 3                                      | [Notes](#teamspeak3)                             |
| terminus             | Terminus                                         |                                                  |
| terrariatshock       | Terraria - TShock                                | [Notes](#terraria)                               |
| tfc                  | Team Fortress Classic                            | [Valve Protocol](#valve)                         |
| theforest            | The Forest                                       | [Valve Protocol](#valve)                         |
| thefront             | The Front                                        | [Valve Protocol](#valve)                         |
| thehidden            | The Hidden                                       | [Valve Protocol](#valve)                         |
| theisle              | The Isle                                         | [Valve Protocol](#valve)                         |
| theship              | The Ship                                         | [Valve Protocol](#valve)                         |
| thespecialists       | The Specialists                                  | [Valve Protocol](#valve)                         |
| thps3                | Tony Hawk's Pro Skater 3                         |                                                  |
| thps4                | Tony Hawk's Pro Skater 4                         |                                                  |
| thu2                 | Tony Hawk's Underground 2                        |                                                  |
| tie                  | The Isle Evrima                                  | [EOS Protocol](#epic)                            |
| toh                  | Take On Helicopters                              |                                                  |
| tonolf               | The Operative: No One Lives Forever              |                                                  |
| towerunite           | Tower Unite                                      | [Valve Protocol](#valve)                         |
| toxikk               | TOXIKK                                           |                                                  |
| trackmania2          | Trackmania 2                                     | [Notes](#nadeo)                                  |
| trackmaniaforever    | Trackmania Forever                               | [Notes](#nadeo)                                  |
| tremulous            | Tremulous                                        |                                                  |
| tribesvengeance      | Tribes: Vengeance                                |                                                  |
| tron20               | Tron 2.0                                         |                                                  |
| turok2               | Turok 2                                          |                                                  |
| u2tax                | Unreal 2: The Awakening - XMP                    |                                                  |
| universalcombat      | Universal Combat                                 |                                                  |
| unreal               | Unreal                                           |                                                  |
| unrealtournament     | Unreal Tournament                                |                                                  |
| unrealtournament2003 | Unreal Tournament 2003                           |                                                  |
| unrealtournament2004 | Unreal Tournament 2004                           |                                                  |
| unrealtournament3    | Unreal Tournament 3                              |                                                  |
| unturned             | unturned                                         | [Valve Protocol](#valve)                         |
| urbanterror          | Urban Terror                                     |                                                  |
| v8sc                 | V8 Supercar Challenge                            |                                                  |
| valheim              | Valheim                                          | [Notes](#valheim), [Valve Protocol](#valve)      |
| vampireslayer        | Vampire Slayer                                   | [Valve Protocol](#valve)                         |
| vcm                  | Vice City Multiplayer                            |                                                  |
| ventrilo             | Ventrilo                                         |                                                  |
| vietcong             | Vietcong                                         |                                                  |
| vietcong2            | Vietcong 2                                       |                                                  |
| vintagestory         | Vintage Story                                    |                                                  |
| vrising              | V Rising                                         | [Valve Protocol](#valve)                         |
| warfork              | Warfork                                          |                                                  |
| warsow               | Warsow                                           |                                                  |
| wet                  | Wolfenstein: Enemy Territory                     |                                                  |
| wolfenstein          | Wolfenstein                                      |                                                  |
| wop                  | World Of Padman                                  |                                                  |
| wot                  | Wheel of Time                                    |                                                  |
| wurmunlimited        | Wurm Unlimited                                   | [Valve Protocol](#valve)                         |
| xonotic              | Xonotic                                          |                                                  |
| xpandrally           | Xpand Rally                                      |                                                  |
| zombiemaster         | Zombie Master                                    | [Valve Protocol](#valve)                         |
| zps                  | Zombie Panic: Source                             | [Valve Protocol](#valve)                         |
<!--- END GENERATED GAMES -->

### Not supported (yet)

* Cube Engine (cube):
    * Cube 1
    * Assault Cube
    * Cube 2: Sauerbraten
    * Blood Frontier
* BFRIS
* Call of Duty: Black Ops 1 and 2 (no documentation, may require rcon)
* Crysis Warhead
* DirtyBomb
* Doom - Skulltag
* Doom - ZDaemon
* Freelancer
* Ghost Recon
* GRAV Online
* GTA Network ([Ref](https://github.com/Austinb/GameQ/blob/v3/src/GameQ/Protocols/Gtan.php))
* GTR 2
* Haze
* Hexen World
* Last Oasis (#248, #446, #352)
* Lost Heaven
* Multi Theft Auto
* Pariah
* Plain Sight
* Purge Jihad
* Red Eclipse
* Red Faction
* S.T.A.L.K.E.R. Clear Sky
* Savage: The Battle For Newerth
* SiN 1 Multiplayer
* South Park
* Star Wars Jedi Knight: Dark Forces II
* Star Wars: X-Wing Alliance
* Sum of All Fears
* Teeworlds
* Tibia ([Ref](https://github.com/Austinb/GameQ/blob/v3/src/GameQ/Protocols/Tibia.php))
* Titanfall
* Tribes 2
* World in Conflict
* World Opponent Network

> Want support for one of these games? Please open an issue to show your interest!
> __Know how to code?__ Protocol details for many of the games above are documented
> at https://github.com/gamedig/legacy-query-library-archive
> , ready for you to develop into GameDig!

> Don't see your game listed here?
>
> First, let us know, so we can fix it. Then, you can try using some common query
> protocols directly from the [protocols folder](/protocols). We also have a little tool
> that could come in handy, [attempt protocols](/tools/attempt_protocols.js)

Games with Additional Notes
---

### <a name="csgo"></a>Counter-Strike: Global Offensive
To receive a full player list response from CS:GO servers, the server must
have set the cvar: host_players_show 2

### <a name="discord"></a> Discord
You must set the `guildId` request field to the server's guild ID. Do not provide an IP.
The Guild ID can be found in server widget settings (Server ID) or by enabling developer mode in client settings and right-clicking the server's icon.
In order to retrieve information from discord server's they must have the `Enable server widget` option enabled.

### <a name="mumble"></a> Mumble
For full query results from Mumble, you must be running the
[GTmurmur plugin](http://www.gametracker.com/downloads/gtmurmurplugin.php).
If you do not wish to run the plugin, or do not require details such as channel and user lists,
you can use the 'mumbleping' server type instead, which uses a less accurate but more reliable solution

### <a name="nadeo"></a> Nadeo (ShootMania / TrackMania / etc)
The server must have `xmlrpc` enabled, the port needs to be the `xmlrpc` one, not the connection port.  
You must also pass the info of a user account on the server with the access level of **User** or higher
in the options parameters as `login` and `password`.

### <a name="gta5r"></a> Grand Theft Auto V - RAGE MP
If you are using a FQDN for your server, you will need to set the host parameter to be this domain e.g. rage2.mydomain.com
This is due to how the Rage MP master server works with server ids as the ip is only used in the ID if no FQDN is provided.

### <a name="gta5am"></a> Grand Theft Auto V - alt:V Multiplayer
When querying a server on alt:V Multiplayer, you have two options for querying the server:
1. Setting the `serverId` request field or `--serverId` when using the cli to the publicId of the server.
2. Passing the `host` and `port` request fields or `--host` and `--port` when using the cli to the server.

If you are using the second option and the server is using a `useCdn` option in the alt:V server config file, you will need to set `host` to the CDN address, and the `port` to the cdn port. As an example, if the server cdn url was `connect.altv.com:443`, you would set the host to `connect.altv.com` and port to `443`.

### <a name="teamspeak3"></a>TeamSpeak 3
For teamspeak 3 queries to work correctly, the following permissions must be available for the guest server group:

* Virtual Server
* b_virtualserver_info_view
* b_virtualserver_channel_list
* b_virtualserver_client_list
* Group
* b_virtualserver_servergroup_list
* b_virtualserver_channelgroup_list

In the extremely unusual case that your server host responds to queries on a non-default port (the default is 10011),
you can specify their host query port using the teamspeakQueryPort option.

### <a name="terraria"></a>Terraria
Requires tshock server mod, and a REST user token, which can be passed to GameDig with the
additional option: `token`

### <a name="valheim"></a>Valheim
Valheim servers will only respond to queries if they are started in public mode (`-public 1`).  
Crossplay servers report `numplayers` always being `0`, servers without this option work as expected ([#539](https://github.com/gamedig/node-gamedig/issues/539)).

### <a name="dayz"></a>DayZ
DayZ stores some of it's servers information inside the `tags` attribute. Make sure to set `requestRules: true` to access it. Some data inside `dayzMods` attribute may be fuzzy, due to how mods are loaded into the servers. Players can be fetched, but will not show ingame names. Alternatively, some servers may have a [third party tool](https://dayzsalauncher.com/#/tools) that you can use to get the mods information. If it's installed, you can access it via browser with the game servers IP:PORT, but add up 10 to the port. (eg. if game port is 2302 then use 2312).

### <a name="thefront"></a>The Front
Responses with wrong `name` (gives out a steamid instead of the server name) and `maxplayers` (always 200, whatever the config would be) field values.

### <a name="conanexiles"></a>Conan Exiles
Conan Exiles never responds to player query.

### <a name="minecraft"></a>Minecraft
Many Minecraft servers do not respond with players data.  
Beware that using this entry is quite slow as it attempts 3 protocols at a time (`minecraftvanilla`, `minecraftbedrock` and `gamespy3`) and waits for all the queries to finish.
If you know your use case, it's better to use a single protocol or make your own logic for attempting multiple ones.

### <a name='farmingsimulator'></a>Farming Simulator
Farming Simulator servers need a token (reffered as code in the game). It can be obtained at your server's web interface (http://ip:port/settings.html). It can be passed to GameDig with the additional option: `token`. It does only work for your own server.
The response includes much information about the server. Currently, only the fields about server information (name, map, version, etc.), players and mods are parsed.


### <a name='hawakening'></a>Hawakening
Querying server info for Hawakening requires a _ServerId_ to be passed to GameDig instead of an IP address. You can acquire such a _ServerId_ from the master query protocol _hawakeningmaster_ [type: `protocol-hawakeningmaster`] (see `raw.servers[]raw.listing.Guid`).

Additionally, the master server requires authorization. A **user profile is required** for querying the API. Such a profile can be created on the [_official page_](https://hawakening.com/enlist).

- Provide a Server Id via `serverId`
- Provide a client profile with `username` (email address, not callsign)

And one of the following options for gaining access:  
- Provide a client access token via the option `token`
- Provide the user profile password via the option `password`

> **_NOTE:_** The protocol `hawakening` will query additional server info by requesting a matchmaking _token_, which will fail for full servers. Due to this, the IP address and port cannot be queried for such servers.


### <a name='brokeprotocol'></a>BROKE PROTOCOL
When querying a server on [BROKE PROTOCOL](https://brokeprotocol.com/), you have two options for querying the server:
1. Passing the `address` and `port` request fields (or `--address` and `--port` when using the cli to the server).
2. Setting the `serverId` request field or `--serverId` when using the cli to the publicId of the server.

You can acquire a _ServerId_ from the master query protocol `protocol-brokeprotocolmaster` (see `raw.servers[].raw.id`).

### <a name='armareforger'></a>ARMA: Reforger
For queries to work, A2S needs to be setup in the server config, more info [here](https://community.bistudio.com/wiki/Arma_Reforger:Server_Config#a2s_2).

Does not provide players data.

Protocols with Additional Notes
---

### <a name="valve"></a>Valve Protocol
For many valve games, additional 'rules' may be fetched into the unstable `raw` field by passing the additional
option: `requestRules: true`. Beware that this may increase query time.

### <a name="epic"></a>Epic Online Services (EOS) Protocol
EOS does not provide players data.

### <a name="palworld"></a>Palworld
Palworld support can be unstable, the devs mention the api is currently experimental.  
To query Palworld servers, the `RESTAPIEnabled` setting must be `True` in the configuration file, and you need to pass the `username` (currently always `admin`) and the `adminpassword` (from the server config) as the `password` parameter.

### <a name="satisfactory"></a>Satisfactory
Satisfactory servers unless specified use self-signed certificates for the HTTPS API. If you are using proper-signed certificates you will need to set the `rejectUnauthorized` flag in options to `true` to ensure a secured query.
For more information on setting a user certificate refer to the [Satisfactory Dedicated server/HTTPS API wiki documentation](https://satisfactory.wiki.gg/wiki/Dedicated_servers/HTTPS_API).

One can also provide an authentication token via the `token` option to skip the `PasswordlessLogin` query.

The query is done via the lightweight query option but also safely tries to utilize the HTTP one.

### <a name="soldat"></a>Soldat
Requires `Allow_Download` and `Logging` to be `1` in the server config.

### <a name="gta5f"></a>Grand Theft Auto V - FiveM
Requires the `sv_exposePlayerIdentifiersInHttpEndpoint` convar to be `1` for the query to return players' data.

### <a name="cs2"></a>Counter-Strike 2
Does not provide players names, using a plugin like this [one](https://github.com/Source2ZE/ServerListPlayersFix) makes the query to return them.

### <a name="aosc-buildandshoot"></a>Ace of Spades / Build and Shoot
Requires usage of the status query server enabled in the config.txt. `status_server.enabled` to `true`

### <a name="sdtd"></a>7 Days to Die
Does not provide player names but can be provided via telnet commands, to use these make sure in `serverconfig.xml` you
have configured `TelnetEnabled` to `true`, `TelnetPort` and `TelnetPassword` and pass `telnetPort` and `telnetPassword`
to the query parameters.

To fetch more info via telnet (game and mods versions, date and time), at the cost of a longer query time, set `moreData` to `true`.

### <a name="ssl"></a>SCP: Secret Laboratory
Unfortunately, only verified servers can be queried, for this you'd need a `accountId`, an `apiKey` and `serverId`
(this optional, not providing this just returns the server list associated with the account in the raw object).

