export const games = {
  abioticfactor: {
    name: 'Abiotic Factor',
    release_year: 2024,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  actionsource: {
    name: 'Action: Source',
    release_year: 2019,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'as'
    }
  },
  ahl: {
    name: 'Action Half-Life',
    release_year: 2009,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  aoc: {
    name: 'Age of Chivalry',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'ageofchivalry'
    }
  },
  aoe2: {
    name: 'Age of Empires 2',
    release_year: 2009,
    options: {
      port_query: 27224,
      protocol: 'ase'
    }
  },
  alienarena: {
    name: 'Alien Arena',
    release_year: 2004,
    options: {
      port_query: 27910,
      protocol: 'quake2'
    }
  },
  alienswarm: {
    name: 'Alien Swarm',
    release_year: 2004,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  ase: {
    name: 'Ark: Survival Evolved',
    release_year: 2017,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'arkse'
    }
  },
  asa: {
    name: 'Ark: Survival Ascended',
    release_year: 2023,
    options: {
      port: 7777,
      protocol: 'asa'
    }
  },
  assettocorsa: {
    name: 'Assetto Corsa',
    release_year: 2014,
    options: {
      port: 9610,
      protocol: 'assettocorsa'
    }
  },
  atlas: {
    name: 'Atlas',
    release_year: 2018,
    options: {
      port: 5761,
      port_query_offset: 51800,
      protocol: 'valve'
    }
  },
  avorion: {
    name: 'Avorion',
    release_year: 2020,
    options: {
      port: 27000,
      port_query_offset: 20,
      protocol: 'valve'
    }
  },
  avp2: {
    name: 'Aliens versus Predator 2',
    release_year: 2001,
    options: {
      port: 27888,
      protocol: 'gamespy1'
    }
  },
  avp2010: {
    name: 'Aliens vs. Predator 2010',
    release_year: 2010,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  americasarmy: {
    name: "America's Army",
    release_year: 2002,
    options: {
      port: 1716,
      port_query_offset: 1,
      protocol: 'gamespy2'
    }
  },
  americasarmy2: {
    name: "America's Army 2",
    release_year: 2003,
    options: {
      port: 1716,
      port_query_offset: 1,
      protocol: 'gamespy2'
    }
  },
  americasarmy3: {
    name: "America's Army 3",
    release_year: 2009,
    options: {
      port: 8777,
      port_query: 27020,
      protocol: 'valve'
    }
  },
  aapg: {
    name: "America's Army: Proving Grounds",
    release_year: 2015,
    options: {
      port: 8777,
      port_query: 27020,
      protocol: 'valve'
    },
    extra: {
      old_id: 'americasarmypg'
    }
  },
  asr08: {
    name: "Arca Sim Racing '08",
    release_year: 2008,
    options: {
      port: 34397,
      port_query_offset: -100,
      protocol: 'rfactor'
    },
    extra: {
      old_id: 'arcasimracing'
    }
  },
  aaa: {
    name: 'ARMA: Armed Assault',
    release_year: 2006,
    options: {
      port: 2302,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'arma'
    }
  },
  arma2: {
    name: 'ARMA 2',
    release_year: 2009,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  a2oa: {
    name: 'ARMA 2: Operation Arrowhead',
    release_year: 2010,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'arma2oa'
    }
  },
  acwa: {
    name: 'ARMA: Cold War Assault',
    release_year: 2011,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'armacwa'
    }
  },
  armaresistance: {
    name: 'ARMA: Resistance',
    release_year: 2011,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'armar'
    }
  },
  arma3: {
    name: 'ARMA 3',
    release_year: 2013,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  armareforger: {
    name: 'ARMA: Reforger',
    release_year: 2022,
    options: {
      port: 2001,
      port_query: 17777,
      protocol: 'valve'
    },
    extra: {
      old_id: 'armare',
      doc_notes: 'armareforger'
    }
  },
  armagetronadvanced: {
    name: 'Armagetron Advanced',
    release_year: 2001,
    options: {
      port: 4534,
      protocol: 'armagetron'
    },
    extra: {
      old_id: 'armagetron'
    }
  },
  baldursgate: {
    name: "Baldur's Gate",
    release_year: 1998,
    options: {
      port: 6073,
      port_query: 1470,
      protocol: 'gamespy1'
    }
  },
  ballisticoverkill: {
    name: 'Ballistic Overkill',
    release_year: 2017,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  barotrauma: {
    name: 'Barotrauma',
    release_year: 2019,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  battalion1944: {
    name: 'Battalion 1944',
    release_year: 2018,
    options: {
      port: 7777,
      port_query_offset: 3,
      protocol: 'valve'
    },
    extra: {
      old_id: 'bat1944'
    }
  },
  beammp: {
    name: 'BeamMP (2021)',
    options: {
      port: 30814,
      protocol: 'beammp'
    }
  },
  battlefield1942: {
    name: 'Battlefield 1942',
    release_year: 2002,
    options: {
      port: 14567,
      port_query: 23000,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'bf1942'
    }
  },
  battlefieldvietnam: {
    name: 'Battlefield Vietnam',
    release_year: 2004,
    options: {
      port: 15567,
      port_query: 23000,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'bfv'
    }
  },
  battlefield2: {
    name: 'Battlefield 2',
    release_year: 2005,
    options: {
      port: 16567,
      port_query: 29900,
      protocol: 'gamespy3'
    },
    extra: {
      old_id: 'bf2'
    }
  },
  battlefield2142: {
    name: 'Battlefield 2142',
    release_year: 2006,
    options: {
      port: 16567,
      port_query: 29900,
      protocol: 'gamespy3'
    },
    extra: {
      old_id: 'bf2142'
    }
  },
  bbc2: {
    name: 'Battlefield: Bad Company 2',
    release_year: 2010,
    options: {
      port: 19567,
      port_query: 48888,
      protocol: 'battlefield'
    },
    extra: {
      old_id: 'bfbc2'
    }
  },
  battlefield3: {
    name: 'Battlefield 3',
    release_year: 2011,
    options: {
      port: 25200,
      port_query_offset: 22000,
      protocol: 'battlefield'
    },
    extra: {
      old_id: 'bf3'
    }
  },
  battlefield4: {
    name: 'Battlefield 4',
    release_year: 2013,
    options: {
      port: 25200,
      port_query_offset: 22000,
      protocol: 'battlefield'
    },
    extra: {
      old_id: 'bf4'
    }
  },
  battlefieldhardline: {
    name: 'Battlefield Hardline',
    release_year: 2015,
    options: {
      port: 25200,
      port_query_offset: 22000,
      protocol: 'battlefield'
    },
    extra: {
      old_id: 'bfh'
    }
  },
  blackmesa: {
    name: 'Black Mesa',
    release_year: 2020,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  brainbread2: {
    name: 'BrainBread 2',
    release_year: 2022,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  brainbread: {
    name: 'BrainBread',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  breach: {
    name: 'Breach',
    release_year: 2011,
    options: {
      port: 27016,
      protocol: 'valve'
    }
  },
  breed: {
    name: 'Breed',
    release_year: 2004,
    options: {
      port: 7649,
      protocol: 'gamespy2'
    }
  },
  brink: {
    name: 'Brink',
    release_year: 2011,
    options: {
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  brokeprotocol: {
    name: 'BROKE PROTOCOL',
    release_year: 2024,
    options: {
      protocol: 'brokeprotocol'
    },
    extra: {
      doc_notes: 'brokeprotocol'
    }
  },
  basedefense: {
    name: 'Base Defense',
    release_year: 2017,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'bd'
    }
  },
  bladesymphony: {
    name: 'Blade Symphony',
    release_year: 2014,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'bs'
    }
  },
  bas: {
    name: 'Build and Shoot',
    release_year: 2012,
    options: {
      port: 32887,
      port_query_offset: -1,
      protocol: 'buildandshoot'
    },
    extra: {
      old_id: 'buildandshoot',
      doc_notes: 'aosc-buildandshoot'
    }
  },
  aosc: {
    name: 'Ace of Spades Classic',
    release_year: 2012,
    options: {
      port: 32887,
      port_query_offset: -1,
      protocol: 'buildandshoot'
    },
    extra: {
      doc_notes: 'aosc-buildandshoot'
    }
  },
  cbu: {
    name: "Clive Barker's Undying",
    release_year: 2002,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  cod: {
    name: 'Call of Duty',
    release_year: 2003,
    options: {
      port: 28960,
      protocol: 'quake3'
    }
  },
  coduo: {
    name: 'Call of Duty: United Offensive',
    release_year: 2004,
    options: {
      port: 28960,
      protocol: 'quake3'
    }
  },
  cod2: {
    name: 'Call of Duty 2',
    release_year: 2005,
    options: {
      port: 28960,
      protocol: 'quake3'
    }
  },
  cod3: {
    name: 'Call of Duty 3',
    release_year: 2006,
    options: {
      port: 28960,
      protocol: 'quake3'
    }
  },
  cod4mw: {
    name: 'Call of Duty 4: Modern Warfare',
    release_year: 2007,
    options: {
      port: 28960,
      protocol: 'quake3'
    },
    extra: {
      old_id: 'cod4'
    }
  },
  codbo3: {
    name: 'Call of Duty: Black Ops 3',
    release_year: 2015,
    options: {
      port: 27017,
      protocol: 'valve'
    }
  },
  codwaw: {
    name: 'Call of Duty: World at War',
    release_year: 2008,
    options: {
      port: 28960,
      protocol: 'quake3'
    }
  },
  codmw2: {
    name: 'Call of Duty: Modern Warfare 2',
    release_year: 2009,
    options: {
      port: 28960,
      protocol: 'quake3'
    }
  },
  codmw3: {
    name: 'Call of Duty: Modern Warfare 3',
    release_year: 2011,
    options: {
      port_query_offset: 2,
      protocol: 'valve'
    }
  },
  coj: {
    name: 'Call of Juarez',
    release_year: 2006,
    options: {
      port_query: 26000,
      protocol: 'ase'
    },
    extra: {
      old_id: 'callofjuarez'
    }
  },
  chaser: {
    name: 'Chaser',
    release_year: 2003,
    options: {
      port: 3000,
      port_query_offset: 123,
      protocol: 'ase'
    }
  },
  cmw: {
    name: 'Chivalry: Medieval Warfare',
    release_year: 2012,
    options: {
      port: 7777,
      port_query_offset: 2,
      protocol: 'valve'
    },
    extra: {
      old_id: 'chivalry'
    }
  },
  chrome: {
    name: 'Chrome',
    release_year: 2003,
    options: {
      port: 27015,
      port_query_offset: 123,
      protocol: 'ase'
    }
  },
  codenamecure: {
    name: 'Codename CURE',
    release_year: 2017,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  codenameeagle: {
    name: 'Codename Eagle',
    release_year: 2000,
    options: {
      port_query: 4711,
      protocol: 'gamespy1'
    }
  },
  colonysurvival: {
    name: 'Colony Survival',
    release_year: 2017,
    options: {
      port: 27004,
      protocol: 'valve'
    }
  },
  c3db: {
    name: 'Commandos 3: Destination Berlin',
    release_year: 2003,
    options: {
      port_query: 6500,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'commandos3'
    }
  },
  cacr: {
    name: 'Command and Conquer: Renegade',
    release_year: 2002,
    options: {
      port: 4848,
      port_query: 25300,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'cacrenegade'
    }
  },
  conanexiles: {
    name: 'Conan Exiles',
    release_year: 2018,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    },
    extra: {
      doc_notes: 'conanexiles'
    }
  },
  contagion: {
    name: 'Contagion',
    release_year: 2011,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  contractjack: {
    name: 'Contract J.A.C.K.',
    release_year: 2003,
    options: {
      port_query: 27888,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'contactjack'
    }
  },
  corekeeper: {
    name: 'Core Keeper',
    release_year: 2022,
    options: {
      port: 1234,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  counterstrike15: {
    name: 'Counter-Strike 1.5',
    release_year: 2002,
    options: {
      port: 27015,
      protocol: 'goldsrc'
    },
    extra: {
      old_id: 'cs15'
    }
  },
  counterstrike16: {
    name: 'Counter-Strike 1.6',
    release_year: 2003,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'cs16'
    }
  },
  c2d: {
    name: 'CS2D',
    release_year: 2004,
    options: {
      port: 36963,
      protocol: 'cs2d'
    },
    extra: {
      old_id: 'cs2d'
    }
  },
  cscz: {
    name: 'Counter-Strike: Condition Zero',
    release_year: 2004,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  css: {
    name: 'Counter-Strike: Source',
    release_year: 2004,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  csgo: {
    name: 'Counter-Strike: Global Offensive',
    release_year: 2012,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      doc_notes: 'csgo'
    }
  },
  counterstrike2: {
    name: 'Counter-Strike 2',
    release_year: 2023,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'cs2',
      doc_notes: 'cs2'
    }
  },
  creativerse: {
    name: 'Creativerse',
    release_year: 2017,
    options: {
      port: 26900,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  crce: {
    name: 'Cross Racing Championship Extreme',
    release_year: 2005,
    options: {
      port: 12321,
      port_query_offset: 123,
      protocol: 'ase'
    },
    extra: {
      old_id: 'crossracing'
    }
  },
  crysis: {
    name: 'Crysis',
    release_year: 2007,
    options: {
      port: 64087,
      protocol: 'gamespy3'
    }
  },
  crysiswars: {
    name: 'Crysis Wars',
    release_year: 2008,
    options: {
      port: 64100,
      protocol: 'gamespy3'
    }
  },
  crysis2: {
    name: 'Crysis 2',
    release_year: 2011,
    options: {
      port: 64000,
      protocol: 'gamespy3'
    }
  },
  dab: {
    name: 'Double Action: Boogaloo',
    release_year: 2014,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  daikatana: {
    name: 'Daikatana',
    release_year: 2000,
    options: {
      port: 27982,
      port_query_offset: 10,
      protocol: 'quake2'
    }
  },
  dmomam: {
    name: 'Dark Messiah of Might and Magic',
    release_year: 2006,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  dhe4445: {
    name: "Darkest Hour: Europe '44-'45",
    release_year: 2008,
    options: {
      port: 7757,
      port_query_offset: 1,
      protocol: 'unreal2'
    },
    extra: {
      old_id: 'darkesthour'
    }
  },
  dayofdragons: {
    name: 'Day of Dragons',
    release_year: 2019,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    }
  },
  dow: {
    name: 'Days of War',
    release_year: 2017,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'daysofwar'
    }
  },
  dayz: {
    name: 'DayZ',
    release_year: 2018,
    options: {
      port: 2302,
      port_query_offset: 24714,
      protocol: 'dayz'
    },
    extra: {
      doc_notes: 'dayz'
    }
  },
  dayzmod: {
    name: 'DayZ Mod',
    release_year: 2013,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  ddpt: {
    name: 'Deadly Dozen: Pacific Theater',
    release_year: 2002,
    options: {
      port_query: 25300,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'deadlydozenpt'
    }
  },
  deerhunter2005: {
    name: 'Deer Hunter 2005',
    release_year: 2004,
    options: {
      port: 23459,
      port_query: 34567,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'dh2005'
    }
  },
  descent3: {
    name: 'Descent 3',
    release_year: 1999,
    options: {
      port: 2092,
      port_query: 20142,
      protocol: 'gamespy1'
    }
  },
  deusex: {
    name: 'Deus Ex',
    release_year: 2000,
    options: {
      port: 7791,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  devastation: {
    name: 'Devastation',
    release_year: 2003,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'unreal2'
    }
  },
  ddd: {
    name: 'Dino D-Day',
    release_year: 2011,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'dinodday'
    }
  },
  dtr2: {
    name: 'Dirt Track Racing 2',
    release_year: 2002,
    options: {
      port: 32240,
      port_query_offset: -100,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'dirttrackracing2'
    }
  },
  discord: {
    name: 'Discord',
    release_year: 2015,
    options: {
      protocol: 'discord'
    },
    extra: {
      doc_notes: 'discord'
    }
  },
  deathmatchclassic: {
    name: 'Deathmatch Classic',
    release_year: 2001,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'dmc'
    }
  },
  dal: {
    name: 'Dark and Light',
    release_year: 2017,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'dnl'
    }
  },
  dnf2001: {
    name: 'Duke Nukem Forever 2001',
    release_year: 2022,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  dod: {
    name: 'Day of Defeat',
    release_year: 2003,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  dods: {
    name: 'Day of Defeat: Source',
    release_year: 2005,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  doi: {
    name: 'Day of Infamy',
    release_year: 2017,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  doom3: {
    name: 'Doom 3',
    release_year: 2004,
    options: {
      port: 27666,
      protocol: 'doom3'
    }
  },
  dota2: {
    name: 'Dota 2',
    release_year: 2013,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  dootf: {
    name: 'Drakan: Order of the Flame',
    release_year: 1999,
    options: {
      port: 27045,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'drakan'
    }
  },
  dst: {
    name: "Don't Starve Together",
    release_year: 2016,
    options: {
      port: 10999,
      port_query: 27016,
      protocol: 'valve'
    }
  },
  dystopia: {
    name: 'Dystopia',
    release_year: 2005,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'dys'
    }
  },
  eco: {
    name: 'Eco',
    release_year: 2018,
    options: {
      port: 3000,
      port_query_offset: 1,
      protocol: 'eco'
    }
  },
  eldewrito: {
    name: 'Halo Online - ElDewrito',
    options: {
      port: 11775,
      protocol: 'eldewrito'
    }
  },
  empiresmod: {
    name: 'Empires Mod',
    release_year: 2008,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'em'
    }
  },
  egs: {
    name: 'Empyrion - Galactic Survival',
    release_year: 2015,
    options: {
      port: 30000,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'empyrion'
    }
  },
  enshrouded: {
    name: 'enshrouded',
    release_year: 2024,
    options: {
      port: 15636,
      port_query: 15637,
      protocol: 'valve'
    }
  },
  etqw: {
    name: 'Enemy Territory: Quake Wars',
    release_year: 2007,
    options: {
      port: 3074,
      port_query: 27733,
      protocol: 'doom3'
    }
  },
  ets2: {
    name: 'Euro Truck Simulator 2',
    release_year: 2012,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  exfil: {
    name: 'Exfil',
    release_year: 2024,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    }
  },
  fear: {
    name: 'F.E.A.R.',
    release_year: 2005,
    options: {
      port_query: 27888,
      protocol: 'gamespy2'
    }
  },
  formulaone2002: {
    name: 'Formula One 2002',
    release_year: 2002,
    options: {
      port_query: 3297,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'f12002'
    }
  },
  f1c9902: {
    name: "F1 Challenge '99-'02",
    release_year: 2002,
    options: {
      port_query: 34397,
      protocol: 'gamespy1'
    }
  },
  factorio: {
    name: 'Factorio',
    release_year: 2016,
    options: {
      port_query: 34197,
      protocol: 'factorio'
    }
  },
  farcry: {
    name: 'Far Cry',
    release_year: 2004,
    options: {
      port: 49001,
      port_query_offset: 123,
      protocol: 'ase'
    }
  },
  farcry2: {
    name: 'Far Cry 2',
    release_year: 2008,
    options: {
      port_query: 14001,
      protocol: 'ase'
    }
  },
  farmingsimulator19: {
    name: 'Farming Simulator 19',
    release_year: 2018,
    options: {
      port: 8080,
      protocol: 'farmingsimulator'
    }
  },
  farmingsimulator22: {
    name: 'Farming Simulator 22',
    release_year: 2021,
    options: {
      port: 8080,
      protocol: 'farmingsimulator'
    }
  },
  farmingsimulator25: {
    name: 'Farming Simulator 25',
    release_year: 2024,
    options: {
      port: 8080,
      protocol: 'farmingsimulator'
    }
  },
  fof: {
    name: 'Fistful of Frags',
    release_year: 2014,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  foundry: {
    name: 'FOUNDRY',
    release_year: 2024,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  fortressforever: {
    name: 'Fortress Forever',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  ofcwc: {
    name: 'Operation Flashpoint: Cold War Crisis',
    release_year: 2001,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  ofr: {
    name: 'Operation Flashpoint: Resistance',
    release_year: 2002,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'flashpointresistance'
    }
  },
  ffow: {
    name: 'Frontlines: Fuel of War',
    release_year: 2008,
    options: {
      port: 5476,
      port_query_offset: 2,
      protocol: 'ffow'
    }
  },
  gta5f: {
    name: 'Grand Theft Auto V - FiveM',
    release_year: 2013,
    options: {
      port: 30120,
      protocol: 'fivem'
    },
    extra: {
      old_id: 'fivem',
      doc_notes: 'gta5f'
    }
  },
  gta5r: {
    name: 'Grand Theft Auto V - RageMP',
    release_year: 2016,
    options: {
      port: 22005,
      protocol: 'ragemp'
    },
    extra: {
      doc_notes: 'gta5r'
    }
  },
  gta5am: {
    name: 'Grand Theft Auto V - alt:V Multiplayer',
    release_year: 2015,
    options: {
      port: 7788,
      protocol: 'altvmp'
    },
    extra: {
      doc_notes: 'gta5am',
      old_id: 'gta5a'
    }
  },
  garrysmod: {
    name: "Garry's Mod",
    release_year: 2004,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  tcgraw: {
    name: "Tom Clancy's Ghost Recon Advanced Warfighter",
    release_year: 2006,
    options: {
      port_query: 15250,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'graw'
    }
  },
  tcgraw2: {
    name: "Tom Clancy's Ghost Recon Advanced Warfighter 2",
    release_year: 2007,
    options: {
      port_query: 16250,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'graw2'
    }
  },
  gck: {
    name: 'Giants: Citizen Kabuto',
    release_year: 2000,
    options: {
      port_query: 8911,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'giantscitizenkabuto'
    }
  },
  globaloperations: {
    name: 'Global Operations',
    release_year: 2002,
    options: {
      port_query: 28672,
      protocol: 'gamespy1'
    }
  },
  geneshift: {
    name: 'Geneshift',
    release_year: 2017,
    options: {
      port: 11235,
      protocol: 'geneshift'
    }
  },
  goldeneyesource: {
    name: 'GoldenEye: Source',
    release_year: 2010,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'ges'
    }
  },
  gus: {
    name: 'Gore: Ultimate Soldier',
    release_year: 2002,
    options: {
      port: 27777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'gore'
    }
  },
  groundbreach: {
    name: 'Ground Breach',
    release_year: 2018,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  gunmanchronicles: {
    name: 'Gunman Chronicles',
    release_year: 2000,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  hld: {
    name: 'Half-Life Deathmatch',
    release_year: 1998,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'hldm'
    }
  },
  hlds: {
    name: 'Half-Life Deathmatch: Source',
    release_year: 2005,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'hldms'
    }
  },
  hlof: {
    name: 'Half-Life: Opposing Force',
    release_year: 1999,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'hlopfor'
    }
  },
  hl2d: {
    name: 'Half-Life 2: Deathmatch',
    release_year: 2004,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'hl2dm'
    }
  },
  halo: {
    name: 'Halo',
    release_year: 2003,
    options: {
      port: 2302,
      protocol: 'gamespy2'
    }
  },
  halo2: {
    name: 'Halo 2',
    release_year: 2007,
    options: {
      port: 2302,
      protocol: 'gamespy2'
    }
  },
  hawakening: {
    name: 'Hawakening',
    release_year: 2024,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'hawakening'
    },
    extra: {
      doc_notes: 'hawakening'
    }
  },
  heretic2: {
    name: 'Heretic II',
    release_year: 1998,
    options: {
      port: 27900,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  hexen2: {
    name: 'Hexen II',
    release_year: 1997,
    options: {
      port: 26900,
      port_query_offset: 50,
      protocol: 'hexen2'
    }
  },
  thehidden: {
    name: 'The Hidden',
    release_year: 2005,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'hidden'
    }
  },
  hll: {
    name: 'Hell Let Loose',
    release_year: 2019,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  hiddendangerous2: {
    name: 'Hidden & Dangerous 2',
    release_year: 2003,
    options: {
      port: 11001,
      port_query_offset: 3,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'had2'
    }
  },
  homefront: {
    name: 'Homefront',
    release_year: 2011,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  homeworld2: {
    name: 'Homeworld 2',
    release_year: 2003,
    options: {
      port_query: 6500,
      protocol: 'gamespy1'
    }
  },
  hurtworld: {
    name: 'Hurtworld',
    release_year: 2015,
    options: {
      port: 12871,
      port_query: 12881,
      protocol: 'valve'
    }
  },
  i2cs: {
    name: 'IGI 2: Covert Strike',
    release_year: 2003,
    options: {
      port_query: 26001,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'igi2'
    }
  },
  i2s: {
    name: 'IL-2 Sturmovik',
    release_year: 2001,
    options: {
      port_query: 21000,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'il2'
    }
  },
  icarus: {
    name: 'Icarus',
    release_year: 2021,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  insurgency: {
    name: 'Insurgency',
    release_year: 2014,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  imic: {
    name: 'Insurgency: Modern Infantry Combat',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'insurgencymic'
    }
  },
  insurgencysandstorm: {
    name: 'Insurgency: Sandstorm',
    release_year: 2018,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  ironstorm: {
    name: 'Iron Storm',
    release_year: 2002,
    options: {
      port_query: 3505,
      protocol: 'gamespy1'
    }
  },
  theisle: {
    name: 'The Isle',
    release_year: 2015,
    options: {
      port: 7707,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'isle'
    }
  },
  tie: {
    name: 'The Isle Evrima',
    options: {
      port: 7777,
      protocol: 'theisleevrima'
    },
    release_year: 2020
  },
  jb0n: {
    name: 'James Bond 007: Nightfire',
    release_year: 2002,
    options: {
      port_query: 6550,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'jamesbondnightfire'
    }
  },
  jc2m: {
    name: 'Just Cause 2 - Multiplayer',
    release_year: 2010,
    options: {
      port: 7777,
      protocol: 'jc2mp'
    },
    extra: {
      old_id: 'jc2mp'
    }
  },
  jc3m: {
    name: 'Just Cause 3 - Multiplayer',
    release_year: 2017,
    options: {
      port: 4200,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'jc3mp'
    }
  },
  killingfloor: {
    name: 'Killing Floor',
    release_year: 2009,
    options: {
      port: 7707,
      port_query_offset: 1,
      protocol: 'unreal2'
    }
  },
  killingfloor2: {
    name: 'Killing Floor 2',
    release_year: 2016,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    }
  },
  kloc: {
    name: 'Kingpin: Life of Crime',
    release_year: 1999,
    options: {
      port: 31510,
      port_query_offset: -10,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'kingpin'
    }
  },
  kpctnc: {
    name: 'Kiss: Psycho Circus: The Nightmare Child',
    release_year: 2000,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'kisspc'
    }
  },
  kspd: {
    name: 'Kerbal Space Program - DMP',
    release_year: 2015,
    options: {
      port: 6702,
      port_query_offset: 1,
      protocol: 'kspdmp'
    },
    extra: {
      old_id: 'kspdmp'
    }
  },
  kreedzclimbing: {
    name: 'Kreedz Climbing',
    release_year: 2017,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'kzmod'
    }
  },
  l4d: {
    name: 'Left 4 Dead',
    release_year: 2008,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'left4dead'
    }
  },
  l4d2: {
    name: 'Left 4 Dead 2',
    release_year: 2009,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'left4dead2'
    }
  },
  m2m: {
    name: 'Mafia II - Multiplayer',
    release_year: 2010,
    options: {
      port: 27016,
      port_query_offset: 1,
      protocol: 'mafia2mp'
    },
    extra: {
      old_id: 'm2mp'
    }
  },
  m2o: {
    name: 'Mafia II - Online',
    release_year: 2010,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'mafia2online'
    }
  },
  medievalengineers: {
    name: 'Medieval Engineers',
    release_year: 2015,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  moe: {
    name: 'Myth of Empires',
    release_year: 2024,
    options: {
      port_query: 12888,
      protocol: 'valve'
    }
  },
  mohaa: {
    name: 'Medal of Honor: Allied Assault',
    release_year: 2002,
    options: {
      port: 12203,
      port_query_offset: 97,
      protocol: 'gamespy1'
    }
  },
  mohaas: {
    name: 'Medal of Honor: Allied Assault Spearhead',
    release_year: 2002,
    options: {
      port: 12203,
      port_query_offset: 97,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'mohsh'
    }
  },
  mohaab: {
    name: 'Medal of Honor: Allied Assault Breakthrough',
    release_year: 2003,
    options: {
      port: 12203,
      port_query_offset: 97,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'mohbt'
    }
  },
  mohpa: {
    name: 'Medal of Honor: Pacific Assault',
    release_year: 2004,
    options: {
      port: 13203,
      port_query_offset: 97,
      protocol: 'gamespy1'
    }
  },
  moha: {
    name: 'Medal of Honor: Airborne',
    release_year: 2007,
    options: {
      port: 12203,
      port_query_offset: 97,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'mohab'
    }
  },
  moh: {
    name: 'Medal of Honor',
    release_year: 2010,
    options: {
      port: 7673,
      port_query: 48888,
      protocol: 'battlefield'
    },
    extra: {
      old_id: 'moh2010'
    }
  },
  mohw: {
    name: 'Medal of Honor: Warfighter',
    release_year: 2012,
    options: {
      port: 25200,
      port_query_offset: 22000,
      protocol: 'battlefield'
    },
    extra: {
      old_id: 'mohwf'
    }
  },
  minecraft: {
    name: 'Minecraft',
    release_year: 2009,
    options: {
      port: 25565,
      protocol: 'minecraft'
    },
    extra: {
      doc_notes: 'minecraft'
    }
  },
  minetest: {
    name: 'Minetest',
    release_year: 2010,
    options: {
      port: 30000,
      protocol: 'minetest'
    }
  },
  mbe: {
    name: 'Minecraft: Bedrock Edition',
    release_year: 2011,
    options: {
      port: 19132,
      protocol: 'minecraft'
    },
    extra: {
      old_id: 'minecraftbe'
    }
  },
  mnc: {
    name: 'Monday Night Combat',
    release_year: 2011,
    options: {
      port: 7777,
      port_query: 27016,
      protocol: 'valve'
    }
  },
  mordhau: {
    name: 'Mordhau',
    release_year: 2019,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    }
  },
  gtavcmta: {
    name: 'Grand Theft Auto: Vice City - Multi Theft Auto',
    release_year: 2002,
    options: {
      port: 22003,
      port_query_offset: 123,
      protocol: 'ase'
    },
    extra: {
      old_id: 'mtavc'
    }
  },
  gtasamta: {
    name: 'Grand Theft Auto: San Andreas - Multi Theft Auto',
    release_year: 2004,
    options: {
      port: 22003,
      port_query_offset: 123,
      protocol: 'ase'
    },
    extra: {
      old_id: 'mtasa'
    }
  },
  mgm: {
    name: 'Mumble - GT Murmur',
    release_year: 2005,
    options: {
      port: 64738,
      port_query: 27800,
      protocol: 'mumble'
    },
    extra: {
      doc_notes: 'mumble'
    }
  },
  mumble: {
    name: 'Mumble',
    release_year: 2005,
    options: {
      port: 64738,
      protocol: 'mumbleping'
    },
    extra: {
      doc_notes: 'mumble'
    }
  },
  mutantfactions: {
    name: 'Mutant Factions',
    release_year: 2009,
    options: {
      port: 11235,
      protocol: 'geneshift'
    }
  },
  nascarthunder2004: {
    name: 'NASCAR Thunder 2004',
    release_year: 2003,
    options: {
      port_query: 13333,
      protocol: 'gamespy2'
    }
  },
  netpanzer: {
    name: 'netPanzer',
    release_year: 2002,
    options: {
      port: 3030,
      protocol: 'gamespy1'
    }
  },
  nmrih: {
    name: 'No More Room in Hell',
    release_year: 2011,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  naturalselection: {
    name: 'Natural Selection',
    release_year: 2002,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'ns'
    }
  },
  naturalselection2: {
    name: 'Natural Selection 2',
    release_year: 2012,
    options: {
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'ns2'
    }
  },
  nfshp2: {
    name: 'Need for Speed: Hot Pursuit 2',
    release_year: 2002,
    options: {
      port_query: 61220,
      protocol: 'gamespy1'
    }
  },
  nab: {
    name: 'Nerf Arena Blast',
    release_year: 1999,
    options: {
      port: 4444,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  neverwinternights: {
    name: 'Neverwinter Nights',
    release_year: 2002,
    options: {
      port_query: 5121,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'nwn'
    }
  },
  neverwinternights2: {
    name: 'Neverwinter Nights 2',
    release_year: 2006,
    options: {
      port: 5121,
      port_query: 6500,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'nwn2'
    }
  },
  nexuiz: {
    name: 'Nexuiz',
    release_year: 2005,
    options: {
      port_query: 26000,
      protocol: 'quake3'
    }
  },
  nitrofamily: {
    name: 'Nitro Family',
    release_year: 2004,
    options: {
      port_query: 25601,
      protocol: 'gamespy1'
    }
  },
  tonolf: {
    name: 'The Operative: No One Lives Forever',
    release_year: 2000,
    options: {
      port_query: 27888,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'nolf'
    }
  },
  nla: {
    name: 'Nova-Life: Amboise',
    release_year: 2020,
    options: {
      port_query: 27015,
      protocol: 'valve'
    }
  },
  nolf2asihw: {
    name: "No One Lives Forever 2: A Spy in H.A.R.M.'s Way",
    release_year: 2002,
    options: {
      port_query: 27890,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'nolf2'
    }
  },
  nucleardawn: {
    name: 'Nuclear Dawn',
    release_year: 2011,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  ohd: {
    name: 'Operation: Harsh Doorstop',
    release_year: 2023,
    options: {
      port: 7777,
      port_query: 27005,
      protocol: 'valve'
    }
  },
  onset: {
    name: 'Onset',
    release_year: 2019,
    options: {
      port: 7777,
      port_query_offset: -1,
      protocol: 'valve'
    }
  },
  openarena: {
    name: 'OpenArena',
    release_year: 2005,
    options: {
      port_query: 27960,
      protocol: 'quake3'
    }
  },
  openttd: {
    name: 'OpenTTD',
    release_year: 2004,
    options: {
      port: 3979,
      protocol: 'openttd'
    }
  },
  painkiller: {
    name: 'Painkiller',
    release_year: 2004,
    options: {
      port: 3455,
      port_query_offset: 123,
      protocol: 'ase'
    }
  },
  palworld: {
    name: 'Palworld',
    release_year: 2024,
    options: {
      port: 8212,
      protocol: 'palworld'
    },
    extra: {
      doc_notes: 'palworld'
    }
  },
  pvak2: {
    name: 'Pirates, Vikings, and Knights II',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'pvkii'
    }
  },
  pixark: {
    name: 'PixARK',
    release_year: 2018,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    }
  },
  postscriptum: {
    name: 'Post Scriptum',
    release_year: 2018,
    options: {
      port: 10037,
      protocol: 'valve'
    },
    extra: {
      old_id: 'ps'
    }
  },
  postal2: {
    name: 'Postal 2',
    release_year: 2003,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  prey: {
    name: 'Prey',
    release_year: 2017,
    options: {
      port: 27719,
      protocol: 'doom3'
    }
  },
  pce: {
    name: 'Primal Carnage: Extinction',
    release_year: 2015,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'primalcarnage'
    }
  },
  projectcars: {
    name: 'Project Cars',
    release_year: 2015,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'pc'
    }
  },
  projectcars2: {
    name: 'Project Cars 2',
    release_year: 2017,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'pc2'
    }
  },
  prb2: {
    name: 'Project Reality: Battlefield 2',
    release_year: 2005,
    options: {
      port: 16567,
      port_query: 29900,
      protocol: 'gamespy3'
    },
    extra: {
      old_id: 'prbf2'
    }
  },
  projectzomboid: {
    name: 'Project Zomboid',
    release_year: 2013,
    options: {
      port: 16261,
      protocol: 'valve'
    },
    extra: {
      old_id: 'przomboid'
    }
  },
  quake: {
    name: 'Quake',
    release_year: 1996,
    options: {
      port: 27500,
      protocol: 'quake1'
    },
    extra: {
      old_id: 'quake1'
    }
  },
  quake2: {
    name: 'Quake 2',
    release_year: 1997,
    options: {
      port: 27910,
      protocol: 'quake2'
    }
  },
  q3a: {
    name: 'Quake 3: Arena',
    release_year: 1999,
    options: {
      port: 27960,
      protocol: 'quake3'
    },
    extra: {
      old_id: 'quake3'
    }
  },
  quake4: {
    name: 'Quake 4',
    release_year: 2005,
    options: {
      port: 28004,
      protocol: 'doom3'
    }
  },
  quakelive: {
    name: 'Quake Live',
    release_year: 2010,
    options: {
      port: 27960,
      protocol: 'valve'
    }
  },
  rdkf: {
    name: 'Rag Doll Kung Fu',
    release_year: 2005,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'ragdollkungfu'
    }
  },
  rainbowsix: {
    name: 'Rainbow Six',
    release_year: 1998,
    options: {
      port_query: 2348,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'r6'
    }
  },
  rs2rs: {
    name: 'Rainbow Six 2: Rogue Spear',
    release_year: 1999,
    options: {
      port_query: 2346,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'r6roguespear'
    }
  },
  rs3rs: {
    name: 'Rainbow Six 3: Raven Shield',
    release_year: 2003,
    options: {
      port: 7777,
      port_query_offset: 1000,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'r6ravenshield'
    }
  },
  rallisportchallenge: {
    name: 'RalliSport Challenge',
    release_year: 2002,
    options: {
      port_query: 17500,
      protocol: 'gamespy1'
    }
  },
  rallymasters: {
    name: 'Rally Masters',
    release_year: 2000,
    options: {
      port_query: 16666,
      protocol: 'gamespy1'
    }
  },
  redorchestra: {
    name: 'Red Orchestra',
    release_year: 2018,
    options: {
      port: 7758,
      port_query_offset: 1,
      protocol: 'unreal2'
    }
  },
  roo4145: {
    name: 'Red Orchestra: Ostfront 41-45',
    release_year: 2006,
    options: {
      port: 7757,
      port_query_offset: 10,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'redorchestraost'
    }
  },
  redorchestra2: {
    name: 'Red Orchestra 2',
    release_year: 2011,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'valve'
    }
  },
  redline: {
    name: 'Redline',
    release_year: 2010,
    options: {
      port_query: 25252,
      protocol: 'gamespy1'
    }
  },
  renegade10: {
    name: 'Renegade X',
    release_year: 2014,
    options: {
      protocol: 'renegadex'
    }
  },
  renown: {
    name: 'Renown',
    release_year: 2025,
    options: {
      protocol: 'renown'
    }
  },
  rdr2r: {
    name: 'Red Dead Redemption 2 - RedM',
    release_year: 2018,
    options: {
      port: 30120,
      protocol: 'fivem'
    },
    extra: {
      old_id: 'redm'
    }
  },
  rtcw: {
    name: 'Return to Castle Wolfenstein',
    release_year: 2001,
    options: {
      port_query: 27960,
      protocol: 'quake3'
    }
  },
  rfactor: {
    name: 'rFactor',
    release_year: 2005,
    options: {
      port: 34397,
      port_query_offset: -100,
      protocol: 'rfactor'
    }
  },
  rfactor2: {
    name: 'rFactor 2',
    release_year: 2013,
    options: {
      port_query: 64299,
      protocol: 'valve'
    }
  },
  ricochet: {
    name: 'Ricochet',
    release_year: 2005,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  ron: {
    name: 'Rise of Nations',
    release_year: 2003,
    options: {
      port_query: 6501,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'riseofnations'
    }
  },
  risingworld: {
    name: 'Rising World',
    release_year: 2014,
    options: {
      port: 4255,
      port_query_offset: -1,
      protocol: 'valve'
    }
  },
  ror2: {
    name: 'Risk of Rain 2',
    release_year: 2020,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  rs2v: {
    name: 'Rising Storm 2: Vietnam',
    release_year: 2017,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'rs2'
    }
  },
  rune: {
    name: 'Rune',
    release_year: 2000,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  rust: {
    name: 'Rust',
    release_year: 2013,
    options: {
      port: 28015,
      protocol: 'valve'
    }
  },
  gtasam: {
    name: 'Grand Theft Auto: San Andreas Multiplayer',
    release_year: 2006,
    options: {
      port: 7777,
      protocol: 'samp'
    },
    extra: {
      old_id: 'samp'
    }
  },
  gtasao: {
    name: 'Grand Theft Auto: San Andreas OpenMP',
    release_year: 2019,
    options: {
      port: 7777,
      protocol: 'gtasao'
    },
    extra: {
      old_id: 'saomp'
    }
  },
  s2ats: {
    name: 'Savage 2: A Tortured Soul',
    release_year: 2008,
    options: {
      port_query: 11235,
      protocol: 'savage2'
    },
    extra: {
      old_id: 'savage2'
    }
  },
  sdtd: {
    name: '7 Days to Die',
    release_year: 2013,
    options: {
      port: 26900,
      port_query_offset: 1,
      protocol: 'sdtd'
    },
    extra: {
      old_id: '7d2d',
      doc_notes: 'sdtd'
    }
  },
  satisfactory: {
    name: 'Satisfactory',
    release_year: 2019,
    options: {
      port: 7777,
      protocol: 'satisfactory'
    },
    extra: {
      doc_notes: 'satisfactory'
    }
  },
  spaceengineers: {
    name: 'Space Engineers',
    release_year: 2019,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  serioussam: {
    name: 'Serious Sam',
    release_year: 2001,
    options: {
      port: 25600,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'ss'
    }
  },
  serioussam2: {
    name: 'Serious Sam 2',
    release_year: 2005,
    options: {
      port: 25600,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'ss2'
    }
  },
  shatteredhorizon: {
    name: 'Shattered Horizon',
    release_year: 2009,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  sstse: {
    name: 'Serious Sam: The Second Encounter',
    release_year: 2002,
    options: {
      port: 25600,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  theship: {
    name: 'The Ship',
    release_year: 2006,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'ship'
    }
  },
  shogo: {
    name: 'Shogo',
    release_year: 1998,
    options: {
      port_query: 27888,
      protocol: 'gamespy1'
    }
  },
  shootmania: {
    name: 'Shootmania',
    release_year: 2013,
    options: {
      port: 2350,
      port_query: 5000,
      protocol: 'nadeo'
    },
    extra: {
      doc_notes: 'nadeo'
    }
  },
  sin: {
    name: 'SiN',
    release_year: 1998,
    options: {
      port_query: 22450,
      protocol: 'gamespy1'
    }
  },
  sinepisodes: {
    name: 'SiN Episodes',
    release_year: 2006,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'sinep'
    }
  },
  soldat: {
    name: 'Soldat',
    release_year: 2002,
    options: {
      port: 23073,
      port_query_offset: 10,
      protocol: 'soldat'
    },
    extra: {
      doc_notes: 'soldat'
    }
  },
  sof: {
    name: 'Soldier of Fortune',
    release_year: 2000,
    options: {
      port: 28910,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  sof2: {
    name: 'Soldier of Fortune 2',
    release_year: 2002,
    options: {
      port_query: 20100,
      protocol: 'quake3'
    }
  },
  sotf: {
    name: 'Sons Of The Forest',
    release_year: 2023,
    options: {
      port: 8766,
      port_query: 27016,
      protocol: 'valve'
    },
    extra: {
      old_id: 'sonsoftheforest'
    }
  },
  soulmask: {
    name: 'Soulmask',
    release_year: 2024,
    options: {
      port: 8777,
      port_query: 27015,
      protocol: 'valve'
    }
  },
  ssl: {
    name: 'SCP: Secret Labratory',
    release_year: 2020,
    options: {
      protocol: 'scpsl'
    },
    extra: {
      doc_notes: 'ssl'
    }
  },
  stalker: {
    name: 'S.T.A.L.K.E.R.',
    release_year: 2007,
    options: {
      port: 5445,
      port_query_offset: 2,
      protocol: 'gamespy3'
    }
  },
  stn: {
    name: 'Survive the Nights',
    release_year: 2017,
    options: {
      port: 7950,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  stbc: {
    name: 'Star Trek: Bridge Commander',
    release_year: 2002,
    options: {
      port_query: 22101,
      protocol: 'gamespy1'
    }
  },
  stvef: {
    name: 'Star Trek: Voyager - Elite Force',
    release_year: 2000,
    options: {
      port_query: 27960,
      protocol: 'quake3'
    }
  },
  stvef2: {
    name: 'Star Trek: Voyager - Elite Force 2',
    release_year: 2003,
    options: {
      port_query: 29253,
      protocol: 'quake3'
    }
  },
  squad: {
    name: 'Squad',
    release_year: 2020,
    options: {
      port: 7787,
      protocol: 'squad'
    }
  },
  swb: {
    name: 'Star Wars: Battlefront',
    release_year: 2004,
    options: {
      port_query: 3658,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'swbf'
    }
  },
  swb2: {
    name: 'Star Wars: Battlefront 2',
    release_year: 2005,
    options: {
      port_query: 3658,
      protocol: 'gamespy2'
    },
    extra: {
      old_id: 'swbf2'
    }
  },
  swjkja: {
    name: 'Star Wars Jedi Knight: Jedi Academy',
    release_year: 2003,
    options: {
      port_query: 29070,
      protocol: 'quake3'
    },
    extra: {
      old_id: 'swjk'
    }
  },
  swjk2jo: {
    name: 'Star Wars Jedi Knight II: Jedi Outcast',
    release_year: 2002,
    options: {
      port_query: 28070,
      protocol: 'quake3'
    },
    extra: {
      old_id: 'swjk2'
    }
  },
  swrc: {
    name: 'Star Wars: Republic Commando',
    release_year: 2005,
    options: {
      port: 7777,
      port_query: 11138,
      protocol: 'gamespy2'
    }
  },
  starbound: {
    name: 'Starbound',
    release_year: 2016,
    options: {
      port: 21025,
      protocol: 'valve'
    }
  },
  starmade: {
    name: 'StarMade',
    release_year: 2012,
    options: {
      port: 4242,
      protocol: 'starmade'
    }
  },
  starsiege: {
    name: 'Starsiege',
    release_year: 2009,
    options: {
      port: 29001,
      protocol: 'starsiege'
    }
  },
  suicidesurvival: {
    name: 'Suicide Survival',
    release_year: 2008,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  swat4: {
    name: 'SWAT 4',
    release_year: 2005,
    options: {
      port: 10480,
      port_query_offset: 2,
      protocol: 'gamespy2'
    }
  },
  svencoop: {
    name: 'Sven Coop',
    release_year: 1999,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  synergy: {
    name: 'Synergy',
    release_year: 2005,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  tacticalops: {
    name: 'Tactical Ops',
    release_year: 1999,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  toh: {
    name: 'Take On Helicopters',
    release_year: 2011,
    options: {
      port: 2302,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'takeonhelicopters'
    }
  },
  teamfactor: {
    name: 'Team Factor',
    release_year: 2002,
    options: {
      port_query: 57778,
      protocol: 'gamespy1'
    }
  },
  tfc: {
    name: 'Team Fortress Classic',
    release_year: 1999,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  teamfortress2: {
    name: 'Team Fortress 2',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'tf2'
    }
  },
  teamspeak2: {
    name: 'Teamspeak 2',
    release_year: 2001,
    options: {
      port: 8767,
      protocol: 'teamspeak2'
    }
  },
  teamspeak3: {
    name: 'Teamspeak 3',
    release_year: 2011,
    options: {
      port: 9987,
      protocol: 'teamspeak3'
    },
    extra: {
      doc_notes: 'teamspeak3'
    }
  },
  terminus: {
    name: 'Terminus',
    release_year: 2000,
    options: {
      port_query: 12286,
      protocol: 'gamespy1'
    }
  },
  terrariatshock: {
    name: 'Terraria - TShock',
    release_year: 2011,
    options: {
      port: 7777,
      port_query_offset: 101,
      protocol: 'terraria'
    },
    extra: {
      old_id: 'terraria',
      doc_notes: 'terraria'
    }
  },
  theforest: {
    name: 'The Forest',
    release_year: 2014,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      old_id: 'forrest'
    }
  },
  thefront: {
    name: 'The Front',
    release_year: 2023,
    options: {
      port_query: 27015,
      protocol: 'valve'
    }
  },
  thps3: {
    name: "Tony Hawk's Pro Skater 3",
    release_year: 2001,
    options: {
      port_query: 6500,
      protocol: 'gamespy1'
    }
  },
  thps4: {
    name: "Tony Hawk's Pro Skater 4",
    release_year: 2002,
    options: {
      port_query: 6500,
      protocol: 'gamespy1'
    }
  },
  thu2: {
    name: "Tony Hawk's Underground 2",
    release_year: 2004,
    options: {
      port_query: 5153,
      protocol: 'gamespy1'
    }
  },
  towerunite: {
    name: 'Tower Unite',
    release_year: 2016,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  trackmania2: {
    name: 'Trackmania 2',
    release_year: 2011,
    options: {
      port: 2350,
      port_query: 5000,
      protocol: 'nadeo'
    },
    extra: {
      doc_notes: 'nadeo'
    }
  },
  trackmaniaforever: {
    name: 'Trackmania Forever',
    release_year: 2008,
    options: {
      port: 2350,
      port_query: 5000,
      protocol: 'nadeo'
    },
    extra: {
      doc_notes: 'nadeo'
    }
  },
  tremulous: {
    name: 'Tremulous',
    release_year: 2006,
    options: {
      port_query: 30720,
      protocol: 'quake3'
    }
  },
  t1s: {
    name: 'Tribes 1: Starsiege',
    release_year: 1998,
    options: {
      port: 28001,
      protocol: 'tribes1'
    },
    extra: {
      old_id: 'tribes1'
    }
  },
  tribesvengeance: {
    name: 'Tribes: Vengeance',
    release_year: 2004,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy2'
    }
  },
  tron20: {
    name: 'Tron 2.0',
    release_year: 2003,
    options: {
      port_query: 27888,
      protocol: 'gamespy2'
    }
  },
  thespecialists: {
    name: 'The Specialists',
    release_year: 2002,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  toxikk: {
    name: 'TOXIKK',
    release_year: 2016,
    options: {
      port: 7777,
      port_query: 27015,
      protocol: 'toxikk'
    }
  },
  turok2: {
    name: 'Turok 2',
    release_year: 1998,
    options: {
      port_query: 12880,
      protocol: 'gamespy1'
    }
  },
  u2tax: {
    name: 'Unreal 2: The Awakening - XMP',
    release_year: 2003,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'unreal2'
    }
  },
  universalcombat: {
    name: 'Universal Combat',
    release_year: 2004,
    options: {
      port: 1135,
      port_query_offset: 123,
      protocol: 'ase'
    }
  },
  unreal: {
    name: 'Unreal',
    release_year: 1998,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    }
  },
  unturned: {
    name: 'unturned',
    release_year: 2014,
    options: {
      port: 27015,
      port_query_offset: 1,
      protocol: 'valve'
    }
  },
  unrealtournament: {
    name: 'Unreal Tournament',
    release_year: 1993,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'ut'
    }
  },
  unrealtournament2003: {
    name: 'Unreal Tournament 2003',
    release_year: 2003,
    options: {
      port: 7757,
      port_query_offset: 1,
      protocol: 'unreal2'
    },
    extra: {
      old_id: 'ut2003'
    }
  },
  unrealtournament2004: {
    name: 'Unreal Tournament 2004',
    release_year: 2004,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'unreal2'
    },
    extra: {
      old_id: 'ut2004'
    }
  },
  unrealtournament3: {
    name: 'Unreal Tournament 3',
    release_year: 2007,
    options: {
      port: 7777,
      port_query_offset: -1277,
      protocol: 'ut3'
    },
    extra: {
      old_id: 'ut3'
    }
  },
  urbanterror: {
    name: 'Urban Terror',
    release_year: 2000,
    options: {
      port_query: 27960,
      protocol: 'quake3'
    }
  },
  v8sc: {
    name: 'V8 Supercar Challenge',
    release_year: 2002,
    options: {
      port_query: 16700,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'v8supercar'
    }
  },
  valheim: {
    name: 'Valheim',
    release_year: 2021,
    options: {
      port: 2456,
      port_query_offset: 1,
      protocol: 'valve'
    },
    extra: {
      doc_notes: 'valheim'
    }
  },
  vcm: {
    name: 'Vice City Multiplayer',
    release_year: 2015,
    options: {
      port: 8192,
      protocol: 'vcmp'
    },
    extra: {
      old_id: 'vcmp'
    }
  },
  ventrilo: {
    name: 'Ventrilo',
    release_year: 2002,
    options: {
      port: 3784,
      protocol: 'ventrilo'
    }
  },
  vietcong: {
    name: 'Vietcong',
    release_year: 2003,
    options: {
      port: 5425,
      port_query: 15425,
      protocol: 'gamespy1'
    }
  },
  vietcong2: {
    name: 'Vietcong 2',
    release_year: 2005,
    options: {
      port: 5001,
      port_query: 19967,
      protocol: 'gamespy2'
    }
  },
  vrising: {
    name: 'V Rising',
    release_year: 2022,
    options: {
      port: 27015,
      port_query_offset: [1, 15],
      protocol: 'valve'
    }
  },
  vampireslayer: {
    name: 'Vampire Slayer',
    release_year: 2000,
    options: {
      port: 27015,
      protocol: 'valve'
    },
    extra: {
      old_id: 'vs'
    }
  },
  vintagestory: {
    name: 'Vintage Story',
    release_year: 2016,
    options: {
      port: 42420,
      protocol: 'vintagestory'
    }
  },
  warsow: {
    name: 'Warsow',
    release_year: 2012,
    options: {
      port: 44400,
      protocol: 'warsow'
    }
  },
  warfork: {
    name: 'Warfork',
    release_year: 2019,
    options: {
      port_query: 44400,
      protocol: 'warsow'
    }
  },
  wot: {
    name: 'Wheel of Time',
    release_year: 1999,
    options: {
      port: 7777,
      port_query_offset: 1,
      protocol: 'gamespy1'
    },
    extra: {
      old_id: 'wheeloftime'
    }
  },
  wolfenstein: {
    name: 'Wolfenstein',
    release_year: 2009,
    options: {
      port: 27666,
      protocol: 'doom3'
    },
    extra: {
      old_id: 'wolfenstein2009'
    }
  },
  wet: {
    name: 'Wolfenstein: Enemy Territory',
    release_year: 2003,
    options: {
      port_query: 27960,
      protocol: 'quake3'
    },
    extra: {
      old_id: 'wolfensteinet'
    }
  },
  wurmunlimited: {
    name: 'Wurm Unlimited',
    release_year: 2006,
    options: {
      port: 3724,
      port_query: 27016,
      protocol: 'valve'
    },
    extra: {
      old_id: 'wurm'
    }
  },
  xonotic: {
    name: 'Xonotic',
    release_year: 2011,
    options: {
      port: 26000,
      protocol: 'xonotic'
    }
  },
  wop: {
    name: 'World Of Padman',
    release_year: 2007,
    options: {
      port: 26000,
      protocol: 'quake3'
    }
  },
  xpandrally: {
    name: 'Xpand Rally',
    release_year: 2004,
    options: {
      port: 28015,
      port_query_offset: 123,
      protocol: 'ase'
    }
  },
  zombiemaster: {
    name: 'Zombie Master',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  },
  zps: {
    name: 'Zombie Panic: Source',
    release_year: 2007,
    options: {
      port: 27015,
      protocol: 'valve'
    }
  }
}
