"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.typeByName = exports.TYPES = exports.TYPE = void 0;
var _null = _interopRequireDefault(require("./data-types/null"));
var _tinyint = _interopRequireDefault(require("./data-types/tinyint"));
var _bit = _interopRequireDefault(require("./data-types/bit"));
var _smallint = _interopRequireDefault(require("./data-types/smallint"));
var _int = _interopRequireDefault(require("./data-types/int"));
var _smalldatetime = _interopRequireDefault(require("./data-types/smalldatetime"));
var _real = _interopRequireDefault(require("./data-types/real"));
var _money = _interopRequireDefault(require("./data-types/money"));
var _datetime = _interopRequireDefault(require("./data-types/datetime"));
var _float = _interopRequireDefault(require("./data-types/float"));
var _decimal = _interopRequireDefault(require("./data-types/decimal"));
var _numeric = _interopRequireDefault(require("./data-types/numeric"));
var _smallmoney = _interopRequireDefault(require("./data-types/smallmoney"));
var _bigint = _interopRequireDefault(require("./data-types/bigint"));
var _image = _interopRequireDefault(require("./data-types/image"));
var _text = _interopRequireDefault(require("./data-types/text"));
var _uniqueidentifier = _interopRequireDefault(require("./data-types/uniqueidentifier"));
var _intn = _interopRequireDefault(require("./data-types/intn"));
var _ntext = _interopRequireDefault(require("./data-types/ntext"));
var _bitn = _interopRequireDefault(require("./data-types/bitn"));
var _decimaln = _interopRequireDefault(require("./data-types/decimaln"));
var _numericn = _interopRequireDefault(require("./data-types/numericn"));
var _floatn = _interopRequireDefault(require("./data-types/floatn"));
var _moneyn = _interopRequireDefault(require("./data-types/moneyn"));
var _datetimen = _interopRequireDefault(require("./data-types/datetimen"));
var _varbinary = _interopRequireDefault(require("./data-types/varbinary"));
var _varchar = _interopRequireDefault(require("./data-types/varchar"));
var _binary = _interopRequireDefault(require("./data-types/binary"));
var _char = _interopRequireDefault(require("./data-types/char"));
var _nvarchar = _interopRequireDefault(require("./data-types/nvarchar"));
var _nchar = _interopRequireDefault(require("./data-types/nchar"));
var _xml = _interopRequireDefault(require("./data-types/xml"));
var _time = _interopRequireDefault(require("./data-types/time"));
var _date = _interopRequireDefault(require("./data-types/date"));
var _datetime2 = _interopRequireDefault(require("./data-types/datetime2"));
var _datetimeoffset = _interopRequireDefault(require("./data-types/datetimeoffset"));
var _udt = _interopRequireDefault(require("./data-types/udt"));
var _tvp = _interopRequireDefault(require("./data-types/tvp"));
var _sqlVariant = _interopRequireDefault(require("./data-types/sql-variant"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const TYPE = exports.TYPE = {
  [_null.default.id]: _null.default,
  [_tinyint.default.id]: _tinyint.default,
  [_bit.default.id]: _bit.default,
  [_smallint.default.id]: _smallint.default,
  [_int.default.id]: _int.default,
  [_smalldatetime.default.id]: _smalldatetime.default,
  [_real.default.id]: _real.default,
  [_money.default.id]: _money.default,
  [_datetime.default.id]: _datetime.default,
  [_float.default.id]: _float.default,
  [_decimal.default.id]: _decimal.default,
  [_numeric.default.id]: _numeric.default,
  [_smallmoney.default.id]: _smallmoney.default,
  [_bigint.default.id]: _bigint.default,
  [_image.default.id]: _image.default,
  [_text.default.id]: _text.default,
  [_uniqueidentifier.default.id]: _uniqueidentifier.default,
  [_intn.default.id]: _intn.default,
  [_ntext.default.id]: _ntext.default,
  [_bitn.default.id]: _bitn.default,
  [_decimaln.default.id]: _decimaln.default,
  [_numericn.default.id]: _numericn.default,
  [_floatn.default.id]: _floatn.default,
  [_moneyn.default.id]: _moneyn.default,
  [_datetimen.default.id]: _datetimen.default,
  [_varbinary.default.id]: _varbinary.default,
  [_varchar.default.id]: _varchar.default,
  [_binary.default.id]: _binary.default,
  [_char.default.id]: _char.default,
  [_nvarchar.default.id]: _nvarchar.default,
  [_nchar.default.id]: _nchar.default,
  [_xml.default.id]: _xml.default,
  [_time.default.id]: _time.default,
  [_date.default.id]: _date.default,
  [_datetime2.default.id]: _datetime2.default,
  [_datetimeoffset.default.id]: _datetimeoffset.default,
  [_udt.default.id]: _udt.default,
  [_tvp.default.id]: _tvp.default,
  [_sqlVariant.default.id]: _sqlVariant.default
};

/**
 * <table>
 * <thead>
 *   <tr>
 *     <th>Type</th>
 *     <th>Constant</th>
 *     <th>JavaScript</th>
 *     <th>Result set</th>
 *     <th>Parameter</th>
 *   </tr>
 * </thead>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Exact numerics</th>
 *   </tr>
 *   <tr>
 *     <td><code>bit</code></td>
 *     <td><code>[[TYPES.Bit]]</code></td>
 *     <td><code>boolean</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>tinyint</code></td>
 *     <td><code>[[TYPES.TinyInt]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>smallint</code></td>
 *     <td><code>[[TYPES.SmallInt]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>int</code></td>
 *     <td><code>[[TYPES.Int]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>bigint</code><sup>1</sup></td>
 *     <td><code>[[TYPES.BigInt]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>numeric</code><sup>2</sup></td>
 *     <td><code>[[TYPES.Numeric]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>decimal</code><sup>2</sup></td>
 *     <td><code>[[TYPES.Decimal]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>smallmoney</code></td>
 *     <td><code>[[TYPES.SmallMoney]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>money</code></td>
 *     <td><code>[[TYPES.Money]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Approximate numerics</th>
 *   </tr>
 *   <tr>
 *     <td><code>float</code></td>
 *     <td><code>[[TYPES.Float]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>real</code></td>
 *     <td><code>[[TYPES.Real]]</code></td>
 *     <td><code>number</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="4">Date and Time</th>
 *   </tr>
 *   <tr>
 *     <td><code>smalldatetime</code></td>
 *     <td><code>[[TYPES.SmallDateTime]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>datetime</code></td>
 *     <td><code>[[TYPES.DateTime]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>datetime2</code></td>
 *     <td><code>[[TYPES.DateTime2]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>datetimeoffset</code></td>
 *     <td><code>[[TYPES.DateTimeOffset]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>time</code></td>
 *     <td><code>[[TYPES.Time]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>date</code></td>
 *     <td><code>[[TYPES.Date]]</code></td>
 *     <td><code>Date</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="4">Character Strings</th>
 *   </tr>
 *   <tr>
 *     <td><code>char</code></td>
 *     <td><code>[[TYPES.Char]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>varchar</code><sup>3</sup></td>
 *     <td><code>[[TYPES.VarChar]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>text</code></td>
 *     <td><code>[[TYPES.Text]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="4">Unicode Strings</th>
 *   </tr>
 *   <tr>
 *     <td><code>nchar</code></td>
 *     <td><code>[[TYPES.NChar]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>nvarchar</code><sup>3</sup></td>
 *     <td><code>[[TYPES.NVarChar]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>ntext</code></td>
 *     <td><code>[[TYPES.NText]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Binary Strings<sup>4</sup></th>
 *   </tr>
 *   <tr>
 *     <td><code>binary</code></td>
 *     <td><code>[[TYPES.Binary]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>varbinary</code></td>
 *     <td><code>[[TYPES.VarBinary]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>image</code></td>
 *     <td><code>[[TYPES.Image]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 * </tbody>
 *
 * <tbody>
 *   <tr class="group-heading">
 *     <th colspan="5">Other Data Types</th>
 *   </tr>
 *   <tr>
 *     <td><code>TVP</code></td>
 *     <td><code>[[TYPES.TVP]]</code></td>
 *     <td><code>Object</code></td>
 *     <td>-</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>UDT</code></td>
 *     <td><code>[[TYPES.UDT]]</code></td>
 *     <td><code>Buffer</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 *   <tr>
 *     <td><code>uniqueidentifier</code><sup>4</sup></td>
 *     <td><code>[[TYPES.UniqueIdentifier]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>✓</td>
 *   </tr>
 *   <tr>
 *     <td><code>variant</code></td>
 *     <td><code>[[TYPES.Variant]]</code></td>
 *     <td><code>any</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 *   <tr>
 *     <td><code>xml</code></td>
 *     <td><code>[[TYPES.Xml]]</code></td>
 *     <td><code>string</code></td>
 *     <td>✓</td>
 *     <td>-</td>
 *   </tr>
 * </tbody>
 * </table>
 *
 * <ol>
 *   <li>
 *     <h4>BigInt</h4>
 *     <p>
 *       Values are returned as a string. This is because values can exceed 53 bits of significant data, which is greater than a
 *       Javascript <code>number</code> type can represent as an integer.
 *     </p>
 *   </li>
 *   <li>
 *     <h4>Numerical, Decimal</h4>
 *     <p>
 *       For input parameters, default precision is 18 and default scale is 0. Maximum supported precision is 19.
 *     </p>
 *   </li>
 *   <li>
 *     <h4>VarChar, NVarChar</h4>
 *     <p>
 *       <code>varchar(max)</code> and <code>nvarchar(max)</code> are also supported.
 *     </p>
 *   </li>
 *   <li>
 *     <h4>UniqueIdentifier</h4>
 *     <p>
 *       Values are returned as a 16 byte hexadecimal string.
 *     </p>
 *     <p>
 *       Note that the order of bytes is not the same as the character representation. See
 *       <a href="http://msdn.microsoft.com/en-us/library/ms190215.aspx">Using uniqueidentifier Data</a>
 *       for an example of the different ordering of bytes.
 *     </p>
 *   </li>
 * </ol>
 */
const TYPES = exports.TYPES = {
  TinyInt: _tinyint.default,
  Bit: _bit.default,
  SmallInt: _smallint.default,
  Int: _int.default,
  SmallDateTime: _smalldatetime.default,
  Real: _real.default,
  Money: _money.default,
  DateTime: _datetime.default,
  Float: _float.default,
  Decimal: _decimal.default,
  Numeric: _numeric.default,
  SmallMoney: _smallmoney.default,
  BigInt: _bigint.default,
  Image: _image.default,
  Text: _text.default,
  UniqueIdentifier: _uniqueidentifier.default,
  NText: _ntext.default,
  VarBinary: _varbinary.default,
  VarChar: _varchar.default,
  Binary: _binary.default,
  Char: _char.default,
  NVarChar: _nvarchar.default,
  NChar: _nchar.default,
  Xml: _xml.default,
  Time: _time.default,
  Date: _date.default,
  DateTime2: _datetime2.default,
  DateTimeOffset: _datetimeoffset.default,
  UDT: _udt.default,
  TVP: _tvp.default,
  Variant: _sqlVariant.default
};
const typeByName = exports.typeByName = TYPES;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJfbnVsbCIsIl9pbnRlcm9wUmVxdWlyZURlZmF1bHQiLCJyZXF1aXJlIiwiX3RpbnlpbnQiLCJfYml0IiwiX3NtYWxsaW50IiwiX2ludCIsIl9zbWFsbGRhdGV0aW1lIiwiX3JlYWwiLCJfbW9uZXkiLCJfZGF0ZXRpbWUiLCJfZmxvYXQiLCJfZGVjaW1hbCIsIl9udW1lcmljIiwiX3NtYWxsbW9uZXkiLCJfYmlnaW50IiwiX2ltYWdlIiwiX3RleHQiLCJfdW5pcXVlaWRlbnRpZmllciIsIl9pbnRuIiwiX250ZXh0IiwiX2JpdG4iLCJfZGVjaW1hbG4iLCJfbnVtZXJpY24iLCJfZmxvYXRuIiwiX21vbmV5biIsIl9kYXRldGltZW4iLCJfdmFyYmluYXJ5IiwiX3ZhcmNoYXIiLCJfYmluYXJ5IiwiX2NoYXIiLCJfbnZhcmNoYXIiLCJfbmNoYXIiLCJfeG1sIiwiX3RpbWUiLCJfZGF0ZSIsIl9kYXRldGltZTIiLCJfZGF0ZXRpbWVvZmZzZXQiLCJfdWR0IiwiX3R2cCIsIl9zcWxWYXJpYW50IiwiZSIsIl9fZXNNb2R1bGUiLCJkZWZhdWx0IiwiVFlQRSIsImV4cG9ydHMiLCJOdWxsIiwiaWQiLCJUaW55SW50IiwiQml0IiwiU21hbGxJbnQiLCJJbnQiLCJTbWFsbERhdGVUaW1lIiwiUmVhbCIsIk1vbmV5IiwiRGF0ZVRpbWUiLCJGbG9hdCIsIkRlY2ltYWwiLCJOdW1lcmljIiwiU21hbGxNb25leSIsIkJpZ0ludCIsIkltYWdlIiwiVGV4dCIsIlVuaXF1ZUlkZW50aWZpZXIiLCJJbnROIiwiTlRleHQiLCJCaXROIiwiRGVjaW1hbE4iLCJOdW1lcmljTiIsIkZsb2F0TiIsIk1vbmV5TiIsIkRhdGVUaW1lTiIsIlZhckJpbmFyeSIsIlZhckNoYXIiLCJCaW5hcnkiLCJDaGFyIiwiTlZhckNoYXIiLCJOQ2hhciIsIlhtbCIsIlRpbWUiLCJEYXRlIiwiRGF0ZVRpbWUyIiwiRGF0ZVRpbWVPZmZzZXQiLCJVRFQiLCJUVlAiLCJWYXJpYW50IiwiVFlQRVMiLCJ0eXBlQnlOYW1lIl0sInNvdXJjZXMiOlsiLi4vc3JjL2RhdGEtdHlwZS50cyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgTnVsbCBmcm9tICcuL2RhdGEtdHlwZXMvbnVsbCc7XG5pbXBvcnQgVGlueUludCBmcm9tICcuL2RhdGEtdHlwZXMvdGlueWludCc7XG5pbXBvcnQgQml0IGZyb20gJy4vZGF0YS10eXBlcy9iaXQnO1xuaW1wb3J0IFNtYWxsSW50IGZyb20gJy4vZGF0YS10eXBlcy9zbWFsbGludCc7XG5pbXBvcnQgSW50IGZyb20gJy4vZGF0YS10eXBlcy9pbnQnO1xuaW1wb3J0IFNtYWxsRGF0ZVRpbWUgZnJvbSAnLi9kYXRhLXR5cGVzL3NtYWxsZGF0ZXRpbWUnO1xuaW1wb3J0IFJlYWwgZnJvbSAnLi9kYXRhLXR5cGVzL3JlYWwnO1xuaW1wb3J0IE1vbmV5IGZyb20gJy4vZGF0YS10eXBlcy9tb25leSc7XG5pbXBvcnQgRGF0ZVRpbWUgZnJvbSAnLi9kYXRhLXR5cGVzL2RhdGV0aW1lJztcbmltcG9ydCBGbG9hdCBmcm9tICcuL2RhdGEtdHlwZXMvZmxvYXQnO1xuaW1wb3J0IERlY2ltYWwgZnJvbSAnLi9kYXRhLXR5cGVzL2RlY2ltYWwnO1xuaW1wb3J0IE51bWVyaWMgZnJvbSAnLi9kYXRhLXR5cGVzL251bWVyaWMnO1xuaW1wb3J0IFNtYWxsTW9uZXkgZnJvbSAnLi9kYXRhLXR5cGVzL3NtYWxsbW9uZXknO1xuaW1wb3J0IEJpZ0ludCBmcm9tICcuL2RhdGEtdHlwZXMvYmlnaW50JztcbmltcG9ydCBJbWFnZSBmcm9tICcuL2RhdGEtdHlwZXMvaW1hZ2UnO1xuaW1wb3J0IFRleHQgZnJvbSAnLi9kYXRhLXR5cGVzL3RleHQnO1xuaW1wb3J0IFVuaXF1ZUlkZW50aWZpZXIgZnJvbSAnLi9kYXRhLXR5cGVzL3VuaXF1ZWlkZW50aWZpZXInO1xuaW1wb3J0IEludE4gZnJvbSAnLi9kYXRhLXR5cGVzL2ludG4nO1xuaW1wb3J0IE5UZXh0IGZyb20gJy4vZGF0YS10eXBlcy9udGV4dCc7XG5pbXBvcnQgQml0TiBmcm9tICcuL2RhdGEtdHlwZXMvYml0bic7XG5pbXBvcnQgRGVjaW1hbE4gZnJvbSAnLi9kYXRhLXR5cGVzL2RlY2ltYWxuJztcbmltcG9ydCBOdW1lcmljTiBmcm9tICcuL2RhdGEtdHlwZXMvbnVtZXJpY24nO1xuaW1wb3J0IEZsb2F0TiBmcm9tICcuL2RhdGEtdHlwZXMvZmxvYXRuJztcbmltcG9ydCBNb25leU4gZnJvbSAnLi9kYXRhLXR5cGVzL21vbmV5bic7XG5pbXBvcnQgRGF0ZVRpbWVOIGZyb20gJy4vZGF0YS10eXBlcy9kYXRldGltZW4nO1xuaW1wb3J0IFZhckJpbmFyeSBmcm9tICcuL2RhdGEtdHlwZXMvdmFyYmluYXJ5JztcbmltcG9ydCBWYXJDaGFyIGZyb20gJy4vZGF0YS10eXBlcy92YXJjaGFyJztcbmltcG9ydCBCaW5hcnkgZnJvbSAnLi9kYXRhLXR5cGVzL2JpbmFyeSc7XG5pbXBvcnQgQ2hhciBmcm9tICcuL2RhdGEtdHlwZXMvY2hhcic7XG5pbXBvcnQgTlZhckNoYXIgZnJvbSAnLi9kYXRhLXR5cGVzL252YXJjaGFyJztcbmltcG9ydCBOQ2hhciBmcm9tICcuL2RhdGEtdHlwZXMvbmNoYXInO1xuaW1wb3J0IFhtbCBmcm9tICcuL2RhdGEtdHlwZXMveG1sJztcbmltcG9ydCBUaW1lIGZyb20gJy4vZGF0YS10eXBlcy90aW1lJztcbmltcG9ydCBEYXRlIGZyb20gJy4vZGF0YS10eXBlcy9kYXRlJztcbmltcG9ydCBEYXRlVGltZTIgZnJvbSAnLi9kYXRhLXR5cGVzL2RhdGV0aW1lMic7XG5pbXBvcnQgRGF0ZVRpbWVPZmZzZXQgZnJvbSAnLi9kYXRhLXR5cGVzL2RhdGV0aW1lb2Zmc2V0JztcbmltcG9ydCBVRFQgZnJvbSAnLi9kYXRhLXR5cGVzL3VkdCc7XG5pbXBvcnQgVFZQIGZyb20gJy4vZGF0YS10eXBlcy90dnAnO1xuaW1wb3J0IFZhcmlhbnQgZnJvbSAnLi9kYXRhLXR5cGVzL3NxbC12YXJpYW50JztcbmltcG9ydCB7IHR5cGUgQ3J5cHRvTWV0YWRhdGEgfSBmcm9tICcuL2Fsd2F5cy1lbmNyeXB0ZWQvdHlwZXMnO1xuXG5pbXBvcnQgeyB0eXBlIEludGVybmFsQ29ubmVjdGlvbk9wdGlvbnMgfSBmcm9tICcuL2Nvbm5lY3Rpb24nO1xuaW1wb3J0IHsgQ29sbGF0aW9uIH0gZnJvbSAnLi9jb2xsYXRpb24nO1xuXG5leHBvcnQgaW50ZXJmYWNlIFBhcmFtZXRlciB7XG4gIHR5cGU6IERhdGFUeXBlO1xuICBuYW1lOiBzdHJpbmc7XG5cbiAgdmFsdWU6IHVua25vd247XG5cbiAgb3V0cHV0OiBib29sZWFuO1xuICBsZW5ndGg/OiBudW1iZXIgfCB1bmRlZmluZWQ7XG4gIHByZWNpc2lvbj86IG51bWJlciB8IHVuZGVmaW5lZDtcbiAgc2NhbGU/OiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgbnVsbGFibGU/OiBib29sZWFuIHwgdW5kZWZpbmVkO1xuXG4gIGZvcmNlRW5jcnlwdD86IGJvb2xlYW4gfCB1bmRlZmluZWQ7XG4gIGNyeXB0b01ldGFkYXRhPzogQ3J5cHRvTWV0YWRhdGEgfCB1bmRlZmluZWQ7XG4gIGVuY3J5cHRlZFZhbD86IEJ1ZmZlciB8IHVuZGVmaW5lZDtcbn1cblxuXG5leHBvcnQgaW50ZXJmYWNlIFBhcmFtZXRlckRhdGE8VCA9IGFueT4ge1xuICBsZW5ndGg/OiBudW1iZXIgfCB1bmRlZmluZWQ7XG4gIHNjYWxlPzogbnVtYmVyIHwgdW5kZWZpbmVkO1xuICBwcmVjaXNpb24/OiBudW1iZXIgfCB1bmRlZmluZWQ7XG5cbiAgY29sbGF0aW9uPzogQ29sbGF0aW9uIHwgdW5kZWZpbmVkO1xuXG4gIHZhbHVlOiBUO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERhdGFUeXBlIHtcbiAgaWQ6IG51bWJlcjtcbiAgdHlwZTogc3RyaW5nO1xuICBuYW1lOiBzdHJpbmc7XG5cbiAgZGVjbGFyYXRpb24ocGFyYW1ldGVyOiBQYXJhbWV0ZXIpOiBzdHJpbmc7XG4gIGdlbmVyYXRlVHlwZUluZm8ocGFyYW1ldGVyOiBQYXJhbWV0ZXJEYXRhLCBvcHRpb25zOiBJbnRlcm5hbENvbm5lY3Rpb25PcHRpb25zKTogQnVmZmVyO1xuICBnZW5lcmF0ZVBhcmFtZXRlckxlbmd0aChwYXJhbWV0ZXI6IFBhcmFtZXRlckRhdGEsIG9wdGlvbnM6IEludGVybmFsQ29ubmVjdGlvbk9wdGlvbnMpOiBCdWZmZXI7XG4gIGdlbmVyYXRlUGFyYW1ldGVyRGF0YShwYXJhbWV0ZXI6IFBhcmFtZXRlckRhdGEsIG9wdGlvbnM6IEludGVybmFsQ29ubmVjdGlvbk9wdGlvbnMpOiBHZW5lcmF0b3I8QnVmZmVyLCB2b2lkPjtcbiAgdmFsaWRhdGUodmFsdWU6IGFueSwgY29sbGF0aW9uOiBDb2xsYXRpb24gfCB1bmRlZmluZWQsIG9wdGlvbnM/OiBJbnRlcm5hbENvbm5lY3Rpb25PcHRpb25zKTogYW55OyAvLyBUT0RPOiBSZWZhY3RvciAnYW55JyBhbmQgcmVwbGFjZSB3aXRoIG1vcmUgc3BlY2lmaWMgdHlwZS5cblxuICBoYXNUYWJsZU5hbWU/OiBib29sZWFuO1xuXG4gIHJlc29sdmVMZW5ndGg/OiAocGFyYW1ldGVyOiBQYXJhbWV0ZXIpID0+IG51bWJlcjtcbiAgcmVzb2x2ZVByZWNpc2lvbj86IChwYXJhbWV0ZXI6IFBhcmFtZXRlcikgPT4gbnVtYmVyO1xuICByZXNvbHZlU2NhbGU/OiAocGFyYW1ldGVyOiBQYXJhbWV0ZXIpID0+IG51bWJlcjtcbn1cblxuZXhwb3J0IGNvbnN0IFRZUEUgPSB7XG4gIFtOdWxsLmlkXTogTnVsbCxcbiAgW1RpbnlJbnQuaWRdOiBUaW55SW50LFxuICBbQml0LmlkXTogQml0LFxuICBbU21hbGxJbnQuaWRdOiBTbWFsbEludCxcbiAgW0ludC5pZF06IEludCxcbiAgW1NtYWxsRGF0ZVRpbWUuaWRdOiBTbWFsbERhdGVUaW1lLFxuICBbUmVhbC5pZF06IFJlYWwsXG4gIFtNb25leS5pZF06IE1vbmV5LFxuICBbRGF0ZVRpbWUuaWRdOiBEYXRlVGltZSxcbiAgW0Zsb2F0LmlkXTogRmxvYXQsXG4gIFtEZWNpbWFsLmlkXTogRGVjaW1hbCxcbiAgW051bWVyaWMuaWRdOiBOdW1lcmljLFxuICBbU21hbGxNb25leS5pZF06IFNtYWxsTW9uZXksXG4gIFtCaWdJbnQuaWRdOiBCaWdJbnQsXG4gIFtJbWFnZS5pZF06IEltYWdlLFxuICBbVGV4dC5pZF06IFRleHQsXG4gIFtVbmlxdWVJZGVudGlmaWVyLmlkXTogVW5pcXVlSWRlbnRpZmllcixcbiAgW0ludE4uaWRdOiBJbnROLFxuICBbTlRleHQuaWRdOiBOVGV4dCxcbiAgW0JpdE4uaWRdOiBCaXROLFxuICBbRGVjaW1hbE4uaWRdOiBEZWNpbWFsTixcbiAgW051bWVyaWNOLmlkXTogTnVtZXJpY04sXG4gIFtGbG9hdE4uaWRdOiBGbG9hdE4sXG4gIFtNb25leU4uaWRdOiBNb25leU4sXG4gIFtEYXRlVGltZU4uaWRdOiBEYXRlVGltZU4sXG4gIFtWYXJCaW5hcnkuaWRdOiBWYXJCaW5hcnksXG4gIFtWYXJDaGFyLmlkXTogVmFyQ2hhcixcbiAgW0JpbmFyeS5pZF06IEJpbmFyeSxcbiAgW0NoYXIuaWRdOiBDaGFyLFxuICBbTlZhckNoYXIuaWRdOiBOVmFyQ2hhcixcbiAgW05DaGFyLmlkXTogTkNoYXIsXG4gIFtYbWwuaWRdOiBYbWwsXG4gIFtUaW1lLmlkXTogVGltZSxcbiAgW0RhdGUuaWRdOiBEYXRlLFxuICBbRGF0ZVRpbWUyLmlkXTogRGF0ZVRpbWUyLFxuICBbRGF0ZVRpbWVPZmZzZXQuaWRdOiBEYXRlVGltZU9mZnNldCxcbiAgW1VEVC5pZF06IFVEVCxcbiAgW1RWUC5pZF06IFRWUCxcbiAgW1ZhcmlhbnQuaWRdOiBWYXJpYW50LFxufTtcblxuLyoqXG4gKiA8dGFibGU+XG4gKiA8dGhlYWQ+XG4gKiAgIDx0cj5cbiAqICAgICA8dGg+VHlwZTwvdGg+XG4gKiAgICAgPHRoPkNvbnN0YW50PC90aD5cbiAqICAgICA8dGg+SmF2YVNjcmlwdDwvdGg+XG4gKiAgICAgPHRoPlJlc3VsdCBzZXQ8L3RoPlxuICogICAgIDx0aD5QYXJhbWV0ZXI8L3RoPlxuICogICA8L3RyPlxuICogPC90aGVhZD5cbiAqXG4gKiA8dGJvZHk+XG4gKiAgIDx0ciBjbGFzcz1cImdyb3VwLWhlYWRpbmdcIj5cbiAqICAgICA8dGggY29sc3Bhbj1cIjVcIj5FeGFjdCBudW1lcmljczwvdGg+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+Yml0PC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuQml0XV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+Ym9vbGVhbjwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPnRpbnlpbnQ8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5UaW55SW50XV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+bnVtYmVyPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+c21hbGxpbnQ8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5TbWFsbEludF1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPm51bWJlcjwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPmludDwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLkludF1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPm51bWJlcjwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPmJpZ2ludDwvY29kZT48c3VwPjE8L3N1cD48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLkJpZ0ludF1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPnN0cmluZzwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPm51bWVyaWM8L2NvZGU+PHN1cD4yPC9zdXA+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5OdW1lcmljXV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+bnVtYmVyPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+ZGVjaW1hbDwvY29kZT48c3VwPjI8L3N1cD48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLkRlY2ltYWxdXTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5udW1iZXI8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT5zbWFsbG1vbmV5PC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuU21hbGxNb25leV1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPm51bWJlcjwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPm1vbmV5PC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuTW9uZXldXTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5udW1iZXI8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgPC90cj5cbiAqIDwvdGJvZHk+XG4gKlxuICogPHRib2R5PlxuICogICA8dHIgY2xhc3M9XCJncm91cC1oZWFkaW5nXCI+XG4gKiAgICAgPHRoIGNvbHNwYW49XCI1XCI+QXBwcm94aW1hdGUgbnVtZXJpY3M8L3RoPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPmZsb2F0PC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuRmxvYXRdXTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5udW1iZXI8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT5yZWFsPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuUmVhbF1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPm51bWJlcjwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogPC90Ym9keT5cbiAqXG4gKiA8dGJvZHk+XG4gKiAgIDx0ciBjbGFzcz1cImdyb3VwLWhlYWRpbmdcIj5cbiAqICAgICA8dGggY29sc3Bhbj1cIjRcIj5EYXRlIGFuZCBUaW1lPC90aD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT5zbWFsbGRhdGV0aW1lPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuU21hbGxEYXRlVGltZV1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPkRhdGU8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT5kYXRldGltZTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLkRhdGVUaW1lXV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+RGF0ZTwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPmRhdGV0aW1lMjwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLkRhdGVUaW1lMl1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPkRhdGU8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT5kYXRldGltZW9mZnNldDwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLkRhdGVUaW1lT2Zmc2V0XV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+RGF0ZTwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPnRpbWU8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5UaW1lXV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+RGF0ZTwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPmRhdGU8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5EYXRlXV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+RGF0ZTwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogPC90Ym9keT5cbiAqXG4gKiA8dGJvZHk+XG4gKiAgIDx0ciBjbGFzcz1cImdyb3VwLWhlYWRpbmdcIj5cbiAqICAgICA8dGggY29sc3Bhbj1cIjRcIj5DaGFyYWN0ZXIgU3RyaW5nczwvdGg+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+Y2hhcjwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLkNoYXJdXTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5zdHJpbmc8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT52YXJjaGFyPC9jb2RlPjxzdXA+Mzwvc3VwPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuVmFyQ2hhcl1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPnN0cmluZzwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPnRleHQ8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5UZXh0XV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+c3RyaW5nPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgIDwvdHI+XG4gKiA8L3Rib2R5PlxuICpcbiAqIDx0Ym9keT5cbiAqICAgPHRyIGNsYXNzPVwiZ3JvdXAtaGVhZGluZ1wiPlxuICogICAgIDx0aCBjb2xzcGFuPVwiNFwiPlVuaWNvZGUgU3RyaW5nczwvdGg+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+bmNoYXI8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5OQ2hhcl1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPnN0cmluZzwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPm52YXJjaGFyPC9jb2RlPjxzdXA+Mzwvc3VwPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuTlZhckNoYXJdXTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5zdHJpbmc8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT5udGV4dDwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLk5UZXh0XV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+c3RyaW5nPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPi08L3RkPlxuICogICA8L3RyPlxuICogPC90Ym9keT5cbiAqXG4gKiA8dGJvZHk+XG4gKiAgIDx0ciBjbGFzcz1cImdyb3VwLWhlYWRpbmdcIj5cbiAqICAgICA8dGggY29sc3Bhbj1cIjVcIj5CaW5hcnkgU3RyaW5nczxzdXA+NDwvc3VwPjwvdGg+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+YmluYXJ5PC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuQmluYXJ5XV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+QnVmZmVyPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+dmFyYmluYXJ5PC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuVmFyQmluYXJ5XV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+QnVmZmVyPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+aW1hZ2U8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5JbWFnZV1dPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPkJ1ZmZlcjwvY29kZT48L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICAgIDx0ZD7inJM8L3RkPlxuICogICA8L3RyPlxuICogPC90Ym9keT5cbiAqXG4gKiA8dGJvZHk+XG4gKiAgIDx0ciBjbGFzcz1cImdyb3VwLWhlYWRpbmdcIj5cbiAqICAgICA8dGggY29sc3Bhbj1cIjVcIj5PdGhlciBEYXRhIFR5cGVzPC90aD5cbiAqICAgPC90cj5cbiAqICAgPHRyPlxuICogICAgIDx0ZD48Y29kZT5UVlA8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5UVlBdXTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5PYmplY3Q8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+LTwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+VURUPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuVURUXV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+QnVmZmVyPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPi08L3RkPlxuICogICA8L3RyPlxuICogICA8dHI+XG4gKiAgICAgPHRkPjxjb2RlPnVuaXF1ZWlkZW50aWZpZXI8L2NvZGU+PHN1cD40PC9zdXA+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+W1tUWVBFUy5VbmlxdWVJZGVudGlmaWVyXV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+c3RyaW5nPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+dmFyaWFudDwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5bW1RZUEVTLlZhcmlhbnRdXTwvY29kZT48L3RkPlxuICogICAgIDx0ZD48Y29kZT5hbnk8L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+4pyTPC90ZD5cbiAqICAgICA8dGQ+LTwvdGQ+XG4gKiAgIDwvdHI+XG4gKiAgIDx0cj5cbiAqICAgICA8dGQ+PGNvZGU+eG1sPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPjxjb2RlPltbVFlQRVMuWG1sXV08L2NvZGU+PC90ZD5cbiAqICAgICA8dGQ+PGNvZGU+c3RyaW5nPC9jb2RlPjwvdGQ+XG4gKiAgICAgPHRkPuKckzwvdGQ+XG4gKiAgICAgPHRkPi08L3RkPlxuICogICA8L3RyPlxuICogPC90Ym9keT5cbiAqIDwvdGFibGU+XG4gKlxuICogPG9sPlxuICogICA8bGk+XG4gKiAgICAgPGg0PkJpZ0ludDwvaDQ+XG4gKiAgICAgPHA+XG4gKiAgICAgICBWYWx1ZXMgYXJlIHJldHVybmVkIGFzIGEgc3RyaW5nLiBUaGlzIGlzIGJlY2F1c2UgdmFsdWVzIGNhbiBleGNlZWQgNTMgYml0cyBvZiBzaWduaWZpY2FudCBkYXRhLCB3aGljaCBpcyBncmVhdGVyIHRoYW4gYVxuICogICAgICAgSmF2YXNjcmlwdCA8Y29kZT5udW1iZXI8L2NvZGU+IHR5cGUgY2FuIHJlcHJlc2VudCBhcyBhbiBpbnRlZ2VyLlxuICogICAgIDwvcD5cbiAqICAgPC9saT5cbiAqICAgPGxpPlxuICogICAgIDxoND5OdW1lcmljYWwsIERlY2ltYWw8L2g0PlxuICogICAgIDxwPlxuICogICAgICAgRm9yIGlucHV0IHBhcmFtZXRlcnMsIGRlZmF1bHQgcHJlY2lzaW9uIGlzIDE4IGFuZCBkZWZhdWx0IHNjYWxlIGlzIDAuIE1heGltdW0gc3VwcG9ydGVkIHByZWNpc2lvbiBpcyAxOS5cbiAqICAgICA8L3A+XG4gKiAgIDwvbGk+XG4gKiAgIDxsaT5cbiAqICAgICA8aDQ+VmFyQ2hhciwgTlZhckNoYXI8L2g0PlxuICogICAgIDxwPlxuICogICAgICAgPGNvZGU+dmFyY2hhcihtYXgpPC9jb2RlPiBhbmQgPGNvZGU+bnZhcmNoYXIobWF4KTwvY29kZT4gYXJlIGFsc28gc3VwcG9ydGVkLlxuICogICAgIDwvcD5cbiAqICAgPC9saT5cbiAqICAgPGxpPlxuICogICAgIDxoND5VbmlxdWVJZGVudGlmaWVyPC9oND5cbiAqICAgICA8cD5cbiAqICAgICAgIFZhbHVlcyBhcmUgcmV0dXJuZWQgYXMgYSAxNiBieXRlIGhleGFkZWNpbWFsIHN0cmluZy5cbiAqICAgICA8L3A+XG4gKiAgICAgPHA+XG4gKiAgICAgICBOb3RlIHRoYXQgdGhlIG9yZGVyIG9mIGJ5dGVzIGlzIG5vdCB0aGUgc2FtZSBhcyB0aGUgY2hhcmFjdGVyIHJlcHJlc2VudGF0aW9uLiBTZWVcbiAqICAgICAgIDxhIGhyZWY9XCJodHRwOi8vbXNkbi5taWNyb3NvZnQuY29tL2VuLXVzL2xpYnJhcnkvbXMxOTAyMTUuYXNweFwiPlVzaW5nIHVuaXF1ZWlkZW50aWZpZXIgRGF0YTwvYT5cbiAqICAgICAgIGZvciBhbiBleGFtcGxlIG9mIHRoZSBkaWZmZXJlbnQgb3JkZXJpbmcgb2YgYnl0ZXMuXG4gKiAgICAgPC9wPlxuICogICA8L2xpPlxuICogPC9vbD5cbiAqL1xuZXhwb3J0IGNvbnN0IFRZUEVTID0ge1xuICBUaW55SW50LFxuICBCaXQsXG4gIFNtYWxsSW50LFxuICBJbnQsXG4gIFNtYWxsRGF0ZVRpbWUsXG4gIFJlYWwsXG4gIE1vbmV5LFxuICBEYXRlVGltZSxcbiAgRmxvYXQsXG4gIERlY2ltYWwsXG4gIE51bWVyaWMsXG4gIFNtYWxsTW9uZXksXG4gIEJpZ0ludCxcbiAgSW1hZ2UsXG4gIFRleHQsXG4gIFVuaXF1ZUlkZW50aWZpZXIsXG4gIE5UZXh0LFxuICBWYXJCaW5hcnksXG4gIFZhckNoYXIsXG4gIEJpbmFyeSxcbiAgQ2hhcixcbiAgTlZhckNoYXIsXG4gIE5DaGFyLFxuICBYbWwsXG4gIFRpbWUsXG4gIERhdGUsXG4gIERhdGVUaW1lMixcbiAgRGF0ZVRpbWVPZmZzZXQsXG4gIFVEVCxcbiAgVFZQLFxuICBWYXJpYW50XG59O1xuXG5leHBvcnQgY29uc3QgdHlwZUJ5TmFtZSA9IFRZUEVTO1xuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxJQUFBQSxLQUFBLEdBQUFDLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBQyxRQUFBLEdBQUFGLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBRSxJQUFBLEdBQUFILHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBRyxTQUFBLEdBQUFKLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBSSxJQUFBLEdBQUFMLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBSyxjQUFBLEdBQUFOLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBTSxLQUFBLEdBQUFQLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBTyxNQUFBLEdBQUFSLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBUSxTQUFBLEdBQUFULHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBUyxNQUFBLEdBQUFWLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBVSxRQUFBLEdBQUFYLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBVyxRQUFBLEdBQUFaLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBWSxXQUFBLEdBQUFiLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBYSxPQUFBLEdBQUFkLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBYyxNQUFBLEdBQUFmLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBZSxLQUFBLEdBQUFoQixzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQWdCLGlCQUFBLEdBQUFqQixzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQWlCLEtBQUEsR0FBQWxCLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBa0IsTUFBQSxHQUFBbkIsc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUFtQixLQUFBLEdBQUFwQixzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQW9CLFNBQUEsR0FBQXJCLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBcUIsU0FBQSxHQUFBdEIsc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUFzQixPQUFBLEdBQUF2QixzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQXVCLE9BQUEsR0FBQXhCLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBd0IsVUFBQSxHQUFBekIsc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUF5QixVQUFBLEdBQUExQixzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQTBCLFFBQUEsR0FBQTNCLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBMkIsT0FBQSxHQUFBNUIsc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUE0QixLQUFBLEdBQUE3QixzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQTZCLFNBQUEsR0FBQTlCLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBOEIsTUFBQSxHQUFBL0Isc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUErQixJQUFBLEdBQUFoQyxzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQWdDLEtBQUEsR0FBQWpDLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBaUMsS0FBQSxHQUFBbEMsc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUFrQyxVQUFBLEdBQUFuQyxzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQW1DLGVBQUEsR0FBQXBDLHNCQUFBLENBQUFDLE9BQUE7QUFDQSxJQUFBb0MsSUFBQSxHQUFBckMsc0JBQUEsQ0FBQUMsT0FBQTtBQUNBLElBQUFxQyxJQUFBLEdBQUF0QyxzQkFBQSxDQUFBQyxPQUFBO0FBQ0EsSUFBQXNDLFdBQUEsR0FBQXZDLHNCQUFBLENBQUFDLE9BQUE7QUFBK0MsU0FBQUQsdUJBQUF3QyxDQUFBLFdBQUFBLENBQUEsSUFBQUEsQ0FBQSxDQUFBQyxVQUFBLEdBQUFELENBQUEsS0FBQUUsT0FBQSxFQUFBRixDQUFBO0FBcUR4QyxNQUFNRyxJQUFJLEdBQUFDLE9BQUEsQ0FBQUQsSUFBQSxHQUFHO0VBQ2xCLENBQUNFLGFBQUksQ0FBQ0MsRUFBRSxHQUFHRCxhQUFJO0VBQ2YsQ0FBQ0UsZ0JBQU8sQ0FBQ0QsRUFBRSxHQUFHQyxnQkFBTztFQUNyQixDQUFDQyxZQUFHLENBQUNGLEVBQUUsR0FBR0UsWUFBRztFQUNiLENBQUNDLGlCQUFRLENBQUNILEVBQUUsR0FBR0csaUJBQVE7RUFDdkIsQ0FBQ0MsWUFBRyxDQUFDSixFQUFFLEdBQUdJLFlBQUc7RUFDYixDQUFDQyxzQkFBYSxDQUFDTCxFQUFFLEdBQUdLLHNCQUFhO0VBQ2pDLENBQUNDLGFBQUksQ0FBQ04sRUFBRSxHQUFHTSxhQUFJO0VBQ2YsQ0FBQ0MsY0FBSyxDQUFDUCxFQUFFLEdBQUdPLGNBQUs7RUFDakIsQ0FBQ0MsaUJBQVEsQ0FBQ1IsRUFBRSxHQUFHUSxpQkFBUTtFQUN2QixDQUFDQyxjQUFLLENBQUNULEVBQUUsR0FBR1MsY0FBSztFQUNqQixDQUFDQyxnQkFBTyxDQUFDVixFQUFFLEdBQUdVLGdCQUFPO0VBQ3JCLENBQUNDLGdCQUFPLENBQUNYLEVBQUUsR0FBR1csZ0JBQU87RUFDckIsQ0FBQ0MsbUJBQVUsQ0FBQ1osRUFBRSxHQUFHWSxtQkFBVTtFQUMzQixDQUFDQyxlQUFNLENBQUNiLEVBQUUsR0FBR2EsZUFBTTtFQUNuQixDQUFDQyxjQUFLLENBQUNkLEVBQUUsR0FBR2MsY0FBSztFQUNqQixDQUFDQyxhQUFJLENBQUNmLEVBQUUsR0FBR2UsYUFBSTtFQUNmLENBQUNDLHlCQUFnQixDQUFDaEIsRUFBRSxHQUFHZ0IseUJBQWdCO0VBQ3ZDLENBQUNDLGFBQUksQ0FBQ2pCLEVBQUUsR0FBR2lCLGFBQUk7RUFDZixDQUFDQyxjQUFLLENBQUNsQixFQUFFLEdBQUdrQixjQUFLO0VBQ2pCLENBQUNDLGFBQUksQ0FBQ25CLEVBQUUsR0FBR21CLGFBQUk7RUFDZixDQUFDQyxpQkFBUSxDQUFDcEIsRUFBRSxHQUFHb0IsaUJBQVE7RUFDdkIsQ0FBQ0MsaUJBQVEsQ0FBQ3JCLEVBQUUsR0FBR3FCLGlCQUFRO0VBQ3ZCLENBQUNDLGVBQU0sQ0FBQ3RCLEVBQUUsR0FBR3NCLGVBQU07RUFDbkIsQ0FBQ0MsZUFBTSxDQUFDdkIsRUFBRSxHQUFHdUIsZUFBTTtFQUNuQixDQUFDQyxrQkFBUyxDQUFDeEIsRUFBRSxHQUFHd0Isa0JBQVM7RUFDekIsQ0FBQ0Msa0JBQVMsQ0FBQ3pCLEVBQUUsR0FBR3lCLGtCQUFTO0VBQ3pCLENBQUNDLGdCQUFPLENBQUMxQixFQUFFLEdBQUcwQixnQkFBTztFQUNyQixDQUFDQyxlQUFNLENBQUMzQixFQUFFLEdBQUcyQixlQUFNO0VBQ25CLENBQUNDLGFBQUksQ0FBQzVCLEVBQUUsR0FBRzRCLGFBQUk7RUFDZixDQUFDQyxpQkFBUSxDQUFDN0IsRUFBRSxHQUFHNkIsaUJBQVE7RUFDdkIsQ0FBQ0MsY0FBSyxDQUFDOUIsRUFBRSxHQUFHOEIsY0FBSztFQUNqQixDQUFDQyxZQUFHLENBQUMvQixFQUFFLEdBQUcrQixZQUFHO0VBQ2IsQ0FBQ0MsYUFBSSxDQUFDaEMsRUFBRSxHQUFHZ0MsYUFBSTtFQUNmLENBQUNDLGFBQUksQ0FBQ2pDLEVBQUUsR0FBR2lDLGFBQUk7RUFDZixDQUFDQyxrQkFBUyxDQUFDbEMsRUFBRSxHQUFHa0Msa0JBQVM7RUFDekIsQ0FBQ0MsdUJBQWMsQ0FBQ25DLEVBQUUsR0FBR21DLHVCQUFjO0VBQ25DLENBQUNDLFlBQUcsQ0FBQ3BDLEVBQUUsR0FBR29DLFlBQUc7RUFDYixDQUFDQyxZQUFHLENBQUNyQyxFQUFFLEdBQUdxQyxZQUFHO0VBQ2IsQ0FBQ0MsbUJBQU8sQ0FBQ3RDLEVBQUUsR0FBR3NDO0FBQ2hCLENBQUM7O0FBRUQ7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNPLE1BQU1DLEtBQUssR0FBQXpDLE9BQUEsQ0FBQXlDLEtBQUEsR0FBRztFQUNuQnRDLE9BQU8sRUFBUEEsZ0JBQU87RUFDUEMsR0FBRyxFQUFIQSxZQUFHO0VBQ0hDLFFBQVEsRUFBUkEsaUJBQVE7RUFDUkMsR0FBRyxFQUFIQSxZQUFHO0VBQ0hDLGFBQWEsRUFBYkEsc0JBQWE7RUFDYkMsSUFBSSxFQUFKQSxhQUFJO0VBQ0pDLEtBQUssRUFBTEEsY0FBSztFQUNMQyxRQUFRLEVBQVJBLGlCQUFRO0VBQ1JDLEtBQUssRUFBTEEsY0FBSztFQUNMQyxPQUFPLEVBQVBBLGdCQUFPO0VBQ1BDLE9BQU8sRUFBUEEsZ0JBQU87RUFDUEMsVUFBVSxFQUFWQSxtQkFBVTtFQUNWQyxNQUFNLEVBQU5BLGVBQU07RUFDTkMsS0FBSyxFQUFMQSxjQUFLO0VBQ0xDLElBQUksRUFBSkEsYUFBSTtFQUNKQyxnQkFBZ0IsRUFBaEJBLHlCQUFnQjtFQUNoQkUsS0FBSyxFQUFMQSxjQUFLO0VBQ0xPLFNBQVMsRUFBVEEsa0JBQVM7RUFDVEMsT0FBTyxFQUFQQSxnQkFBTztFQUNQQyxNQUFNLEVBQU5BLGVBQU07RUFDTkMsSUFBSSxFQUFKQSxhQUFJO0VBQ0pDLFFBQVEsRUFBUkEsaUJBQVE7RUFDUkMsS0FBSyxFQUFMQSxjQUFLO0VBQ0xDLEdBQUcsRUFBSEEsWUFBRztFQUNIQyxJQUFJLEVBQUpBLGFBQUk7RUFDSkMsSUFBSSxFQUFKQSxhQUFJO0VBQ0pDLFNBQVMsRUFBVEEsa0JBQVM7RUFDVEMsY0FBYyxFQUFkQSx1QkFBYztFQUNkQyxHQUFHLEVBQUhBLFlBQUc7RUFDSEMsR0FBRyxFQUFIQSxZQUFHO0VBQ0hDLE9BQU8sRUFBUEE7QUFDRixDQUFDO0FBRU0sTUFBTUUsVUFBVSxHQUFBMUMsT0FBQSxDQUFBMEMsVUFBQSxHQUFHRCxLQUFLIiwiaWdub3JlTGlzdCI6W119