"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _intn = _interopRequireDefault(require("./intn"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const DATA_LENGTH = Buffer.from([0x02]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallInt = {
  id: 0x34,
  type: 'INT2',
  name: 'SmallInt',
  declaration: function () {
    return 'smallint';
  },
  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x02]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const buffer = Buffer.alloc(2);
    buffer.writeInt16LE(Number(parameter.value), 0);
    yield buffer;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    if (typeof value !== 'number') {
      value = Number(value);
    }
    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }
    if (value < -32768 || value > 32767) {
      throw new TypeError('Value must be between -32768 and 32767, inclusive.');
    }
    return value | 0;
  }
};
var _default = exports.default = SmallInt;
module.exports = SmallInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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