"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _writableTrackingBuffer = _interopRequireDefault(require("./tracking-buffer/writable-tracking-buffer"));
var _allHeaders = require("./all-headers");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
  s2.2.6.6
 */
class SqlBatchPayload {
  constructor(sqlText, txnDescriptor, options) {
    this.sqlText = sqlText;
    this.txnDescriptor = txnDescriptor;
    this.options = options;
  }
  *[Symbol.iterator]() {
    if (this.options.tdsVersion >= '7_2') {
      const buffer = new _writableTrackingBuffer.default(18, 'ucs2');
      const outstandingRequestCount = 1;
      (0, _allHeaders.writeToTrackingBuffer)(buffer, this.txnDescriptor, outstandingRequestCount);
      yield buffer.data;
    }
    yield Buffer.from(this.sqlText, 'ucs2');
  }
  toString(indent = '') {
    return indent + ('SQL Batch - ' + this.sqlText);
  }
}
var _default = exports.default = SqlBatchPayload;
module.exports = SqlBatchPayload;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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