set(program_name go)
set(program_version 1.25.5)
set(brew_package_name "go")
set(apt_package_name "golang-go")
if(CMAKE_HOST_WIN32)
    if(DEFINED ENV{PROCESSOR_ARCHITEW6432})
        set(build_arch $ENV{PROCESSOR_ARCHITEW6432})
    else()
        set(build_arch $ENV{PROCESSOR_ARCHITECTURE})
    endif()
    if(build_arch MATCHES "^(ARM|arm)64$")
        set(tool_subdirectory ${program_version}.windows-arm64)
        set(download_sha512 1282b9898e604003bdfe42f1afcf5e5d074bfbebf0b34e8d79bae5cb0c561fe13705325837895db76843864299929f8a3fa72372bd79becc1d121e33f6deb1d2)
    elseif(build_arch MATCHES "^(AMD|amd)64$")
        set(tool_subdirectory ${program_version}.windows-amd64)
        set(download_sha512 0628e15ac96a766a6e903e6bfb1706ff23bd0de61ca2bbd3716349b15feb5c45cfc814b6d0eba1d1096b70f41778524db6be33ff45b6594f449d4fc3bcbf9b68)
    else()
        # Default to x86 for 32-bit systems
        set(tool_subdirectory ${program_version}.windows-386)
        set(download_sha512 b55873696b4e38ec92583adc2e573f03dc57e77ee97e5ef61db0dc25b69d18595b0e08cb74d7a45c119ae394f681d60c9235034b44acd17ee1907e628a50b6e9)
    endif()
    set(paths_to_search "${DOWNLOADS}/tools/go/${tool_subdirectory}/go/bin")
    set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.zip")
    set(download_filename "go${tool_subdirectory}.zip")
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Darwin")
    vcpkg_execute_in_download_mode(COMMAND "uname" "-m" OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH MATCHES "x86_64|amd64|AMD64")
        set(tool_subdirectory ${program_version}.darwin-amd64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 1646af2f49e93920b1db021ab3f054faa45b8fcfc3eaae57595a7957a3fa3718aa0deaad5c98998aad11dfa62dda5d0d3b08ad40d3ebb17ca8790cd7a91c98b2)
    elseif(HOST_ARCH MATCHES "arm64|aarch64|ARM64|AARCH64")
        set(tool_subdirectory ${program_version}.darwin-arm64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 92f5bb2524f0f83f1275e703266cd243a68f96710e408809f82fffab73c30fffc361b97563f1d0f851d22e858c5d25571366c7aacc6186bdf472f6687fbb893c)
    endif()
    set(paths_to_search "${DOWNLOADS}/tools/go/${tool_subdirectory}/go/bin")
elseif(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux")
    vcpkg_execute_in_download_mode(COMMAND "uname" "-m" OUTPUT_VARIABLE HOST_ARCH OUTPUT_STRIP_TRAILING_WHITESPACE)
    if(HOST_ARCH MATCHES "x86_64|amd64|AMD64")
        set(tool_subdirectory ${program_version}.linux-amd64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 b23f749a51b6da1bf7042a87af6daca2454604c69c62044627b411769f207ac5676fb629948a26c16000c3b495bf785902c3250a6db4522f60dbf4ad900064a8)
    elseif(HOST_ARCH MATCHES "arm64|aarch64|ARM64|AARCH64")
        set(tool_subdirectory ${program_version}.linux-arm64)
        set(download_urls "https://dl.google.com/go/go${tool_subdirectory}.tar.gz")
        set(download_filename "go${tool_subdirectory}.tar.gz")
        set(download_sha512 5f67f7c45652a47553edd3835d1ca400a51aa5d1b9880c05fe5e7344341814d3107d6a39f18203baf52363507de8dd5f75241f0f7ecda0bdabcef9a82f6e50e6)
    endif()
    set(paths_to_search "${DOWNLOADS}/tools/go/${tool_subdirectory}/go/bin")
else()
    message(WARNING "Unsupported host system for prebuilt Go binaries. Skipping...")
endif()
