vcpkg_from_github(
    OUT_SOURCE_PATH SOURCE_PATH
    REPO knncolle/knncolle
    REF "v${VERSION}"
    SHA512 f9e0be6880e6f641b3cce4d46340f6abf3e3c6b27e3ac46fd944da944fba1e0fcde95b8b615af3a63028d19be3859e5a48a65f0d0850fab3192cb66c2dfde0b7
    HEAD_REF master
)

set(VCPKG_BUILD_TYPE "release") # header-only port

vcpkg_cmake_configure(
    SOURCE_PATH "${SOURCE_PATH}"
    OPTIONS
        -DKNNCOLLE_FETCH_EXTERN=OFF
        -DKNNCOLLE_TESTS=OFF
)

vcpkg_cmake_install()
vcpkg_cmake_config_fixup(
    PACKAGE_NAME knncolle_knncolle
    CONFIG_PATH lib/cmake/knncolle_knncolle
)

file(REMOVE_RECURSE "${CURRENT_PACKAGES_DIR}/lib")

vcpkg_install_copyright(FILE_LIST "${SOURCE_PATH}/LICENSE")
file(INSTALL "${CMAKE_CURRENT_LIST_DIR}/usage" DESTINATION "${CURRENT_PACKAGES_DIR}/share/${PORT}")
