/* Generated by wayland-scanner 1.24.0 */

#ifndef EXT_WORKSPACE_V1_SERVER_PROTOCOL_H
#define EXT_WORKSPACE_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_ext_workspace_v1 The ext_workspace_v1 protocol
 * @section page_ifaces_ext_workspace_v1 Interfaces
 * - @subpage page_iface_ext_workspace_manager_v1 - list and control workspaces
 * - @subpage page_iface_ext_workspace_group_handle_v1 - a workspace group assigned to a set of outputs
 * - @subpage page_iface_ext_workspace_handle_v1 - a workspace handing a group of surfaces
 * @section page_copyright_ext_workspace_v1 Copyright
 * <pre>
 *
 * Copyright © 2019 Christopher Billington
 * Copyright © 2020 Ilia Bozhinov
 * Copyright © 2022 Victoria Brekenfeld
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct ext_workspace_group_handle_v1;
struct ext_workspace_handle_v1;
struct ext_workspace_manager_v1;
struct wl_output;

#ifndef EXT_WORKSPACE_MANAGER_V1_INTERFACE
#define EXT_WORKSPACE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_workspace_manager_v1 ext_workspace_manager_v1
 * @section page_iface_ext_workspace_manager_v1_desc Description
 *
 * Workspaces, also called virtual desktops, are groups of surfaces. A
 * compositor with a concept of workspaces may only show some such groups of
 * surfaces (those of 'active' workspaces) at a time. 'Activating' a
 * workspace is a request for the compositor to display that workspace's
 * surfaces as normal, whereas the compositor may hide or otherwise
 * de-emphasise surfaces that are associated only with 'inactive' workspaces.
 * Workspaces are grouped by which sets of outputs they correspond to, and
 * may contain surfaces only from those outputs. In this way, it is possible
 * for each output to have its own set of workspaces, or for all outputs (or
 * any other arbitrary grouping) to share workspaces. Compositors may
 * optionally conceptually arrange each group of workspaces in an
 * N-dimensional grid.
 *
 * The purpose of this protocol is to enable the creation of taskbars and
 * docks by providing them with a list of workspaces and their properties,
 * and allowing them to activate and deactivate workspaces.
 *
 * After a client binds the ext_workspace_manager_v1, each workspace will be
 * sent via the workspace event.
 * @section page_iface_ext_workspace_manager_v1_api API
 * See @ref iface_ext_workspace_manager_v1.
 */
/**
 * @defgroup iface_ext_workspace_manager_v1 The ext_workspace_manager_v1 interface
 *
 * Workspaces, also called virtual desktops, are groups of surfaces. A
 * compositor with a concept of workspaces may only show some such groups of
 * surfaces (those of 'active' workspaces) at a time. 'Activating' a
 * workspace is a request for the compositor to display that workspace's
 * surfaces as normal, whereas the compositor may hide or otherwise
 * de-emphasise surfaces that are associated only with 'inactive' workspaces.
 * Workspaces are grouped by which sets of outputs they correspond to, and
 * may contain surfaces only from those outputs. In this way, it is possible
 * for each output to have its own set of workspaces, or for all outputs (or
 * any other arbitrary grouping) to share workspaces. Compositors may
 * optionally conceptually arrange each group of workspaces in an
 * N-dimensional grid.
 *
 * The purpose of this protocol is to enable the creation of taskbars and
 * docks by providing them with a list of workspaces and their properties,
 * and allowing them to activate and deactivate workspaces.
 *
 * After a client binds the ext_workspace_manager_v1, each workspace will be
 * sent via the workspace event.
 */
extern const struct wl_interface ext_workspace_manager_v1_interface;
#endif
#ifndef EXT_WORKSPACE_GROUP_HANDLE_V1_INTERFACE
#define EXT_WORKSPACE_GROUP_HANDLE_V1_INTERFACE
/**
 * @page page_iface_ext_workspace_group_handle_v1 ext_workspace_group_handle_v1
 * @section page_iface_ext_workspace_group_handle_v1_desc Description
 *
 * A ext_workspace_group_handle_v1 object represents a workspace group
 * that is assigned a set of outputs and contains a number of workspaces.
 *
 * The set of outputs assigned to the workspace group is conveyed to the client via
 * output_enter and output_leave events, and its workspaces are conveyed with
 * workspace events.
 *
 * For example, a compositor which has a set of workspaces for each output may
 * advertise a workspace group (and its workspaces) per output, whereas a compositor
 * where a workspace spans all outputs may advertise a single workspace group for all
 * outputs.
 * @section page_iface_ext_workspace_group_handle_v1_api API
 * See @ref iface_ext_workspace_group_handle_v1.
 */
/**
 * @defgroup iface_ext_workspace_group_handle_v1 The ext_workspace_group_handle_v1 interface
 *
 * A ext_workspace_group_handle_v1 object represents a workspace group
 * that is assigned a set of outputs and contains a number of workspaces.
 *
 * The set of outputs assigned to the workspace group is conveyed to the client via
 * output_enter and output_leave events, and its workspaces are conveyed with
 * workspace events.
 *
 * For example, a compositor which has a set of workspaces for each output may
 * advertise a workspace group (and its workspaces) per output, whereas a compositor
 * where a workspace spans all outputs may advertise a single workspace group for all
 * outputs.
 */
extern const struct wl_interface ext_workspace_group_handle_v1_interface;
#endif
#ifndef EXT_WORKSPACE_HANDLE_V1_INTERFACE
#define EXT_WORKSPACE_HANDLE_V1_INTERFACE
/**
 * @page page_iface_ext_workspace_handle_v1 ext_workspace_handle_v1
 * @section page_iface_ext_workspace_handle_v1_desc Description
 *
 * A ext_workspace_handle_v1 object represents a workspace that handles a
 * group of surfaces.
 *
 * Each workspace has:
 * - a name, conveyed to the client with the name event
 * - potentially an id conveyed with the id event
 * - a list of states, conveyed to the client with the state event
 * - and optionally a set of coordinates, conveyed to the client with the
 * coordinates event
 *
 * The client may request that the compositor activate or deactivate the workspace.
 *
 * Each workspace can belong to only a single workspace group.
 * Depending on the compositor policy, there might be workspaces with
 * the same name in different workspace groups, but these workspaces are still
 * separate (e.g. one of them might be active while the other is not).
 * @section page_iface_ext_workspace_handle_v1_api API
 * See @ref iface_ext_workspace_handle_v1.
 */
/**
 * @defgroup iface_ext_workspace_handle_v1 The ext_workspace_handle_v1 interface
 *
 * A ext_workspace_handle_v1 object represents a workspace that handles a
 * group of surfaces.
 *
 * Each workspace has:
 * - a name, conveyed to the client with the name event
 * - potentially an id conveyed with the id event
 * - a list of states, conveyed to the client with the state event
 * - and optionally a set of coordinates, conveyed to the client with the
 * coordinates event
 *
 * The client may request that the compositor activate or deactivate the workspace.
 *
 * Each workspace can belong to only a single workspace group.
 * Depending on the compositor policy, there might be workspaces with
 * the same name in different workspace groups, but these workspaces are still
 * separate (e.g. one of them might be active while the other is not).
 */
extern const struct wl_interface ext_workspace_handle_v1_interface;
#endif

/**
 * @ingroup iface_ext_workspace_manager_v1
 * @struct ext_workspace_manager_v1_interface
 */
struct ext_workspace_manager_v1_interface {
	/**
	 * all requests about the workspaces have been sent
	 *
	 * The client must send this request after it has finished
	 * sending other requests. The compositor must process a series of
	 * requests preceding a commit request atomically.
	 *
	 * This allows changes to the workspace properties to be seen as
	 * atomic, even if they happen via multiple events, and even if
	 * they involve multiple ext_workspace_handle_v1 objects, for
	 * example, deactivating one workspace and activating another.
	 */
	void (*commit)(struct wl_client *client,
		       struct wl_resource *resource);
	/**
	 * stop sending events
	 *
	 * Indicates the client no longer wishes to receive events for
	 * new workspace groups. However the compositor may emit further
	 * workspace events, until the finished event is emitted. The
	 * compositor is expected to send the finished event eventually
	 * once the stop request has been processed.
	 *
	 * The client must not send any requests after this one, doing so
	 * will raise a wl_display invalid_object error.
	 */
	void (*stop)(struct wl_client *client,
		     struct wl_resource *resource);
};

#define EXT_WORKSPACE_MANAGER_V1_WORKSPACE_GROUP 0
#define EXT_WORKSPACE_MANAGER_V1_WORKSPACE 1
#define EXT_WORKSPACE_MANAGER_V1_DONE 2
#define EXT_WORKSPACE_MANAGER_V1_FINISHED 3

/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_WORKSPACE_GROUP_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_WORKSPACE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_STOP_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_manager_v1
 * Sends an workspace_group event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_manager_v1_send_workspace_group(struct wl_resource *resource_, struct wl_resource *workspace_group)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_MANAGER_V1_WORKSPACE_GROUP, workspace_group);
}

/**
 * @ingroup iface_ext_workspace_manager_v1
 * Sends an workspace event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_manager_v1_send_workspace(struct wl_resource *resource_, struct wl_resource *workspace)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_MANAGER_V1_WORKSPACE, workspace);
}

/**
 * @ingroup iface_ext_workspace_manager_v1
 * Sends an done event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_manager_v1_send_done(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_MANAGER_V1_DONE);
}

/**
 * @ingroup iface_ext_workspace_manager_v1
 * Sends an finished event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_manager_v1_send_finished(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_MANAGER_V1_FINISHED);
}

#ifndef EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM
#define EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM
enum ext_workspace_group_handle_v1_group_capabilities {
	/**
	 * create_workspace request is available
	 */
	EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_CREATE_WORKSPACE = 1,
};
#endif /* EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM */

#ifndef EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM_IS_VALID
#define EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM_IS_VALID
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * Validate a ext_workspace_group_handle_v1 group_capabilities value.
 *
 * @return true on success, false on error.
 * @ref ext_workspace_group_handle_v1_group_capabilities
 */
static inline bool
ext_workspace_group_handle_v1_group_capabilities_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_CREATE_WORKSPACE;
	return (value & ~valid) == 0;
}
#endif /* EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * @struct ext_workspace_group_handle_v1_interface
 */
struct ext_workspace_group_handle_v1_interface {
	/**
	 * create a new workspace
	 *
	 * Request that the compositor create a new workspace with the
	 * given name and assign it to this group.
	 *
	 * There is no guarantee that the compositor will create a new
	 * workspace, or that the created workspace will have the provided
	 * name.
	 */
	void (*create_workspace)(struct wl_client *client,
				 struct wl_resource *resource,
				 const char *workspace);
	/**
	 * destroy the ext_workspace_group_handle_v1 object
	 *
	 * Destroys the ext_workspace_group_handle_v1 object.
	 *
	 * This request should be send either when the client does not want
	 * to use the workspace group object any more or after the removed
	 * event to finalize the destruction of the object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define EXT_WORKSPACE_GROUP_HANDLE_V1_CAPABILITIES 0
#define EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_ENTER 1
#define EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_LEAVE 2
#define EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_ENTER 3
#define EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_LEAVE 4
#define EXT_WORKSPACE_GROUP_HANDLE_V1_REMOVED 5

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_CAPABILITIES_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_CREATE_WORKSPACE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * Sends an capabilities event to the client owning the resource.
 * @param resource_ The client's resource
 * @param capabilities capabilities
 */
static inline void
ext_workspace_group_handle_v1_send_capabilities(struct wl_resource *resource_, uint32_t capabilities)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_GROUP_HANDLE_V1_CAPABILITIES, capabilities);
}

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * Sends an output_enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_group_handle_v1_send_output_enter(struct wl_resource *resource_, struct wl_resource *output)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_ENTER, output);
}

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * Sends an output_leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_group_handle_v1_send_output_leave(struct wl_resource *resource_, struct wl_resource *output)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_LEAVE, output);
}

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * Sends an workspace_enter event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_group_handle_v1_send_workspace_enter(struct wl_resource *resource_, struct wl_resource *workspace)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_ENTER, workspace);
}

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * Sends an workspace_leave event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_group_handle_v1_send_workspace_leave(struct wl_resource *resource_, struct wl_resource *workspace)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_LEAVE, workspace);
}

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_group_handle_v1_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_GROUP_HANDLE_V1_REMOVED);
}

#ifndef EXT_WORKSPACE_HANDLE_V1_STATE_ENUM
#define EXT_WORKSPACE_HANDLE_V1_STATE_ENUM
/**
 * @ingroup iface_ext_workspace_handle_v1
 * types of states on the workspace
 *
 * The different states that a workspace can have.
 */
enum ext_workspace_handle_v1_state {
	/**
	 * the workspace is active
	 */
	EXT_WORKSPACE_HANDLE_V1_STATE_ACTIVE = 1,
	/**
	 * the workspace requests attention
	 */
	EXT_WORKSPACE_HANDLE_V1_STATE_URGENT = 2,
	/**
	 * the workspace is not visible
	 *
	 * The workspace is not visible in its workspace group, and
	 * clients attempting to visualize the compositor workspace state
	 * should not display such workspaces.
	 */
	EXT_WORKSPACE_HANDLE_V1_STATE_HIDDEN = 4,
};
#endif /* EXT_WORKSPACE_HANDLE_V1_STATE_ENUM */

#ifndef EXT_WORKSPACE_HANDLE_V1_STATE_ENUM_IS_VALID
#define EXT_WORKSPACE_HANDLE_V1_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_ext_workspace_handle_v1
 * Validate a ext_workspace_handle_v1 state value.
 *
 * @return true on success, false on error.
 * @ref ext_workspace_handle_v1_state
 */
static inline bool
ext_workspace_handle_v1_state_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= EXT_WORKSPACE_HANDLE_V1_STATE_ACTIVE;
	if (version >= 1)
		valid |= EXT_WORKSPACE_HANDLE_V1_STATE_URGENT;
	if (version >= 1)
		valid |= EXT_WORKSPACE_HANDLE_V1_STATE_HIDDEN;
	return (value & ~valid) == 0;
}
#endif /* EXT_WORKSPACE_HANDLE_V1_STATE_ENUM_IS_VALID */

#ifndef EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM
#define EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM
enum ext_workspace_handle_v1_workspace_capabilities {
	/**
	 * activate request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ACTIVATE = 1,
	/**
	 * deactivate request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_DEACTIVATE = 2,
	/**
	 * remove request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_REMOVE = 4,
	/**
	 * assign request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ASSIGN = 8,
};
#endif /* EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM */

#ifndef EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM_IS_VALID
#define EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM_IS_VALID
/**
 * @ingroup iface_ext_workspace_handle_v1
 * Validate a ext_workspace_handle_v1 workspace_capabilities value.
 *
 * @return true on success, false on error.
 * @ref ext_workspace_handle_v1_workspace_capabilities
 */
static inline bool
ext_workspace_handle_v1_workspace_capabilities_is_valid(uint32_t value, uint32_t version) {
	uint32_t valid = 0;
	if (version >= 1)
		valid |= EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ACTIVATE;
	if (version >= 1)
		valid |= EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_DEACTIVATE;
	if (version >= 1)
		valid |= EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_REMOVE;
	if (version >= 1)
		valid |= EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ASSIGN;
	return (value & ~valid) == 0;
}
#endif /* EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM_IS_VALID */

/**
 * @ingroup iface_ext_workspace_handle_v1
 * @struct ext_workspace_handle_v1_interface
 */
struct ext_workspace_handle_v1_interface {
	/**
	 * destroy the ext_workspace_handle_v1 object
	 *
	 * Destroys the ext_workspace_handle_v1 object.
	 *
	 * This request should be made either when the client does not want
	 * to use the workspace object any more or after the remove event
	 * to finalize the destruction of the object.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * activate the workspace
	 *
	 * Request that this workspace be activated.
	 *
	 * There is no guarantee the workspace will be actually activated,
	 * and behaviour may be compositor-dependent. For example,
	 * activating a workspace may or may not deactivate all other
	 * workspaces in the same group.
	 */
	void (*activate)(struct wl_client *client,
			 struct wl_resource *resource);
	/**
	 * deactivate the workspace
	 *
	 * Request that this workspace be deactivated.
	 *
	 * There is no guarantee the workspace will be actually
	 * deactivated.
	 */
	void (*deactivate)(struct wl_client *client,
			   struct wl_resource *resource);
	/**
	 * assign workspace to group
	 *
	 * Requests that this workspace is assigned to the given
	 * workspace group.
	 *
	 * There is no guarantee the workspace will be assigned.
	 */
	void (*assign)(struct wl_client *client,
		       struct wl_resource *resource,
		       struct wl_resource *workspace_group);
	/**
	 * remove the workspace
	 *
	 * Request that this workspace be removed.
	 *
	 * There is no guarantee the workspace will be actually removed.
	 */
	void (*remove)(struct wl_client *client,
		       struct wl_resource *resource);
};

#define EXT_WORKSPACE_HANDLE_V1_ID 0
#define EXT_WORKSPACE_HANDLE_V1_NAME 1
#define EXT_WORKSPACE_HANDLE_V1_COORDINATES 2
#define EXT_WORKSPACE_HANDLE_V1_STATE 3
#define EXT_WORKSPACE_HANDLE_V1_CAPABILITIES 4
#define EXT_WORKSPACE_HANDLE_V1_REMOVED 5

/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_ID_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_COORDINATES_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_CAPABILITIES_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_DEACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_ASSIGN_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_REMOVE_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_handle_v1
 * Sends an id event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_handle_v1_send_id(struct wl_resource *resource_, const char *id)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_HANDLE_V1_ID, id);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 * Sends an name event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_handle_v1_send_name(struct wl_resource *resource_, const char *name)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_HANDLE_V1_NAME, name);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 * Sends an coordinates event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_handle_v1_send_coordinates(struct wl_resource *resource_, struct wl_array *coordinates)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_HANDLE_V1_COORDINATES, coordinates);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 * Sends an state event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_handle_v1_send_state(struct wl_resource *resource_, uint32_t state)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_HANDLE_V1_STATE, state);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 * Sends an capabilities event to the client owning the resource.
 * @param resource_ The client's resource
 * @param capabilities capabilities
 */
static inline void
ext_workspace_handle_v1_send_capabilities(struct wl_resource *resource_, uint32_t capabilities)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_HANDLE_V1_CAPABILITIES, capabilities);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 * Sends an removed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
ext_workspace_handle_v1_send_removed(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, EXT_WORKSPACE_HANDLE_V1_REMOVED);
}

#ifdef  __cplusplus
}
#endif

#endif
