// Generated with hyprwayland-scanner 0.4.5. Made with vaxry's keyboard and ❤️.
// wlr_screencopy_unstable_v1

/*
 This protocol's authors' copyright notice is:


		Copyright © 2018 Simon Ser
		Copyright © 2019 Andri Yngvason

		Permission is hereby granted, free of charge, to any person obtaining a
		copy of this software and associated documentation files (the "Software"),
		to deal in the Software without restriction, including without limitation
		the rights to use, copy, modify, merge, publish, distribute, sublicense,
		and/or sell copies of the Software, and to permit persons to whom the
		Software is furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice (including the next
		paragraph) shall be included in all copies or substantial portions of the
		Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
		THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
		FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
		DEALINGS IN THE SOFTWARE.
	
*/

#define private public
#define HYPRWAYLAND_SCANNER_NO_INTERFACES
#include "wlr-screencopy-unstable-v1.hpp"
#undef private
#define F std::function

static const wl_interface* wlrScreencopyUnstableV1_dummyTypes[] = { nullptr };

// Reference all other interfaces.
// The reason why this is in snake is to
// be able to cooperate with existing
// wayland_scanner interfaces (they are interop)
extern const wl_interface zwlr_screencopy_manager_v1_interface;
extern const wl_interface zwlr_screencopy_frame_v1_interface;
extern const wl_interface wl_output_interface;
extern const wl_interface wl_buffer_interface;

static const void* _CCZwlrScreencopyManagerV1VTable[] = {
    nullptr,
};

wl_proxy* CCZwlrScreencopyManagerV1::sendCaptureOutput(int32_t overlay_cursor, wl_proxy* output) {
    if (!pResource)
        return nullptr;

    auto proxy = wl_proxy_marshal_flags(pResource, 0, &zwlr_screencopy_frame_v1_interface, wl_proxy_get_version(pResource), 0, nullptr, overlay_cursor, output);

    return proxy;
}

wl_proxy* CCZwlrScreencopyManagerV1::sendCaptureOutputRegion(int32_t overlay_cursor, wl_proxy* output, int32_t x, int32_t y, int32_t width, int32_t height) {
    if (!pResource)
        return nullptr;

    auto proxy = wl_proxy_marshal_flags(pResource, 1, &zwlr_screencopy_frame_v1_interface, wl_proxy_get_version(pResource), 0, nullptr, overlay_cursor, output, x, y, width, height);

    return proxy;
}

void CCZwlrScreencopyManagerV1::sendDestroy() {
    if (!pResource)
        return;
    destroyed = true;

    auto proxy = wl_proxy_marshal_flags(pResource, 2, nullptr, wl_proxy_get_version(pResource), 1);
    proxy;
}
static const wl_interface* _CZwlrScreencopyManagerV1CaptureOutputTypes[] = {
    &zwlr_screencopy_frame_v1_interface,
    nullptr,
    &wl_output_interface,
};
static const wl_interface* _CZwlrScreencopyManagerV1CaptureOutputRegionTypes[] = {
    &zwlr_screencopy_frame_v1_interface,
    nullptr,
    &wl_output_interface,
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};

static const wl_message _CZwlrScreencopyManagerV1Requests[] = {
    { .name = "capture_output", .signature = "nio", .types = _CZwlrScreencopyManagerV1CaptureOutputTypes + 0},
    { .name = "capture_output_region", .signature = "nioiiii", .types = _CZwlrScreencopyManagerV1CaptureOutputRegionTypes + 0},
    { .name = "destroy", .signature = "", .types = wlrScreencopyUnstableV1_dummyTypes + 0},
};

const wl_interface zwlr_screencopy_manager_v1_interface = {
    .name = "zwlr_screencopy_manager_v1", .version = 3,
    .method_count = 3, .methods = _CZwlrScreencopyManagerV1Requests,
    .event_count = 0, .events = nullptr,
};

CCZwlrScreencopyManagerV1::CCZwlrScreencopyManagerV1(wl_proxy* resource) : pResource(resource) {

    if (!pResource)
        return;

    wl_proxy_add_listener(pResource, (void (**)(void))&_CCZwlrScreencopyManagerV1VTable, this);
}

CCZwlrScreencopyManagerV1::~CCZwlrScreencopyManagerV1() {
    if (!destroyed)
        sendDestroy();
}

static void _CZwlrScreencopyFrameV1Buffer(void* data, void* resource, uint32_t format, uint32_t width, uint32_t height, uint32_t stride) {
    const auto PO = (CCZwlrScreencopyFrameV1*)data;
    if (PO && PO->requests.buffer)
        PO->requests.buffer(PO, format, width, height, stride);
}

static void _CZwlrScreencopyFrameV1Flags(void* data, void* resource, zwlrScreencopyFrameV1Flags flags) {
    const auto PO = (CCZwlrScreencopyFrameV1*)data;
    if (PO && PO->requests.flags)
        PO->requests.flags(PO, flags);
}

static void _CZwlrScreencopyFrameV1Ready(void* data, void* resource, uint32_t tv_sec_hi, uint32_t tv_sec_lo, uint32_t tv_nsec) {
    const auto PO = (CCZwlrScreencopyFrameV1*)data;
    if (PO && PO->requests.ready)
        PO->requests.ready(PO, tv_sec_hi, tv_sec_lo, tv_nsec);
}

static void _CZwlrScreencopyFrameV1Failed(void* data, void* resource) {
    const auto PO = (CCZwlrScreencopyFrameV1*)data;
    if (PO && PO->requests.failed)
        PO->requests.failed(PO);
}

static void _CZwlrScreencopyFrameV1Damage(void* data, void* resource, uint32_t x, uint32_t y, uint32_t width, uint32_t height) {
    const auto PO = (CCZwlrScreencopyFrameV1*)data;
    if (PO && PO->requests.damage)
        PO->requests.damage(PO, x, y, width, height);
}

static void _CZwlrScreencopyFrameV1LinuxDmabuf(void* data, void* resource, uint32_t format, uint32_t width, uint32_t height) {
    const auto PO = (CCZwlrScreencopyFrameV1*)data;
    if (PO && PO->requests.linuxDmabuf)
        PO->requests.linuxDmabuf(PO, format, width, height);
}

static void _CZwlrScreencopyFrameV1BufferDone(void* data, void* resource) {
    const auto PO = (CCZwlrScreencopyFrameV1*)data;
    if (PO && PO->requests.bufferDone)
        PO->requests.bufferDone(PO);
}

static const void* _CCZwlrScreencopyFrameV1VTable[] = {
    (void*)_CZwlrScreencopyFrameV1Buffer,
    (void*)_CZwlrScreencopyFrameV1Flags,
    (void*)_CZwlrScreencopyFrameV1Ready,
    (void*)_CZwlrScreencopyFrameV1Failed,
    (void*)_CZwlrScreencopyFrameV1Damage,
    (void*)_CZwlrScreencopyFrameV1LinuxDmabuf,
    (void*)_CZwlrScreencopyFrameV1BufferDone,
};

void CCZwlrScreencopyFrameV1::sendCopy(wl_proxy* buffer) {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 0, nullptr, wl_proxy_get_version(pResource), 0, buffer);
    proxy;
}

void CCZwlrScreencopyFrameV1::sendDestroy() {
    if (!pResource)
        return;
    destroyed = true;

    auto proxy = wl_proxy_marshal_flags(pResource, 1, nullptr, wl_proxy_get_version(pResource), 1);
    proxy;
}

void CCZwlrScreencopyFrameV1::sendCopyWithDamage(wl_proxy* buffer) {
    if (!pResource)
        return;

    auto proxy = wl_proxy_marshal_flags(pResource, 2, nullptr, wl_proxy_get_version(pResource), 0, buffer);
    proxy;
}
static const wl_interface* _CZwlrScreencopyFrameV1CopyTypes[] = {
    &wl_buffer_interface,
};
static const wl_interface* _CZwlrScreencopyFrameV1CopyWithDamageTypes[] = {
    &wl_buffer_interface,
};
static const wl_interface* _CZwlrScreencopyFrameV1BufferTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CZwlrScreencopyFrameV1FlagsTypes[] = {
    nullptr,
};
static const wl_interface* _CZwlrScreencopyFrameV1ReadyTypes[] = {
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CZwlrScreencopyFrameV1DamageTypes[] = {
    nullptr,
    nullptr,
    nullptr,
    nullptr,
};
static const wl_interface* _CZwlrScreencopyFrameV1LinuxDmabufTypes[] = {
    nullptr,
    nullptr,
    nullptr,
};

static const wl_message _CZwlrScreencopyFrameV1Requests[] = {
    { .name = "copy", .signature = "o", .types = _CZwlrScreencopyFrameV1CopyTypes + 0},
    { .name = "destroy", .signature = "", .types = wlrScreencopyUnstableV1_dummyTypes + 0},
    { .name = "copy_with_damage", .signature = "2o", .types = _CZwlrScreencopyFrameV1CopyWithDamageTypes + 0},
};

static const wl_message _CZwlrScreencopyFrameV1Events[] = {
    { .name = "buffer", .signature = "uuuu", .types = _CZwlrScreencopyFrameV1BufferTypes + 0},
    { .name = "flags", .signature = "u", .types = _CZwlrScreencopyFrameV1FlagsTypes + 0},
    { .name = "ready", .signature = "uuu", .types = _CZwlrScreencopyFrameV1ReadyTypes + 0},
    { .name = "failed", .signature = "", .types = wlrScreencopyUnstableV1_dummyTypes + 0},
    { .name = "damage", .signature = "2uuuu", .types = _CZwlrScreencopyFrameV1DamageTypes + 0},
    { .name = "linux_dmabuf", .signature = "3uuu", .types = _CZwlrScreencopyFrameV1LinuxDmabufTypes + 0},
    { .name = "buffer_done", .signature = "3", .types = wlrScreencopyUnstableV1_dummyTypes + 0},
};

const wl_interface zwlr_screencopy_frame_v1_interface = {
    .name = "zwlr_screencopy_frame_v1", .version = 3,
    .method_count = 3, .methods = _CZwlrScreencopyFrameV1Requests,
    .event_count = 7, .events = _CZwlrScreencopyFrameV1Events,
};

CCZwlrScreencopyFrameV1::CCZwlrScreencopyFrameV1(wl_proxy* resource) : pResource(resource) {

    if (!pResource)
        return;

    wl_proxy_add_listener(pResource, (void (**)(void))&_CCZwlrScreencopyFrameV1VTable, this);
}

CCZwlrScreencopyFrameV1::~CCZwlrScreencopyFrameV1() {
    if (!destroyed)
        sendDestroy();
}

void CCZwlrScreencopyFrameV1::setBuffer(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t, uint32_t)> &&handler) {
    requests.buffer = std::move(handler);
}

void CCZwlrScreencopyFrameV1::setFlags(F<void(CCZwlrScreencopyFrameV1*, zwlrScreencopyFrameV1Flags)> &&handler) {
    requests.flags = std::move(handler);
}

void CCZwlrScreencopyFrameV1::setReady(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t)> &&handler) {
    requests.ready = std::move(handler);
}

void CCZwlrScreencopyFrameV1::setFailed(F<void(CCZwlrScreencopyFrameV1*)> &&handler) {
    requests.failed = std::move(handler);
}

void CCZwlrScreencopyFrameV1::setDamage(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t, uint32_t)> &&handler) {
    requests.damage = std::move(handler);
}

void CCZwlrScreencopyFrameV1::setLinuxDmabuf(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t)> &&handler) {
    requests.linuxDmabuf = std::move(handler);
}

void CCZwlrScreencopyFrameV1::setBufferDone(F<void(CCZwlrScreencopyFrameV1*)> &&handler) {
    requests.bufferDone = std::move(handler);
}

#undef F
