// Generated with hyprwayland-scanner 0.4.5. Made with vaxry's keyboard and ❤️.
// wlr_screencopy_unstable_v1

/*
 This protocol's authors' copyright notice is:


		Copyright © 2018 Simon Ser
		Copyright © 2019 Andri Yngvason

		Permission is hereby granted, free of charge, to any person obtaining a
		copy of this software and associated documentation files (the "Software"),
		to deal in the Software without restriction, including without limitation
		the rights to use, copy, modify, merge, publish, distribute, sublicense,
		and/or sell copies of the Software, and to permit persons to whom the
		Software is furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice (including the next
		paragraph) shall be included in all copies or substantial portions of the
		Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
		THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
		FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
		DEALINGS IN THE SOFTWARE.
	
*/

#pragma once

#include <functional>
#include <cstdint>
#include <string>
#include <wayland-client.h>

#define F std::function

struct wl_proxy;

enum zwlrScreencopyFrameV1Error : uint32_t {
    ZWLR_SCREENCOPY_FRAME_V1_ERROR_ALREADY_USED = 0,
    ZWLR_SCREENCOPY_FRAME_V1_ERROR_INVALID_BUFFER = 1,
};

enum zwlrScreencopyFrameV1Flags : uint32_t {
    ZWLR_SCREENCOPY_FRAME_V1_FLAGS_Y_INVERT = 1,
};


class CCZwlrScreencopyManagerV1;
class CCZwlrScreencopyFrameV1;
class CCWlOutput;
class CCZwlrScreencopyFrameV1;
class CCWlOutput;
class CCZwlrScreencopyFrameV1;
class CCWlBuffer;
class CCWlBuffer;

#ifndef HYPRWAYLAND_SCANNER_NO_INTERFACES
extern const wl_interface zwlr_screencopy_manager_v1_interface;
extern const wl_interface zwlr_screencopy_frame_v1_interface;

#endif


class CCZwlrScreencopyManagerV1 {
  public:
    CCZwlrScreencopyManagerV1(wl_proxy*);
    ~CCZwlrScreencopyManagerV1();


    // set the data for this resource
    void setData(void* data) {{
        pData = data;
    }}

    // get the data for this resource
    void* data() {{
        return pData;
    }}

    // get the raw wl_resource (wl_proxy) ptr
    wl_proxy* resource() {{
        return pResource;
    }}

    // get the raw wl_proxy ptr
    wl_proxy* proxy() {{
        return pResource;
    }}

    // get the resource version
    int version() {{
        return wl_proxy_get_version(pResource);
    }}
            
    // --------------- Requests --------------- //


    // --------------- Events --------------- //

    wl_proxy* sendCaptureOutput(int32_t, wl_proxy*);
    wl_proxy* sendCaptureOutputRegion(int32_t, wl_proxy*, int32_t, int32_t, int32_t, int32_t);
    void sendDestroy();

  private:
    struct {
    } requests;

    wl_proxy* pResource = nullptr;

    bool destroyed = false;

    void* pData = nullptr;
};



class CCZwlrScreencopyFrameV1 {
  public:
    CCZwlrScreencopyFrameV1(wl_proxy*);
    ~CCZwlrScreencopyFrameV1();


    // set the data for this resource
    void setData(void* data) {{
        pData = data;
    }}

    // get the data for this resource
    void* data() {{
        return pData;
    }}

    // get the raw wl_resource (wl_proxy) ptr
    wl_proxy* resource() {{
        return pResource;
    }}

    // get the raw wl_proxy ptr
    wl_proxy* proxy() {{
        return pResource;
    }}

    // get the resource version
    int version() {{
        return wl_proxy_get_version(pResource);
    }}
            
    // --------------- Requests --------------- //

    void setBuffer(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t, uint32_t)> &&handler);
    void setFlags(F<void(CCZwlrScreencopyFrameV1*, zwlrScreencopyFrameV1Flags)> &&handler);
    void setReady(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t)> &&handler);
    void setFailed(F<void(CCZwlrScreencopyFrameV1*)> &&handler);
    void setDamage(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t, uint32_t)> &&handler);
    void setLinuxDmabuf(F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t)> &&handler);
    void setBufferDone(F<void(CCZwlrScreencopyFrameV1*)> &&handler);

    // --------------- Events --------------- //

    void sendCopy(wl_proxy*);
    void sendDestroy();
    void sendCopyWithDamage(wl_proxy*);

  private:
    struct {
        F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t, uint32_t)> buffer;
        F<void(CCZwlrScreencopyFrameV1*, zwlrScreencopyFrameV1Flags)> flags;
        F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t)> ready;
        F<void(CCZwlrScreencopyFrameV1*)> failed;
        F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t, uint32_t)> damage;
        F<void(CCZwlrScreencopyFrameV1*, uint32_t, uint32_t, uint32_t)> linuxDmabuf;
        F<void(CCZwlrScreencopyFrameV1*)> bufferDone;
    } requests;

    wl_proxy* pResource = nullptr;

    bool destroyed = false;

    void* pData = nullptr;
};



#undef F
