/* This file is autogenerated by tracetool, do not edit. */
/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef TRACE_GDBSTUB_GENERATED_TRACERS_H
#define TRACE_GDBSTUB_GENERATED_TRACERS_H

#include "trace/control.h"

extern TraceEvent _TRACE_GDBSTUB_OP_START_EVENT;
extern TraceEvent _TRACE_GDBSTUB_OP_EXITING_EVENT;
extern TraceEvent _TRACE_GDBSTUB_OP_CONTINUE_EVENT;
extern TraceEvent _TRACE_GDBSTUB_OP_CONTINUE_CPU_EVENT;
extern TraceEvent _TRACE_GDBSTUB_OP_STEPPING_EVENT;
extern TraceEvent _TRACE_GDBSTUB_OP_EXTRA_INFO_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_INTERNAL_ERROR_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_BREAK_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_PAUSED_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_SHUTDOWN_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_IO_ERROR_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_WATCHDOG_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_UNKNOWN_EVENT;
extern TraceEvent _TRACE_GDBSTUB_IO_REPLY_EVENT;
extern TraceEvent _TRACE_GDBSTUB_IO_BINARYREPLY_EVENT;
extern TraceEvent _TRACE_GDBSTUB_IO_COMMAND_EVENT;
extern TraceEvent _TRACE_GDBSTUB_IO_GOT_ACK_EVENT;
extern TraceEvent _TRACE_GDBSTUB_IO_GOT_UNEXPECTED_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_GOT_NACK_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_GARBAGE_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_OVERRUN_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_INVALID_REPEAT_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_INVALID_RLE_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_CHECKSUM_INVALID_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_CHECKSUM_INCORRECT_EVENT;
extern TraceEvent _TRACE_GDBSTUB_ERR_UNEXPECTED_RUNPKT_EVENT;
extern TraceEvent _TRACE_GDBSTUB_HIT_WATCHPOINT_EVENT;
extern uint16_t _TRACE_GDBSTUB_OP_START_DSTATE;
extern uint16_t _TRACE_GDBSTUB_OP_EXITING_DSTATE;
extern uint16_t _TRACE_GDBSTUB_OP_CONTINUE_DSTATE;
extern uint16_t _TRACE_GDBSTUB_OP_CONTINUE_CPU_DSTATE;
extern uint16_t _TRACE_GDBSTUB_OP_STEPPING_DSTATE;
extern uint16_t _TRACE_GDBSTUB_OP_EXTRA_INFO_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_INTERNAL_ERROR_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_BREAK_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_PAUSED_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_SHUTDOWN_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_IO_ERROR_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_WATCHDOG_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_UNKNOWN_DSTATE;
extern uint16_t _TRACE_GDBSTUB_IO_REPLY_DSTATE;
extern uint16_t _TRACE_GDBSTUB_IO_BINARYREPLY_DSTATE;
extern uint16_t _TRACE_GDBSTUB_IO_COMMAND_DSTATE;
extern uint16_t _TRACE_GDBSTUB_IO_GOT_ACK_DSTATE;
extern uint16_t _TRACE_GDBSTUB_IO_GOT_UNEXPECTED_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_GOT_NACK_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_GARBAGE_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_OVERRUN_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_INVALID_REPEAT_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_INVALID_RLE_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_CHECKSUM_INVALID_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_CHECKSUM_INCORRECT_DSTATE;
extern uint16_t _TRACE_GDBSTUB_ERR_UNEXPECTED_RUNPKT_DSTATE;
extern uint16_t _TRACE_GDBSTUB_HIT_WATCHPOINT_DSTATE;
#define TRACE_GDBSTUB_OP_START_ENABLED 1
#define TRACE_GDBSTUB_OP_EXITING_ENABLED 1
#define TRACE_GDBSTUB_OP_CONTINUE_ENABLED 1
#define TRACE_GDBSTUB_OP_CONTINUE_CPU_ENABLED 1
#define TRACE_GDBSTUB_OP_STEPPING_ENABLED 1
#define TRACE_GDBSTUB_OP_EXTRA_INFO_ENABLED 1
#define TRACE_GDBSTUB_HIT_INTERNAL_ERROR_ENABLED 1
#define TRACE_GDBSTUB_HIT_BREAK_ENABLED 1
#define TRACE_GDBSTUB_HIT_PAUSED_ENABLED 1
#define TRACE_GDBSTUB_HIT_SHUTDOWN_ENABLED 1
#define TRACE_GDBSTUB_HIT_IO_ERROR_ENABLED 1
#define TRACE_GDBSTUB_HIT_WATCHDOG_ENABLED 1
#define TRACE_GDBSTUB_HIT_UNKNOWN_ENABLED 1
#define TRACE_GDBSTUB_IO_REPLY_ENABLED 1
#define TRACE_GDBSTUB_IO_BINARYREPLY_ENABLED 1
#define TRACE_GDBSTUB_IO_COMMAND_ENABLED 1
#define TRACE_GDBSTUB_IO_GOT_ACK_ENABLED 1
#define TRACE_GDBSTUB_IO_GOT_UNEXPECTED_ENABLED 1
#define TRACE_GDBSTUB_ERR_GOT_NACK_ENABLED 1
#define TRACE_GDBSTUB_ERR_GARBAGE_ENABLED 1
#define TRACE_GDBSTUB_ERR_OVERRUN_ENABLED 1
#define TRACE_GDBSTUB_ERR_INVALID_REPEAT_ENABLED 1
#define TRACE_GDBSTUB_ERR_INVALID_RLE_ENABLED 1
#define TRACE_GDBSTUB_ERR_CHECKSUM_INVALID_ENABLED 1
#define TRACE_GDBSTUB_ERR_CHECKSUM_INCORRECT_ENABLED 1
#define TRACE_GDBSTUB_ERR_UNEXPECTED_RUNPKT_ENABLED 1
#define TRACE_GDBSTUB_HIT_WATCHPOINT_ENABLED 1
#include "qemu/log-for-trace.h"


#define TRACE_GDBSTUB_OP_START_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_OP_START) || \
    false)

static inline void trace_gdbstub_op_start(const char *device)
{
    if (trace_event_get_state(TRACE_GDBSTUB_OP_START)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 4 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_op_start " "Starting gdbstub using device %s" "\n", device);
#line 104 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_OP_EXITING_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_OP_EXITING) || \
    false)

static inline void trace_gdbstub_op_exiting(uint8_t code)
{
    if (trace_event_get_state(TRACE_GDBSTUB_OP_EXITING)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 5 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_op_exiting " "notifying exit with code=0x%02x" "\n", code);
#line 119 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_OP_CONTINUE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_OP_CONTINUE) || \
    false)

static inline void trace_gdbstub_op_continue(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_OP_CONTINUE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 6 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_op_continue " "Continuing all CPUs" "\n");
#line 134 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_OP_CONTINUE_CPU_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_OP_CONTINUE_CPU) || \
    false)

static inline void trace_gdbstub_op_continue_cpu(int cpu_index)
{
    if (trace_event_get_state(TRACE_GDBSTUB_OP_CONTINUE_CPU)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 7 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_op_continue_cpu " "Continuing CPU %d" "\n", cpu_index);
#line 149 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_OP_STEPPING_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_OP_STEPPING) || \
    false)

static inline void trace_gdbstub_op_stepping(int cpu_index)
{
    if (trace_event_get_state(TRACE_GDBSTUB_OP_STEPPING)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 8 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_op_stepping " "Stepping CPU %d" "\n", cpu_index);
#line 164 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_OP_EXTRA_INFO_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_OP_EXTRA_INFO) || \
    false)

static inline void trace_gdbstub_op_extra_info(const char *info)
{
    if (trace_event_get_state(TRACE_GDBSTUB_OP_EXTRA_INFO)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 9 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_op_extra_info " "Thread extra info: %s" "\n", info);
#line 179 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_INTERNAL_ERROR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_INTERNAL_ERROR) || \
    false)

static inline void trace_gdbstub_hit_internal_error(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_INTERNAL_ERROR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 10 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_internal_error " "RUN_STATE_INTERNAL_ERROR" "\n");
#line 194 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_BREAK_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_BREAK) || \
    false)

static inline void trace_gdbstub_hit_break(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_BREAK)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 11 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_break " "RUN_STATE_DEBUG" "\n");
#line 209 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_PAUSED_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_PAUSED) || \
    false)

static inline void trace_gdbstub_hit_paused(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_PAUSED)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 12 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_paused " "RUN_STATE_PAUSED" "\n");
#line 224 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_SHUTDOWN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_SHUTDOWN) || \
    false)

static inline void trace_gdbstub_hit_shutdown(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_SHUTDOWN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 13 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_shutdown " "RUN_STATE_SHUTDOWN" "\n");
#line 239 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_IO_ERROR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_IO_ERROR) || \
    false)

static inline void trace_gdbstub_hit_io_error(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_IO_ERROR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 14 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_io_error " "RUN_STATE_IO_ERROR" "\n");
#line 254 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_WATCHDOG_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_WATCHDOG) || \
    false)

static inline void trace_gdbstub_hit_watchdog(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_WATCHDOG)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 15 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_watchdog " "RUN_STATE_WATCHDOG" "\n");
#line 269 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_UNKNOWN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_UNKNOWN) || \
    false)

static inline void trace_gdbstub_hit_unknown(int state)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_UNKNOWN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 16 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_unknown " "Unknown run state=0x%x" "\n", state);
#line 284 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_IO_REPLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_IO_REPLY) || \
    false)

static inline void trace_gdbstub_io_reply(const char *message)
{
    if (trace_event_get_state(TRACE_GDBSTUB_IO_REPLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 17 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_io_reply " "Sent: %s" "\n", message);
#line 299 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_IO_BINARYREPLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_IO_BINARYREPLY) || \
    false)

static inline void trace_gdbstub_io_binaryreply(size_t ofs, const char *line)
{
    if (trace_event_get_state(TRACE_GDBSTUB_IO_BINARYREPLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 18 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_io_binaryreply " "0x%04zx: %s" "\n", ofs, line);
#line 314 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_IO_COMMAND_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_IO_COMMAND) || \
    false)

static inline void trace_gdbstub_io_command(const char *command)
{
    if (trace_event_get_state(TRACE_GDBSTUB_IO_COMMAND)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 19 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_io_command " "Received: %s" "\n", command);
#line 329 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_IO_GOT_ACK_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_IO_GOT_ACK) || \
    false)

static inline void trace_gdbstub_io_got_ack(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_IO_GOT_ACK)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 20 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_io_got_ack " "Got ACK" "\n");
#line 344 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_IO_GOT_UNEXPECTED_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_IO_GOT_UNEXPECTED) || \
    false)

static inline void trace_gdbstub_io_got_unexpected(uint8_t ch)
{
    if (trace_event_get_state(TRACE_GDBSTUB_IO_GOT_UNEXPECTED)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 21 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_io_got_unexpected " "Got 0x%02x when expecting ACK/NACK" "\n", ch);
#line 359 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_GOT_NACK_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_GOT_NACK) || \
    false)

static inline void trace_gdbstub_err_got_nack(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_GOT_NACK)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 22 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_got_nack " "Got NACK, retransmitting" "\n");
#line 374 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_GARBAGE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_GARBAGE) || \
    false)

static inline void trace_gdbstub_err_garbage(uint8_t ch)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_GARBAGE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 23 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_garbage " "received garbage between packets: 0x%02x" "\n", ch);
#line 389 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_OVERRUN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_OVERRUN) || \
    false)

static inline void trace_gdbstub_err_overrun(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_OVERRUN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 24 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_overrun " "command buffer overrun, dropping command" "\n");
#line 404 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_INVALID_REPEAT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_INVALID_REPEAT) || \
    false)

static inline void trace_gdbstub_err_invalid_repeat(uint8_t ch)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_INVALID_REPEAT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 25 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_invalid_repeat " "got invalid RLE count: 0x%02x" "\n", ch);
#line 419 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_INVALID_RLE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_INVALID_RLE) || \
    false)

static inline void trace_gdbstub_err_invalid_rle(void)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_INVALID_RLE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 26 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_invalid_rle " "got invalid RLE sequence" "\n");
#line 434 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_CHECKSUM_INVALID_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_CHECKSUM_INVALID) || \
    false)

static inline void trace_gdbstub_err_checksum_invalid(uint8_t ch)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_CHECKSUM_INVALID)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 27 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_checksum_invalid " "got invalid command checksum digit: 0x%02x" "\n", ch);
#line 449 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_CHECKSUM_INCORRECT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_CHECKSUM_INCORRECT) || \
    false)

static inline void trace_gdbstub_err_checksum_incorrect(uint8_t expected, uint8_t got)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_CHECKSUM_INCORRECT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 28 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_checksum_incorrect " "got command packet with incorrect checksum, expected=0x%02x, received=0x%02x" "\n", expected, got);
#line 464 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_ERR_UNEXPECTED_RUNPKT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_ERR_UNEXPECTED_RUNPKT) || \
    false)

static inline void trace_gdbstub_err_unexpected_runpkt(uint8_t ch)
{
    if (trace_event_get_state(TRACE_GDBSTUB_ERR_UNEXPECTED_RUNPKT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 29 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_err_unexpected_runpkt " "unexpected packet (0x%02x) while target running" "\n", ch);
#line 479 "trace/trace-gdbstub.h"
        }
    }
}

#define TRACE_GDBSTUB_HIT_WATCHPOINT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_GDBSTUB_HIT_WATCHPOINT) || \
    false)

static inline void trace_gdbstub_hit_watchpoint(const char *type, int cpu_gdb_index, uint64_t vaddr)
{
    if (trace_event_get_state(TRACE_GDBSTUB_HIT_WATCHPOINT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 32 "../xemu/gdbstub/trace-events"
            qemu_log("gdbstub_hit_watchpoint " "Watchpoint hit, type=\"%s\" cpu=%d, vaddr=0x%" PRIx64 "" "\n", type, cpu_gdb_index, vaddr);
#line 494 "trace/trace-gdbstub.h"
        }
    }
}
#endif /* TRACE_GDBSTUB_GENERATED_TRACERS_H */
