/* This file is autogenerated by tracetool, do not edit. */
/* SPDX-License-Identifier: GPL-2.0-or-later */

#ifndef TRACE_NBD_GENERATED_TRACERS_H
#define TRACE_NBD_GENERATED_TRACERS_H

#include "trace/control.h"

extern TraceEvent _TRACE_NBD_SEND_OPTION_REQUEST_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_OPTION_REPLY_EVENT;
extern TraceEvent _TRACE_NBD_SERVER_ERROR_MSG_EVENT;
extern TraceEvent _TRACE_NBD_REPLY_ERR_IGNORED_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_LIST_EVENT;
extern TraceEvent _TRACE_NBD_OPT_INFO_GO_START_EVENT;
extern TraceEvent _TRACE_NBD_OPT_INFO_GO_SUCCESS_EVENT;
extern TraceEvent _TRACE_NBD_OPT_INFO_UNKNOWN_EVENT;
extern TraceEvent _TRACE_NBD_OPT_INFO_BLOCK_SIZE_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_QUERY_EXPORTS_START_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_QUERY_EXPORTS_SUCCESS_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_STARTTLS_NEW_CLIENT_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_STARTTLS_TLS_HANDSHAKE_EVENT;
extern TraceEvent _TRACE_NBD_OPT_META_REQUEST_EVENT;
extern TraceEvent _TRACE_NBD_OPT_META_REPLY_EVENT;
extern TraceEvent _TRACE_NBD_START_NEGOTIATE_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_NEGOTIATE_MAGIC_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_NEGOTIATE_SERVER_FLAGS_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_NEGOTIATE_NAME_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_NEGOTIATE_SIZE_FLAGS_EVENT;
extern TraceEvent _TRACE_NBD_INIT_SET_SOCKET_EVENT;
extern TraceEvent _TRACE_NBD_INIT_SET_BLOCK_SIZE_EVENT;
extern TraceEvent _TRACE_NBD_INIT_SET_SIZE_EVENT;
extern TraceEvent _TRACE_NBD_INIT_TRAILING_BYTES_EVENT;
extern TraceEvent _TRACE_NBD_INIT_SET_READONLY_EVENT;
extern TraceEvent _TRACE_NBD_INIT_FINISH_EVENT;
extern TraceEvent _TRACE_NBD_CLIENT_LOOP_EVENT;
extern TraceEvent _TRACE_NBD_CLIENT_LOOP_RET_EVENT;
extern TraceEvent _TRACE_NBD_CLIENT_CLEAR_QUEUE_EVENT;
extern TraceEvent _TRACE_NBD_CLIENT_CLEAR_SOCKET_EVENT;
extern TraceEvent _TRACE_NBD_SEND_REQUEST_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_SIMPLE_REPLY_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_REPLY_CHUNK_HEADER_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_WRONG_HEADER_EVENT;
extern TraceEvent _TRACE_NBD_UNKNOWN_ERROR_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_SEND_REP_LEN_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_SEND_REP_ERR_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_SEND_REP_LIST_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_REQUEST_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_SEND_INFO_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUESTS_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUEST_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_HANDLE_INFO_BLOCK_SIZE_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_HANDSHAKE_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_META_CONTEXT_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_META_QUERY_SKIP_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_META_QUERY_PARSE_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_META_QUERY_REPLY_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_OPTIONS_FLAGS_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_MAGIC_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_OPTION_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_BEGIN_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_NEW_STYLE_SIZE_FLAGS_EVENT;
extern TraceEvent _TRACE_NBD_NEGOTIATE_SUCCESS_EVENT;
extern TraceEvent _TRACE_NBD_RECEIVE_REQUEST_EVENT;
extern TraceEvent _TRACE_NBD_BLK_AIO_ATTACHED_EVENT;
extern TraceEvent _TRACE_NBD_BLK_AIO_DETACH_EVENT;
extern TraceEvent _TRACE_NBD_CO_SEND_SIMPLE_REPLY_EVENT;
extern TraceEvent _TRACE_NBD_CO_SEND_CHUNK_DONE_EVENT;
extern TraceEvent _TRACE_NBD_CO_SEND_CHUNK_READ_EVENT;
extern TraceEvent _TRACE_NBD_CO_SEND_CHUNK_READ_HOLE_EVENT;
extern TraceEvent _TRACE_NBD_CO_SEND_EXTENTS_EVENT;
extern TraceEvent _TRACE_NBD_CO_SEND_CHUNK_ERROR_EVENT;
extern TraceEvent _TRACE_NBD_CO_RECEIVE_BLOCK_STATUS_PAYLOAD_COMPLIANCE_EVENT;
extern TraceEvent _TRACE_NBD_CO_RECEIVE_REQUEST_DECODE_TYPE_EVENT;
extern TraceEvent _TRACE_NBD_CO_RECEIVE_REQUEST_PAYLOAD_RECEIVED_EVENT;
extern TraceEvent _TRACE_NBD_CO_RECEIVE_EXT_PAYLOAD_COMPLIANCE_EVENT;
extern TraceEvent _TRACE_NBD_CO_RECEIVE_ALIGN_COMPLIANCE_EVENT;
extern TraceEvent _TRACE_NBD_TRIP_EVENT;
extern TraceEvent _TRACE_NBD_HANDSHAKE_TIMER_CB_EVENT;
extern TraceEvent _TRACE_NBD_CONNECT_THREAD_SLEEP_EVENT;
extern uint16_t _TRACE_NBD_SEND_OPTION_REQUEST_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_OPTION_REPLY_DSTATE;
extern uint16_t _TRACE_NBD_SERVER_ERROR_MSG_DSTATE;
extern uint16_t _TRACE_NBD_REPLY_ERR_IGNORED_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_LIST_DSTATE;
extern uint16_t _TRACE_NBD_OPT_INFO_GO_START_DSTATE;
extern uint16_t _TRACE_NBD_OPT_INFO_GO_SUCCESS_DSTATE;
extern uint16_t _TRACE_NBD_OPT_INFO_UNKNOWN_DSTATE;
extern uint16_t _TRACE_NBD_OPT_INFO_BLOCK_SIZE_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_QUERY_EXPORTS_START_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_QUERY_EXPORTS_SUCCESS_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_STARTTLS_NEW_CLIENT_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_STARTTLS_TLS_HANDSHAKE_DSTATE;
extern uint16_t _TRACE_NBD_OPT_META_REQUEST_DSTATE;
extern uint16_t _TRACE_NBD_OPT_META_REPLY_DSTATE;
extern uint16_t _TRACE_NBD_START_NEGOTIATE_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_NEGOTIATE_MAGIC_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_NEGOTIATE_SERVER_FLAGS_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_NEGOTIATE_NAME_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_NEGOTIATE_SIZE_FLAGS_DSTATE;
extern uint16_t _TRACE_NBD_INIT_SET_SOCKET_DSTATE;
extern uint16_t _TRACE_NBD_INIT_SET_BLOCK_SIZE_DSTATE;
extern uint16_t _TRACE_NBD_INIT_SET_SIZE_DSTATE;
extern uint16_t _TRACE_NBD_INIT_TRAILING_BYTES_DSTATE;
extern uint16_t _TRACE_NBD_INIT_SET_READONLY_DSTATE;
extern uint16_t _TRACE_NBD_INIT_FINISH_DSTATE;
extern uint16_t _TRACE_NBD_CLIENT_LOOP_DSTATE;
extern uint16_t _TRACE_NBD_CLIENT_LOOP_RET_DSTATE;
extern uint16_t _TRACE_NBD_CLIENT_CLEAR_QUEUE_DSTATE;
extern uint16_t _TRACE_NBD_CLIENT_CLEAR_SOCKET_DSTATE;
extern uint16_t _TRACE_NBD_SEND_REQUEST_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_SIMPLE_REPLY_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_REPLY_CHUNK_HEADER_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_WRONG_HEADER_DSTATE;
extern uint16_t _TRACE_NBD_UNKNOWN_ERROR_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_SEND_REP_LEN_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_SEND_REP_ERR_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_SEND_REP_LIST_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_REQUEST_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_SEND_INFO_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUESTS_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUEST_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_HANDLE_INFO_BLOCK_SIZE_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_HANDSHAKE_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_META_CONTEXT_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_META_QUERY_SKIP_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_META_QUERY_PARSE_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_META_QUERY_REPLY_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_OPTIONS_FLAGS_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_MAGIC_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_OPTION_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_BEGIN_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_NEW_STYLE_SIZE_FLAGS_DSTATE;
extern uint16_t _TRACE_NBD_NEGOTIATE_SUCCESS_DSTATE;
extern uint16_t _TRACE_NBD_RECEIVE_REQUEST_DSTATE;
extern uint16_t _TRACE_NBD_BLK_AIO_ATTACHED_DSTATE;
extern uint16_t _TRACE_NBD_BLK_AIO_DETACH_DSTATE;
extern uint16_t _TRACE_NBD_CO_SEND_SIMPLE_REPLY_DSTATE;
extern uint16_t _TRACE_NBD_CO_SEND_CHUNK_DONE_DSTATE;
extern uint16_t _TRACE_NBD_CO_SEND_CHUNK_READ_DSTATE;
extern uint16_t _TRACE_NBD_CO_SEND_CHUNK_READ_HOLE_DSTATE;
extern uint16_t _TRACE_NBD_CO_SEND_EXTENTS_DSTATE;
extern uint16_t _TRACE_NBD_CO_SEND_CHUNK_ERROR_DSTATE;
extern uint16_t _TRACE_NBD_CO_RECEIVE_BLOCK_STATUS_PAYLOAD_COMPLIANCE_DSTATE;
extern uint16_t _TRACE_NBD_CO_RECEIVE_REQUEST_DECODE_TYPE_DSTATE;
extern uint16_t _TRACE_NBD_CO_RECEIVE_REQUEST_PAYLOAD_RECEIVED_DSTATE;
extern uint16_t _TRACE_NBD_CO_RECEIVE_EXT_PAYLOAD_COMPLIANCE_DSTATE;
extern uint16_t _TRACE_NBD_CO_RECEIVE_ALIGN_COMPLIANCE_DSTATE;
extern uint16_t _TRACE_NBD_TRIP_DSTATE;
extern uint16_t _TRACE_NBD_HANDSHAKE_TIMER_CB_DSTATE;
extern uint16_t _TRACE_NBD_CONNECT_THREAD_SLEEP_DSTATE;
#define TRACE_NBD_SEND_OPTION_REQUEST_ENABLED 1
#define TRACE_NBD_RECEIVE_OPTION_REPLY_ENABLED 1
#define TRACE_NBD_SERVER_ERROR_MSG_ENABLED 1
#define TRACE_NBD_REPLY_ERR_IGNORED_ENABLED 1
#define TRACE_NBD_RECEIVE_LIST_ENABLED 1
#define TRACE_NBD_OPT_INFO_GO_START_ENABLED 1
#define TRACE_NBD_OPT_INFO_GO_SUCCESS_ENABLED 1
#define TRACE_NBD_OPT_INFO_UNKNOWN_ENABLED 1
#define TRACE_NBD_OPT_INFO_BLOCK_SIZE_ENABLED 1
#define TRACE_NBD_RECEIVE_QUERY_EXPORTS_START_ENABLED 1
#define TRACE_NBD_RECEIVE_QUERY_EXPORTS_SUCCESS_ENABLED 1
#define TRACE_NBD_RECEIVE_STARTTLS_NEW_CLIENT_ENABLED 1
#define TRACE_NBD_RECEIVE_STARTTLS_TLS_HANDSHAKE_ENABLED 1
#define TRACE_NBD_OPT_META_REQUEST_ENABLED 1
#define TRACE_NBD_OPT_META_REPLY_ENABLED 1
#define TRACE_NBD_START_NEGOTIATE_ENABLED 1
#define TRACE_NBD_RECEIVE_NEGOTIATE_MAGIC_ENABLED 1
#define TRACE_NBD_RECEIVE_NEGOTIATE_SERVER_FLAGS_ENABLED 1
#define TRACE_NBD_RECEIVE_NEGOTIATE_NAME_ENABLED 1
#define TRACE_NBD_RECEIVE_NEGOTIATE_SIZE_FLAGS_ENABLED 1
#define TRACE_NBD_INIT_SET_SOCKET_ENABLED 1
#define TRACE_NBD_INIT_SET_BLOCK_SIZE_ENABLED 1
#define TRACE_NBD_INIT_SET_SIZE_ENABLED 1
#define TRACE_NBD_INIT_TRAILING_BYTES_ENABLED 1
#define TRACE_NBD_INIT_SET_READONLY_ENABLED 1
#define TRACE_NBD_INIT_FINISH_ENABLED 1
#define TRACE_NBD_CLIENT_LOOP_ENABLED 1
#define TRACE_NBD_CLIENT_LOOP_RET_ENABLED 1
#define TRACE_NBD_CLIENT_CLEAR_QUEUE_ENABLED 1
#define TRACE_NBD_CLIENT_CLEAR_SOCKET_ENABLED 1
#define TRACE_NBD_SEND_REQUEST_ENABLED 1
#define TRACE_NBD_RECEIVE_SIMPLE_REPLY_ENABLED 1
#define TRACE_NBD_RECEIVE_REPLY_CHUNK_HEADER_ENABLED 1
#define TRACE_NBD_RECEIVE_WRONG_HEADER_ENABLED 1
#define TRACE_NBD_UNKNOWN_ERROR_ENABLED 1
#define TRACE_NBD_NEGOTIATE_SEND_REP_LEN_ENABLED 1
#define TRACE_NBD_NEGOTIATE_SEND_REP_ERR_ENABLED 1
#define TRACE_NBD_NEGOTIATE_SEND_REP_LIST_ENABLED 1
#define TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_ENABLED 1
#define TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_REQUEST_ENABLED 1
#define TRACE_NBD_NEGOTIATE_SEND_INFO_ENABLED 1
#define TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUESTS_ENABLED 1
#define TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUEST_ENABLED 1
#define TRACE_NBD_NEGOTIATE_HANDLE_INFO_BLOCK_SIZE_ENABLED 1
#define TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_ENABLED 1
#define TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_HANDSHAKE_ENABLED 1
#define TRACE_NBD_NEGOTIATE_META_CONTEXT_ENABLED 1
#define TRACE_NBD_NEGOTIATE_META_QUERY_SKIP_ENABLED 1
#define TRACE_NBD_NEGOTIATE_META_QUERY_PARSE_ENABLED 1
#define TRACE_NBD_NEGOTIATE_META_QUERY_REPLY_ENABLED 1
#define TRACE_NBD_NEGOTIATE_OPTIONS_FLAGS_ENABLED 1
#define TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_MAGIC_ENABLED 1
#define TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_OPTION_ENABLED 1
#define TRACE_NBD_NEGOTIATE_BEGIN_ENABLED 1
#define TRACE_NBD_NEGOTIATE_NEW_STYLE_SIZE_FLAGS_ENABLED 1
#define TRACE_NBD_NEGOTIATE_SUCCESS_ENABLED 1
#define TRACE_NBD_RECEIVE_REQUEST_ENABLED 1
#define TRACE_NBD_BLK_AIO_ATTACHED_ENABLED 1
#define TRACE_NBD_BLK_AIO_DETACH_ENABLED 1
#define TRACE_NBD_CO_SEND_SIMPLE_REPLY_ENABLED 1
#define TRACE_NBD_CO_SEND_CHUNK_DONE_ENABLED 1
#define TRACE_NBD_CO_SEND_CHUNK_READ_ENABLED 1
#define TRACE_NBD_CO_SEND_CHUNK_READ_HOLE_ENABLED 1
#define TRACE_NBD_CO_SEND_EXTENTS_ENABLED 1
#define TRACE_NBD_CO_SEND_CHUNK_ERROR_ENABLED 1
#define TRACE_NBD_CO_RECEIVE_BLOCK_STATUS_PAYLOAD_COMPLIANCE_ENABLED 1
#define TRACE_NBD_CO_RECEIVE_REQUEST_DECODE_TYPE_ENABLED 1
#define TRACE_NBD_CO_RECEIVE_REQUEST_PAYLOAD_RECEIVED_ENABLED 1
#define TRACE_NBD_CO_RECEIVE_EXT_PAYLOAD_COMPLIANCE_ENABLED 1
#define TRACE_NBD_CO_RECEIVE_ALIGN_COMPLIANCE_ENABLED 1
#define TRACE_NBD_TRIP_ENABLED 1
#define TRACE_NBD_HANDSHAKE_TIMER_CB_ENABLED 1
#define TRACE_NBD_CONNECT_THREAD_SLEEP_ENABLED 1
#include "qemu/log-for-trace.h"


#define TRACE_NBD_SEND_OPTION_REQUEST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_SEND_OPTION_REQUEST) || \
    false)

static inline void trace_nbd_send_option_request(uint32_t opt, const char *name, uint32_t len)
{
    if (trace_event_get_state(TRACE_NBD_SEND_OPTION_REQUEST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 4 "../xemu/nbd/trace-events"
            qemu_log("nbd_send_option_request " "Sending option request %" PRIu32" (%s), len %" PRIu32 "\n", opt, name, len);
#line 242 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_OPTION_REPLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_OPTION_REPLY) || \
    false)

static inline void trace_nbd_receive_option_reply(uint32_t option, const char *optname, uint32_t type, const char *typename, uint32_t length)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_OPTION_REPLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 5 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_option_reply " "Received option reply %" PRIu32" (%s), type %" PRIu32" (%s), len %" PRIu32 "\n", option, optname, type, typename, length);
#line 257 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_SERVER_ERROR_MSG_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_SERVER_ERROR_MSG) || \
    false)

static inline void trace_nbd_server_error_msg(uint32_t err, const char *type, const char *msg)
{
    if (trace_event_get_state(TRACE_NBD_SERVER_ERROR_MSG)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 6 "../xemu/nbd/trace-events"
            qemu_log("nbd_server_error_msg " "server reported error 0x%" PRIx32 " (%s) with additional message: %s" "\n", err, type, msg);
#line 272 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_REPLY_ERR_IGNORED_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_REPLY_ERR_IGNORED) || \
    false)

static inline void trace_nbd_reply_err_ignored(uint32_t option, const char *name, uint32_t reply, const char *reply_name)
{
    if (trace_event_get_state(TRACE_NBD_REPLY_ERR_IGNORED)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 7 "../xemu/nbd/trace-events"
            qemu_log("nbd_reply_err_ignored " "server failed request %" PRIu32 " (%s) with error 0x%" PRIx32 " (%s), attempting fallback" "\n", option, name, reply, reply_name);
#line 287 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_LIST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_LIST) || \
    false)

static inline void trace_nbd_receive_list(const char *name, const char *desc)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_LIST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 8 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_list " "export list includes '%s', description '%s'" "\n", name, desc);
#line 302 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_OPT_INFO_GO_START_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_OPT_INFO_GO_START) || \
    false)

static inline void trace_nbd_opt_info_go_start(const char *opt, const char *name)
{
    if (trace_event_get_state(TRACE_NBD_OPT_INFO_GO_START)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 9 "../xemu/nbd/trace-events"
            qemu_log("nbd_opt_info_go_start " "Attempting %s for export '%s'" "\n", opt, name);
#line 317 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_OPT_INFO_GO_SUCCESS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_OPT_INFO_GO_SUCCESS) || \
    false)

static inline void trace_nbd_opt_info_go_success(const char *opt)
{
    if (trace_event_get_state(TRACE_NBD_OPT_INFO_GO_SUCCESS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 10 "../xemu/nbd/trace-events"
            qemu_log("nbd_opt_info_go_success " "Export is ready after %s request" "\n", opt);
#line 332 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_OPT_INFO_UNKNOWN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_OPT_INFO_UNKNOWN) || \
    false)

static inline void trace_nbd_opt_info_unknown(int info, const char *name)
{
    if (trace_event_get_state(TRACE_NBD_OPT_INFO_UNKNOWN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 11 "../xemu/nbd/trace-events"
            qemu_log("nbd_opt_info_unknown " "Ignoring unknown info %d (%s)" "\n", info, name);
#line 347 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_OPT_INFO_BLOCK_SIZE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_OPT_INFO_BLOCK_SIZE) || \
    false)

static inline void trace_nbd_opt_info_block_size(uint32_t minimum, uint32_t preferred, uint32_t maximum)
{
    if (trace_event_get_state(TRACE_NBD_OPT_INFO_BLOCK_SIZE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 12 "../xemu/nbd/trace-events"
            qemu_log("nbd_opt_info_block_size " "Block sizes are 0x%" PRIx32 ", 0x%" PRIx32 ", 0x%" PRIx32 "\n", minimum, preferred, maximum);
#line 362 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_QUERY_EXPORTS_START_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_QUERY_EXPORTS_START) || \
    false)

static inline void trace_nbd_receive_query_exports_start(const char *wantname)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_QUERY_EXPORTS_START)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 13 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_query_exports_start " "Querying export list for '%s'" "\n", wantname);
#line 377 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_QUERY_EXPORTS_SUCCESS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_QUERY_EXPORTS_SUCCESS) || \
    false)

static inline void trace_nbd_receive_query_exports_success(const char *wantname)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_QUERY_EXPORTS_SUCCESS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 14 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_query_exports_success " "Found desired export name '%s'" "\n", wantname);
#line 392 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_STARTTLS_NEW_CLIENT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_STARTTLS_NEW_CLIENT) || \
    false)

static inline void trace_nbd_receive_starttls_new_client(void)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_STARTTLS_NEW_CLIENT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 15 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_starttls_new_client " "Setting up TLS" "\n");
#line 407 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_STARTTLS_TLS_HANDSHAKE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_STARTTLS_TLS_HANDSHAKE) || \
    false)

static inline void trace_nbd_receive_starttls_tls_handshake(void)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_STARTTLS_TLS_HANDSHAKE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 16 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_starttls_tls_handshake " "Starting TLS handshake" "\n");
#line 422 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_OPT_META_REQUEST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_OPT_META_REQUEST) || \
    false)

static inline void trace_nbd_opt_meta_request(const char *optname, const char *context, const char *export)
{
    if (trace_event_get_state(TRACE_NBD_OPT_META_REQUEST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 17 "../xemu/nbd/trace-events"
            qemu_log("nbd_opt_meta_request " "Requesting %s %s for export %s" "\n", optname, context, export);
#line 437 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_OPT_META_REPLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_OPT_META_REPLY) || \
    false)

static inline void trace_nbd_opt_meta_reply(const char *optname, const char *context, uint32_t id)
{
    if (trace_event_get_state(TRACE_NBD_OPT_META_REPLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 18 "../xemu/nbd/trace-events"
            qemu_log("nbd_opt_meta_reply " "Received %s mapping of %s to id %" PRIu32 "\n", optname, context, id);
#line 452 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_START_NEGOTIATE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_START_NEGOTIATE) || \
    false)

static inline void trace_nbd_start_negotiate(void *tlscreds, const char *hostname)
{
    if (trace_event_get_state(TRACE_NBD_START_NEGOTIATE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 19 "../xemu/nbd/trace-events"
            qemu_log("nbd_start_negotiate " "Receiving negotiation tlscreds=%p hostname=%s" "\n", tlscreds, hostname);
#line 467 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_NEGOTIATE_MAGIC_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_NEGOTIATE_MAGIC) || \
    false)

static inline void trace_nbd_receive_negotiate_magic(uint64_t magic)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_NEGOTIATE_MAGIC)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 20 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_negotiate_magic " "Magic is 0x%" PRIx64 "\n", magic);
#line 482 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_NEGOTIATE_SERVER_FLAGS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_NEGOTIATE_SERVER_FLAGS) || \
    false)

static inline void trace_nbd_receive_negotiate_server_flags(uint32_t globalflags)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_NEGOTIATE_SERVER_FLAGS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 21 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_negotiate_server_flags " "Global flags are 0x%" PRIx32 "\n", globalflags);
#line 497 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_NEGOTIATE_NAME_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_NEGOTIATE_NAME) || \
    false)

static inline void trace_nbd_receive_negotiate_name(const char *name)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_NEGOTIATE_NAME)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 22 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_negotiate_name " "Requesting NBD export name '%s'" "\n", name);
#line 512 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_NEGOTIATE_SIZE_FLAGS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_NEGOTIATE_SIZE_FLAGS) || \
    false)

static inline void trace_nbd_receive_negotiate_size_flags(uint64_t size, uint16_t flags)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_NEGOTIATE_SIZE_FLAGS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 23 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_negotiate_size_flags " "Size is %" PRIu64 ", export flags 0x%" PRIx16 "\n", size, flags);
#line 527 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_INIT_SET_SOCKET_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_INIT_SET_SOCKET) || \
    false)

static inline void trace_nbd_init_set_socket(void)
{
    if (trace_event_get_state(TRACE_NBD_INIT_SET_SOCKET)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 24 "../xemu/nbd/trace-events"
            qemu_log("nbd_init_set_socket " "Setting NBD socket" "\n");
#line 542 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_INIT_SET_BLOCK_SIZE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_INIT_SET_BLOCK_SIZE) || \
    false)

static inline void trace_nbd_init_set_block_size(unsigned long block_size)
{
    if (trace_event_get_state(TRACE_NBD_INIT_SET_BLOCK_SIZE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 25 "../xemu/nbd/trace-events"
            qemu_log("nbd_init_set_block_size " "Setting block size to %lu" "\n", block_size);
#line 557 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_INIT_SET_SIZE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_INIT_SET_SIZE) || \
    false)

static inline void trace_nbd_init_set_size(unsigned long sectors)
{
    if (trace_event_get_state(TRACE_NBD_INIT_SET_SIZE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 26 "../xemu/nbd/trace-events"
            qemu_log("nbd_init_set_size " "Setting size to %lu block(s)" "\n", sectors);
#line 572 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_INIT_TRAILING_BYTES_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_INIT_TRAILING_BYTES) || \
    false)

static inline void trace_nbd_init_trailing_bytes(int ignored_bytes)
{
    if (trace_event_get_state(TRACE_NBD_INIT_TRAILING_BYTES)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 27 "../xemu/nbd/trace-events"
            qemu_log("nbd_init_trailing_bytes " "Ignoring trailing %d bytes of export" "\n", ignored_bytes);
#line 587 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_INIT_SET_READONLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_INIT_SET_READONLY) || \
    false)

static inline void trace_nbd_init_set_readonly(void)
{
    if (trace_event_get_state(TRACE_NBD_INIT_SET_READONLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 28 "../xemu/nbd/trace-events"
            qemu_log("nbd_init_set_readonly " "Setting readonly attribute" "\n");
#line 602 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_INIT_FINISH_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_INIT_FINISH) || \
    false)

static inline void trace_nbd_init_finish(void)
{
    if (trace_event_get_state(TRACE_NBD_INIT_FINISH)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 29 "../xemu/nbd/trace-events"
            qemu_log("nbd_init_finish " "Negotiation ended" "\n");
#line 617 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CLIENT_LOOP_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CLIENT_LOOP) || \
    false)

static inline void trace_nbd_client_loop(void)
{
    if (trace_event_get_state(TRACE_NBD_CLIENT_LOOP)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 30 "../xemu/nbd/trace-events"
            qemu_log("nbd_client_loop " "Doing NBD loop" "\n");
#line 632 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CLIENT_LOOP_RET_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CLIENT_LOOP_RET) || \
    false)

static inline void trace_nbd_client_loop_ret(int ret, const char *error)
{
    if (trace_event_get_state(TRACE_NBD_CLIENT_LOOP_RET)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 31 "../xemu/nbd/trace-events"
            qemu_log("nbd_client_loop_ret " "NBD loop returned %d: %s" "\n", ret, error);
#line 647 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CLIENT_CLEAR_QUEUE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CLIENT_CLEAR_QUEUE) || \
    false)

static inline void trace_nbd_client_clear_queue(void)
{
    if (trace_event_get_state(TRACE_NBD_CLIENT_CLEAR_QUEUE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 32 "../xemu/nbd/trace-events"
            qemu_log("nbd_client_clear_queue " "Clearing NBD queue" "\n");
#line 662 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CLIENT_CLEAR_SOCKET_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CLIENT_CLEAR_SOCKET) || \
    false)

static inline void trace_nbd_client_clear_socket(void)
{
    if (trace_event_get_state(TRACE_NBD_CLIENT_CLEAR_SOCKET)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 33 "../xemu/nbd/trace-events"
            qemu_log("nbd_client_clear_socket " "Clearing NBD socket" "\n");
#line 677 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_SEND_REQUEST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_SEND_REQUEST) || \
    false)

static inline void trace_nbd_send_request(uint64_t from, uint64_t len, uint64_t cookie, uint16_t flags, uint16_t type, const char *name)
{
    if (trace_event_get_state(TRACE_NBD_SEND_REQUEST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 34 "../xemu/nbd/trace-events"
            qemu_log("nbd_send_request " "Sending request to server: { .from = %" PRIu64", .len = %" PRIu64 ", .cookie = %" PRIu64 ", .flags = 0x%" PRIx16 ", .type = %" PRIu16 " (%s) }" "\n", from, len, cookie, flags, type, name);
#line 692 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_SIMPLE_REPLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_SIMPLE_REPLY) || \
    false)

static inline void trace_nbd_receive_simple_reply(int32_t error, const char *errname, uint64_t cookie)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_SIMPLE_REPLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 35 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_simple_reply " "Got simple reply: { .error = %" PRId32 " (%s), cookie = %" PRIu64" }" "\n", error, errname, cookie);
#line 707 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_REPLY_CHUNK_HEADER_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_REPLY_CHUNK_HEADER) || \
    false)

static inline void trace_nbd_receive_reply_chunk_header(uint16_t flags, uint16_t type, const char *name, uint64_t cookie, uint32_t length)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_REPLY_CHUNK_HEADER)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 36 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_reply_chunk_header " "Got reply chunk header: { flags = 0x%" PRIx16 ", type = %" PRIu16 " (%s), cookie = %" PRIu64 ", length = %" PRIu32 " }" "\n", flags, type, name, cookie, length);
#line 722 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_WRONG_HEADER_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_WRONG_HEADER) || \
    false)

static inline void trace_nbd_receive_wrong_header(uint32_t magic, const char *mode)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_WRONG_HEADER)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 37 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_wrong_header " "Server sent unexpected magic 0x%" PRIx32 " for negotiated mode %s" "\n", magic, mode);
#line 737 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_UNKNOWN_ERROR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_UNKNOWN_ERROR) || \
    false)

static inline void trace_nbd_unknown_error(int err)
{
    if (trace_event_get_state(TRACE_NBD_UNKNOWN_ERROR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 40 "../xemu/nbd/trace-events"
            qemu_log("nbd_unknown_error " "Squashing unexpected error %d to EINVAL" "\n", err);
#line 752 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_SEND_REP_LEN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_SEND_REP_LEN) || \
    false)

static inline void trace_nbd_negotiate_send_rep_len(uint32_t opt, const char *optname, uint32_t type, const char *typename, uint32_t len)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_SEND_REP_LEN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 43 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_send_rep_len " "Reply opt=%" PRIu32 " (%s), type=%" PRIu32 " (%s), len=%" PRIu32 "\n", opt, optname, type, typename, len);
#line 767 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_SEND_REP_ERR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_SEND_REP_ERR) || \
    false)

static inline void trace_nbd_negotiate_send_rep_err(const char *msg)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_SEND_REP_ERR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 44 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_send_rep_err " "sending error message \"%s\"" "\n", msg);
#line 782 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_SEND_REP_LIST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_SEND_REP_LIST) || \
    false)

static inline void trace_nbd_negotiate_send_rep_list(const char *name, const char *desc)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_SEND_REP_LIST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 45 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_send_rep_list " "Advertising export name '%s' description '%s'" "\n", name, desc);
#line 797 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME) || \
    false)

static inline void trace_nbd_negotiate_handle_export_name(void)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 46 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_handle_export_name " "Checking length" "\n");
#line 812 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_REQUEST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_REQUEST) || \
    false)

static inline void trace_nbd_negotiate_handle_export_name_request(const char *name)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_HANDLE_EXPORT_NAME_REQUEST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 47 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_handle_export_name_request " "Client requested export '%s'" "\n", name);
#line 827 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_SEND_INFO_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_SEND_INFO) || \
    false)

static inline void trace_nbd_negotiate_send_info(int info, const char *name, uint32_t length)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_SEND_INFO)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 48 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_send_info " "Sending NBD_REP_INFO type %d (%s) with remaining length %" PRIu32 "\n", info, name, length);
#line 842 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUESTS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUESTS) || \
    false)

static inline void trace_nbd_negotiate_handle_info_requests(int requests)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUESTS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 49 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_handle_info_requests " "Client requested %d items of info" "\n", requests);
#line 857 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUEST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUEST) || \
    false)

static inline void trace_nbd_negotiate_handle_info_request(int request, const char *name)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_HANDLE_INFO_REQUEST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 50 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_handle_info_request " "Client requested info %d (%s)" "\n", request, name);
#line 872 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_HANDLE_INFO_BLOCK_SIZE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_HANDLE_INFO_BLOCK_SIZE) || \
    false)

static inline void trace_nbd_negotiate_handle_info_block_size(uint32_t minimum, uint32_t preferred, uint32_t maximum)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_HANDLE_INFO_BLOCK_SIZE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 51 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_handle_info_block_size " "advertising minimum 0x%" PRIx32 ", preferred 0x%" PRIx32 ", maximum 0x%" PRIx32 "\n", minimum, preferred, maximum);
#line 887 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS) || \
    false)

static inline void trace_nbd_negotiate_handle_starttls(void)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 52 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_handle_starttls " "Setting up TLS" "\n");
#line 902 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_HANDSHAKE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_HANDSHAKE) || \
    false)

static inline void trace_nbd_negotiate_handle_starttls_handshake(void)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_HANDLE_STARTTLS_HANDSHAKE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 53 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_handle_starttls_handshake " "Starting TLS handshake" "\n");
#line 917 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_META_CONTEXT_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_META_CONTEXT) || \
    false)

static inline void trace_nbd_negotiate_meta_context(const char *optname, const char *export, uint32_t queries)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_META_CONTEXT)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 54 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_meta_context " "Client requested %s for export %s, with %" PRIu32 " queries" "\n", optname, export, queries);
#line 932 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_META_QUERY_SKIP_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_META_QUERY_SKIP) || \
    false)

static inline void trace_nbd_negotiate_meta_query_skip(const char *reason)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_META_QUERY_SKIP)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 55 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_meta_query_skip " "Skipping meta query: %s" "\n", reason);
#line 947 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_META_QUERY_PARSE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_META_QUERY_PARSE) || \
    false)

static inline void trace_nbd_negotiate_meta_query_parse(const char *query)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_META_QUERY_PARSE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 56 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_meta_query_parse " "Parsed meta query '%s'" "\n", query);
#line 962 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_META_QUERY_REPLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_META_QUERY_REPLY) || \
    false)

static inline void trace_nbd_negotiate_meta_query_reply(const char *context, uint32_t id)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_META_QUERY_REPLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 57 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_meta_query_reply " "Replying with meta context '%s' id %" PRIu32 "\n", context, id);
#line 977 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_OPTIONS_FLAGS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_OPTIONS_FLAGS) || \
    false)

static inline void trace_nbd_negotiate_options_flags(uint32_t flags)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_OPTIONS_FLAGS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 58 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_options_flags " "Received client flags 0x%" PRIx32 "\n", flags);
#line 992 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_MAGIC_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_MAGIC) || \
    false)

static inline void trace_nbd_negotiate_options_check_magic(uint64_t magic)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_MAGIC)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 59 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_options_check_magic " "Checking opts magic 0x%" PRIx64 "\n", magic);
#line 1007 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_OPTION_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_OPTION) || \
    false)

static inline void trace_nbd_negotiate_options_check_option(uint32_t option, const char *name)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_OPTIONS_CHECK_OPTION)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 60 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_options_check_option " "Checking option %" PRIu32 " (%s)" "\n", option, name);
#line 1022 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_BEGIN_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_BEGIN) || \
    false)

static inline void trace_nbd_negotiate_begin(void)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_BEGIN)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 61 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_begin " "Beginning negotiation" "\n");
#line 1037 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_NEW_STYLE_SIZE_FLAGS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_NEW_STYLE_SIZE_FLAGS) || \
    false)

static inline void trace_nbd_negotiate_new_style_size_flags(uint64_t size, unsigned flags)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_NEW_STYLE_SIZE_FLAGS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 62 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_new_style_size_flags " "advertising size %" PRIu64 " and flags 0x%x" "\n", size, flags);
#line 1052 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_NEGOTIATE_SUCCESS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_NEGOTIATE_SUCCESS) || \
    false)

static inline void trace_nbd_negotiate_success(void)
{
    if (trace_event_get_state(TRACE_NBD_NEGOTIATE_SUCCESS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 63 "../xemu/nbd/trace-events"
            qemu_log("nbd_negotiate_success " "Negotiation succeeded" "\n");
#line 1067 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_RECEIVE_REQUEST_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_RECEIVE_REQUEST) || \
    false)

static inline void trace_nbd_receive_request(uint32_t magic, uint16_t flags, uint16_t type, uint64_t from, uint64_t len)
{
    if (trace_event_get_state(TRACE_NBD_RECEIVE_REQUEST)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 64 "../xemu/nbd/trace-events"
            qemu_log("nbd_receive_request " "Got request: { magic = 0x%" PRIx32 ", .flags = 0x%" PRIx16 ", .type = 0x%" PRIx16 ", from = %" PRIu64 ", len = %" PRIu64 " }" "\n", magic, flags, type, from, len);
#line 1082 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_BLK_AIO_ATTACHED_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_BLK_AIO_ATTACHED) || \
    false)

static inline void trace_nbd_blk_aio_attached(const char *name, void *ctx)
{
    if (trace_event_get_state(TRACE_NBD_BLK_AIO_ATTACHED)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 65 "../xemu/nbd/trace-events"
            qemu_log("nbd_blk_aio_attached " "Export %s: Attaching clients to AIO context %p" "\n", name, ctx);
#line 1097 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_BLK_AIO_DETACH_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_BLK_AIO_DETACH) || \
    false)

static inline void trace_nbd_blk_aio_detach(const char *name, void *ctx)
{
    if (trace_event_get_state(TRACE_NBD_BLK_AIO_DETACH)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 66 "../xemu/nbd/trace-events"
            qemu_log("nbd_blk_aio_detach " "Export %s: Detaching clients from AIO context %p" "\n", name, ctx);
#line 1112 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_SEND_SIMPLE_REPLY_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_SEND_SIMPLE_REPLY) || \
    false)

static inline void trace_nbd_co_send_simple_reply(uint64_t cookie, uint32_t error, const char *errname, uint64_t len)
{
    if (trace_event_get_state(TRACE_NBD_CO_SEND_SIMPLE_REPLY)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 67 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_send_simple_reply " "Send simple reply: cookie = %" PRIu64 ", error = %" PRIu32 " (%s), len = %" PRIu64 "\n", cookie, error, errname, len);
#line 1127 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_SEND_CHUNK_DONE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_SEND_CHUNK_DONE) || \
    false)

static inline void trace_nbd_co_send_chunk_done(uint64_t cookie)
{
    if (trace_event_get_state(TRACE_NBD_CO_SEND_CHUNK_DONE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 68 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_send_chunk_done " "Send structured reply done: cookie = %" PRIu64 "\n", cookie);
#line 1142 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_SEND_CHUNK_READ_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_SEND_CHUNK_READ) || \
    false)

static inline void trace_nbd_co_send_chunk_read(uint64_t cookie, uint64_t offset, void *data, uint64_t size)
{
    if (trace_event_get_state(TRACE_NBD_CO_SEND_CHUNK_READ)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 69 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_send_chunk_read " "Send structured read data reply: cookie = %" PRIu64 ", offset = %" PRIu64 ", data = %p, len = %" PRIu64 "\n", cookie, offset, data, size);
#line 1157 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_SEND_CHUNK_READ_HOLE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_SEND_CHUNK_READ_HOLE) || \
    false)

static inline void trace_nbd_co_send_chunk_read_hole(uint64_t cookie, uint64_t offset, uint64_t size)
{
    if (trace_event_get_state(TRACE_NBD_CO_SEND_CHUNK_READ_HOLE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 70 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_send_chunk_read_hole " "Send structured read hole reply: cookie = %" PRIu64 ", offset = %" PRIu64 ", len = %" PRIu64 "\n", cookie, offset, size);
#line 1172 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_SEND_EXTENTS_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_SEND_EXTENTS) || \
    false)

static inline void trace_nbd_co_send_extents(uint64_t cookie, unsigned int extents, uint32_t id, uint64_t length, int last)
{
    if (trace_event_get_state(TRACE_NBD_CO_SEND_EXTENTS)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 71 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_send_extents " "Send block status reply: cookie = %" PRIu64 ", extents = %u, context = %d (extents cover %" PRIu64 " bytes, last chunk = %d)" "\n", cookie, extents, id, length, last);
#line 1187 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_SEND_CHUNK_ERROR_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_SEND_CHUNK_ERROR) || \
    false)

static inline void trace_nbd_co_send_chunk_error(uint64_t cookie, int err, const char *errname, const char *msg)
{
    if (trace_event_get_state(TRACE_NBD_CO_SEND_CHUNK_ERROR)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 72 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_send_chunk_error " "Send structured error reply: cookie = %" PRIu64 ", error = %d (%s), msg = '%s'" "\n", cookie, err, errname, msg);
#line 1202 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_RECEIVE_BLOCK_STATUS_PAYLOAD_COMPLIANCE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_RECEIVE_BLOCK_STATUS_PAYLOAD_COMPLIANCE) || \
    false)

static inline void trace_nbd_co_receive_block_status_payload_compliance(uint64_t from, uint64_t len)
{
    if (trace_event_get_state(TRACE_NBD_CO_RECEIVE_BLOCK_STATUS_PAYLOAD_COMPLIANCE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 73 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_receive_block_status_payload_compliance " "client sent unusable block status payload: from=0x%" PRIx64 ", len=0x%" PRIx64 "\n", from, len);
#line 1217 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_RECEIVE_REQUEST_DECODE_TYPE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_RECEIVE_REQUEST_DECODE_TYPE) || \
    false)

static inline void trace_nbd_co_receive_request_decode_type(uint64_t cookie, uint16_t type, const char *name)
{
    if (trace_event_get_state(TRACE_NBD_CO_RECEIVE_REQUEST_DECODE_TYPE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 74 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_receive_request_decode_type " "Decoding type: cookie = %" PRIu64 ", type = %" PRIu16 " (%s)" "\n", cookie, type, name);
#line 1232 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_RECEIVE_REQUEST_PAYLOAD_RECEIVED_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_RECEIVE_REQUEST_PAYLOAD_RECEIVED) || \
    false)

static inline void trace_nbd_co_receive_request_payload_received(uint64_t cookie, uint64_t len)
{
    if (trace_event_get_state(TRACE_NBD_CO_RECEIVE_REQUEST_PAYLOAD_RECEIVED)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 75 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_receive_request_payload_received " "Payload received: cookie = %" PRIu64 ", len = %" PRIu64 "\n", cookie, len);
#line 1247 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_RECEIVE_EXT_PAYLOAD_COMPLIANCE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_RECEIVE_EXT_PAYLOAD_COMPLIANCE) || \
    false)

static inline void trace_nbd_co_receive_ext_payload_compliance(uint64_t from, uint64_t len)
{
    if (trace_event_get_state(TRACE_NBD_CO_RECEIVE_EXT_PAYLOAD_COMPLIANCE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 76 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_receive_ext_payload_compliance " "client sent non-compliant write without payload flag: from=0x%" PRIx64 ", len=0x%" PRIx64 "\n", from, len);
#line 1262 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CO_RECEIVE_ALIGN_COMPLIANCE_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CO_RECEIVE_ALIGN_COMPLIANCE) || \
    false)

static inline void trace_nbd_co_receive_align_compliance(const char *op, uint64_t from, uint64_t len, uint32_t align)
{
    if (trace_event_get_state(TRACE_NBD_CO_RECEIVE_ALIGN_COMPLIANCE)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 77 "../xemu/nbd/trace-events"
            qemu_log("nbd_co_receive_align_compliance " "client sent non-compliant unaligned %s request: from=0x%" PRIx64 ", len=0x%" PRIx64 ", align=0x%" PRIx32 "\n", op, from, len, align);
#line 1277 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_TRIP_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_TRIP) || \
    false)

static inline void trace_nbd_trip(void)
{
    if (trace_event_get_state(TRACE_NBD_TRIP)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 78 "../xemu/nbd/trace-events"
            qemu_log("nbd_trip " "Reading request" "\n");
#line 1292 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_HANDSHAKE_TIMER_CB_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_HANDSHAKE_TIMER_CB) || \
    false)

static inline void trace_nbd_handshake_timer_cb(void)
{
    if (trace_event_get_state(TRACE_NBD_HANDSHAKE_TIMER_CB)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 79 "../xemu/nbd/trace-events"
            qemu_log("nbd_handshake_timer_cb " "client took too long to negotiate" "\n");
#line 1307 "trace/trace-nbd.h"
        }
    }
}

#define TRACE_NBD_CONNECT_THREAD_SLEEP_BACKEND_DSTATE() ( \
    trace_event_get_state_dynamic_by_id(TRACE_NBD_CONNECT_THREAD_SLEEP) || \
    false)

static inline void trace_nbd_connect_thread_sleep(uint64_t timeout)
{
    if (trace_event_get_state(TRACE_NBD_CONNECT_THREAD_SLEEP)) {
        if (qemu_loglevel_mask(LOG_TRACE)) {
#line 82 "../xemu/nbd/trace-events"
            qemu_log("nbd_connect_thread_sleep " "timeout %" PRIu64 "\n", timeout);
#line 1322 "trace/trace-nbd.h"
        }
    }
}
#endif /* TRACE_NBD_GENERATED_TRACERS_H */
