#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-H8fJ2epPimX3ey8n3fZdI9
key:                  arch-hs-0.12.1-H8fJ2epPimX3ey8n3fZdI9
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  f00f073318e8b84930b73b78e1afa4e2
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-H8fJ2epPimX3ey8n3fZdI9
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-2Up5HNAxZSNmr3b9Y21Rq
    aeson-2.1.2.1-6FuMYI3vdPa8Ts5NPsnpCg
    algebraic-graphs-0.7-HxznOAIWoKOB0nblZzBwMs
    arch-web-0.3.2-H4ZmtaZsdGrDAn2HibVuRi base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-E440ekNNgW6K3EfLZREfa1
    conduit-extra-1.3.8-CgVZWFLveL3JOQpGK40p1j containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-78uC0uCSEiyDcWnzeSVLMH
    http-client-0.7.19-LiXl0zXhncYKUDAcqgcwk8
    http-client-tls-0.3.6.4-8Rtb2QgRnuG7Z2EdKrVOdn
    megaparsec-9.7.0-8vxoLKsvFvg2EeYv7J5Buq
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-FtOUjEeg3uZKUKNQdqfNCl
    optparse-simple-0.1.1.4-7ONiq51klrC2gnC2wDqlJ
    polysemy-1.9.2.0-Hqvh2biOvyCZ7IgRzRYje
    prettyprinter-1.7.1-18Jm3UFnGYW2Ifx2izjEAg
    prettyprinter-ansi-terminal-1.1.3-7xtieJh015GBqxFnpOTjap
    servant-client-0.20.3.0-5s7zGzfAItOB4ZzFrtUduz
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-APL4AZHnfe03qivedP7OnH template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

