#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-4nYYNMOVNunEFpgl2kICyh
key:                  dhall-1.42.3-4nYYNMOVNunEFpgl2kICyh
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  cbe55af202b9acbe00bd2e5ce1f7422f
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-4nYYNMOVNunEFpgl2kICyh
depends:
    Diff-0.5-2Up5HNAxZSNmr3b9Y21Rq aeson-2.1.2.1-6FuMYI3vdPa8Ts5NPsnpCg
    aeson-pretty-0.8.10-FQa8xIJIIpZJMrtrbu8IN4
    ansi-terminal-1.0.2-K3FcB9OuSW9G9IWrQwwwo4
    atomic-write-0.2.1.1-Hm8zFm23VTF8DL56OITKyS base-4.17.2.1
    base16-bytestring-1.0.2.0-ASFphLrgXvi67bm2qxzorY
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-JVWVUVinOoKLKsx1rHKuw7
    cborg-0.2.10.0-LeUw3GSZCiX2AKfS7UAVRg
    cborg-json-0.2.6.0-3P1KDdmAJOA2bwM30it0md containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-IHvIQzXwFR1KCJZF621hvW
    data-fix-0.3.4-6YFxAX142Gz8mbyykoUam0 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-Hg24mZ4IZ71J0pBPr5Smvf exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-CMjsDRKDuxdHVmYqwuYVzM
    hashable-1.4.4.0-HF0gObldLcB4LirfpxeD3R haskeline-0.8.2
    http-client-0.7.19-LiXl0zXhncYKUDAcqgcwk8
    http-client-tls-0.3.6.4-8Rtb2QgRnuG7Z2EdKrVOdn
    http-types-0.12.4-Kfgn5nq0Uw5JM2IxBj4ZY1
    indexed-traversable-0.1.4-EeVo0prc4Ve5Oh8yIcLoq0
    megaparsec-9.7.0-8vxoLKsvFvg2EeYv7J5Buq
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-6dAHdOyJLq76CXdDmIsqEl
    optparse-applicative-0.18.1.0-3qYZezrQAxc4lJKAil0WN1
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-LBDYop5QYiCC1l4dJj3TCF
    pretty-simple-4.1.3.0-8uG0Piij7TsG07pLMGkFHh
    prettyprinter-1.7.1-18Jm3UFnGYW2Ifx2izjEAg
    prettyprinter-ansi-terminal-1.1.3-7xtieJh015GBqxFnpOTjap
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.8.0-L88GQ4rEhQfGc3NVSCAVTu
    serialise-0.2.6.1-F8dXTIVlKoKKTRi1WoerpP template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-HzrE3w64Z1eEGVFZex0GSc
    text-short-0.1.6-13dQTwo5D2lGB4fGCa6bmE
    th-lift-instances-0.1.20-4HlXS6eUQvv3LpmmJLLB0s time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-E7DsEjXAuRTILEPpVPaZJi
    unordered-containers-0.2.20-89DcpQLd7HI30AdGz5XyJk
    vector-0.13.2.0-AtXaKVcIvtCInBZOrzSe57

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

