#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-8YaZ0pKYrbmBqzfIOHAIby
key:                  gitit-0.15.1.2-8YaZ0pKYrbmBqzfIOHAIby
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  8c023d8838aab5c90d0588fa58fca390
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-8YaZ0pKYrbmBqzfIOHAIby
depends:
    HStringTemplate-0.8.8-LDz2yoLIvLdLuARweJlOLY
    HTTP-4000.4.1-HD8KR4Gj7kDIqhYvZQSDU7
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-6FuMYI3vdPa8Ts5NPsnpCg base-4.17.2.1
    base64-bytestring-1.2.1.0-Fa0BuK0N9mu9JPJP7gaxRT
    blaze-html-0.9.2.0-BsVDj7UmD9SGJonPOQFUuj bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-4Cr4E5685hYBdl2efnysbQ
    feed-1.3.2.1-SqEve4mTpSKXL6sweIAtZ filepath-1.4.2.2
    filestore-0.6.5.1-FhUfwP7ZKCp7r5Eo9Wfr8y ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-AV99YDwELOSD3UNOvJWzIm
    hoauth2-2.12.0-2IkHC0nAfv35p7O0S0GIuO
    hslogger-1.3.2.0-5UzjE3rtE0cIibzskwqOPp
    http-client-tls-0.3.6.4-8Rtb2QgRnuG7Z2EdKrVOdn
    http-conduit-2.3.9.1-Ez7Wwb3oy5J4EzeufIRGd5
    json-0.10-GtmTPpjuynnC3spyvpHoyU mtl-2.2.2
    network-3.1.4.0-BMQQjwbPvFR57Ka0tgIiy2
    network-bsd-2.8.1.0-FFpbVO9AuzE8JLFVOXvOKf
    network-uri-2.6.4.2-6dAHdOyJLq76CXdDmIsqEl
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-DuROXpCSLKCIgtqKmiqc3s
    pandoc-types-1.23.1-1bQhO4167wJAXeIDmZ5obj parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-KpmZVmsijPULH6l5PrmXSD
    recaptcha-0.1.0.4-EuNHx02lVDr2To6I1UTo4E
    safe-0.3.21-FBimV6u2RMNDKpiH5qP0vN
    skylighting-0.14.2-BKkXJCiOCLu5t314HJc6kD
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-Lap6GPARkRXCVbqA2faY6P
    tagsoup-0.14.8-Lm79B6V1TRXB75cjyobVOb
    temporary-1.3-9l44ZQzJSbTL0MfCqPU8eB text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-6VDDo73tyQUDXwOD3Kknnb
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-EjkwI8O9b0QEIoqIovpB87 xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-4j2T32Yc9L746h6qu9IdEP
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-2rM1fBjR8Df9EcYYfuGxmc
    zlib-0.7.0.0-GyKiLr1fmrq1PY0I5V10Kr

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

