#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-5DLkLhWQKt7Cl5KtNhF3j9
key:                  gitit-0.15.1.2-5DLkLhWQKt7Cl5KtNhF3j9
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  7ba50df9d8c3e9b074854dc0eba8e092
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-5DLkLhWQKt7Cl5KtNhF3j9
depends:
    HStringTemplate-0.8.8-xIRLELvvJvCEeEnKma38g
    HTTP-4000.4.1-I2SHq0OXREm3IzlxzjgUek
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-3HLieqpkeG06w6MDAYdLLk base-4.17.2.1
    base64-bytestring-1.2.1.0-G8BjkxE58WI1uqeVjCB0n4
    blaze-html-0.9.2.0-3cSCYM9QSR99BQnVHXrYzE bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-HHaJqrkPafw9ReFWY7cQcB
    feed-1.3.2.1-yx0X9LJNEv52G6fJrRAKj filepath-1.4.2.2
    filestore-0.6.5.1-G5fEn6Mj47MGqg1SDBJiSD ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-ByqTRJuQ3E66NUb86tFz2o
    hoauth2-2.13.1-G6qXswi1QiXBPjIpxyfD1n
    hslogger-1.3.2.0-20ZBQm4ZKyVCpCr1LdKap5
    http-client-tls-0.3.6.4-Fuw6mDzbeZhIZH9nOSD8AM
    http-conduit-2.3.9.1-Jt8i9zz8puP9BUVEul6uLX
    json-0.10-DS5VstB1UA8octeAwOFew mtl-2.2.2
    network-3.1.4.0-2g2oEkgQCahBaM3HvlpVNW
    network-bsd-2.8.1.0-45NgNz6r2kWHrH0TdvR5cZ
    network-uri-2.6.4.2-DVBcu05aYxxCjTvpzOd17v
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.4-63TUATvZwvL55hlo8jfZQU
    pandoc-types-1.23.1-2Af65ACjfKtCfKJLbmCXaX parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-KY8hXIsRO0nEsZvihu4hBT
    recaptcha-0.1.0.4-Gsvox5xRt8bJ28Oix5yEe5
    safe-0.3.21-JMKA2bKqr97GM6r3OADsOi
    skylighting-0.14.3-KSJNhHcJDzEEIFFIvERqbg
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-C5AaeelSWDKGvBUWTjIxkt
    tagsoup-0.14.8-ESLaw6fy0OxKMJPLcUMPCl
    temporary-1.3-Kn2M9G1H4VS6orEei4BtCV text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-LdrV5aDMusr3ES1vRzYGGr
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-7LbW7JPPUccGPBdJigsSEH xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-93p77c2FG7W9C5BkdNl9oF
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-AeSM24YsTfE3PT9JYVBBm1
    zlib-0.7.0.0-8ZqFqGsvFQB8ur6Sh8fLj0

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

