#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              2.1.0.0
visibility:           public
id:                   lsp-2.1.0.0-GxokUjVxBLy4j05JlhgdFg
key:                  lsp-2.1.0.0-GxokUjVxBLy4j05JlhgdFg
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  362bf83bc9a9263ece93cc3d36037fb1
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Protocol.Capabilities from lsp-types-2.0.1.0-11kcCUIWM0n8rW3sZUJHGA:Language.LSP.Protocol.Capabilities,
    Language.LSP.Protocol.Lens from lsp-types-2.0.1.0-11kcCUIWM0n8rW3sZUJHGA:Language.LSP.Protocol.Lens,
    Language.LSP.Protocol.Message from lsp-types-2.0.1.0-11kcCUIWM0n8rW3sZUJHGA:Language.LSP.Protocol.Message,
    Language.LSP.Protocol.Types from lsp-types-2.0.1.0-11kcCUIWM0n8rW3sZUJHGA:Language.LSP.Protocol.Types,
    Language.LSP.Server, Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Control Language.LSP.Server.Core
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-2.1.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-2.1.0.0-GxokUjVxBLy4j05JlhgdFg
depends:
    aeson-2.1.2.1-6FuMYI3vdPa8Ts5NPsnpCg
    async-2.2.5-DWviBtrYTc7K8qRxzPsJC
    attoparsec-0.14.4-DYbgeBOmAIRHL8NoYiOyFW base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.5-4V3HmgoGkXErp4Ib9Tvbp
    containers-0.6.7 data-default-0.7.1.2-7bG7braRZax6ZJaJ3dSesR
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-HF0gObldLcB4LirfpxeD3R
    lens-5.3.1-57CGCDOUfQCLkJSlnZcVUR
    lsp-types-2.0.1.0-11kcCUIWM0n8rW3sZUJHGA mtl-2.2.2
    prettyprinter-1.7.1-18Jm3UFnGYW2Ifx2izjEAg
    random-1.2.1.3-KpmZVmsijPULH6l5PrmXSD
    row-types-1.0.1.2-FQkLZYizLy6IrD2AIWrDwp
    sorted-list-0.2.3.1-1RE8jt0x7DqIclSCiBuL2r stm-2.5.1.0
    temporary-1.3-9l44ZQzJSbTL0MfCqPU8eB text-2.0.2
    text-rope-0.3-B63XxTtZ9rH6f5aGYdHxkH transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-89DcpQLd7HI30AdGz5XyJk
    uuid-1.3.16-EjkwI8O9b0QEIoqIovpB87

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

