#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                   nettle
version:                0.3.1.1
visibility:             public
id:                     nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
key:                    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
license:                MIT
copyright:              Stefan Bühler <stbuehler@web.de>
maintainer:             Clint Adams <clint@debian.org>
author:                 Stefan Bühler <stbuehler@web.de>
homepage:               https://github.com/stbuehler/haskell-nettle
synopsis:               safe nettle binding
description:
    safe binding for the nettle (<http://www.lysator.liu.se/~nisse/nettle/nettle.html>) library.
    Tested with 3.4, might work with 3.2 (but not earlier).

category:               Cryptography
abi:                    516ef0f44dbd4935d7a0b12597d99e73
exposed:                True
exposed-modules:
    Crypto.Nettle.CCM Crypto.Nettle.ChaChaPoly1305
    Crypto.Nettle.Ciphers Crypto.Nettle.HMAC Crypto.Nettle.Hash
    Crypto.Nettle.KeyedHash Crypto.Nettle.UMAC

hidden-modules:
    Crypto.Nettle.Ciphers.Internal Crypto.Nettle.Ciphers.ForeignImports
    Crypto.Nettle.Hash.ForeignImports Crypto.Nettle.Hash.Types
    Nettle.Utils

import-dirs:            /usr/lib/ghc-9.4.8/site-local/nettle-0.3.1.1
library-dirs:           /usr/lib/ghc-9.4.8/site-local/nettle-0.3.1.1
library-dirs-static:    /usr/lib/ghc-9.4.8/site-local/nettle-0.3.1.1
dynamic-library-dirs:   /usr/lib
data-dir:               /usr/share/haskell-nettle
hs-libraries:           HSnettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
extra-libraries:        nettle
extra-libraries-static: nettle
depends:
    base-4.17.2.1 byteable-0.1.1-BiXMgwkGoIQH63GBEhxKBY
    bytestring-0.11.5.3
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    securemem-0.1.10-EOlWoZVaToP2K6s5wFpHsU
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C

haddock-interfaces:     /usr/share/doc/haskell-nettle/html/nettle.haddock
haddock-html:           /usr/share/doc/haskell-nettle/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

