#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 rebase
version:              1.20.1
visibility:           public
id:                   rebase-1.20.1-EZLhAB0WCH3eAQQWrtiTn
key:                  rebase-1.20.1-EZLhAB0WCH3eAQQWrtiTn
license:              MIT
copyright:            (c) 2016, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/rebase
synopsis:             A more progressive alternative to the "base" package
description:
    This package is intended for those who are tired of keeping
    long lists of dependencies to the same essential libraries in each package
    as well as the endless imports of the same APIs all over again.
    It also supports the modern tendencies in the language.
    .
    To solve those problems this package does the following:
    .
    * Reexport the original APIs under the \"Rebase\" namespace.
    .
    * Export all the possible non-conflicting symbols from the \"Rebase.Prelude\" module.
    .
    * Give priority to the modern practices in the conflicting cases.
    .
    The policy behind the package is only to reexport the non-ambiguous
    and non-controversial APIs, which the community has obviously settled on.
    The package is intended to rapidly evolve with the contribution from the community,
    with the missing features being added with pull-requests.
    .
    If you don\'\''t need the \"Rebase\" namespace and want to import modules
    from the reexported packages as they are check out
    the \"<https://hackage.haskell.org/package/rerebase rerebase>\" package
    which simply reexports the original symbols in the original namespace.
    Thus it simply lets you depend on all the de-facto default packages,
    by yourself having to maintain only the dependency on \"rerebase\".
    Also it comes packed with a prelude as rich as here.

abi:                  ef243fe93e45c8cdeb4dff4b3b36cf0a
exposed:              True
exposed-modules:
    Rebase.Control.Applicative Rebase.Control.Applicative.Backwards
    Rebase.Control.Applicative.Lift Rebase.Control.Arrow
    Rebase.Control.Category Rebase.Control.Comonad
    Rebase.Control.Concurrent Rebase.Control.Concurrent.Chan
    Rebase.Control.Concurrent.MVar Rebase.Control.Concurrent.QSem
    Rebase.Control.Concurrent.QSemN Rebase.Control.Concurrent.STM
    Rebase.Control.Concurrent.STM.TArray
    Rebase.Control.Concurrent.STM.TBQueue
    Rebase.Control.Concurrent.STM.TChan
    Rebase.Control.Concurrent.STM.TMVar
    Rebase.Control.Concurrent.STM.TQueue
    Rebase.Control.Concurrent.STM.TSem
    Rebase.Control.Concurrent.STM.TVar Rebase.Control.DeepSeq
    Rebase.Control.Exception Rebase.Control.Exception.Base
    Rebase.Control.Monad Rebase.Control.Monad.Cont
    Rebase.Control.Monad.Cont.Class Rebase.Control.Monad.Error.Class
    Rebase.Control.Monad.Fail Rebase.Control.Monad.Fix
    Rebase.Control.Monad.IO.Class Rebase.Control.Monad.Identity
    Rebase.Control.Monad.RWS Rebase.Control.Monad.RWS.Class
    Rebase.Control.Monad.RWS.Lazy Rebase.Control.Monad.RWS.Strict
    Rebase.Control.Monad.Reader Rebase.Control.Monad.Reader.Class
    Rebase.Control.Monad.ST Rebase.Control.Monad.ST.Lazy
    Rebase.Control.Monad.ST.Lazy.Safe
    Rebase.Control.Monad.ST.Lazy.Unsafe Rebase.Control.Monad.ST.Safe
    Rebase.Control.Monad.ST.Strict Rebase.Control.Monad.ST.Unsafe
    Rebase.Control.Monad.STM Rebase.Control.Monad.Signatures
    Rebase.Control.Monad.State Rebase.Control.Monad.State.Class
    Rebase.Control.Monad.State.Lazy Rebase.Control.Monad.State.Strict
    Rebase.Control.Monad.Trans Rebase.Control.Monad.Trans.Class
    Rebase.Control.Monad.Trans.Cont Rebase.Control.Monad.Trans.Except
    Rebase.Control.Monad.Trans.Identity
    Rebase.Control.Monad.Trans.Maybe Rebase.Control.Monad.Trans.RWS
    Rebase.Control.Monad.Trans.RWS.Lazy
    Rebase.Control.Monad.Trans.RWS.Strict
    Rebase.Control.Monad.Trans.Reader Rebase.Control.Monad.Trans.State
    Rebase.Control.Monad.Trans.State.Lazy
    Rebase.Control.Monad.Trans.State.Strict
    Rebase.Control.Monad.Trans.Writer
    Rebase.Control.Monad.Trans.Writer.Lazy
    Rebase.Control.Monad.Trans.Writer.Strict
    Rebase.Control.Monad.Writer Rebase.Control.Monad.Writer.Class
    Rebase.Control.Monad.Writer.Lazy Rebase.Control.Monad.Writer.Strict
    Rebase.Control.Monad.Zip Rebase.Control.Selective
    Rebase.Control.Selective.Free Rebase.Control.Selective.Multi
    Rebase.Control.Selective.Rigid.Free
    Rebase.Control.Selective.Rigid.Freer Rebase.Data.Biapplicative
    Rebase.Data.Bifoldable Rebase.Data.Bifunctor
    Rebase.Data.Bifunctor.Apply Rebase.Data.Bifunctor.Biff
    Rebase.Data.Bifunctor.Clown Rebase.Data.Bifunctor.Flip
    Rebase.Data.Bifunctor.Join Rebase.Data.Bifunctor.Joker
    Rebase.Data.Bifunctor.Product Rebase.Data.Bifunctor.Tannen
    Rebase.Data.Bifunctor.Wrapped Rebase.Data.Bitraversable
    Rebase.Data.Bits Rebase.Data.Bool Rebase.Data.ByteString
    Rebase.Data.ByteString.Builder Rebase.Data.ByteString.Builder.Extra
    Rebase.Data.ByteString.Builder.Internal
    Rebase.Data.ByteString.Builder.Prim
    Rebase.Data.ByteString.Builder.Prim.Internal
    Rebase.Data.ByteString.Builder.Scientific
    Rebase.Data.ByteString.Char8 Rebase.Data.ByteString.Internal
    Rebase.Data.ByteString.Lazy Rebase.Data.ByteString.Lazy.Char8
    Rebase.Data.ByteString.Lazy.Internal Rebase.Data.ByteString.Short
    Rebase.Data.ByteString.Short.Internal Rebase.Data.ByteString.Unsafe
    Rebase.Data.Char Rebase.Data.Coerce Rebase.Data.Complex
    Rebase.Data.DList Rebase.Data.Data Rebase.Data.Dynamic
    Rebase.Data.Either Rebase.Data.Either.Combinators
    Rebase.Data.Either.Validation Rebase.Data.Eq Rebase.Data.Fixed
    Rebase.Data.Foldable Rebase.Data.Function Rebase.Data.Functor
    Rebase.Data.Functor.Alt Rebase.Data.Functor.Apply
    Rebase.Data.Functor.Bind Rebase.Data.Functor.Bind.Class
    Rebase.Data.Functor.Bind.Trans Rebase.Data.Functor.Classes
    Rebase.Data.Functor.Compose Rebase.Data.Functor.Constant
    Rebase.Data.Functor.Contravariant
    Rebase.Data.Functor.Contravariant.Compose
    Rebase.Data.Functor.Contravariant.Divisible
    Rebase.Data.Functor.Extend Rebase.Data.Functor.Identity
    Rebase.Data.Functor.Invariant Rebase.Data.Functor.Invariant.TH
    Rebase.Data.Functor.Plus Rebase.Data.Functor.Product
    Rebase.Data.Functor.Reverse Rebase.Data.Functor.Sum
    Rebase.Data.Graph Rebase.Data.Group Rebase.Data.Groupoid
    Rebase.Data.HashMap.Lazy Rebase.Data.HashMap.Strict
    Rebase.Data.HashSet Rebase.Data.Hashable Rebase.Data.IORef
    Rebase.Data.Int Rebase.Data.IntMap Rebase.Data.IntMap.Lazy
    Rebase.Data.IntMap.Strict Rebase.Data.IntSet
    Rebase.Data.Isomorphism Rebase.Data.Ix Rebase.Data.Kind
    Rebase.Data.List Rebase.Data.List.NonEmpty Rebase.Data.List1
    Rebase.Data.Map Rebase.Data.Map.Lazy Rebase.Data.Map.Strict
    Rebase.Data.Maybe Rebase.Data.Monoid Rebase.Data.Ord
    Rebase.Data.Profunctor Rebase.Data.Profunctor.Adjunction
    Rebase.Data.Profunctor.Cayley Rebase.Data.Profunctor.Choice
    Rebase.Data.Profunctor.Closed Rebase.Data.Profunctor.Composition
    Rebase.Data.Profunctor.Mapping Rebase.Data.Profunctor.Monad
    Rebase.Data.Profunctor.Ran Rebase.Data.Profunctor.Rep
    Rebase.Data.Profunctor.Sieve Rebase.Data.Profunctor.Strong
    Rebase.Data.Profunctor.Traversing Rebase.Data.Profunctor.Types
    Rebase.Data.Profunctor.Unsafe Rebase.Data.Profunctor.Yoneda
    Rebase.Data.Proxy Rebase.Data.Ratio Rebase.Data.STRef
    Rebase.Data.STRef.Lazy Rebase.Data.STRef.Strict
    Rebase.Data.Scientific Rebase.Data.Semigroup
    Rebase.Data.Semigroup.Bifoldable
    Rebase.Data.Semigroup.Bitraversable Rebase.Data.Semigroup.Foldable
    Rebase.Data.Semigroup.Foldable.Class
    Rebase.Data.Semigroup.Traversable
    Rebase.Data.Semigroup.Traversable.Class Rebase.Data.Semigroupoid
    Rebase.Data.Semigroupoid.Dual Rebase.Data.Semigroupoid.Ob
    Rebase.Data.Semigroupoid.Static Rebase.Data.Sequence
    Rebase.Data.Set Rebase.Data.String Rebase.Data.Text
    Rebase.Data.Text.Array Rebase.Data.Text.Encoding
    Rebase.Data.Text.Encoding.Error Rebase.Data.Text.Foreign
    Rebase.Data.Text.IO Rebase.Data.Text.Internal Rebase.Data.Text.Lazy
    Rebase.Data.Text.Lazy.Builder Rebase.Data.Text.Lazy.Builder.Int
    Rebase.Data.Text.Lazy.Builder.RealFloat
    Rebase.Data.Text.Lazy.Builder.Scientific
    Rebase.Data.Text.Lazy.Encoding Rebase.Data.Text.Lazy.IO
    Rebase.Data.Text.Lazy.Read Rebase.Data.Text.Read
    Rebase.Data.Text.Unsafe Rebase.Data.Time Rebase.Data.Time.Calendar
    Rebase.Data.Time.Calendar.Easter Rebase.Data.Time.Calendar.Julian
    Rebase.Data.Time.Calendar.MonthDay
    Rebase.Data.Time.Calendar.OrdinalDate
    Rebase.Data.Time.Calendar.WeekDate Rebase.Data.Time.Clock
    Rebase.Data.Time.Clock.POSIX Rebase.Data.Time.Clock.System
    Rebase.Data.Time.Clock.TAI Rebase.Data.Time.Compat
    Rebase.Data.Time.Format Rebase.Data.Time.Format.ISO8601
    Rebase.Data.Time.LocalTime Rebase.Data.Traversable
    Rebase.Data.Traversable.Instances Rebase.Data.Tree
    Rebase.Data.Tuple Rebase.Data.Type.Bool Rebase.Data.Type.Coercion
    Rebase.Data.Type.Equality Rebase.Data.Typeable Rebase.Data.UUID
    Rebase.Data.Unique Rebase.Data.Vector
    Rebase.Data.Vector.Fusion.Stream.Monadic
    Rebase.Data.Vector.Fusion.Util Rebase.Data.Vector.Generic
    Rebase.Data.Vector.Generic.Base Rebase.Data.Vector.Generic.Mutable
    Rebase.Data.Vector.Generic.New Rebase.Data.Vector.Instances
    Rebase.Data.Vector.Internal.Check Rebase.Data.Vector.Mutable
    Rebase.Data.Vector.Primitive Rebase.Data.Vector.Primitive.Mutable
    Rebase.Data.Vector.Storable Rebase.Data.Vector.Storable.Internal
    Rebase.Data.Vector.Storable.Mutable Rebase.Data.Vector.Unboxed
    Rebase.Data.Vector.Unboxed.Base Rebase.Data.Vector.Unboxed.Mutable
    Rebase.Data.Version Rebase.Data.Void Rebase.Data.Void.Unsafe
    Rebase.Data.Word Rebase.Debug.Trace Rebase.Foreign Rebase.Foreign.C
    Rebase.Foreign.C.Error Rebase.Foreign.C.String
    Rebase.Foreign.C.Types Rebase.Foreign.Concurrent
    Rebase.Foreign.ForeignPtr Rebase.Foreign.ForeignPtr.Safe
    Rebase.Foreign.ForeignPtr.Unsafe Rebase.Foreign.Marshal
    Rebase.Foreign.Marshal.Alloc Rebase.Foreign.Marshal.Array
    Rebase.Foreign.Marshal.Error Rebase.Foreign.Marshal.Pool
    Rebase.Foreign.Marshal.Safe Rebase.Foreign.Marshal.Unsafe
    Rebase.Foreign.Marshal.Utils Rebase.Foreign.Ptr Rebase.Foreign.Safe
    Rebase.Foreign.StablePtr Rebase.Foreign.Storable Rebase.GHC.Arr
    Rebase.GHC.Base Rebase.GHC.Char Rebase.GHC.Conc Rebase.GHC.Conc.IO
    Rebase.GHC.Conc.Signal Rebase.GHC.Conc.Sync
    Rebase.GHC.ConsoleHandler Rebase.GHC.Constants Rebase.GHC.Desugar
    Rebase.GHC.Enum Rebase.GHC.Environment Rebase.GHC.Err
    Rebase.GHC.Exception Rebase.GHC.Exts Rebase.GHC.Fingerprint
    Rebase.GHC.Fingerprint.Type Rebase.GHC.Float
    Rebase.GHC.Float.ConversionUtils Rebase.GHC.Float.RealFracMethods
    Rebase.GHC.Foreign Rebase.GHC.ForeignPtr Rebase.GHC.GHCi
    Rebase.GHC.Generics Rebase.GHC.IO Rebase.GHC.IO.Buffer
    Rebase.GHC.IO.BufferedIO Rebase.GHC.IO.Device
    Rebase.GHC.IO.Encoding Rebase.GHC.IO.Encoding.CodePage
    Rebase.GHC.IO.Encoding.Failure Rebase.GHC.IO.Encoding.Iconv
    Rebase.GHC.IO.Encoding.Latin1 Rebase.GHC.IO.Encoding.Types
    Rebase.GHC.IO.Encoding.UTF16 Rebase.GHC.IO.Encoding.UTF32
    Rebase.GHC.IO.Encoding.UTF8 Rebase.GHC.IO.Exception
    Rebase.GHC.IO.FD Rebase.GHC.IO.Handle Rebase.GHC.IO.Handle.FD
    Rebase.GHC.IO.Handle.Internals Rebase.GHC.IO.Handle.Text
    Rebase.GHC.IO.Handle.Types Rebase.GHC.IO.IOMode Rebase.GHC.IOArray
    Rebase.GHC.IORef Rebase.GHC.Int Rebase.GHC.List Rebase.GHC.MVar
    Rebase.GHC.Num Rebase.GHC.OverloadedLabels Rebase.GHC.Pack
    Rebase.GHC.Profiling Rebase.GHC.Ptr Rebase.GHC.Read Rebase.GHC.Real
    Rebase.GHC.Records Rebase.GHC.ST Rebase.GHC.STRef Rebase.GHC.Show
    Rebase.GHC.Stable Rebase.GHC.Stack Rebase.GHC.Stats
    Rebase.GHC.Storable Rebase.GHC.TopHandler Rebase.GHC.TypeLits
    Rebase.GHC.TypeNats Rebase.GHC.Unicode Rebase.GHC.Weak
    Rebase.GHC.Word Rebase.Numeric Rebase.Numeric.Natural
    Rebase.Prelude Rebase.System.CPUTime Rebase.System.Console.GetOpt
    Rebase.System.Environment Rebase.System.Exit Rebase.System.IO
    Rebase.System.IO.Error Rebase.System.IO.Unsafe Rebase.System.Info
    Rebase.System.Mem Rebase.System.Mem.StableName
    Rebase.System.Mem.Weak Rebase.System.Posix.Internals
    Rebase.System.Posix.Types Rebase.System.Timeout
    Rebase.Text.ParserCombinators.ReadP
    Rebase.Text.ParserCombinators.ReadPrec Rebase.Text.Printf
    Rebase.Text.Read Rebase.Text.Read.Lex Rebase.Text.Show
    Rebase.Text.Show.Functions Rebase.Unsafe.Coerce

import-dirs:          /usr/lib/ghc-9.4.8/site-local/rebase-1.20.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/rebase-1.20.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/rebase-1.20.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-rebase
hs-libraries:         HSrebase-1.20.1-EZLhAB0WCH3eAQQWrtiTn
depends:
    base-4.17.2.1 bifunctors-5.6.2-55pB15N2vUAu5vVW3jWWD
    bytestring-0.11.5.3 comonad-5.0.9-7Nx7TLF48pI5LjqSes8omR
    containers-0.6.7 contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    deepseq-1.4.8.0 dlist-1.0-E99MqJW5mmB4kr4PCgIESI
    either-5.0.3-Hg24mZ4IZ71J0pBPr5Smvf
    groups-0.5.3-FFsNBj45OTyFj2OEUodrXZ
    hashable-1.4.4.0-HF0gObldLcB4LirfpxeD3R
    invariant-0.6.4-HOhoDRyaHN83sFT5WZseuM mtl-2.2.2
    profunctors-5.6.3-7SwpvPUR3WDDKDPlUxhog4
    scientific-0.3.8.0-L88GQ4rEhQfGc3NVSCAVTu
    selective-0.7.0.1-7tMjzEcO8cBm9zDzWAHHw
    semigroupoids-6.0.1-6I5b3GpOwhwAglmgd4w9RR stm-2.5.1.0 text-2.0.2
    time-1.12.2 time-compat-1.9.7-IqYpU3i0AgpHlVcSPUZpUA
    transformers-0.5.6.2
    unordered-containers-0.2.20-89DcpQLd7HI30AdGz5XyJk
    uuid-types-1.0.6-Hb7YSEOTSK2GsRNY7hIeS
    vector-0.13.2.0-AtXaKVcIvtCInBZOrzSe57
    vector-instances-3.4.3-C0uSgtYOdPMDMMcqe0pxUg
    void-0.7.3-H00KtmFLEBuFgBidznP5Pq

haddock-interfaces:   /usr/share/doc/haskell-rebase/html/rebase.haddock
haddock-html:         /usr/share/doc/haskell-rebase/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

