#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 trifecta
version:              2.1.4
visibility:           public
id:                   trifecta-2.1.4-FbuhYlFIDzc1ORuvS967f6
key:                  trifecta-2.1.4-FbuhYlFIDzc1ORuvS967f6
license:              BSD-3-Clause
copyright:            Copyright (C) 2010-2017 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            experimental
homepage:             http://github.com/ekmett/trifecta/
synopsis:
    A modern parser combinator library with convenient diagnostics

description:
    A modern parser combinator library with slicing and Clang-style colored diagnostics

    For example:

    <<https://i.imgur.com/ZyzUSSn.png>>

    <images/example.png (Local Copy)>

category:             Text, Parsing, Diagnostics, Pretty Printer, Logging
abi:                  ba5d09fcf60efd0306a036aafda57c2d
exposed:              True
exposed-modules:
    Text.Trifecta Text.Trifecta.Combinators Text.Trifecta.Delta
    Text.Trifecta.Highlight Text.Trifecta.Parser
    Text.Trifecta.Rendering Text.Trifecta.Result Text.Trifecta.Rope
    Text.Trifecta.Tutorial Text.Trifecta.Util.IntervalMap
    Text.Trifecta.Util.It

hidden-modules:
    Text.Trifecta.Util.Combinators Text.Trifecta.Util.Pretty

import-dirs:          /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/trifecta-2.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-trifecta
hs-libraries:         HStrifecta-2.1.4-FbuhYlFIDzc1ORuvS967f6
depends:
    ansi-terminal-1.0.2-K3FcB9OuSW9G9IWrQwwwo4 array-0.5.4.0
    base-4.17.2.1 blaze-builder-0.4.4-1ntb6RP4OewIlLWEkSeIAR
    blaze-html-0.9.2.0-BsVDj7UmD9SGJonPOQFUuj
    blaze-markup-0.8.3.0-Ey7XmXUOs4eDBTvJFYpeuT bytestring-0.11.5.3
    charset-0.3.12-KkCeqVkObTj3WDA69pl9uT
    comonad-5.0.9-7Nx7TLF48pI5LjqSes8omR containers-0.6.7
    deepseq-1.4.8.0 fingertree-0.1.6.2-HyFF8R8DbBb1f3TaBV8sAi
    ghc-prim-0.9.1 hashable-1.4.4.0-HF0gObldLcB4LirfpxeD3R
    indexed-traversable-0.1.4-EeVo0prc4Ve5Oh8yIcLoq0
    lens-5.3.1-57CGCDOUfQCLkJSlnZcVUR mtl-2.2.2
    parsers-0.12.12-LBDYop5QYiCC1l4dJj3TCF
    prettyprinter-1.7.1-18Jm3UFnGYW2Ifx2izjEAg
    prettyprinter-ansi-terminal-1.1.3-7xtieJh015GBqxFnpOTjap
    profunctors-5.6.3-7SwpvPUR3WDDKDPlUxhog4
    reducers-3.12.5-2SrNk3rYyef97Ats6BVZjQ transformers-0.5.6.2
    unordered-containers-0.2.20-89DcpQLd7HI30AdGz5XyJk
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-trifecta/html/trifecta.haddock
haddock-html:         /usr/share/doc/haskell-trifecta/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

