#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-web
version:              1.43.1
visibility:           public
id:                   hledger-web-1.43.1-7MQJ8McvWbnIrSRer7lNPp
key:                  hledger-web-1.43.1-7MQJ8McvWbnIrSRer7lNPp
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             Web user interface for the hledger accounting system
description:
    A simple web user interface for the hledger accounting system,
    providing a more modern UI than the command-line or terminal interfaces.
    It can be used as a local single-user UI, or as a multi-user UI for
    viewing\/adding\/editing on the web.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting. Read more at:
    <https://hledger.org>

category:             Finance
abi:                  305268dc3ccf234aea835d628ed59e61
exposed:              True
exposed-modules:
    Hledger.Web Hledger.Web.Application Hledger.Web.Import
    Hledger.Web.Main Hledger.Web.Test Hledger.Web.WebOptions

hidden-modules:
    Hledger.Web.App Hledger.Web.Handler.AddR Hledger.Web.Handler.EditR
    Hledger.Web.Handler.JournalR Hledger.Web.Handler.MiscR
    Hledger.Web.Handler.RegisterR Hledger.Web.Handler.UploadR
    Hledger.Web.Settings Hledger.Web.Settings.StaticFiles
    Hledger.Web.Widget.AddForm Hledger.Web.Widget.Common
    Paths_hledger_web

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-web-1.43.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/hledger-web
hs-libraries:         HShledger-web-1.43.1-7MQJ8McvWbnIrSRer7lNPp
depends:
    Decimal-0.5.2-CZNgfQK6v3DFQrbNDQg9pR
    aeson-2.1.2.1-3HLieqpkeG06w6MDAYdLLk base-4.17.2.1
    base64-1.0-89adjIZRicd5UJyOVzaPU9
    blaze-html-0.9.2.0-3cSCYM9QSR99BQnVHXrYzE
    blaze-markup-0.8.3.0-gQO1lU2QPQ9hXIev9mjlD bytestring-0.11.5.3
    case-insensitive-1.2.1.0-4psXWcL2Or6Ff92NkDcfKY
    clientsession-0.9.3.0-JwxzyO0YC8g8tMaAn3YBkZ
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    conduit-1.3.6.1-YyCKRGvJ9RFx9ccf8Rnd3
    conduit-extra-1.3.8-1hrV1nPRDhE45dAx9zvo6P containers-0.6.7
    data-default-0.7.1.3-1SaGr9SWFYZ17MG1fTAOKi directory-1.3.7.1
    extra-1.7.16-CyTEZvSfBxsKCwY9ZtJE7E
    file-embed-0.0.16.0-FS79AECsQN660bIXAMLGHY filepath-1.4.2.2
    githash-0.1.6.3-9GBeKMqGAcC72CXb0q8NgF
    hjsmin-0.2.1-GuhCTEDLsVO59FzJLo8ni3
    hledger-1.43.1-CaJOccJREd87ILNGxZ4rzg
    hledger-lib-1.43.1-HwSG03UtR4s6N4N6SpQZca
    hspec-2.11.4-HeteQh8xgtfLgehpo4VbZM
    http-client-0.7.19-Iyp8kyAVyHs5ic3dfNFLTs
    http-conduit-2.3.9.1-Jt8i9zz8puP9BUVEul6uLX
    http-types-0.12.4-3Rkn4NOOYhzvBVdRap5Ii
    megaparsec-9.7.0-A5HZG6HxQB028mYZSYROei mtl-2.2.2
    network-3.1.4.0-2g2oEkgQCahBaM3HvlpVNW
    safe-0.3.21-JMKA2bKqr97GM6r3OADsOi
    shakespeare-2.1.7-8Tdsqxebqs756ICmE3o1IV template-haskell-2.19.0.0
    text-2.0.2 time-1.12.2 transformers-0.5.6.2
    unix-compat-0.7.4.1-4GSEG4F7IBa3tepmzc9c8r
    unordered-containers-0.2.20.1-JRJBW0Nl9iEJULI134IWXM
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    wai-3.2.4-GKgviHtnWhO3KoBTtmAmpl
    wai-cors-0.2.7-CsoAkv69lzM7kxtefCTfBe
    wai-extra-3.1.18-F6kzlF5sHmSKQRA7O6iDV5
    wai-handler-launch-3.0.3.1-D7R4n7T42Bw2sR2VXYjCcj
    warp-3.4.0-4WQzRXYOsvYHbiPfjmDm2s
    yaml-0.11.11.2-AINh0PDgMr7KUeC4aAoheB
    yesod-1.6.2.1-1aiPWEyylKEFZ19oYkE7eA
    yesod-core-1.6.27.1-EwsliX2Eq0V3h6VQF9toZp
    yesod-form-1.7.9-DRYl9E9h5BgDPl9gkPOGpC
    yesod-static-1.6.1.0-IDviG1bbzV92U8Ge1vfKLV
    yesod-test-1.6.23-KuFletQMvyF2Rfh0t1bU2w

haddock-interfaces:   /usr/share/doc/hledger-web/html/hledger-web.haddock
haddock-html:         /usr/share/doc/hledger-web/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

