/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.indices.scale.searchonly;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;

class ScaleIndexRequest
extends AcknowledgedRequest<ScaleIndexRequest> {
    private final String index;
    private boolean scaleDown;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();

    ScaleIndexRequest(String index, boolean scaleDown) {
        this.index = index;
        this.scaleDown = scaleDown;
    }

    ScaleIndexRequest(StreamInput in) throws IOException {
        super(in);
        this.index = in.readString();
        this.scaleDown = in.readBoolean();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null || this.index.trim().isEmpty()) {
            validationException = ValidateActions.addValidationError("index is required", validationException);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.index);
        out.writeBoolean(this.scaleDown);
        this.indicesOptions.writeIndicesOptions(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScaleIndexRequest that = (ScaleIndexRequest)o;
        return this.scaleDown == that.scaleDown && Objects.equals(this.index, that.index) && Objects.equals(this.indicesOptions, that.indicesOptions);
    }

    public int hashCode() {
        return Objects.hash(this.index, this.scaleDown, this.indicesOptions);
    }

    public String getIndex() {
        return this.index;
    }

    public boolean isScaleDown() {
        return this.scaleDown;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public ScaleIndexRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public ScaleIndexRequest scaleDown(boolean scaleDown) {
        this.scaleDown = scaleDown;
        return this;
    }
}

