/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.JsonProcessorConflictStrategy;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class JsonProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, JsonProcessor> {
    @Nullable
    private final Boolean addToRoot;
    @Nullable
    private final JsonProcessorConflictStrategy addToRootConflictStrategy;
    @Nullable
    private final Boolean allowDuplicateKeys;
    @Nonnull
    private final String field;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<JsonProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JsonProcessor::setupJsonProcessorDeserializer);

    private JsonProcessor(Builder builder) {
        super(builder);
        this.addToRoot = builder.addToRoot;
        this.addToRootConflictStrategy = builder.addToRootConflictStrategy;
        this.allowDuplicateKeys = builder.allowDuplicateKeys;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.targetField = builder.targetField;
    }

    public static JsonProcessor of(Function<Builder, ObjectBuilder<JsonProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Json;
    }

    @Nullable
    public final Boolean addToRoot() {
        return this.addToRoot;
    }

    @Nullable
    public final JsonProcessorConflictStrategy addToRootConflictStrategy() {
        return this.addToRootConflictStrategy;
    }

    @Nullable
    public final Boolean allowDuplicateKeys() {
        return this.allowDuplicateKeys;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.addToRoot != null) {
            generator.writeKey("add_to_root");
            generator.write(this.addToRoot.booleanValue());
        }
        if (this.addToRootConflictStrategy != null) {
            generator.writeKey("add_to_root_conflict_strategy");
            this.addToRootConflictStrategy.serialize(generator, mapper);
        }
        if (this.allowDuplicateKeys != null) {
            generator.writeKey("allow_duplicate_keys");
            generator.write(this.allowDuplicateKeys.booleanValue());
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupJsonProcessorDeserializer(ObjectDeserializer<Builder> op) {
        JsonProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::addToRoot, JsonpDeserializer.booleanDeserializer(), "add_to_root");
        op.add(Builder::addToRootConflictStrategy, JsonProcessorConflictStrategy._DESERIALIZER, "add_to_root_conflict_strategy");
        op.add(Builder::allowDuplicateKeys, JsonpDeserializer.booleanDeserializer(), "allow_duplicate_keys");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.addToRoot);
        result = 31 * result + Objects.hashCode(this.addToRootConflictStrategy);
        result = 31 * result + Objects.hashCode(this.allowDuplicateKeys);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonProcessor other = (JsonProcessor)o;
        return Objects.equals(this.addToRoot, other.addToRoot) && Objects.equals(this.addToRootConflictStrategy, other.addToRootConflictStrategy) && Objects.equals(this.allowDuplicateKeys, other.allowDuplicateKeys) && this.field.equals(other.field) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, JsonProcessor> {
        @Nullable
        private Boolean addToRoot;
        @Nullable
        private JsonProcessorConflictStrategy addToRootConflictStrategy;
        @Nullable
        private Boolean allowDuplicateKeys;
        private String field;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(JsonProcessor o) {
            super(o);
            this.addToRoot = o.addToRoot;
            this.addToRootConflictStrategy = o.addToRootConflictStrategy;
            this.allowDuplicateKeys = o.allowDuplicateKeys;
            this.field = o.field;
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            super(o);
            this.addToRoot = o.addToRoot;
            this.addToRootConflictStrategy = o.addToRootConflictStrategy;
            this.allowDuplicateKeys = o.allowDuplicateKeys;
            this.field = o.field;
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder addToRoot(@Nullable Boolean value) {
            this.addToRoot = value;
            return this;
        }

        @Nonnull
        public final Builder addToRootConflictStrategy(@Nullable JsonProcessorConflictStrategy value) {
            this.addToRootConflictStrategy = value;
            return this;
        }

        @Nonnull
        public final Builder allowDuplicateKeys(@Nullable Boolean value) {
            this.allowDuplicateKeys = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public JsonProcessor build() {
            this._checkSingleUse();
            return new JsonProcessor(this);
        }
    }
}

