#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 postgrest
version:              10.0.0
visibility:           public
id:                   postgrest-10.0.0-AKl1letaExcCoLJV7c702b
key:                  postgrest-10.0.0-AKl1letaExcCoLJV7c702b
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for tables, views, and functions, supporting all HTTP methods that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  2897cbd6af1e06ab64ffcd5f067fe7a4
exposed:              True
exposed-modules:
    PostgREST.Admin PostgREST.App PostgREST.AppState PostgREST.Auth
    PostgREST.CLI PostgREST.Config PostgREST.Config.Database
    PostgREST.Config.JSPath PostgREST.Config.PgVersion
    PostgREST.Config.Proxy PostgREST.Cors PostgREST.DbStructure
    PostgREST.DbStructure.Identifiers PostgREST.DbStructure.Proc
    PostgREST.DbStructure.Relationship PostgREST.DbStructure.Table
    PostgREST.Error PostgREST.GucHeader PostgREST.Logger
    PostgREST.MediaType PostgREST.Middleware PostgREST.OpenAPI
    PostgREST.Query.QueryBuilder PostgREST.Query.SqlFragment
    PostgREST.Query.Statements PostgREST.RangeQuery
    PostgREST.Request.ApiRequest PostgREST.Request.DbRequestBuilder
    PostgREST.Request.MutateQuery PostgREST.Request.Preferences
    PostgREST.Request.QueryParams PostgREST.Request.ReadQuery
    PostgREST.Request.Types PostgREST.Unix PostgREST.Version
    PostgREST.Workers

hidden-modules:       Paths_postgrest
import-dirs:          /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/postgrest-10.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/postgrest
hs-libraries:         HSpostgrest-10.0.0-AKl1letaExcCoLJV7c702b
depends:
    HTTP-4000.4.1-HD8KR4Gj7kDIqhYvZQSDU7
    Ranged-sets-0.5.0-18nVcRd5e6I6Jkeo7z5KoD
    aeson-2.1.2.1-6FuMYI3vdPa8Ts5NPsnpCg
    auto-update-0.1.6-1X8lPE4bLI38j7aPRN1TxU base-4.17.2.1
    base64-bytestring-1.2.1.0-Fa0BuK0N9mu9JPJP7gaxRT
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-JVWVUVinOoKLKsx1rHKuw7
    cassava-0.5.4.1-1xqnibA8Yby7eJmAIBOQHe
    configurator-pg-0.2.10-ICh0qImWTsw5prxRVrDwQZ containers-0.6.7
    contravariant-extras-0.3.5.4-55ftugxfRMl5DZHT7luCXJ
    cookie-0.4.6-4KcZJbma3z5GIFijXOzknm directory-1.3.7.1
    either-5.0.3-Hg24mZ4IZ71J0pBPr5Smvf
    gitrev-1.3.1-KhpMNofwsxABRoyEGWB0ci
    hasql-1.5.0.5-HRwvYPLzYhM9K1MKHwukHo
    hasql-dynamic-statements-0.3.1.1-9BAjPkPzrzlAtUVgv7D6ot
    hasql-notifications-0.2.0.5-JUPBhIuYsR3FhkZoSziI9v
    hasql-pool-0.5.2.2-VQByVsUzSiAMrUC4awYFl
    hasql-transaction-1.0.1.1-H7ehcIQpYgC1xlMpLUdemb
    heredoc-0.2.0.0-77nW0mrU6iW6fQsJ6nWzcx
    http-types-0.12.4-Kfgn5nq0Uw5JM2IxBj4ZY1
    insert-ordered-containers-0.2.5.3-1vMS0zgZAhREdKpjP2hLv
    interpolatedstring-perl6-1.0.2-EjREsjMDdrMB1hh8nYGB33
    jose-0.10-Iqw0Vo11RIcAU6ngdKNHzJ lens-5.3.1-57CGCDOUfQCLkJSlnZcVUR
    lens-aeson-1.2.3-IQCA0tfGZ9IGSPqjYgAIyQ mtl-2.2.2
    network-3.1.4.0-BMQQjwbPvFR57Ka0tgIiy2
    network-uri-2.6.4.2-6dAHdOyJLq76CXdDmIsqEl
    optparse-applicative-0.18.1.0-3qYZezrQAxc4lJKAil0WN1
    parsec-3.1.16.1 protolude-0.3.5-FF16Kw53b0P1FIWwznQv6g
    regex-tdfa-1.3.2.4-9ZyuPp8BFYO5HpZyySDZc8
    retry-0.9.3.1-7RVohaD3s1T6hQjJC83jKU
    scientific-0.3.8.0-L88GQ4rEhQfGc3NVSCAVTu
    swagger2-2.8.10-A7sAg4SLDb5DzpGIN1Qkps text-2.0.2 time-1.12.2
    unix-2.7.3 unordered-containers-0.2.20-89DcpQLd7HI30AdGz5XyJk
    vault-0.3.1.5-Euat3gnPaqr1JFGOFA9eru
    vector-0.13.2.0-AtXaKVcIvtCInBZOrzSe57
    wai-3.2.4-LnpkwzoHUW9G2cGUC0nKUm
    wai-cors-0.2.7-3lBvOwPW2nNIrnm5IcJl2K
    wai-extra-3.1.17-AD6FgV5uWuJ7azui80eCeO
    wai-logger-2.5.0-62KACjarsGL324XNzO7Ya2
    warp-3.3.30-BXGJjdXXESkBepSPGuenDW

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

