# frozen_string_literal: true

require_relative '../../lib/sass/elf'

module Sass
  module CLI
    INTERPRETER = '/lib/ld-linux-riscv64-lp64d.so.1'

    INTERPRETER_SUFFIX = '/ld-linux-riscv64-lp64d.so.1'

    COMMAND = [
      *(ELF::INTERPRETER if ELF::INTERPRETER != INTERPRETER && ELF::INTERPRETER&.end_with?(INTERPRETER_SUFFIX)),
      File.absolute_path('/usr/bin/sass', __dir__).freeze
    ].freeze
  end

  private_constant :CLI
end
